
!------------------------------------------------------------------------!
!  The Community Multiscale Air Quality (CMAQ) system software is in     !
!  continuous development by various groups and is based on information  !
!  from these groups: Federal Government employees, contractors working  !
!  within a United States Government contract, and non-Federal sources   !
!  including research institutions.  These groups give the Government    !
!  permission to use, prepare derivative works of, and distribute copies !
!  of their work in the CMAQ system to the public and to permit others   !
!  to do so.  The United States Environmental Protection Agency          !
!  therefore grants similar permission to use the CMAQ system software,  !
!  but users are requested to provide copies of derivative works or      !
!  products designed to operate in the CMAQ system to the United States  !
!  Government without restrictions as to use by others.  Software        !
!  that is used with the CMAQ system but distributed under the GNU       !
!  General Public License or the GNU Lesser General Public License is    !
!  subject to their copyright restrictions.                              !
!------------------------------------------------------------------------!

      SUBROUTINE HRPRODLOSS

C***********************************************************************
C
C  FUNCTION: To compute the production and loss rates for EBI species
C
C  PRECONDITIONS: For the CB6R3M_AE7_KMTBR mechanism
C
C  RETURN VALUES: None
C
C  KEY SUBROUTINES/FUNCTIONS CALLED: None
C
C  REVISION HISTORY: Created by EBI solver program, Jan  9, 2020
C
C   18 Jul 14 B.Hutzell: revised to use real(8) variables

C***********************************************************************
      USE HRDATA

      IMPLICIT NONE


C.....INCLUDES: NONE


C.....ARGUMENTS: NONE


C.....PARAMETERS: NONE


C.....EXTERNAL FUNCTIONS: NONE


C.....SAVED VARIABLES: NONE
!     CHARACTER( 16 ), SAVE  ::  PNAME = 'HRPRODLOSS'   ! Program name


C.....LOCAL VARIABLES:


C***********************************************************************


      PROD(  H2O2         ) =                 RXRAT(    17 )      ! OH+OH=H2O2
     &                      +                 RXRAT(    19 )      ! HO2+HO2=H2O2
     &                      +                 RXRAT(    20 )      ! HO2+HO2=H2O2
     &                      +    4.0000D-02 * RXRAT(   143 )      ! OLE+O3=0.4000D-01*H2O2+...
     &                      +    8.0000D-02 * RXRAT(   147 )      ! IOLE+O3=0.8000D-01*H2O2+...
      LOSS(  H2O2         ) =                 RXRAT(    21 )      ! H2O2=0.2000D+01*OH
     &                      +                 RXRAT(    22 )      ! H2O2+OH=HO2
     &                      +                 RXRAT(    23 )      ! H2O2+O=OH+HO2

      PROD(  HNO3         ) =    2.0000D+00 * RXRAT(    39 )      ! N2O5=0.2000D+01*HNO3
     &                      +                 RXRAT(    45 )      ! NO2+OH=HNO3
     &                      +                 RXRAT(   100 )      ! FORM+NO3=HNO3+HO2+CO
     &                      +                 RXRAT(   107 )      ! ALD2+NO3=HNO3+C2O3
     &                      +                 RXRAT(   111 )      ! ALDX+NO3=HNO3+CXO3
     &                      +                 RXRAT(   115 )      ! GLYD+NO3=HNO3+C2O3
     &                      +                 RXRAT(   118 )      ! GLY+NO3=HNO3+0.1500D+01*CO+...
     &                      +                 RXRAT(   120 )      ! MGLY+NO3=HNO3+C2O3+XO2+RO2
     &                      +    7.1700D-01 * RXRAT(   160 )      ! ISPD+NO3=0.7170D+00*HNO3+...
     &                      +                 RXRAT(   164 )      ! HPLD+NO3=HNO3+ISPD
     &                      +                 RXRAT(   196 )      ! CRES+NO3=HNO3+0.3000D+...
     &                      +                 RXRAT(   200 )      ! CRON+NO3=HNO3+0.5000D+...
     &                      +                 RXRAT(   209 )      ! OPEN+NO3=HNO3+OPO3
     &                      +                 RXRAT(   211 )      ! CAT1+NO3=HNO3+CRO
     &                      +                 RXRAT(   255 )      ! CLNO3=HNO3+HOCL
     &                      +                 RXRAT(   268 )      ! NTR2=HNO3
     &                      +                 RXRAT(   269 )      ! N2O5=HNO3+H2NO3PIJ
     &                      +                 RXRAT(   270 )      ! N2O5=HNO3+H2NO3PK
     &                      +                 RXRAT(   271 )      ! H2NO3PIJ=HNO3
     &                      +                 RXRAT(   272 )      ! H2NO3PK=HNO3
     &                      +    5.0000D-01 * RXRAT(   276 )      ! NO2=0.5000D+00*HNO3+...
     &                      +                 RXRAT(   381 )      ! BRNO3=HNO3+HOBR
     &                      +                 RXRAT(   432 )      ! INO3+ACLJ=HNO3+ICL
     &                      +                 RXRAT(   433 )      ! INO3+ABRJ=HNO3+IBR
     &                      +                 RXRAT(   441 )      ! DMS+NO3=HNO3+SO2+MEO2+FORM
      LOSS(  HNO3         ) =                 RXRAT(    46 )      ! HNO3+OH=NO3
     &                      +                 RXRAT(    47 )      ! HNO3=OH+NO2

      PROD(  SO2          ) =    7.5000D-01 * RXRAT(   369 )      ! DMS+BRO=0.7500D+00*SO2+...
     &                      +    7.5000D-01 * RXRAT(   412 )      ! DMS+IO=0.7500D+00*SO2+...
     &                      +                 RXRAT(   439 )      ! DMS+OH=SO2+MEO2+FORM
     &                      +    7.5000D-01 * RXRAT(   440 )      ! DMS+OH=0.7500D+00*SO2+...
     &                      +                 RXRAT(   441 )      ! DMS+NO3=SO2+HNO3+MEO2+FORM
     &                      +    8.6000D-01 * RXRAT(   442 )      ! DMS+CL=0.8600D+00*SO2+MEO2+...
     &                      +    7.5000D-01 * RXRAT(   443 )      ! DMS+CLO=0.7500D+00*SO2+...
      LOSS(  SO2          ) =                 RXRAT(    52 )      ! SO2+OH=SULF+HO2+SULRXN

      PROD(  SULF         ) =                 RXRAT(    52 )      ! SO2+OH=SULF+HO2+SULRXN
      LOSS(  SULF         ) =   0.0D0

      PROD(  SULRXN       ) =                 RXRAT(    52 )      ! SO2+OH=SULRXN+HO2+SULF
      LOSS(  SULRXN       ) =   0.0D0

      PROD(  MEO2         ) =                 RXRAT(    53 )      ! C2O3+NO=MEO2+NO2+RO2
     &                      +    4.0000D-01 * RXRAT(    56 )      ! PAN=0.4000D+00*MEO2+...
     &                      +    4.4000D-01 * RXRAT(    57 )      ! C2O3+HO2=0.4400D+00*MEO2+...
     &                      +    2.0000D+00 * RXRAT(    59 )      ! C2O3+C2O3=0.2000D+01*MEO2+...
     &                      +                 RXRAT(    60 )      ! C2O3+CXO3=MEO2+ALD2+XO2H+...
     &                      +    8.0000D-01 * RXRAT(    77 )      ! XO2H+C2O3=0.8000D+00*MEO2+...
     &                      +    8.0000D-01 * RXRAT(    81 )      ! XO2+C2O3=0.8000D+00*MEO2+...
     &                      +    8.0000D-01 * RXRAT(    85 )      ! XO2N+C2O3=0.8000D+00*MEO2+...
     &                      +    6.0000D-01 * RXRAT(    87 )      ! MEPX+OH=0.6000D+00*MEO2+...
     &                      +                 RXRAT(    88 )      ! MEPX=MEO2+RO2+OH
     &                      +                 RXRAT(    94 )      ! AACD+OH=MEO2+RO2
     &                      +                 RXRAT(   108 )      ! ALD2=MEO2+RO2+CO+HO2
     &                      +                 RXRAT(   124 )      ! OH=MEO2+RO2
     &                      +    5.0000D-01 * RXRAT(   128 )      ! KET=0.5000D+00*MEO2+...
     &                      +    1.3800D+00 * RXRAT(   129 )      ! ACET=0.1380D+01*MEO2+...
     &                      +    8.0000D-01 * RXRAT(   153 )      ! ISO2+C2O3=0.8000D+00*MEO2+...
     &                      +    1.1500D-01 * RXRAT(   158 )      ! ISPD+OH=0.1150D+00*MEO2+...
     &                      +    3.4000D-01 * RXRAT(   161 )      ! ISPD=0.3400D+00*MEO2+...
     &                      +    8.0000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.8000D+00*MEO2+...
     &                      +                 RXRAT(   181 )      ! BZO2+C2O3=MEO2+OPEN+HO2+...
     &                      +                 RXRAT(   186 )      ! TO2+C2O3=MEO2+0.5200D+...
     &                      +                 RXRAT(   193 )      ! XLO2+C2O3=MEO2+0.7700D+...
     &                      +                 RXRAT(   216 )      ! OPO3+C2O3=MEO2+XO2+ALDX+...
     &                      +                 RXRAT(   220 )      ! ECH4+OH=MEO2+RO2
     &                      +                 RXRAT(   234 )      ! CL=MEO2+HCL+RO2
     &                      +                 RXRAT(   369 )      ! DMS+BRO=MEO2+0.2500D+...
     &                      +                 RXRAT(   412 )      ! DMS+IO=MEO2+0.2500D+00*MSA+...
     &                      +                 RXRAT(   425 )      ! CH3I=MEO2+I
     &                      +                 RXRAT(   439 )      ! DMS+OH=MEO2+SO2+FORM
     &                      +                 RXRAT(   440 )      ! DMS+OH=MEO2+0.2500D+00*MSA+...
     &                      +                 RXRAT(   441 )      ! DMS+NO3=MEO2+HNO3+SO2+FORM
     &                      +                 RXRAT(   442 )      ! DMS+CL=MEO2+0.8600D+00*SO2+...
     &                      +                 RXRAT(   443 )      ! DMS+CLO=MEO2+0.2500D+...
      LOSS(  MEO2         ) =                 RXRAT(    71 )      ! MEO2+NO=FORM+HO2+NO2
     &                      +                 RXRAT(    72 )      ! MEO2+HO2=0.9000D+00*MEPX+...
     &                      +    1.0000D-01 * RXRAT(    73 )      ! MEO2+C2O3=0.9000D+00*MEO2+...
     &                      +                 RXRAT(    74 )      ! MEO2+RO2=0.6850D+00*FORM+...
     &                      +                 RXRAT(   231 )      ! MEO2+CLO=CL+FORM+HO2
     &                      +                 RXRAT(   362 )      ! MEO2+BRO=0.8000D+00*HOBR+...

      PROD(  RO2          ) =                 RXRAT(    53 )      ! C2O3+NO=RO2+MEO2+NO2
     &                      +    4.0000D-01 * RXRAT(    56 )      ! PAN=0.4000D+00*RO2+0.6000D+...
     &                      +    4.4000D-01 * RXRAT(    57 )      ! C2O3+HO2=0.4400D+00*RO2+...
     &                      +    2.0000D+00 * RXRAT(    59 )      ! C2O3+C2O3=0.2000D+01*RO2+...
     &                      +    2.0000D+00 * RXRAT(    60 )      ! C2O3+CXO3=0.2000D+01*RO2+...
     &                      +                 RXRAT(    61 )      ! CXO3+NO=RO2+ALD2+XO2H+NO2
     &                      +    4.0000D-01 * RXRAT(    64 )      ! PANX=0.4000D+00*RO2+...
     &                      +    4.4000D-01 * RXRAT(    65 )      ! CXO3+HO2=0.4400D+00*RO2+...
     &                      +    2.0000D+00 * RXRAT(    67 )      ! CXO3+CXO3=0.2000D+01*RO2+...
     &                      +    9.0000D-01 * RXRAT(    73 )      ! MEO2+C2O3=0.9000D+00*RO2+...
     &                      +    8.0000D-01 * RXRAT(    77 )      ! XO2H+C2O3=0.8000D+00*RO2+...
     &                      +    8.0000D-01 * RXRAT(    81 )      ! XO2+C2O3=0.8000D+00*RO2+...
     &                      +    8.0000D-01 * RXRAT(    85 )      ! XO2N+C2O3=0.8000D+00*RO2+...
     &                      +    6.0000D-01 * RXRAT(    87 )      ! MEPX+OH=0.6000D+00*RO2+...
     &                      +                 RXRAT(    88 )      ! MEPX=RO2+MEO2+OH
     &                      +    6.0000D-01 * RXRAT(    89 )      ! ROOH+OH=0.6000D+00*RO2+...
     &                      +                 RXRAT(    94 )      ! AACD+OH=RO2+MEO2
     &                      +                 RXRAT(   108 )      ! ALD2=RO2+MEO2+CO+HO2
     &                      +                 RXRAT(   112 )      ! ALDX=RO2+XO2H+ALD2+CO+HO2
     &                      +    1.1000D-01 * RXRAT(   114 )      ! GLYD=0.1100D+00*RO2+...
     &                      +    2.0000D-01 * RXRAT(   116 )      ! GLY+OH=0.2000D+00*RO2+...
     &                      +    5.0000D-01 * RXRAT(   118 )      ! GLY+NO3=0.5000D+00*RO2+...
     &                      +                 RXRAT(   120 )      ! MGLY+NO3=RO2+C2O3+XO2+HNO3
     &                      +                 RXRAT(   124 )      ! OH=RO2+MEO2
     &                      +                 RXRAT(   125 )      ! ETHA+OH=RO2+0.9910D+...
     &                      +    1.0000D-01 * RXRAT(   127 )      ! ETOH+OH=0.1000D+00*RO2+...
     &                      +                 RXRAT(   128 )      ! KET=RO2+0.5000D+00*C2O3+...
     &                      +    1.3800D+00 * RXRAT(   129 )      ! ACET=0.1380D+01*RO2+...
     &                      +                 RXRAT(   130 )      ! ACET+OH=RO2+C2O3+XO2+FORM
     &                      +    9.8000D-01 * RXRAT(   133 )      ! ROR=0.9800D+00*RO2+0.4200D+...
     &                      +    7.0000D-01 * RXRAT(   137 )      ! ETH+O=0.7000D+00*RO2+HO2+...
     &                      +                 RXRAT(   138 )      ! ETH+OH=RO2+XO2H+0.1560D+...
     &                      +                 RXRAT(   140 )      ! ETH+NO3=RO2+0.5000D+...
     &                      +    2.1000D-01 * RXRAT(   141 )      ! OLE+O=0.2100D+00*RO2+...
     &                      +    1.1950D+00 * RXRAT(   142 )      ! OLE+OH=0.1195D+01*RO2+...
     &                      +    1.5000D-01 * RXRAT(   143 )      ! OLE+O3=0.1500D+00*RO2+...
     &                      +                 RXRAT(   144 )      ! OLE+NO3=RO2+0.5000D+...
     &                      +    1.0000D-01 * RXRAT(   145 )      ! IOLE+O=0.1000D+00*RO2+...
     &                      +                 RXRAT(   146 )      ! IOLE+OH=RO2+0.7000D+...
     &                      +    3.0000D-01 * RXRAT(   147 )      ! IOLE+O3=0.3000D+00*RO2+...
     &                      +                 RXRAT(   148 )      ! IOLE+NO3=RO2+0.5000D+...
     &                      +                 RXRAT(   149 )      ! ISOP+OH=RO2+ISO2+ISOPRXN
     &                      +    2.5000D-01 * RXRAT(   150 )      ! ISOP+O=0.2500D+00*RO2+...
     &                      +    8.2000D-02 * RXRAT(   151 )      ! ISO2+NO=0.8200D-01*RO2+...
     &                      +    8.7200D-01 * RXRAT(   153 )      ! ISO2+C2O3=0.8720D+00*RO2+...
     &                      +    7.2000D-02 * RXRAT(   154 )      ! ISO2+RO2=0.1072D+01*RO2+...
     &                      +    2.0000D-01 * RXRAT(   156 )      ! ISOP+O3=0.2000D+00*RO2+...
     &                      +                 RXRAT(   157 )      ! ISOP+NO3=RO2+0.6500D+...
     &                      +    6.5800D-01 * RXRAT(   158 )      ! ISPD+OH=0.6580D+00*RO2+...
     &                      +    2.8400D-01 * RXRAT(   160 )      ! ISPD+NO3=0.2840D+00*RO2+...
     &                      +    8.4000D-01 * RXRAT(   161 )      ! ISPD=0.8400D+00*RO2+...
     &                      +    6.7000D-02 * RXRAT(   162 )      ! ISPX+OH=0.6700D-01*RO2+...
     &                      +                 RXRAT(   165 )      ! EPOX+OH=RO2+EPX2
     &                      +    8.0000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.8000D+00*RO2+...
     &                      +                 RXRAT(   170 )      ! INTR+OH=RO2+0.3700D+...
     &                      +    1.5000D+00 * RXRAT(   172 )      ! TERP+OH=0.1500D+01*RO2+...
     &                      +    9.4000D-01 * RXRAT(   173 )      ! TERP+O3=0.9400D+00*RO2+...
     &                      +    1.2800D+00 * RXRAT(   174 )      ! TERP+NO3=0.1280D+01*RO2+...
     &                      +    1.5000D+00 * RXRAT(   176 )      ! APIN+OH=0.1500D+01*RO2+...
     &                      +    9.4000D-01 * RXRAT(   177 )      ! APIN+O3=0.9400D+00*RO2+...
     &                      +    1.2800D+00 * RXRAT(   178 )      ! APIN+NO3=0.1280D+01*RO2+...
     &                      +    3.5200D-01 * RXRAT(   179 )      ! BENZENE+OH=0.3520D+00*RO2+...
     &                      +                 RXRAT(   181 )      ! BZO2+C2O3=RO2+OPEN+HO2+...
     &                      +    7.2000D-01 * RXRAT(   184 )      ! TOL+OH=0.7200D+00*RO2+...
     &                      +                 RXRAT(   186 )      ! TO2+C2O3=RO2+0.5200D+...
     &                      +    6.0200D-01 * RXRAT(   189 )      ! XYLMN+OH=0.6020D+00*RO2+...
     &                      +    6.0200D-01 * RXRAT(   190 )      ! NAPH+OH=0.6020D+00*RO2+...
     &                      +                 RXRAT(   193 )      ! XLO2+C2O3=RO2+0.7700D+...
     &                      +    2.0000D-02 * RXRAT(   195 )      ! CRES+OH=0.2000D-01*RO2+...
     &                      +    7.0000D-01 * RXRAT(   196 )      ! CRES+NO3=0.7000D+00*RO2+...
     &                      +    2.0000D+00 * RXRAT(   203 )      ! XOPN+OH=0.2000D+01*RO2+...
     &                      +    3.0000D-01 * RXRAT(   204 )      ! XOPN+O3=0.3000D+00*RO2+...
     &                      +                 RXRAT(   205 )      ! XOPN+NO3=RO2+0.5000D+...
     &                      +    4.0000D-01 * RXRAT(   207 )      ! OPEN+OH=0.4000D+00*RO2+...
     &                      +    4.4000D-01 * RXRAT(   215 )      ! OPO3+HO2=0.4400D+00*RO2+...
     &                      +    2.0000D+00 * RXRAT(   216 )      ! OPO3+C2O3=0.2000D+01*RO2+...
     &                      +    8.0000D-01 * RXRAT(   217 )      ! OPO3+RO2=0.1800D+01*RO2+...
     &                      +                 RXRAT(   220 )      ! ECH4+OH=RO2+MEO2
     &                      +                 RXRAT(   221 )      ! XPRP=RO2+XO2N
     &                      +                 RXRAT(   222 )      ! XPRP=RO2+0.2680D+00*ALDX+...
     &                      +                 RXRAT(   223 )      ! XPAR=RO2+XO2N
     &                      +                 RXRAT(   224 )      ! XPAR=RO2+0.8740D+00*ROR+...
     &                      +                 RXRAT(   234 )      ! CL=RO2+MEO2+HCL
     &                      +                 RXRAT(   236 )      ! CL+PRPA=RO2+ACET+0.9700D+...
     &                      +                 RXRAT(   237 )      ! CL+ETHA=RO2+0.9910D+...
     &                      +                 RXRAT(   241 )      ! CL+ISOP=RO2+ISPD+0.9600D+...
     &                      +    7.2000D-01 * RXRAT(   248 )      ! CL+TOL=0.7200D+00*RO2+...
     &                      +    6.0200D-01 * RXRAT(   249 )      ! CL+XYLMN=0.6020D+00*RO2+...
     &                      +    6.0200D-01 * RXRAT(   250 )      ! CL+NAPH=0.6020D+00*RO2+...
     &                      +                 RXRAT(   359 )      ! OLE+BR=RO2+ALD2+XO2H-PAR+FMBR
     &                      +                 RXRAT(   360 )      ! ISOP+BR=RO2+ISPD+0.9600D+...
      LOSS(  RO2          ) =                 RXRAT(    58 )      ! RO2+C2O3=C2O3
     &                      +    2.0000D-01 * RXRAT(    66 )      ! RO2+CXO3=0.8000D+00*RO2+...
     &                      +                 RXRAT(    68 )      ! RO2+NO=NO
     &                      +                 RXRAT(    69 )      ! RO2+HO2=HO2
     &                      +    2.0000D+00 * RXRAT(    70 )      ! RO2+RO2=

      PROD(  PACD         ) =    4.1000D-01 * RXRAT(    57 )      ! C2O3+HO2=0.4100D+00*PACD+...
     &                      +    4.1000D-01 * RXRAT(    65 )      ! CXO3+HO2=0.4100D+00*PACD+...
     &                      +    4.1000D-01 * RXRAT(   215 )      ! OPO3+HO2=0.4100D+00*PACD+...
      LOSS(  PACD         ) =                 RXRAT(    95 )      ! PACD+OH=C2O3

      PROD(  AACD         ) =    1.5000D-01 * RXRAT(    57 )      ! C2O3+HO2=0.1500D+00*AACD+...
     &                      +    1.5000D-01 * RXRAT(    65 )      ! CXO3+HO2=0.1500D+00*AACD+...
     &                      +    1.0000D-01 * RXRAT(    73 )      ! MEO2+C2O3=0.1000D+00*AACD+...
     &                      +    2.0000D-01 * RXRAT(    77 )      ! XO2H+C2O3=0.2000D+00*AACD+...
     &                      +    2.0000D-01 * RXRAT(    81 )      ! XO2+C2O3=0.2000D+00*AACD+...
     &                      +    2.0000D-01 * RXRAT(    85 )      ! XO2N+C2O3=0.2000D+00*AACD+...
     &                      +    1.3000D-01 * RXRAT(   143 )      ! OLE+O3=0.1300D+00*AACD+...
     &                      +    8.0000D-02 * RXRAT(   147 )      ! IOLE+O3=0.8000D-01*AACD+...
     &                      +    2.0000D-01 * RXRAT(   153 )      ! ISO2+C2O3=0.2000D+00*AACD+...
     &                      +    2.0000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.2000D+00*AACD+...
     &                      +    1.5000D-01 * RXRAT(   215 )      ! OPO3+HO2=0.1500D+00*AACD+...
     &                      +    2.0000D-01 * RXRAT(   217 )      ! OPO3+RO2=0.2000D+00*AACD+...
      LOSS(  AACD         ) =                 RXRAT(    94 )      ! AACD+OH=MEO2+RO2

      PROD(  CXO3         ) =                 RXRAT(    63 )      ! PANX=CXO3+NO2
     &                      +    6.0000D-01 * RXRAT(    64 )      ! PANX=0.6000D+00*CXO3+...
     &                      +                 RXRAT(   109 )      ! ALDX+O=CXO3+OH
     &                      +                 RXRAT(   110 )      ! ALDX+OH=CXO3
     &                      +                 RXRAT(   111 )      ! ALDX+NO3=CXO3+HNO3
     &                      +    5.0000D-01 * RXRAT(   128 )      ! KET=0.5000D+00*CXO3+...
     &                      +    2.5000D-01 * RXRAT(   150 )      ! ISOP+O=0.2500D+00*CXO3+...
     &                      +    2.0000D-01 * RXRAT(   156 )      ! ISOP+O3=0.2000D+00*CXO3+...
     &                      +    7.1700D-01 * RXRAT(   160 )      ! ISPD+NO3=0.7170D+00*CXO3+...
     &                      +    3.9000D-01 * RXRAT(   173 )      ! TERP+O3=0.3900D+00*CXO3+...
     &                      +    3.9000D-01 * RXRAT(   177 )      ! APIN+O3=0.3900D+00*CXO3+...
     &                      +    2.0000D-01 * RXRAT(   212 )      ! OPO3+NO=0.2000D+00*CXO3+...
     &                      +                 RXRAT(   244 )      ! CL+ALDX=CXO3+HCL
      LOSS(  CXO3         ) =                 RXRAT(    60 )      ! CXO3+C2O3=MEO2+ALD2+XO2H+...
     &                      +                 RXRAT(    61 )      ! CXO3+NO=NO2+ALD2+XO2H+RO2
     &                      +                 RXRAT(    62 )      ! CXO3+NO2=PANX
     &                      +                 RXRAT(    65 )      ! CXO3+HO2=0.4100D+00*PACD+...
     &                      +                 RXRAT(    66 )      ! CXO3+RO2=0.8000D+00*ALD2+...
     &                      +    2.0000D+00 * RXRAT(    67 )      ! CXO3+CXO3=0.2000D+01*ALD2+...

      PROD(  ALD2         ) =                 RXRAT(    60 )      ! C2O3+CXO3=ALD2+MEO2+XO2H+...
     &                      +                 RXRAT(    61 )      ! CXO3+NO=ALD2+NO2+XO2H+RO2
     &                      +    4.0000D-01 * RXRAT(    64 )      ! PANX=0.4000D+00*ALD2+...
     &                      +    4.4000D-01 * RXRAT(    65 )      ! CXO3+HO2=0.4400D+00*ALD2+...
     &                      +    8.0000D-01 * RXRAT(    66 )      ! CXO3+RO2=0.8000D+00*ALD2+...
     &                      +    2.0000D+00 * RXRAT(    67 )      ! CXO3+CXO3=0.2000D+01*ALD2+...
     &                      +                 RXRAT(   112 )      ! ALDX=ALD2+XO2H+RO2+CO+HO2
     &                      +    9.9100D-01 * RXRAT(   125 )      ! ETHA+OH=0.9910D+00*ALD2+...
     &                      +    9.5000D-01 * RXRAT(   127 )      ! ETOH+OH=0.9500D+00*ALD2+...
     &                      +    5.0000D-01 * RXRAT(   128 )      ! KET=0.5000D+00*ALD2+...
     &                      +    7.4000D-01 * RXRAT(   133 )      ! ROR=0.7400D+00*ALD2+...
     &                      +    2.0000D-01 * RXRAT(   141 )      ! OLE+O=0.2000D+00*ALD2+...
     &                      +    4.8800D-01 * RXRAT(   142 )      ! OLE+OH=0.4880D+00*ALD2+...
     &                      +    2.9500D-01 * RXRAT(   143 )      ! OLE+O3=0.2950D+00*ALD2+...
     &                      +    2.5000D-01 * RXRAT(   144 )      ! OLE+NO3=0.2500D+00*ALD2+...
     &                      +    1.2400D+00 * RXRAT(   145 )      ! IOLE+O=0.1240D+01*ALD2+...
     &                      +    1.3000D+00 * RXRAT(   146 )      ! IOLE+OH=0.1300D+01*ALD2+...
     &                      +    7.3200D-01 * RXRAT(   147 )      ! IOLE+O3=0.7320D+00*ALD2+...
     &                      +    5.0000D-01 * RXRAT(   148 )      ! IOLE+NO3=0.5000D+00*ALD2+...
     &                      +    4.0000D-02 * RXRAT(   159 )      ! ISPD+O3=0.4000D-01*ALD2+...
     &                      +    1.0000D-01 * RXRAT(   204 )      ! XOPN+O3=0.1000D+00*ALD2+...
     &                      +    2.0000D-02 * RXRAT(   208 )      ! OPEN+O3=0.2000D-01*ALD2+...
     &                      +                 RXRAT(   219 )      ! PANX+OH=ALD2+NO2
     &                      +    9.9100D-01 * RXRAT(   237 )      ! CL+ETHA=0.9910D+00*ALD2+...
     &                      +    3.3000D-01 * RXRAT(   239 )      ! CL+OLE=0.3300D+00*ALD2+...
     &                      +    4.5000D-01 * RXRAT(   240 )      ! CL+IOLE=0.4500D+00*ALD2+...
     &                      +                 RXRAT(   246 )      ! CL+ETOH=ALD2+HO2+HCL
     &                      +                 RXRAT(   359 )      ! OLE+BR=ALD2+FMBR+XO2H-PAR+RO2
      LOSS(  ALD2         ) =                 RXRAT(   105 )      ! ALD2+O=C2O3+OH
     &                      +                 RXRAT(   106 )      ! ALD2+OH=C2O3
     &                      +                 RXRAT(   107 )      ! ALD2+NO3=C2O3+HNO3
     &                      +                 RXRAT(   108 )      ! ALD2=MEO2+RO2+CO+HO2
     &                      +                 RXRAT(   243 )      ! ALD2+CL=HCL+C2O3
     &                      +                 RXRAT(   358 )      ! ALD2+BR=HBR+C2O3

      PROD(  XO2H         ) =                 RXRAT(    60 )      ! C2O3+CXO3=XO2H+ALD2+MEO2+...
     &                      +                 RXRAT(    61 )      ! CXO3+NO=XO2H+ALD2+NO2+RO2
     &                      +    4.0000D-01 * RXRAT(    64 )      ! PANX=0.4000D+00*XO2H+...
     &                      +    4.4000D-01 * RXRAT(    65 )      ! CXO3+HO2=0.4400D+00*XO2H+...
     &                      +    8.0000D-01 * RXRAT(    66 )      ! CXO3+RO2=0.8000D+00*XO2H+...
     &                      +    2.0000D+00 * RXRAT(    67 )      ! CXO3+CXO3=0.2000D+01*XO2H+...
     &                      +    5.4000D-01 * RXRAT(    89 )      ! ROOH+OH=0.5400D+00*XO2H+...
     &                      +                 RXRAT(   112 )      ! ALDX=XO2H+ALD2+RO2+CO+HO2
     &                      +    1.1000D-01 * RXRAT(   114 )      ! GLYD=0.1100D+00*XO2H+...
     &                      +    9.9100D-01 * RXRAT(   125 )      ! ETHA+OH=0.9910D+00*XO2H+...
     &                      +    1.0000D-01 * RXRAT(   127 )      ! ETOH+OH=0.1000D+00*XO2H+...
     &                      +    5.0000D-01 * RXRAT(   128 )      ! KET=0.5000D+00*XO2H+...
     &                      +    9.4000D-01 * RXRAT(   133 )      ! ROR=0.9400D+00*XO2H+...
     &                      +    7.0000D-01 * RXRAT(   137 )      ! ETH+O=0.7000D+00*XO2H+HO2+...
     &                      +                 RXRAT(   138 )      ! ETH+OH=XO2H+RO2+0.1560D+...
     &                      +    5.0000D-01 * RXRAT(   140 )      ! ETH+NO3=0.5000D+00*XO2H+...
     &                      +    2.0000D-01 * RXRAT(   141 )      ! OLE+O=0.2000D+00*XO2H+...
     &                      +    9.7600D-01 * RXRAT(   142 )      ! OLE+OH=0.9760D+00*XO2H+...
     &                      +    1.5000D-01 * RXRAT(   143 )      ! OLE+O3=0.1500D+00*XO2H+...
     &                      +    4.8000D-01 * RXRAT(   144 )      ! OLE+NO3=0.4800D+00*XO2H+...
     &                      +    1.0000D-01 * RXRAT(   145 )      ! IOLE+O=0.1000D+00*XO2H+...
     &                      +                 RXRAT(   146 )      ! IOLE+OH=XO2H+0.7000D+...
     &                      +    3.0000D-01 * RXRAT(   147 )      ! IOLE+O3=0.3000D+00*XO2H+...
     &                      +    4.8000D-01 * RXRAT(   148 )      ! IOLE+NO3=0.4800D+00*XO2H+...
     &                      +    8.2000D-02 * RXRAT(   151 )      ! ISO2+NO=0.8200D-01*XO2H+...
     &                      +    7.2000D-02 * RXRAT(   153 )      ! ISO2+C2O3=0.7200D-01*XO2H+...
     &                      +    7.2000D-02 * RXRAT(   154 )      ! ISO2+RO2=0.7200D-01*XO2H+...
     &                      +    6.4000D-01 * RXRAT(   157 )      ! ISOP+NO3=0.6400D+00*XO2H+...
     &                      +    1.4200D-01 * RXRAT(   160 )      ! ISPD+NO3=0.1420D+00*XO2H+...
     &                      +    3.4000D-01 * RXRAT(   161 )      ! ISPD=0.3400D+00*XO2H+...
     &                      +    3.7000D-01 * RXRAT(   170 )      ! INTR+OH=0.3700D+00*XO2H+...
     &                      +    7.5000D-01 * RXRAT(   172 )      ! TERP+OH=0.7500D+00*XO2H+...
     &                      +    7.0000D-02 * RXRAT(   173 )      ! TERP+O3=0.7000D-01*XO2H+...
     &                      +    2.8000D-01 * RXRAT(   174 )      ! TERP+NO3=0.2800D+00*XO2H+...
     &                      +    7.5000D-01 * RXRAT(   176 )      ! APIN+OH=0.7500D+00*XO2H+...
     &                      +    7.0000D-02 * RXRAT(   177 )      ! APIN+O3=0.7000D-01*XO2H+...
     &                      +    2.8000D-01 * RXRAT(   178 )      ! APIN+NO3=0.2800D+00*XO2H+...
     &                      +    7.0000D-02 * RXRAT(   184 )      ! TOL+OH=0.7000D-01*XO2H+...
     &                      +    5.8000D-02 * RXRAT(   189 )      ! XYLMN+OH=0.5800D-01*XO2H+...
     &                      +    5.8000D-02 * RXRAT(   190 )      ! NAPH+OH=0.5800D-01*XO2H+...
     &                      +    1.2000D-01 * RXRAT(   196 )      ! CRES+NO3=0.1200D+00*XO2H+...
     &                      +                 RXRAT(   202 )      ! XOPN=XO2H+0.4000D+00*GLY+...
     &                      +    2.0000D+00 * RXRAT(   203 )      ! XOPN+OH=0.2000D+01*XO2H+...
     &                      +    3.0000D-01 * RXRAT(   204 )      ! XOPN+O3=0.3000D+00*XO2H+...
     &                      +    4.5000D-01 * RXRAT(   205 )      ! XOPN+NO3=0.4500D+00*XO2H+...
     &                      +    4.0000D-01 * RXRAT(   207 )      ! OPEN+OH=0.4000D+00*XO2H+...
     &                      +    4.4000D-01 * RXRAT(   215 )      ! OPO3+HO2=0.4400D+00*XO2H+...
     &                      +    8.0000D-01 * RXRAT(   217 )      ! OPO3+RO2=0.8000D+00*XO2H+...
     &                      +                 RXRAT(   222 )      ! XPRP=XO2H+0.2680D+00*ALDX+...
     &                      +    1.2600D-01 * RXRAT(   224 )      ! XPAR=0.1260D+00*XO2H+...
     &                      +    9.7000D-01 * RXRAT(   236 )      ! CL+PRPA=0.9700D+00*XO2H+...
     &                      +    9.9100D-01 * RXRAT(   237 )      ! CL+ETHA=0.9910D+00*XO2H+...
     &                      +    9.6000D-01 * RXRAT(   241 )      ! CL+ISOP=0.9600D+00*XO2H+...
     &                      +    7.0000D-02 * RXRAT(   248 )      ! CL+TOL=0.7000D-01*XO2H+...
     &                      +    5.8000D-02 * RXRAT(   249 )      ! CL+XYLMN=0.5800D-01*XO2H+...
     &                      +    5.8000D-02 * RXRAT(   250 )      ! CL+NAPH=0.5800D-01*XO2H+...
     &                      +                 RXRAT(   359 )      ! OLE+BR=XO2H+ALD2+FMBR-PAR+RO2
     &                      +    9.6000D-01 * RXRAT(   360 )      ! ISOP+BR=0.9600D+00*XO2H+...
      LOSS(  XO2H         ) =                 RXRAT(    75 )      ! XO2H+NO=NO2+HO2
     &                      +                 RXRAT(    76 )      ! XO2H+HO2=ROOH
     &                      +                 RXRAT(    77 )      ! XO2H+C2O3=0.8000D+00*HO2+...
     &                      +                 RXRAT(    78 )      ! XO2H+RO2=0.6000D+00*HO2+RO2

      PROD(  PANX         ) =                 RXRAT(    62 )      ! CXO3+NO2=PANX
      LOSS(  PANX         ) =                 RXRAT(    63 )      ! PANX=NO2+CXO3
     &                      +                 RXRAT(    64 )      ! PANX=0.6000D+00*NO2+...
     &                      +                 RXRAT(   219 )      ! PANX+OH=ALD2+NO2

      PROD(  FORM         ) =                 RXRAT(    71 )      ! MEO2+NO=FORM+HO2+NO2
     &                      +    1.0000D-01 * RXRAT(    72 )      ! MEO2+HO2=0.1000D+00*FORM+...
     &                      +                 RXRAT(    73 )      ! MEO2+C2O3=FORM+0.9000D+...
     &                      +    6.8500D-01 * RXRAT(    74 )      ! MEO2+RO2=0.6850D+00*FORM+...
     &                      +    4.0000D-01 * RXRAT(    87 )      ! MEPX+OH=0.4000D+00*FORM+...
     &                      +                 RXRAT(   102 )      ! HCO3=FORM+HO2
     &                      +    7.4000D-01 * RXRAT(   114 )      ! GLYD=0.7400D+00*FORM+...
     &                      +                 RXRAT(   126 )      ! MEOH+OH=FORM+HO2
     &                      +    7.8000D-02 * RXRAT(   127 )      ! ETOH+OH=0.7800D-01*FORM+...
     &                      +                 RXRAT(   130 )      ! ACET+OH=FORM+C2O3+XO2+RO2
     &                      +                 RXRAT(   137 )      ! ETH+O=FORM+HO2+CO+0.7000D+...
     &                      +    1.5600D+00 * RXRAT(   138 )      ! ETH+OH=0.1560D+01*FORM+RO2+...
     &                      +                 RXRAT(   139 )      ! ETH+O3=FORM+0.5100D+00*CO+...
     &                      +    1.1250D+00 * RXRAT(   140 )      ! ETH+NO3=0.1125D+01*FORM+...
     &                      +    2.0000D-01 * RXRAT(   141 )      ! OLE+O=0.2000D+00*FORM+...
     &                      +    7.8100D-01 * RXRAT(   142 )      ! OLE+OH=0.7810D+00*FORM+...
     &                      +    5.5500D-01 * RXRAT(   143 )      ! OLE+O3=0.5550D+00*FORM+...
     &                      +    5.0000D-01 * RXRAT(   144 )      ! OLE+NO3=0.5000D+00*FORM+...
     &                      +    1.2800D-01 * RXRAT(   147 )      ! IOLE+O3=0.1280D+00*FORM+...
     &                      +    5.0000D-01 * RXRAT(   150 )      ! ISOP+O=0.5000D+00*FORM+...
     &                      +    6.7300D-01 * RXRAT(   151 )      ! ISO2+NO=0.6730D+00*FORM+...
     &                      +    1.2000D-01 * RXRAT(   152 )      ! ISO2+HO2=0.1200D+00*FORM+...
     &                      +    5.9800D-01 * RXRAT(   153 )      ! ISO2+C2O3=0.5980D+00*FORM+...
     &                      +    5.9800D-01 * RXRAT(   154 )      ! ISO2+RO2=0.5980D+00*FORM+...
     &                      +    6.0000D-01 * RXRAT(   156 )      ! ISOP+O3=0.6000D+00*FORM+...
     &                      +    3.5000D-01 * RXRAT(   157 )      ! ISOP+NO3=0.3500D+00*FORM+...
     &                      +    2.3100D-01 * RXRAT(   159 )      ! ISPD+O3=0.2310D+00*FORM+...
     &                      +    2.6000D-01 * RXRAT(   161 )      ! ISPD=0.2600D+00*FORM+...
     &                      +    3.7500D-01 * RXRAT(   166 )      ! EPX2+HO2=0.3750D+00*FORM+...
     &                      +    3.7500D-01 * RXRAT(   167 )      ! EPX2+NO=0.3750D+00*FORM+...
     &                      +    3.0000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.3000D+00*FORM+...
     &                      +    3.7500D-01 * RXRAT(   169 )      ! EPX2+RO2=0.3750D+00*FORM+...
     &                      +    5.9200D-01 * RXRAT(   170 )      ! INTR+OH=0.5920D+00*FORM+...
     &                      +    2.8000D-01 * RXRAT(   172 )      ! TERP+OH=0.2800D+00*FORM+...
     &                      +    2.4000D-01 * RXRAT(   173 )      ! TERP+O3=0.2400D+00*FORM+...
     &                      +    2.8000D-01 * RXRAT(   176 )      ! APIN+OH=0.2800D+00*FORM+...
     &                      +    2.4000D-01 * RXRAT(   177 )      ! APIN+O3=0.2400D+00*FORM+...
     &                      +                 RXRAT(   201 )      ! CRON=FORM+HO2+HONO+OPEN
     &                      +    8.0000D-02 * RXRAT(   208 )      ! OPEN+O3=0.8000D-01*FORM+...
     &                      +    1.4000D-01 * RXRAT(   210 )      ! CAT1+OH=0.1400D+00*FORM+...
     &                      +                 RXRAT(   231 )      ! CLO+MEO2=FORM+CL+HO2
     &                      +                 RXRAT(   238 )      ! CL+ETH=FORM+0.2000D+01*XO2+...
     &                      +                 RXRAT(   245 )      ! CL+MEOH=FORM+HO2+HCL
     &                      +                 RXRAT(   362 )      ! BRO+MEO2=FORM+0.2000D+...
     &                      +                 RXRAT(   363 )      ! CH3BR+OH=FORM+BR
     &                      +                 RXRAT(   411 )      ! CH3I+OH=FORM+I
     &                      +                 RXRAT(   426 )      ! MI2=FORM+0.2000D+01*I
     &                      +                 RXRAT(   427 )      ! MIB=FORM+BR+I
     &                      +                 RXRAT(   428 )      ! MIC=FORM+CL+I
     &                      +                 RXRAT(   439 )      ! DMS+OH=FORM+MEO2+SO2
     &                      +                 RXRAT(   441 )      ! DMS+NO3=FORM+HNO3+MEO2+SO2
     &                      +    4.5000D-01 * RXRAT(   442 )      ! DMS+CL=0.4500D+00*FORM+...
      LOSS(  FORM         ) =                 RXRAT(    96 )      ! FORM+OH=HO2+CO
     &                      +                 RXRAT(    97 )      ! FORM=0.2000D+01*HO2+CO
     &                      +                 RXRAT(    98 )      ! FORM=CO
     &                      +                 RXRAT(    99 )      ! FORM+O=OH+HO2+CO
     &                      +                 RXRAT(   100 )      ! FORM+NO3=HNO3+HO2+CO
     &                      +                 RXRAT(   101 )      ! FORM+HO2=HCO3
     &                      +                 RXRAT(   242 )      ! FORM+CL=HCL+HO2+CO
     &                      +                 RXRAT(   357 )      ! FORM+BR=HBR+HO2+CO

      PROD(  MEPX         ) =    9.0000D-01 * RXRAT(    72 )      ! MEO2+HO2=0.9000D+00*MEPX+...
     &                      +    5.0000D-01 * RXRAT(   104 )      ! HCO3+HO2=0.5000D+00*MEPX+...
      LOSS(  MEPX         ) =                 RXRAT(    87 )      ! MEPX+OH=0.6000D+00*MEO2+...
     &                      +                 RXRAT(    88 )      ! MEPX=MEO2+RO2+OH

      PROD(  MEOH         ) =    3.1500D-01 * RXRAT(    74 )      ! MEO2+RO2=0.3150D+00*MEOH+...
     &                      +    1.5000D-01 * RXRAT(   114 )      ! GLYD=0.1500D+00*MEOH+...
      LOSS(  MEOH         ) =                 RXRAT(   126 )      ! MEOH+OH=FORM+HO2
     &                      +                 RXRAT(   245 )      ! MEOH+CL=HCL+HO2+FORM

      PROD(  ROOH         ) =                 RXRAT(    76 )      ! XO2H+HO2=ROOH
     &                      +                 RXRAT(    80 )      ! XO2+HO2=ROOH
     &                      +                 RXRAT(    84 )      ! XO2N+HO2=ROOH
      LOSS(  ROOH         ) =                 RXRAT(    89 )      ! ROOH+OH=0.5400D+00*XO2H+...
     &                      +                 RXRAT(    90 )      ! ROOH=HO2+OH

      PROD(  XO2          ) =    2.0000D-01 * RXRAT(   116 )      ! GLY+OH=0.2000D+00*XO2+...
     &                      +    5.0000D-01 * RXRAT(   118 )      ! GLY+NO3=0.5000D+00*XO2+...
     &                      +                 RXRAT(   120 )      ! MGLY+NO3=XO2+C2O3+HNO3+RO2
     &                      +                 RXRAT(   130 )      ! ACET+OH=XO2+C2O3+FORM+RO2
     &                      +    5.0000D-01 * RXRAT(   140 )      ! ETH+NO3=0.5000D+00*XO2+...
     &                      +    1.9500D-01 * RXRAT(   142 )      ! OLE+OH=0.1950D+00*XO2+...
     &                      +    4.8000D-01 * RXRAT(   144 )      ! OLE+NO3=0.4800D+00*XO2+...
     &                      +    4.8000D-01 * RXRAT(   148 )      ! IOLE+NO3=0.4800D+00*XO2+...
     &                      +    2.5000D-01 * RXRAT(   150 )      ! ISOP+O=0.2500D+00*XO2+...
     &                      +    2.0000D-01 * RXRAT(   156 )      ! ISOP+O3=0.2000D+00*XO2+...
     &                      +    3.3000D-01 * RXRAT(   157 )      ! ISOP+NO3=0.3300D+00*XO2+...
     &                      +    5.2100D-01 * RXRAT(   158 )      ! ISPD+OH=0.5210D+00*XO2+...
     &                      +    1.4200D-01 * RXRAT(   160 )      ! ISPD+NO3=0.1420D+00*XO2+...
     &                      +    1.6000D-01 * RXRAT(   161 )      ! ISPD=0.1600D+00*XO2+...
     &                      +    6.3000D-01 * RXRAT(   170 )      ! INTR+OH=0.6300D+00*XO2+...
     &                      +    5.0000D-01 * RXRAT(   172 )      ! TERP+OH=0.5000D+00*XO2+...
     &                      +    6.9000D-01 * RXRAT(   173 )      ! TERP+O3=0.6900D+00*XO2+...
     &                      +    7.5000D-01 * RXRAT(   174 )      ! TERP+NO3=0.7500D+00*XO2+...
     &                      +    5.0000D-01 * RXRAT(   176 )      ! APIN+OH=0.5000D+00*XO2+...
     &                      +    6.9000D-01 * RXRAT(   177 )      ! APIN+O3=0.6900D+00*XO2+...
     &                      +    7.5000D-01 * RXRAT(   178 )      ! APIN+NO3=0.7500D+00*XO2+...
     &                      +    4.8000D-01 * RXRAT(   196 )      ! CRES+NO3=0.4800D+00*XO2+...
     &                      +    4.5000D-01 * RXRAT(   205 )      ! XOPN+NO3=0.4500D+00*XO2+...
     &                      +                 RXRAT(   216 )      ! OPO3+C2O3=XO2+MEO2+ALDX+...
     &                      +    8.7400D-01 * RXRAT(   224 )      ! XPAR=0.8740D+00*XO2+...
     &                      +    2.0000D+00 * RXRAT(   238 )      ! CL+ETH=0.2000D+01*XO2+FMCL+...
     &                      +    2.0000D+00 * RXRAT(   239 )      ! CL+OLE=0.2000D+01*XO2+...
     &                      +    1.7000D+00 * RXRAT(   240 )      ! CL+IOLE=0.1700D+01*XO2+...
      LOSS(  XO2          ) =                 RXRAT(    79 )      ! XO2+NO=NO2
     &                      +                 RXRAT(    80 )      ! XO2+HO2=ROOH
     &                      +                 RXRAT(    81 )      ! XO2+C2O3=0.8000D+00*MEO2+...
     &                      +                 RXRAT(    82 )      ! XO2+RO2=RO2

      PROD(  XO2N         ) =    6.0000D-02 * RXRAT(    89 )      ! ROOH+OH=0.6000D-01*XO2N+...
     &                      +    9.0000D-03 * RXRAT(   125 )      ! ETHA+OH=0.9000D-02*XO2N+...
     &                      +    4.0000D-02 * RXRAT(   133 )      ! ROR=0.4000D-01*XO2N+...
     &                      +    1.0000D-02 * RXRAT(   141 )      ! OLE+O=0.1000D-01*XO2N+...
     &                      +    2.4000D-02 * RXRAT(   142 )      ! OLE+OH=0.2400D-01*XO2N+...
     &                      +    4.0000D-02 * RXRAT(   144 )      ! OLE+NO3=0.4000D-01*XO2N+...
     &                      +    4.0000D-02 * RXRAT(   148 )      ! IOLE+NO3=0.4000D-01*XO2N+...
     &                      +    3.0000D-02 * RXRAT(   157 )      ! ISOP+NO3=0.3000D-01*XO2N+...
     &                      +    2.2000D-02 * RXRAT(   158 )      ! ISPD+OH=0.2200D-01*XO2N+...
     &                      +    2.5000D-01 * RXRAT(   172 )      ! TERP+OH=0.2500D+00*XO2N+...
     &                      +    1.8000D-01 * RXRAT(   173 )      ! TERP+O3=0.1800D+00*XO2N+...
     &                      +    2.5000D-01 * RXRAT(   174 )      ! TERP+NO3=0.2500D+00*XO2N+...
     &                      +    2.5000D-01 * RXRAT(   176 )      ! APIN+OH=0.2500D+00*XO2N+...
     &                      +    1.8000D-01 * RXRAT(   177 )      ! APIN+O3=0.1800D+00*XO2N+...
     &                      +    2.5000D-01 * RXRAT(   178 )      ! APIN+NO3=0.2500D+00*XO2N+...
     &                      +    2.0000D-02 * RXRAT(   195 )      ! CRES+OH=0.2000D-01*XO2N+...
     &                      +    1.0000D-01 * RXRAT(   196 )      ! CRES+NO3=0.1000D+00*XO2N+...
     &                      +    1.0000D-01 * RXRAT(   205 )      ! XOPN+NO3=0.1000D+00*XO2N+...
     &                      +                 RXRAT(   221 )      ! XPRP=XO2N+RO2
     &                      +                 RXRAT(   223 )      ! XPAR=XO2N+RO2
     &                      +    3.0000D-02 * RXRAT(   236 )      ! CL+PRPA=0.3000D-01*XO2N+...
     &                      +    9.0000D-03 * RXRAT(   237 )      ! CL+ETHA=0.9000D-02*XO2N+...
     &                      +    4.0000D-02 * RXRAT(   241 )      ! CL+ISOP=0.4000D-01*XO2N+...
     &                      +    4.0000D-02 * RXRAT(   360 )      ! ISOP+BR=0.4000D-01*XO2N+...
      LOSS(  XO2N         ) =                 RXRAT(    83 )      ! XO2N+NO=0.5000D+00*NTR1+...
     &                      +                 RXRAT(    84 )      ! XO2N+HO2=ROOH
     &                      +                 RXRAT(    85 )      ! XO2N+C2O3=0.8000D+00*HO2+...
     &                      +                 RXRAT(    86 )      ! XO2N+RO2=RO2

      PROD(  NTR1         ) =    5.0000D-01 * RXRAT(    83 )      ! XO2N+NO=0.5000D+00*NTR1+...
     &                      +                 RXRAT(   135 )      ! ROR+NO2=NTR1
     &                      +    5.0000D-01 * RXRAT(   140 )      ! ETH+NO3=0.5000D+00*NTR1+...
     &                      +    5.0000D-01 * RXRAT(   144 )      ! OLE+NO3=0.5000D+00*NTR1+...
     &                      +    5.0000D-01 * RXRAT(   148 )      ! IOLE+NO3=0.5000D+00*NTR1+...
      LOSS(  NTR1         ) =                 RXRAT(    91 )      ! NTR1+OH=NTR2
     &                      +                 RXRAT(    92 )      ! NTR1=NO2

      PROD(  NTR2         ) =    5.0000D-01 * RXRAT(    83 )      ! XO2N+NO=0.5000D+00*NTR2+...
     &                      +                 RXRAT(    91 )      ! NTR1+OH=NTR2
     &                      +    6.5000D-01 * RXRAT(   157 )      ! ISOP+NO3=0.6500D+00*NTR2+...
     &                      +    1.4200D-01 * RXRAT(   160 )      ! ISPD+NO3=0.1420D+00*NTR2+...
     &                      +    2.6600D-01 * RXRAT(   170 )      ! INTR+OH=0.2660D+00*NTR2+...
     &                      +    5.3000D-01 * RXRAT(   174 )      ! TERP+NO3=0.5300D+00*NTR2+...
     &                      +    5.3000D-01 * RXRAT(   178 )      ! APIN+NO3=0.5300D+00*NTR2+...
     &                      +    8.2000D-02 * RXRAT(   180 )      ! BZO2+NO=0.8200D-01*NTR2+...
     &                      +    1.4000D-01 * RXRAT(   185 )      ! TO2+NO=0.1400D+00*NTR2+...
     &                      +    1.4000D-01 * RXRAT(   191 )      ! XLO2+NO=0.1400D+00*NTR2+...
     &                      +                 RXRAT(   199 )      ! CRON+OH=NTR2+0.5000D+00*CRO
     &                      +                 RXRAT(   200 )      ! CRON+NO3=NTR2+0.5000D+...
     &                      +    5.0000D-01 * RXRAT(   205 )      ! XOPN+NO3=0.5000D+00*NTR2+...
     &                      +    5.0000D-01 * RXRAT(   218 )      ! OPAN+OH=0.5000D+00*NTR2+...
      LOSS(  NTR2         ) =                 RXRAT(   268 )      ! NTR2=HNO3

      PROD(  FACD         ) =                 RXRAT(   103 )      ! HCO3+NO=FACD+NO2+HO2
     &                      +    5.0000D-01 * RXRAT(   104 )      ! HCO3+HO2=0.5000D+00*FACD+...
     &                      +    3.0000D-01 * RXRAT(   136 )      ! ETHY+OH=0.3000D+00*FACD+...
     &                      +    3.7000D-01 * RXRAT(   139 )      ! ETH+O3=0.3700D+00*FACD+...
     &                      +    9.0000D-02 * RXRAT(   143 )      ! OLE+O3=0.9000D-01*FACD+...
     &                      +    1.5000D-01 * RXRAT(   159 )      ! ISPD+O3=0.1500D+00*FACD+...
     &                      +    7.4000D-02 * RXRAT(   166 )      ! EPX2+HO2=0.7400D-01*FACD+...
     &                      +    1.8500D-01 * RXRAT(   170 )      ! INTR+OH=0.1850D+00*FACD+...
      LOSS(  FACD         ) =                 RXRAT(    93 )      ! FACD+OH=HO2

      PROD(  CO           ) =                 RXRAT(    96 )      ! FORM+OH=CO+HO2
     &                      +                 RXRAT(    97 )      ! FORM=CO+0.2000D+01*HO2
     &                      +                 RXRAT(    98 )      ! FORM=CO
     &                      +                 RXRAT(    99 )      ! FORM+O=CO+HO2+OH
     &                      +                 RXRAT(   100 )      ! FORM+NO3=CO+HO2+HNO3
     &                      +                 RXRAT(   108 )      ! ALD2=CO+RO2+MEO2+HO2
     &                      +                 RXRAT(   112 )      ! ALDX=CO+XO2H+RO2+ALD2+HO2
     &                      +    8.9000D-01 * RXRAT(   114 )      ! GLYD=0.8900D+00*CO+0.7400D+...
     &                      +    1.8000D+00 * RXRAT(   116 )      ! GLY+OH=0.1800D+01*CO+...
     &                      +    2.0000D+00 * RXRAT(   117 )      ! GLY=0.2000D+01*CO+0.2000D+...
     &                      +    1.5000D+00 * RXRAT(   118 )      ! GLY+NO3=0.1500D+01*CO+HNO3+...
     &                      +                 RXRAT(   119 )      ! MGLY=CO+HO2+C2O3
     &                      +                 RXRAT(   121 )      ! MGLY+OH=CO+C2O3
     &                      +    3.8000D-01 * RXRAT(   129 )      ! ACET=0.3800D+00*CO+0.1380D+...
     &                      +    3.0000D-01 * RXRAT(   136 )      ! ETHY+OH=0.3000D+00*CO+...
     &                      +                 RXRAT(   137 )      ! ETH+O=CO+HO2+FORM+0.7000D+...
     &                      +    5.1000D-01 * RXRAT(   139 )      ! ETH+O3=0.5100D+00*CO+FORM+...
     &                      +    2.0000D-01 * RXRAT(   141 )      ! OLE+O=0.2000D+00*CO+...
     &                      +    3.7800D-01 * RXRAT(   143 )      ! OLE+O3=0.3780D+00*CO+...
     &                      +    1.0000D-01 * RXRAT(   145 )      ! IOLE+O=0.1000D+00*CO+...
     &                      +    2.4500D-01 * RXRAT(   147 )      ! IOLE+O3=0.2450D+00*CO+...
     &                      +    6.6000D-02 * RXRAT(   156 )      ! ISOP+O3=0.6600D-01*CO+...
     &                      +    1.3700D-01 * RXRAT(   158 )      ! ISPD+OH=0.1370D+00*CO+...
     &                      +    5.4300D-01 * RXRAT(   159 )      ! ISPD+O3=0.5430D+00*CO+...
     &                      +    2.5100D-01 * RXRAT(   166 )      ! EPX2+HO2=0.2510D+00*CO+...
     &                      +    2.5100D-01 * RXRAT(   167 )      ! EPX2+NO=0.2510D+00*CO+...
     &                      +    2.0000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.2000D+00*CO+...
     &                      +    2.5100D-01 * RXRAT(   169 )      ! EPX2+RO2=0.2510D+00*CO+...
     &                      +    1.0000D-03 * RXRAT(   173 )      ! TERP+O3=0.1000D-02*CO+...
     &                      +    1.0000D-03 * RXRAT(   177 )      ! APIN+O3=0.1000D-02*CO+...
     &                      +    7.0000D-01 * RXRAT(   202 )      ! XOPN=0.7000D+00*CO+XO2H+...
     &                      +    5.0000D-01 * RXRAT(   204 )      ! XOPN+O3=0.5000D+00*CO+...
     &                      +                 RXRAT(   206 )      ! OPEN=CO+HO2+OPO3
     &                      +    1.9800D+00 * RXRAT(   208 )      ! OPEN+O3=0.1980D+01*CO+...
     &                      +    5.0000D-01 * RXRAT(   212 )      ! OPO3+NO=0.5000D+00*CO+...
     &                      +                 RXRAT(   218 )      ! OPAN+OH=CO+0.5000D+00*GLY+...
     &                      +                 RXRAT(   232 )      ! OH+FMCL=CO+CL
     &                      +                 RXRAT(   233 )      ! FMCL=CO+CL+HO2
     &                      +                 RXRAT(   242 )      ! CL+FORM=CO+HO2+HCL
     &                      +                 RXRAT(   357 )      ! FORM+BR=CO+HO2+HBR
     &                      +                 RXRAT(   361 )      ! FMBR+OH=CO+BR
     &                      +                 RXRAT(   364 )      ! MB3+OH=CO+0.3000D+01*BR
     &                      +                 RXRAT(   365 )      ! MB2+OH=CO+HO2+0.2000D+01*BR
     &                      +                 RXRAT(   366 )      ! MB2C+OH=CO+CL+0.2000D+01*BR
     &                      +                 RXRAT(   367 )      ! MBC2+OH=CO+0.2000D+01*CL+BR
     &                      +                 RXRAT(   368 )      ! MBC+OH=CO+CL+BR+HO2
     &                      +                 RXRAT(   377 )      ! FMBR=CO+BR+HO2
     &                      +                 RXRAT(   378 )      ! MB3=CO+HO2+0.3000D+01*BR
     &                      +                 RXRAT(   379 )      ! MB2C=CO+CL+HO2+0.2000D+01*BR
     &                      +                 RXRAT(   380 )      ! MBC2=CO+0.2000D+01*CL+HO2+BR
      LOSS(  CO           ) =                 RXRAT(   123 )      ! CO+OH=HO2

      PROD(  HCO3         ) =                 RXRAT(   101 )      ! FORM+HO2=HCO3
      LOSS(  HCO3         ) =                 RXRAT(   102 )      ! HCO3=FORM+HO2
     &                      +                 RXRAT(   103 )      ! HCO3+NO=FACD+NO2+HO2
     &                      +                 RXRAT(   104 )      ! HCO3+HO2=0.5000D+00*MEPX+...

      PROD(  ALDX         ) =    3.7000D-01 * RXRAT(   133 )      ! ROR=0.3700D+00*ALDX+...
     &                      +    3.0000D-01 * RXRAT(   141 )      ! OLE+O=0.3000D+00*ALDX+...
     &                      +    4.8800D-01 * RXRAT(   142 )      ! OLE+OH=0.4880D+00*ALDX+...
     &                      +    2.7000D-01 * RXRAT(   143 )      ! OLE+O3=0.2700D+00*ALDX+...
     &                      +    3.7500D-01 * RXRAT(   144 )      ! OLE+NO3=0.3750D+00*ALDX+...
     &                      +    6.6000D-01 * RXRAT(   145 )      ! IOLE+O=0.6600D+00*ALDX+...
     &                      +    7.0000D-01 * RXRAT(   146 )      ! IOLE+OH=0.7000D+00*ALDX+...
     &                      +    4.4200D-01 * RXRAT(   147 )      ! IOLE+O3=0.4420D+00*ALDX+...
     &                      +    6.2500D-01 * RXRAT(   148 )      ! IOLE+NO3=0.6250D+00*ALDX+...
     &                      +    1.5000D-01 * RXRAT(   156 )      ! ISOP+O3=0.1500D+00*ALDX+...
     &                      +    2.9000D-02 * RXRAT(   162 )      ! ISPX+OH=0.2900D-01*ALDX+...
     &                      +    7.8000D-02 * RXRAT(   170 )      ! INTR+OH=0.7800D-01*ALDX+...
     &                      +    1.5000D-01 * RXRAT(   171 )      ! TERP+O=0.1500D+00*ALDX+...
     &                      +    4.7000D-01 * RXRAT(   172 )      ! TERP+OH=0.4700D+00*ALDX+...
     &                      +    2.1000D-01 * RXRAT(   173 )      ! TERP+O3=0.2100D+00*ALDX+...
     &                      +    4.7000D-01 * RXRAT(   174 )      ! TERP+NO3=0.4700D+00*ALDX+...
     &                      +    1.5000D-01 * RXRAT(   175 )      ! APIN+O=0.1500D+00*ALDX+...
     &                      +    4.7000D-01 * RXRAT(   176 )      ! APIN+OH=0.4700D+00*ALDX+...
     &                      +    2.1000D-01 * RXRAT(   177 )      ! APIN+O3=0.2100D+00*ALDX+...
     &                      +    4.7000D-01 * RXRAT(   178 )      ! APIN+NO3=0.4700D+00*ALDX+...
     &                      +    4.4000D-01 * RXRAT(   215 )      ! OPO3+HO2=0.4400D+00*ALDX+...
     &                      +                 RXRAT(   216 )      ! OPO3+C2O3=ALDX+XO2+MEO2+...
     &                      +    8.0000D-01 * RXRAT(   217 )      ! OPO3+RO2=0.8000D+00*ALDX+...
     &                      +    2.6800D-01 * RXRAT(   222 )      ! XPRP=0.2680D+00*ALDX+...
     &                      +    1.2600D-01 * RXRAT(   224 )      ! XPAR=0.1260D+00*ALDX+...
     &                      +    6.7000D-01 * RXRAT(   239 )      ! CL+OLE=0.6700D+00*ALDX+...
     &                      +    5.5000D-01 * RXRAT(   240 )      ! CL+IOLE=0.5500D+00*ALDX+...
      LOSS(  ALDX         ) =                 RXRAT(   109 )      ! ALDX+O=CXO3+OH
     &                      +                 RXRAT(   110 )      ! ALDX+OH=CXO3
     &                      +                 RXRAT(   111 )      ! ALDX+NO3=CXO3+HNO3
     &                      +                 RXRAT(   112 )      ! ALDX=ALD2+XO2H+RO2+CO+HO2
     &                      +                 RXRAT(   244 )      ! ALDX+CL=HCL+CXO3

      PROD(  GLYD         ) =    1.1000D-02 * RXRAT(   127 )      ! ETOH+OH=0.1100D-01*GLYD+...
     &                      +    2.2000D-01 * RXRAT(   138 )      ! ETH+OH=0.2200D+00*GLYD+RO2+...
     &                      +    2.6900D-01 * RXRAT(   158 )      ! ISPD+OH=0.2690D+00*GLYD+...
     &                      +    1.1300D-01 * RXRAT(   160 )      ! ISPD+NO3=0.1130D+00*GLYD+...
     &                      +    1.2800D-01 * RXRAT(   161 )      ! ISPD=0.1280D+00*GLYD+...
     &                      +    2.7500D-01 * RXRAT(   166 )      ! EPX2+HO2=0.2750D+00*GLYD+...
     &                      +    2.7500D-01 * RXRAT(   167 )      ! EPX2+NO=0.2750D+00*GLYD+...
     &                      +    2.2000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.2200D+00*GLYD+...
     &                      +    2.7500D-01 * RXRAT(   169 )      ! EPX2+RO2=0.2750D+00*GLYD+...
     &                      +    3.3100D-01 * RXRAT(   170 )      ! INTR+OH=0.3310D+00*GLYD+...
      LOSS(  GLYD         ) =                 RXRAT(   113 )      ! GLYD+OH=0.2000D+00*GLY+...
     &                      +                 RXRAT(   114 )      ! GLYD=0.7400D+00*FORM+...
     &                      +                 RXRAT(   115 )      ! GLYD+NO3=HNO3+C2O3

      PROD(  GLY          ) =    2.0000D-01 * RXRAT(   113 )      ! GLYD+OH=0.2000D+00*GLY+...
     &                      +    1.1000D-01 * RXRAT(   114 )      ! GLYD=0.1100D+00*GLY+...
     &                      +    7.0000D-01 * RXRAT(   136 )      ! ETHY+OH=0.7000D+00*GLY+...
     &                      +    7.5000D-02 * RXRAT(   143 )      ! OLE+O3=0.7500D-01*GLY+...
     &                      +    2.4000D-01 * RXRAT(   147 )      ! IOLE+O3=0.2400D+00*GLY+...
     &                      +    1.7000D-01 * RXRAT(   159 )      ! ISPD+O3=0.1700D+00*GLY+...
     &                      +    2.7500D-01 * RXRAT(   166 )      ! EPX2+HO2=0.2750D+00*GLY+...
     &                      +    2.7500D-01 * RXRAT(   167 )      ! EPX2+NO=0.2750D+00*GLY+...
     &                      +    2.2000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.2200D+00*GLY+...
     &                      +    2.7500D-01 * RXRAT(   169 )      ! EPX2+RO2=0.2750D+00*GLY+...
     &                      +    9.1800D-01 * RXRAT(   180 )      ! BZO2+NO=0.9180D+00*GLY+...
     &                      +                 RXRAT(   181 )      ! BZO2+C2O3=GLY+OPEN+HO2+...
     &                      +                 RXRAT(   183 )      ! BZO2+RO2=GLY+OPEN+HO2+RO2
     &                      +    4.1700D-01 * RXRAT(   185 )      ! TO2+NO=0.4170D+00*GLY+...
     &                      +    4.8000D-01 * RXRAT(   186 )      ! TO2+C2O3=0.4800D+00*GLY+...
     &                      +    4.8000D-01 * RXRAT(   188 )      ! TO2+RO2=0.4800D+00*GLY+...
     &                      +    2.2100D-01 * RXRAT(   191 )      ! XLO2+NO=0.2210D+00*GLY+...
     &                      +    2.6000D-01 * RXRAT(   193 )      ! XLO2+C2O3=0.2600D+00*GLY+...
     &                      +    2.6000D-01 * RXRAT(   194 )      ! XLO2+RO2=0.2600D+00*GLY+...
     &                      +    2.5000D-02 * RXRAT(   195 )      ! CRES+OH=0.2500D-01*GLY+...
     &                      +    2.4000D-01 * RXRAT(   196 )      ! CRES+NO3=0.2400D+00*GLY+...
     &                      +    4.0000D-01 * RXRAT(   202 )      ! XOPN=0.4000D+00*GLY+XO2H+...
     &                      +    4.0000D-01 * RXRAT(   203 )      ! XOPN+OH=0.4000D+00*GLY+...
     &                      +    4.0000D-01 * RXRAT(   207 )      ! OPEN+OH=0.4000D+00*GLY+...
     &                      +    1.4000D+00 * RXRAT(   208 )      ! OPEN+O3=0.1400D+01*GLY+...
     &                      +    5.0000D-01 * RXRAT(   212 )      ! OPO3+NO=0.5000D+00*GLY+NO2+...
     &                      +    5.0000D-01 * RXRAT(   218 )      ! OPAN+OH=0.5000D+00*GLY+...
      LOSS(  GLY          ) =                 RXRAT(   116 )      ! GLY+OH=0.1800D+01*CO+...
     &                      +                 RXRAT(   117 )      ! GLY=0.2000D+01*HO2+0.2000D+...
     &                      +                 RXRAT(   118 )      ! GLY+NO3=HNO3+0.1500D+01*CO+...
     &                      +                 RXRAT(   280 )      ! GLY=AGLYJ

      PROD(  MGLY         ) =    7.5000D-02 * RXRAT(   143 )      ! OLE+O3=0.7500D-01*MGLY+...
     &                      +    6.0000D-02 * RXRAT(   147 )      ! IOLE+O3=0.6000D-01*MGLY+...
     &                      +    1.1500D-01 * RXRAT(   158 )      ! ISPD+OH=0.1150D+00*MGLY+...
     &                      +    5.3100D-01 * RXRAT(   159 )      ! ISPD+O3=0.5310D+00*MGLY+...
     &                      +    1.1300D-01 * RXRAT(   160 )      ! ISPD+NO3=0.1130D+00*MGLY+...
     &                      +    2.7500D-01 * RXRAT(   166 )      ! EPX2+HO2=0.2750D+00*MGLY+...
     &                      +    2.7500D-01 * RXRAT(   167 )      ! EPX2+NO=0.2750D+00*MGLY+...
     &                      +    2.2000D-01 * RXRAT(   168 )      ! EPX2+C2O3=0.2200D+00*MGLY+...
     &                      +    2.7500D-01 * RXRAT(   169 )      ! EPX2+RO2=0.2750D+00*MGLY+...
     &                      +    4.4300D-01 * RXRAT(   185 )      ! TO2+NO=0.4430D+00*MGLY+...
     &                      +    5.2000D-01 * RXRAT(   186 )      ! TO2+C2O3=0.5200D+00*MGLY+...
     &                      +    5.2000D-01 * RXRAT(   188 )      ! TO2+RO2=0.5200D+00*MGLY+...
     &                      +    6.7500D-01 * RXRAT(   191 )      ! XLO2+NO=0.6750D+00*MGLY+...
     &                      +    7.7000D-01 * RXRAT(   193 )      ! XLO2+C2O3=0.7700D+00*MGLY+...
     &                      +    7.7000D-01 * RXRAT(   194 )      ! XLO2+RO2=0.7700D+00*MGLY+...
     &                      +    2.4000D-01 * RXRAT(   196 )      ! CRES+NO3=0.2400D+00*MGLY+...
     &                      +                 RXRAT(   203 )      ! XOPN+OH=MGLY+0.4000D+...
     &                      +    1.2000D+00 * RXRAT(   204 )      ! XOPN+O3=0.1200D+01*MGLY+...
     &                      +    2.5000D-01 * RXRAT(   205 )      ! XOPN+NO3=0.2500D+00*MGLY+...
     &                      +    2.4000D-01 * RXRAT(   208 )      ! OPEN+O3=0.2400D+00*MGLY+...
      LOSS(  MGLY         ) =                 RXRAT(   119 )      ! MGLY=C2O3+HO2+CO
     &                      +                 RXRAT(   120 )      ! MGLY+NO3=HNO3+C2O3+XO2+RO2
     &                      +                 RXRAT(   121 )      ! MGLY+OH=C2O3+CO
     &                      +                 RXRAT(   281 )      ! MGLY=AGLYJ

      PROD(  ETHA         ) =   0.0D0
      LOSS(  ETHA         ) =                 RXRAT(   125 )      ! ETHA+OH=0.9910D+00*ALD2+...
     &                      +                 RXRAT(   237 )      ! ETHA+CL=HCL+0.9910D+...

      PROD(  ETOH         ) =   0.0D0
      LOSS(  ETOH         ) =                 RXRAT(   127 )      ! ETOH+OH=0.9500D+00*ALD2+...
     &                      +                 RXRAT(   246 )      ! ETOH+CL=HCL+HO2+ALD2

      PROD(  KET          ) =    2.0000D-01 * RXRAT(   133 )      ! ROR=0.2000D+00*KET+0.4200D+...
     &                      +                 RXRAT(   134 )      ! ROR=KET+HO2
      LOSS(  KET          ) =                 RXRAT(   128 )      ! KET=0.5000D+00*ALD2+...

      PROD(  PAR          ) =    2.0000D-01 * RXRAT(   141 )      ! OLE+O=0.2000D+00*PAR+...
     &                      +    1.0000D-01 * RXRAT(   145 )      ! IOLE+O=0.1000D+00*PAR+...
     &                      +    2.9000D-01 * RXRAT(   147 )      ! IOLE+O3=0.2900D+00*PAR+...
     &                      +                 RXRAT(   148 )      ! IOLE+NO3=PAR+0.5000D+...
     &                      +    2.5000D-01 * RXRAT(   150 )      ! ISOP+O=0.2500D+00*PAR+...
     &                      +    3.5000D-01 * RXRAT(   156 )      ! ISOP+O3=0.3500D+00*PAR+...
     &                      +    1.1700D-01 * RXRAT(   158 )      ! ISPD+OH=0.1170D+00*PAR+...
     &                      +    7.1700D-01 * RXRAT(   160 )      ! ISPD+NO3=0.7170D+00*PAR+...
     &                      +    2.4000D-01 * RXRAT(   161 )      ! ISPD=0.2400D+00*PAR+...
     &                      +    2.1750D+00 * RXRAT(   166 )      ! EPX2+HO2=0.2175D+01*PAR+...
     &                      +    2.1750D+00 * RXRAT(   167 )      ! EPX2+NO=0.2175D+01*PAR+...
     &                      +    1.7400D+00 * RXRAT(   168 )      ! EPX2+C2O3=0.1740D+01*PAR+...
     &                      +    2.1750D+00 * RXRAT(   169 )      ! EPX2+RO2=0.2175D+01*PAR+...
     &                      +    2.7000D+00 * RXRAT(   170 )      ! INTR+OH=0.2700D+01*PAR+...
     &                      +    5.1200D+00 * RXRAT(   171 )      ! TERP+O=0.5120D+01*PAR+...
     &                      +    1.6600D+00 * RXRAT(   172 )      ! TERP+OH=0.1660D+01*PAR+...
     &                      +    7.0000D+00 * RXRAT(   173 )      ! TERP+O3=0.7000D+01*PAR+...
     &                      +    5.1200D+00 * RXRAT(   175 )      ! APIN+O=0.5120D+01*PAR+...
     &                      +    1.6600D+00 * RXRAT(   176 )      ! APIN+OH=0.1660D+01*PAR+...
     &                      +    7.0000D+00 * RXRAT(   177 )      ! APIN+O3=0.7000D+01*PAR+...
     &                      +    2.6800D-01 * RXRAT(   222 )      ! XPRP=0.2680D+00*PAR+...
     &                      +    3.0000D-01 * RXRAT(   240 )      ! CL+IOLE=0.3000D+00*PAR+...
      LOSS(  PAR          ) =    2.5000D+00 * RXRAT(   128 )      ! KET=-0.2500D+01*PAR+...
     &                      +                 RXRAT(   132 )      ! PAR+OH=XPAR
     &                      +    2.7000D+00 * RXRAT(   133 )      ! ROR=-0.2700D+01*PAR+...
     &                      +    7.3000D-01 * RXRAT(   142 )      ! OLE+OH=-0.7300D+00*PAR+...
     &                      +    7.9000D-01 * RXRAT(   143 )      ! OLE+O3=-0.7900D+00*PAR+...
     &                      +                 RXRAT(   144 )      ! OLE+NO3=-PAR+0.5000D+...
     &                      +    1.2600D-01 * RXRAT(   224 )      ! XPAR=-0.1260D+00*PAR+...
     &                      +                 RXRAT(   235 )      ! PAR+CL=HCL+XPAR
     &                      +                 RXRAT(   239 )      ! CL+OLE=-PAR+0.3300D+...
     &                      +                 RXRAT(   359 )      ! OLE+BR=-PAR+ALD2+XO2H+FMBR+RO2

      PROD(  ACET         ) =    4.2000D-01 * RXRAT(   133 )      ! ROR=0.4200D+00*ACET+...
     &                      +    1.3700D-01 * RXRAT(   158 )      ! ISPD+OH=0.1370D+00*ACET+...
     &                      +    1.7000D-01 * RXRAT(   159 )      ! ISPD+O3=0.1700D+00*ACET+...
     &                      +    1.7000D-01 * RXRAT(   161 )      ! ISPD=0.1700D+00*ACET+...
     &                      +    7.3200D-01 * RXRAT(   222 )      ! XPRP=0.7320D+00*ACET+...
     &                      +                 RXRAT(   236 )      ! CL+PRPA=ACET+HCL+0.9700D+...
      LOSS(  ACET         ) =                 RXRAT(   129 )      ! ACET=0.3800D+00*CO+0.1380D+...
     &                      +                 RXRAT(   130 )      ! ACET+OH=FORM+C2O3+XO2+RO2

      PROD(  PRPA         ) =   0.0D0
      LOSS(  PRPA         ) =                 RXRAT(   131 )      ! PRPA+OH=XPRP
     &                      +                 RXRAT(   236 )      ! PRPA+CL=HCL+ACET+0.9700D+...

      PROD(  XPRP         ) =                 RXRAT(   131 )      ! PRPA+OH=XPRP
      LOSS(  XPRP         ) =                 RXRAT(   221 )      ! XPRP=XO2N+RO2
     &                      +                 RXRAT(   222 )      ! XPRP=0.7320D+00*ACET+...

      PROD(  XPAR         ) =                 RXRAT(   132 )      ! PAR+OH=XPAR
     &                      +                 RXRAT(   235 )      ! CL+PAR=XPAR+HCL
      LOSS(  XPAR         ) =                 RXRAT(   223 )      ! XPAR=XO2N+RO2
     &                      +                 RXRAT(   224 )      ! XPAR=0.1260D+00*ALDX+...

      PROD(  ROR          ) =    8.7400D-01 * RXRAT(   224 )      ! XPAR=0.8740D+00*ROR+...
      LOSS(  ROR          ) =    9.8000D-01 * RXRAT(   133 )      ! ROR=0.2000D-01*ROR+0.4200D+...
     &                      +                 RXRAT(   134 )      ! ROR=KET+HO2
     &                      +                 RXRAT(   135 )      ! ROR+NO2=NTR1

      PROD(  ETHY         ) =   0.0D0
      LOSS(  ETHY         ) =                 RXRAT(   136 )      ! ETHY+OH=0.7000D+00*GLY+...

      PROD(  ETH          ) =   0.0D0
      LOSS(  ETH          ) =                 RXRAT(   137 )      ! ETH+O=FORM+HO2+CO+0.7000D+...
     &                      +                 RXRAT(   138 )      ! ETH+OH=XO2H+RO2+0.1560D+...
     &                      +                 RXRAT(   139 )      ! ETH+O3=FORM+0.5100D+00*CO+...
     &                      +                 RXRAT(   140 )      ! ETH+NO3=0.5000D+00*NO2+...
     &                      +                 RXRAT(   238 )      ! ETH+CL=FMCL+0.2000D+01*XO2+...

      PROD(  OLE          ) =    2.4000D-01 * RXRAT(   161 )      ! ISPD=0.2400D+00*OLE+...
     &                      +    9.8000D-02 * RXRAT(   170 )      ! INTR+OH=0.9800D-01*OLE+...
     &                      +    3.0000D-01 * RXRAT(   240 )      ! CL+IOLE=0.3000D+00*OLE+...
      LOSS(  OLE          ) =                 RXRAT(   141 )      ! OLE+O=0.2000D+00*ALD2+...
     &                      +                 RXRAT(   142 )      ! OLE+OH=0.7810D+00*FORM+...
     &                      +                 RXRAT(   143 )      ! OLE+O3=0.2950D+00*ALD2+...
     &                      +                 RXRAT(   144 )      ! OLE+NO3=0.5000D+00*NO2+...
     &                      +                 RXRAT(   239 )      ! OLE+CL=FMCL+0.3300D+...
     &                      +                 RXRAT(   359 )      ! OLE+BR=FMBR+ALD2+XO2H-PAR+RO2

      PROD(  IOLE         ) =    2.9000D-02 * RXRAT(   162 )      ! ISPX+OH=0.2900D-01*IOLE+...
      LOSS(  IOLE         ) =                 RXRAT(   145 )      ! IOLE+O=0.1240D+01*ALD2+...
     &                      +                 RXRAT(   146 )      ! IOLE+OH=0.1300D+01*ALD2+...
     &                      +                 RXRAT(   147 )      ! IOLE+O3=0.7320D+00*ALD2+...
     &                      +                 RXRAT(   148 )      ! IOLE+NO3=0.5000D+00*NO2+...
     &                      +                 RXRAT(   240 )      ! IOLE+CL=0.3000D+00*HCL+...

      PROD(  ISOP         ) =   0.0D0
      LOSS(  ISOP         ) =                 RXRAT(   149 )      ! ISOP+OH=ISO2+RO2+ISOPRXN
     &                      +                 RXRAT(   150 )      ! ISOP+O=0.7500D+00*ISPD+...
     &                      +                 RXRAT(   156 )      ! ISOP+O3=0.6000D+00*FORM+...
     &                      +                 RXRAT(   157 )      ! ISOP+NO3=0.3500D+00*NO2+...
     &                      +                 RXRAT(   241 )      ! ISOP+CL=FMCL+ISPD+0.9600D+...
     &                      +                 RXRAT(   360 )      ! ISOP+BR=FMBR+ISPD+0.9600D+...

      PROD(  ISO2         ) =                 RXRAT(   149 )      ! ISOP+OH=ISO2+RO2+ISOPRXN
     &                      +    6.7000D-02 * RXRAT(   162 )      ! ISPX+OH=0.6700D-01*ISO2+...
      LOSS(  ISO2         ) =                 RXRAT(   151 )      ! ISO2+NO=0.1000D+00*INTR+...
     &                      +                 RXRAT(   152 )      ! ISO2+HO2=0.8800D+00*ISPX+...
     &                      +                 RXRAT(   153 )      ! ISO2+C2O3=0.5980D+00*FORM+...
     &                      +                 RXRAT(   154 )      ! ISO2+RO2=0.5980D+00*FORM+...
     &                      +                 RXRAT(   155 )      ! ISO2=HO2+HPLD

      PROD(  ISOPRXN      ) =                 RXRAT(   149 )      ! ISOP+OH=ISOPRXN+RO2+ISO2
     &                      +                 RXRAT(   157 )      ! ISOP+NO3=ISOPRXN+0.6500D+...
      LOSS(  ISOPRXN      ) =   0.0D0

      PROD(  ISPD         ) =    7.5000D-01 * RXRAT(   150 )      ! ISOP+O=0.7500D+00*ISPD+...
     &                      +    9.0000D-01 * RXRAT(   151 )      ! ISO2+NO=0.9000D+00*ISPD+...
     &                      +    1.2000D-01 * RXRAT(   152 )      ! ISO2+HO2=0.1200D+00*ISPD+...
     &                      +                 RXRAT(   153 )      ! ISO2+C2O3=ISPD+0.5980D+...
     &                      +                 RXRAT(   154 )      ! ISO2+RO2=ISPD+0.5980D+...
     &                      +    6.5000D-01 * RXRAT(   156 )      ! ISOP+O3=0.6500D+00*ISPD+...
     &                      +    3.5000D-01 * RXRAT(   157 )      ! ISOP+NO3=0.3500D+00*ISPD+...
     &                      +                 RXRAT(   163 )      ! HPLD=ISPD+OH
     &                      +                 RXRAT(   164 )      ! HPLD+NO3=ISPD+HNO3
     &                      +                 RXRAT(   241 )      ! CL+ISOP=ISPD+FMCL+0.9600D+...
     &                      +                 RXRAT(   360 )      ! ISOP+BR=ISPD+FMBR+0.9600D+...
      LOSS(  ISPD         ) =                 RXRAT(   158 )      ! ISPD+OH=0.2200D-01*XO2N+...
     &                      +                 RXRAT(   159 )      ! ISPD+O3=0.4000D-01*ALD2+...
     &                      +                 RXRAT(   160 )      ! ISPD+NO3=0.7170D+00*HNO3+...
     &                      +                 RXRAT(   161 )      ! ISPD=0.7600D+00*HO2+...

      PROD(  INTR         ) =    1.0000D-01 * RXRAT(   151 )      ! ISO2+NO=0.1000D+00*INTR+...
      LOSS(  INTR         ) =    8.9600D-01 * RXRAT(   170 )      ! INTR+OH=0.1040D+00*INTR+...

      PROD(  ISPX         ) =    8.8000D-01 * RXRAT(   152 )      ! ISO2+HO2=0.8800D+00*ISPX+...
      LOSS(  ISPX         ) =                 RXRAT(   162 )      ! ISPX+OH=0.9040D+00*EPOX+...

      PROD(  HPLD         ) =                 RXRAT(   155 )      ! ISO2=HPLD+HO2
      LOSS(  HPLD         ) =                 RXRAT(   163 )      ! HPLD=OH+ISPD
     &                      +                 RXRAT(   164 )      ! HPLD+NO3=HNO3+ISPD

      PROD(  OPO3         ) =    4.5700D-01 * RXRAT(   158 )      ! ISPD+OH=0.4570D+00*OPO3+...
     &                      +    4.8000D-01 * RXRAT(   196 )      ! CRES+NO3=0.4800D+00*OPO3+...
     &                      +                 RXRAT(   206 )      ! OPEN=OPO3+HO2+CO
     &                      +    6.0000D-01 * RXRAT(   207 )      ! OPEN+OH=0.6000D+00*OPO3+...
     &                      +                 RXRAT(   209 )      ! OPEN+NO3=OPO3+HNO3
     &                      +                 RXRAT(   214 )      ! OPAN=OPO3+NO2
      LOSS(  OPO3         ) =                 RXRAT(   212 )      ! OPO3+NO=NO2+0.5000D+00*GLY+...
     &                      +                 RXRAT(   213 )      ! OPO3+NO2=OPAN
     &                      +                 RXRAT(   215 )      ! OPO3+HO2=0.4100D+00*PACD+...
     &                      +                 RXRAT(   216 )      ! OPO3+C2O3=MEO2+XO2+ALDX+...
     &                      +                 RXRAT(   217 )      ! OPO3+RO2=0.8000D+00*XO2H+...

      PROD(  EPOX         ) =    9.0400D-01 * RXRAT(   162 )      ! ISPX+OH=0.9040D+00*EPOX+...
      LOSS(  EPOX         ) =                 RXRAT(   165 )      ! EPOX+OH=EPX2+RO2
     &                      +                 RXRAT(   277 )      ! EPOX=IEPOXP

      PROD(  EPX2         ) =                 RXRAT(   165 )      ! EPOX+OH=EPX2+RO2
      LOSS(  EPX2         ) =                 RXRAT(   166 )      ! EPX2+HO2=0.2750D+00*GLYD+...
     &                      +                 RXRAT(   167 )      ! EPX2+NO=0.2750D+00*GLYD+...
     &                      +                 RXRAT(   168 )      ! EPX2+C2O3=0.2200D+00*GLYD+...
     &                      +                 RXRAT(   169 )      ! EPX2+RO2=0.2750D+00*GLYD+...

      PROD(  TERP         ) =   0.0D0
      LOSS(  TERP         ) =                 RXRAT(   171 )      ! TERP+O=0.1500D+00*ALDX+...
     &                      +                 RXRAT(   172 )      ! TERP+OH=0.7500D+00*XO2H+...
     &                      +                 RXRAT(   173 )      ! TERP+O3=0.5700D+00*OH+...
     &                      +                 RXRAT(   174 )      ! TERP+NO3=0.4700D+00*NO2+...

      PROD(  TRPRXN       ) =                 RXRAT(   171 )      ! TERP+O=TRPRXN+0.5120D+...
     &                      +                 RXRAT(   172 )      ! TERP+OH=TRPRXN+0.5000D+...
     &                      +                 RXRAT(   173 )      ! TERP+O3=TRPRXN+0.7000D-...
     &                      +                 RXRAT(   175 )      ! APIN+O=TRPRXN+0.5120D+...
     &                      +                 RXRAT(   176 )      ! APIN+OH=TRPRXN+0.5000D+...
     &                      +                 RXRAT(   177 )      ! APIN+O3=TRPRXN+0.7000D-...
      LOSS(  TRPRXN       ) =   0.0D0

      PROD(  TERPNRO2     ) =                 RXRAT(   174 )      ! TERP+NO3=TERPNRO2+0.2800D+...
      LOSS(  TERPNRO2     ) =                 RXRAT(   282 )      ! TERPNRO2+NO=NO+0.6880D+...
     &                      +                 RXRAT(   283 )      ! TERPNRO2+HO2=HO2+MTNO3
     &                      +                 RXRAT(   284 )      ! TERPNRO2+NO3=NO3+0.4220D+...
     &                      +                 RXRAT(   285 )      ! TERPNRO2+RO2=RO2+0.7110D+...

      PROD(  APIN         ) =   0.0D0
      LOSS(  APIN         ) =                 RXRAT(   175 )      ! APIN+O=0.1500D+00*ALDX+...
     &                      +                 RXRAT(   176 )      ! APIN+OH=0.7500D+00*XO2H+...
     &                      +                 RXRAT(   177 )      ! APIN+O3=0.5700D+00*OH+...
     &                      +                 RXRAT(   178 )      ! APIN+NO3=0.4700D+00*NO2+...

      PROD(  BENZENE      ) =   0.0D0
      LOSS(  BENZENE      ) =                 RXRAT(   179 )      ! BENZENE+OH=0.5300D+00*CRES+...

      PROD(  CRES         ) =    5.3000D-01 * RXRAT(   179 )      ! BENZENE+OH=0.5300D+00*CRES+...
     &                      +    1.8000D-01 * RXRAT(   184 )      ! TOL+OH=0.1800D+00*CRES+...
     &                      +    1.5500D-01 * RXRAT(   189 )      ! XYLMN+OH=0.1550D+00*CRES+...
     &                      +    1.5500D-01 * RXRAT(   190 )      ! NAPH+OH=0.1550D+00*CRES+...
     &                      +                 RXRAT(   198 )      ! CRO+HO2=CRES
     &                      +    1.8000D-01 * RXRAT(   248 )      ! CL+TOL=0.1800D+00*CRES+HCL+...
     &                      +    1.5500D-01 * RXRAT(   249 )      ! CL+XYLMN=0.1550D+00*CRES+...
     &                      +    1.5500D-01 * RXRAT(   250 )      ! CL+NAPH=0.1550D+00*CRES+...
      LOSS(  CRES         ) =                 RXRAT(   195 )      ! CRES+OH=0.2500D-01*GLY+...
     &                      +                 RXRAT(   196 )      ! CRES+NO3=0.3000D+00*CRO+...

      PROD(  BZO2         ) =    3.5200D-01 * RXRAT(   179 )      ! BENZENE+OH=0.3520D+00*BZO2+...
      LOSS(  BZO2         ) =                 RXRAT(   180 )      ! BZO2+NO=0.9180D+00*NO2+...
     &                      +                 RXRAT(   181 )      ! BZO2+C2O3=GLY+OPEN+HO2+...
     &                      +                 RXRAT(   182 )      ! BZO2+HO2=
     &                      +                 RXRAT(   183 )      ! BZO2+RO2=GLY+OPEN+HO2+RO2

      PROD(  OPEN         ) =    1.1800D-01 * RXRAT(   179 )      ! BENZENE+OH=0.1180D+00*OPEN+...
     &                      +    9.1800D-01 * RXRAT(   180 )      ! BZO2+NO=0.9180D+00*OPEN+...
     &                      +                 RXRAT(   181 )      ! BZO2+C2O3=OPEN+GLY+HO2+...
     &                      +                 RXRAT(   183 )      ! BZO2+RO2=OPEN+GLY+HO2+RO2
     &                      +    1.0000D-01 * RXRAT(   184 )      ! TOL+OH=0.1000D+00*OPEN+...
     &                      +    6.6000D-01 * RXRAT(   185 )      ! TO2+NO=0.6600D+00*OPEN+...
     &                      +    7.7000D-01 * RXRAT(   186 )      ! TO2+C2O3=0.7700D+00*OPEN+...
     &                      +    7.7000D-01 * RXRAT(   188 )      ! TO2+RO2=0.7700D+00*OPEN+...
     &                      +    3.0000D-01 * RXRAT(   191 )      ! XLO2+NO=0.3000D+00*OPEN+...
     &                      +    3.5000D-01 * RXRAT(   193 )      ! XLO2+C2O3=0.3500D+00*OPEN+...
     &                      +    3.5000D-01 * RXRAT(   194 )      ! XLO2+RO2=0.3500D+00*OPEN+...
     &                      +    2.5000D-02 * RXRAT(   195 )      ! CRES+OH=0.2500D-01*OPEN+...
     &                      +                 RXRAT(   201 )      ! CRON=OPEN+HO2+FORM+HONO
     &                      +    2.5000D-01 * RXRAT(   205 )      ! XOPN+NO3=0.2500D+00*OPEN+...
     &                      +    1.0000D-01 * RXRAT(   248 )      ! CL+TOL=0.1000D+00*OPEN+...
      LOSS(  OPEN         ) =                 RXRAT(   206 )      ! OPEN=OPO3+HO2+CO
     &                      +                 RXRAT(   207 )      ! OPEN+OH=0.6000D+00*OPO3+...
     &                      +                 RXRAT(   208 )      ! OPEN+O3=0.1400D+01*GLY+...
     &                      +                 RXRAT(   209 )      ! OPEN+NO3=OPO3+HNO3

      PROD(  BENZRO2      ) =                 RXRAT(   179 )      ! BENZENE+OH=BENZRO2+0.3520D+...
      LOSS(  BENZRO2      ) =                 RXRAT(   260 )      ! BENZRO2+NO=NO+0.3400D-...
     &                      +                 RXRAT(   261 )      ! BENZRO2+HO2=HO2+0.1460D+...

      PROD(  TOL          ) =   0.0D0
      LOSS(  TOL          ) =                 RXRAT(   184 )      ! TOL+OH=0.1800D+00*CRES+...
     &                      +                 RXRAT(   248 )      ! TOL+CL=HCL+0.1800D+00*CRES+...

      PROD(  TO2          ) =    6.5000D-01 * RXRAT(   184 )      ! TOL+OH=0.6500D+00*TO2+...
     &                      +    6.5000D-01 * RXRAT(   248 )      ! CL+TOL=0.6500D+00*TO2+...
      LOSS(  TO2          ) =                 RXRAT(   185 )      ! TO2+NO=0.8600D+00*NO2+...
     &                      +                 RXRAT(   186 )      ! TO2+C2O3=0.4800D+00*GLY+...
     &                      +                 RXRAT(   187 )      ! TO2+HO2=
     &                      +                 RXRAT(   188 )      ! TO2+RO2=0.4800D+00*GLY+...

      PROD(  TOLRO2       ) =                 RXRAT(   184 )      ! TOL+OH=TOLRO2+0.6500D+...
     &                      +                 RXRAT(   248 )      ! CL+TOL=TOLRO2+0.1800D+...
      LOSS(  TOLRO2       ) =                 RXRAT(   256 )      ! TOLRO2+NO=NO+0.1600D-...
     &                      +                 RXRAT(   257 )      ! TOLRO2+HO2=HO2+0.1400D+...

      PROD(  XOPN         ) =    2.0000D-01 * RXRAT(   185 )      ! TO2+NO=0.2000D+00*XOPN+...
     &                      +    2.3000D-01 * RXRAT(   186 )      ! TO2+C2O3=0.2300D+00*XOPN+...
     &                      +    2.3000D-01 * RXRAT(   188 )      ! TO2+RO2=0.2300D+00*XOPN+...
     &                      +    2.4400D-01 * RXRAT(   189 )      ! XYLMN+OH=0.2440D+00*XOPN+...
     &                      +    2.4400D-01 * RXRAT(   190 )      ! NAPH+OH=0.2440D+00*XOPN+...
     &                      +    5.6000D-01 * RXRAT(   191 )      ! XLO2+NO=0.5600D+00*XOPN+...
     &                      +    6.5000D-01 * RXRAT(   193 )      ! XLO2+C2O3=0.6500D+00*XOPN+...
     &                      +    6.5000D-01 * RXRAT(   194 )      ! XLO2+RO2=0.6500D+00*XOPN+...
     &                      +    2.4400D-01 * RXRAT(   249 )      ! CL+XYLMN=0.2440D+00*XOPN+...
     &                      +    2.4400D-01 * RXRAT(   250 )      ! CL+NAPH=0.2440D+00*XOPN+...
      LOSS(  XOPN         ) =                 RXRAT(   202 )      ! XOPN=0.4000D+00*GLY+XO2H+...
     &                      +                 RXRAT(   203 )      ! XOPN+OH=MGLY+0.4000D+...
     &                      +                 RXRAT(   204 )      ! XOPN+O3=0.1200D+01*MGLY+...
     &                      +                 RXRAT(   205 )      ! XOPN+NO3=0.5000D+00*NO2+...

      PROD(  XYLMN        ) =   0.0D0
      LOSS(  XYLMN        ) =                 RXRAT(   189 )      ! XYLMN+OH=0.1550D+00*CRES+...
     &                      +                 RXRAT(   249 )      ! XYLMN+CL=HCL+0.1550D+...

      PROD(  XLO2         ) =    5.4400D-01 * RXRAT(   189 )      ! XYLMN+OH=0.5440D+00*XLO2+...
     &                      +    5.4400D-01 * RXRAT(   190 )      ! NAPH+OH=0.5440D+00*XLO2+...
     &                      +    5.4400D-01 * RXRAT(   249 )      ! CL+XYLMN=0.5440D+00*XLO2+...
     &                      +    5.4400D-01 * RXRAT(   250 )      ! CL+NAPH=0.5440D+00*XLO2+...
      LOSS(  XLO2         ) =                 RXRAT(   191 )      ! XLO2+NO=0.8600D+00*NO2+...
     &                      +                 RXRAT(   192 )      ! XLO2+HO2=
     &                      +                 RXRAT(   193 )      ! XLO2+C2O3=0.2600D+00*GLY+...
     &                      +                 RXRAT(   194 )      ! XLO2+RO2=0.2600D+00*GLY+...

      PROD(  XYLRO2       ) =                 RXRAT(   189 )      ! XYLMN+OH=XYLRO2+0.5440D+...
     &                      +                 RXRAT(   249 )      ! CL+XYLMN=XYLRO2+0.1550D+...
      LOSS(  XYLRO2       ) =                 RXRAT(   258 )      ! XYLRO2+NO=NO+0.1500D-...
     &                      +                 RXRAT(   259 )      ! XYLRO2+HO2=HO2+0.1930D+...

      PROD(  NAPH         ) =   0.0D0
      LOSS(  NAPH         ) =                 RXRAT(   190 )      ! NAPH+OH=0.1550D+00*CRES+...
     &                      +                 RXRAT(   250 )      ! NAPH+CL=HCL+0.1550D+...

      PROD(  PAHRO2       ) =                 RXRAT(   190 )      ! NAPH+OH=PAHRO2+0.5440D+...
     &                      +                 RXRAT(   250 )      ! CL+NAPH=PAHRO2+0.1550D+...
      LOSS(  PAHRO2       ) =                 RXRAT(   265 )      ! PAHRO2+NO=NO+0.2800D-...
     &                      +                 RXRAT(   266 )      ! PAHRO2+HO2=HO2+0.4730D+...

      PROD(  CRO          ) =    2.0000D-01 * RXRAT(   195 )      ! CRES+OH=0.2000D+00*CRO+...
     &                      +    3.0000D-01 * RXRAT(   196 )      ! CRES+NO3=0.3000D+00*CRO+...
     &                      +    5.0000D-01 * RXRAT(   199 )      ! CRON+OH=0.5000D+00*CRO+NTR2
     &                      +    5.0000D-01 * RXRAT(   200 )      ! CRON+NO3=0.5000D+00*CRO+...
     &                      +    5.0000D-01 * RXRAT(   210 )      ! CAT1+OH=0.5000D+00*CRO+...
     &                      +                 RXRAT(   211 )      ! CAT1+NO3=CRO+HNO3
      LOSS(  CRO          ) =                 RXRAT(   197 )      ! CRO+NO2=CRON
     &                      +                 RXRAT(   198 )      ! CRO+HO2=CRES

      PROD(  CAT1         ) =    7.3200D-01 * RXRAT(   195 )      ! CRES+OH=0.7320D+00*CAT1+...
      LOSS(  CAT1         ) =                 RXRAT(   210 )      ! CAT1+OH=0.1400D+00*FORM+...
     &                      +                 RXRAT(   211 )      ! CAT1+NO3=CRO+HNO3

      PROD(  CRON         ) =                 RXRAT(   197 )      ! CRO+NO2=CRON
      LOSS(  CRON         ) =                 RXRAT(   199 )      ! CRON+OH=NTR2+0.5000D+00*CRO
     &                      +                 RXRAT(   200 )      ! CRON+NO3=NTR2+0.5000D+...
     &                      +                 RXRAT(   201 )      ! CRON=HONO+HO2+FORM+OPEN

      PROD(  OPAN         ) =                 RXRAT(   213 )      ! OPO3+NO2=OPAN
      LOSS(  OPAN         ) =                 RXRAT(   214 )      ! OPAN=OPO3+NO2
     &                      +                 RXRAT(   218 )      ! OPAN+OH=0.5000D+00*NO2+...

      PROD(  ECH4         ) =   0.0D0
      LOSS(  ECH4         ) =                 RXRAT(   220 )      ! ECH4+OH=MEO2+RO2

      PROD(  CL2          ) =    3.0000D-01 * RXRAT(   228 )      ! CLO+CLO=0.3000D+00*CL2+...
      LOSS(  CL2          ) =                 RXRAT(   225 )      ! CL2=0.2000D+01*CL

      PROD(  CL           ) =    2.0000D+00 * RXRAT(   225 )      ! CL2=0.2000D+01*CL
     &                      +                 RXRAT(   226 )      ! HOCL=CL+OH
     &                      +    1.4000D+00 * RXRAT(   228 )      ! CLO+CLO=0.1400D+01*CL+...
     &                      +                 RXRAT(   229 )      ! CLO+NO=CL+NO2
     &                      +                 RXRAT(   231 )      ! CLO+MEO2=CL+FORM+HO2
     &                      +                 RXRAT(   232 )      ! OH+FMCL=CL+CO
     &                      +                 RXRAT(   233 )      ! FMCL=CL+CO+HO2
     &                      +                 RXRAT(   247 )      ! HCL+OH=CL
     &                      +                 RXRAT(   251 )      ! CLNO2=CL+NO2
     &                      +                 RXRAT(   254 )      ! CLNO3=CL+NO3
     &                      +                 RXRAT(   356 )      ! BRO+CLO=CL+BR
     &                      +                 RXRAT(   366 )      ! MB2C+OH=CL+0.2000D+01*BR+CO
     &                      +    2.0000D+00 * RXRAT(   367 )      ! MBC2+OH=0.2000D+01*CL+BR+CO
     &                      +                 RXRAT(   368 )      ! MBC+OH=CL+BR+CO+HO2
     &                      +                 RXRAT(   376 )      ! BRCL=CL+BR
     &                      +                 RXRAT(   379 )      ! MB2C=CL+0.2000D+01*BR+HO2+CO
     &                      +    2.0000D+00 * RXRAT(   380 )      ! MBC2=0.2000D+01*CL+BR+HO2+CO
     &                      +                 RXRAT(   399 )      ! IO+CLO=CL+I
     &                      +                 RXRAT(   423 )      ! ICL=CL+I
     &                      +                 RXRAT(   428 )      ! MIC=CL+I+FORM
     &                      +                 RXRAT(   443 )      ! DMS+CLO=CL+0.2500D+00*MSA+...
      LOSS(  CL           ) =                 RXRAT(   227 )      ! CL+O3=CLO
     &                      +                 RXRAT(   234 )      ! CL=HCL+MEO2+RO2
     &                      +                 RXRAT(   235 )      ! CL+PAR=HCL+XPAR
     &                      +                 RXRAT(   236 )      ! CL+PRPA=HCL+ACET+0.9700D+...
     &                      +                 RXRAT(   237 )      ! CL+ETHA=HCL+0.9910D+...
     &                      +                 RXRAT(   238 )      ! CL+ETH=FMCL+0.2000D+01*XO2+...
     &                      +                 RXRAT(   239 )      ! CL+OLE=FMCL+0.3300D+...
     &                      +                 RXRAT(   240 )      ! CL+IOLE=0.3000D+00*HCL+...
     &                      +                 RXRAT(   241 )      ! CL+ISOP=FMCL+ISPD+0.9600D+...
     &                      +                 RXRAT(   242 )      ! CL+FORM=HCL+HO2+CO
     &                      +                 RXRAT(   243 )      ! CL+ALD2=HCL+C2O3
     &                      +                 RXRAT(   244 )      ! CL+ALDX=HCL+CXO3
     &                      +                 RXRAT(   245 )      ! CL+MEOH=HCL+HO2+FORM
     &                      +                 RXRAT(   246 )      ! CL+ETOH=HCL+HO2+ALD2
     &                      +                 RXRAT(   248 )      ! CL+TOL=HCL+0.1800D+00*CRES+...
     &                      +                 RXRAT(   249 )      ! CL+XYLMN=HCL+0.1550D+...
     &                      +                 RXRAT(   250 )      ! CL+NAPH=HCL+0.1550D+...
     &                      +                 RXRAT(   442 )      ! CL+DMS=0.8600D+00*SO2+MEO2+...

      PROD(  HOCL         ) =                 RXRAT(   230 )      ! CLO+HO2=HOCL
     &                      +                 RXRAT(   255 )      ! CLNO3=HOCL+HNO3
      LOSS(  HOCL         ) =                 RXRAT(   226 )      ! HOCL=OH+CL

      PROD(  CLO          ) =                 RXRAT(   227 )      ! CL+O3=CLO
     &                      +                 RXRAT(   253 )      ! CLNO3=CLO+NO2
     &                      +    5.5000D-01 * RXRAT(   442 )      ! DMS+CL=0.5500D+00*CLO+MEO2+...
      LOSS(  CLO          ) =    2.0000D+00 * RXRAT(   228 )      ! CLO+CLO=0.3000D+00*CL2+...
     &                      +                 RXRAT(   229 )      ! CLO+NO=CL+NO2
     &                      +                 RXRAT(   230 )      ! CLO+HO2=HOCL
     &                      +                 RXRAT(   231 )      ! CLO+MEO2=CL+FORM+HO2
     &                      +                 RXRAT(   252 )      ! CLO+NO2=CLNO3
     &                      +                 RXRAT(   356 )      ! CLO+BRO=BR+CL
     &                      +                 RXRAT(   399 )      ! CLO+IO=I+CL
     &                      +                 RXRAT(   443 )      ! CLO+DMS=0.7500D+00*SO2+...

      PROD(  FMCL         ) =                 RXRAT(   238 )      ! CL+ETH=FMCL+0.2000D+01*XO2+...
     &                      +                 RXRAT(   239 )      ! CL+OLE=FMCL+0.3300D+...
     &                      +    7.0000D-01 * RXRAT(   240 )      ! CL+IOLE=0.7000D+00*FMCL+...
     &                      +                 RXRAT(   241 )      ! CL+ISOP=FMCL+ISPD+0.9600D+...
      LOSS(  FMCL         ) =                 RXRAT(   232 )      ! FMCL+OH=CL+CO
     &                      +                 RXRAT(   233 )      ! FMCL=CL+CO+HO2

      PROD(  HCL          ) =                 RXRAT(   234 )      ! CL=HCL+MEO2+RO2
     &                      +                 RXRAT(   235 )      ! CL+PAR=HCL+XPAR
     &                      +                 RXRAT(   236 )      ! CL+PRPA=HCL+ACET+0.9700D+...
     &                      +                 RXRAT(   237 )      ! CL+ETHA=HCL+0.9910D+...
     &                      +    3.0000D-01 * RXRAT(   240 )      ! CL+IOLE=0.3000D+00*HCL+...
     &                      +                 RXRAT(   242 )      ! CL+FORM=HCL+HO2+CO
     &                      +                 RXRAT(   243 )      ! CL+ALD2=HCL+C2O3
     &                      +                 RXRAT(   244 )      ! CL+ALDX=HCL+CXO3
     &                      +                 RXRAT(   245 )      ! CL+MEOH=HCL+HO2+FORM
     &                      +                 RXRAT(   246 )      ! CL+ETOH=HCL+HO2+ALD2
     &                      +                 RXRAT(   248 )      ! CL+TOL=HCL+0.1800D+00*CRES+...
     &                      +                 RXRAT(   249 )      ! CL+XYLMN=HCL+0.1550D+...
     &                      +                 RXRAT(   250 )      ! CL+NAPH=HCL+0.1550D+...
     &                      +    4.5000D-01 * RXRAT(   442 )      ! DMS+CL=0.4500D+00*HCL+MEO2+...
      LOSS(  HCL          ) =                 RXRAT(   247 )      ! HCL+OH=CL

      PROD(  CLNO2        ) =                 RXRAT(   273 )      ! H2NO3PIJ+ACLI=CLNO2
     &                      +                 RXRAT(   274 )      ! H2NO3PIJ+ACLJ=CLNO2
     &                      +                 RXRAT(   275 )      ! H2NO3PK+ACLK=CLNO2
      LOSS(  CLNO2        ) =                 RXRAT(   251 )      ! CLNO2=CL+NO2

      PROD(  CLNO3        ) =                 RXRAT(   252 )      ! CLO+NO2=CLNO3
      LOSS(  CLNO3        ) =                 RXRAT(   253 )      ! CLNO3=CLO+NO2
     &                      +                 RXRAT(   254 )      ! CLNO3=CL+NO3
     &                      +                 RXRAT(   255 )      ! CLNO3=HOCL+HNO3

      PROD(  SVAVB2       ) =    1.6000D-02 * RXRAT(   256 )      ! TOLRO2+NO=0.1600D-...
     &                      +    1.5000D-02 * RXRAT(   258 )      ! XYLRO2+NO=0.1500D-...
     &                      +    3.4000D-02 * RXRAT(   260 )      ! BENZRO2+NO=0.3400D-...
     &                      +    2.8000D-02 * RXRAT(   265 )      ! PAHRO2+NO=0.2800D-...
     &                      +    6.0000D-03 * RXRAT(   267 )      ! SOAALK+OH=0.6000D-...
      LOSS(  SVAVB2       ) =   0.0D0

      PROD(  SVAVB3       ) =    5.1000D-02 * RXRAT(   256 )      ! TOLRO2+NO=0.5100D-...
     &                      +    2.3000D-02 * RXRAT(   258 )      ! XYLRO2+NO=0.2300D-...
     &                      +    2.2500D-01 * RXRAT(   265 )      ! PAHRO2+NO=0.2250D+...
     &                      +    5.2000D-02 * RXRAT(   267 )      ! SOAALK+OH=0.5200D-...
      LOSS(  SVAVB3       ) =   0.0D0

      PROD(  SVAVB4       ) =    4.7000D-02 * RXRAT(   256 )      ! TOLRO2+NO=0.4700D-...
     &                      +    6.0000D-02 * RXRAT(   258 )      ! XYLRO2+NO=0.6000D-...
     &                      +    3.9200D-01 * RXRAT(   260 )      ! BENZRO2+NO=0.3920D+...
     &                      +    1.9100D-01 * RXRAT(   265 )      ! PAHRO2+NO=0.1910D+...
     &                      +    8.1000D-02 * RXRAT(   267 )      ! SOAALK+OH=0.8100D-...
      LOSS(  SVAVB4       ) =   0.0D0

      PROD(  SVAVB1       ) =    1.4000D-01 * RXRAT(   257 )      ! TOLRO2+HO2=0.1400D+...
     &                      +    1.9300D-01 * RXRAT(   259 )      ! XYLRO2+HO2=0.1930D+...
     &                      +    1.4600D-01 * RXRAT(   261 )      ! BENZRO2+HO2=0.1460D+...
     &                      +    4.7300D-01 * RXRAT(   266 )      ! PAHRO2+HO2=0.4730D+...
      LOSS(  SVAVB1       ) =   0.0D0

      PROD(  SESQ         ) =   0.0D0
      LOSS(  SESQ         ) =                 RXRAT(   262 )      ! SESQ+O3=O3+SESQRXN
     &                      +                 RXRAT(   263 )      ! SESQ+OH=OH+SESQRXN
     &                      +                 RXRAT(   264 )      ! SESQ+NO3=NO3+SESQRXN

      PROD(  SESQRXN      ) =                 RXRAT(   262 )      ! SESQ+O3=SESQRXN+O3
     &                      +                 RXRAT(   263 )      ! SESQ+OH=SESQRXN+OH
     &                      +                 RXRAT(   264 )      ! SESQ+NO3=SESQRXN+NO3
      LOSS(  SESQRXN      ) =   0.0D0

      PROD(  SOAALK       ) =   0.0D0
      LOSS(  SOAALK       ) =                 RXRAT(   267 )      ! SOAALK+OH=OH+0.6000D-...

      PROD(  H2NO3PIJ     ) =                 RXRAT(   269 )      ! N2O5=H2NO3PIJ+HNO3
      LOSS(  H2NO3PIJ     ) =                 RXRAT(   271 )      ! H2NO3PIJ=HNO3
     &                      +                 RXRAT(   273 )      ! H2NO3PIJ+ACLI=CLNO2
     &                      +                 RXRAT(   274 )      ! H2NO3PIJ+ACLJ=CLNO2

      PROD(  H2NO3PK      ) =                 RXRAT(   270 )      ! N2O5=H2NO3PK+HNO3
      LOSS(  H2NO3PK      ) =                 RXRAT(   272 )      ! H2NO3PK=HNO3
     &                      +                 RXRAT(   275 )      ! H2NO3PK+ACLK=CLNO2

      PROD(  ACLI         ) =   0.0D0
      LOSS(  ACLI         ) =                 RXRAT(   273 )      ! ACLI+H2NO3PIJ=CLNO2

      PROD(  ACLJ         ) =   0.0D0
      LOSS(  ACLJ         ) =                 RXRAT(   274 )      ! ACLJ+H2NO3PIJ=CLNO2
     &                      +                 RXRAT(   382 )      ! ACLJ+HOBR=BRCL
     &                      +                 RXRAT(   432 )      ! ACLJ+INO3=ICL+HNO3
     &                      +                 RXRAT(   434 )      ! ACLJ+INO2=ICL+HONO
     &                      +                 RXRAT(   436 )      ! ACLJ+HOI=ICL

      PROD(  ACLK         ) =   0.0D0
      LOSS(  ACLK         ) =                 RXRAT(   275 )      ! ACLK+H2NO3PK=CLNO2

      PROD(  IEPOXP       ) =                 RXRAT(   277 )      ! EPOX=IEPOXP
      LOSS(  IEPOXP       ) =                 RXRAT(   278 )      ! IEPOXP+ASO4J=AISO3J
     &                      +                 RXRAT(   279 )      ! IEPOXP=AISO3J

      PROD(  ASO4J        ) =   0.0D0
      LOSS(  ASO4J        ) =                 RXRAT(   278 )      ! ASO4J+IEPOXP=AISO3J

      PROD(  AISO3J       ) =                 RXRAT(   278 )      ! IEPOXP+ASO4J=AISO3J
     &                      +                 RXRAT(   279 )      ! IEPOXP=AISO3J
      LOSS(  AISO3J       ) =   0.0D0

      PROD(  AGLYJ        ) =                 RXRAT(   280 )      ! GLY=AGLYJ
     &                      +                 RXRAT(   281 )      ! MGLY=AGLYJ
      LOSS(  AGLYJ        ) =   0.0D0

      PROD(  MTNO3        ) =    6.8800D-01 * RXRAT(   282 )      ! TERPNRO2+NO=0.6880D+...
     &                      +                 RXRAT(   283 )      ! TERPNRO2+HO2=MTNO3+HO2
     &                      +    4.2200D-01 * RXRAT(   284 )      ! TERPNRO2+NO3=0.4220D+...
     &                      +    7.1100D-01 * RXRAT(   285 )      ! TERPNRO2+RO2=0.7110D+...
      LOSS(  MTNO3        ) =    6.3000D-01 * RXRAT(   286 )      ! MTNO3+CL=0.3700D+00*MTNO3+CL
     &                      +    7.6000D-01 * RXRAT(   287 )      ! MTNO3+OH=0.2400D+00*MTNO3+OH
     &                      +                 RXRAT(   288 )      ! MTNO3=

      PROD(  AMTNO3J      ) =   0.0D0
      LOSS(  AMTNO3J      ) =                 RXRAT(   289 )      ! AMTNO3J=AMTHYDJ

      PROD(  AMTHYDJ      ) =                 RXRAT(   289 )      ! AMTNO3J=AMTHYDJ
      LOSS(  AMTHYDJ      ) =   0.0D0

      PROD(  AAVB2J       ) =   0.0D0
      LOSS(  AAVB2J       ) =                 RXRAT(   290 )      ! AAVB2J=0.9070D+00*AOLGAJ

      PROD(  AOLGAJ       ) =    9.0700D-01 * RXRAT(   290 )      ! AAVB2J=0.9070D+00*AOLGAJ
     &                      +    9.2500D-01 * RXRAT(   291 )      ! AAVB3J=0.9250D+00*AOLGAJ
     &                      +    9.4300D-01 * RXRAT(   292 )      ! AAVB4J=0.9430D+00*AOLGAJ
      LOSS(  AOLGAJ       ) =   0.0D0

      PROD(  AAVB3J       ) =   0.0D0
      LOSS(  AAVB3J       ) =                 RXRAT(   291 )      ! AAVB3J=0.9250D+00*AOLGAJ

      PROD(  AAVB4J       ) =   0.0D0
      LOSS(  AAVB4J       ) =                 RXRAT(   292 )      ! AAVB4J=0.9430D+00*AOLGAJ

      PROD(  AISO1J       ) =   0.0D0
      LOSS(  AISO1J       ) =                 RXRAT(   293 )      ! AISO1J=0.5000D+00*AOLGBJ

      PROD(  AOLGBJ       ) =    5.0000D-01 * RXRAT(   293 )      ! AISO1J=0.5000D+00*AOLGBJ
     &                      +    5.0000D-01 * RXRAT(   294 )      ! AISO2J=0.5000D+00*AOLGBJ
     &                      +    1.5000D+00 * RXRAT(   295 )      ! ASQTJ=0.1500D+01*AOLGBJ
      LOSS(  AOLGBJ       ) =   0.0D0

      PROD(  AISO2J       ) =   0.0D0
      LOSS(  AISO2J       ) =                 RXRAT(   294 )      ! AISO2J=0.5000D+00*AOLGBJ

      PROD(  ASQTJ        ) =   0.0D0
      LOSS(  ASQTJ        ) =                 RXRAT(   295 )      ! ASQTJ=0.1500D+01*AOLGBJ

      PROD(  APOCI        ) =   0.0D0
      LOSS(  APOCI        ) =   0.0D0

      PROD(  APNCOMI      ) =    1.2500D+00 * RXRAT(   296 )      ! APOCI+OH=0.1250D+...
      LOSS(  APNCOMI      ) =                 RXRAT(   297 )      ! APNCOMI+OH=OH

      PROD(  APOCJ        ) =   0.0D0
      LOSS(  APOCJ        ) =   0.0D0

      PROD(  APNCOMJ      ) =    1.2500D+00 * RXRAT(   298 )      ! APOCJ+OH=0.1250D+...
      LOSS(  APNCOMJ      ) =                 RXRAT(   299 )      ! APNCOMJ+OH=OH

      PROD(  PCVOC        ) =   0.0D0
      LOSS(  PCVOC        ) =                 RXRAT(   300 )      ! PCVOC+OH=OH+PCSOARXN

      PROD(  PCSOARXN     ) =                 RXRAT(   300 )      ! PCVOC+OH=PCSOARXN+OH
      LOSS(  PCSOARXN     ) =   0.0D0

      PROD(  VLVPO1       ) =    3.0030D-01 * RXRAT(   302 )      ! VSVPO1+OH=0.3003D+...
     &                      +    3.8560D-01 * RXRAT(   303 )      ! VSVPO2+OH=0.3856D+...
     &                      +    2.1810D-01 * RXRAT(   304 )      ! VSVPO3+OH=0.2181D+...
     &                      +    2.4120D-01 * RXRAT(   305 )      ! VIVPO1+OH=0.2412D+...
      LOSS(  VLVPO1       ) =    5.1430D-01 * RXRAT(   301 )      ! VLVPO1+OH=0.4857D+...

      PROD(  VSVPO1       ) =    6.2000D-03 * RXRAT(   301 )      ! VLVPO1+OH=0.6200D-...
     &                      +    9.5000D-02 * RXRAT(   303 )      ! VSVPO2+OH=0.9500D-...
     &                      +    3.0630D-01 * RXRAT(   304 )      ! VSVPO3+OH=0.3063D+...
     &                      +    2.0890D-01 * RXRAT(   305 )      ! VIVPO1+OH=0.2089D+...
      LOSS(  VSVPO1       ) =    7.1380D-01 * RXRAT(   302 )      ! VSVPO1+OH=0.2862D+...

      PROD(  VSVPO2       ) =    2.5000D-03 * RXRAT(   301 )      ! VLVPO1+OH=0.2500D-...
     &                      +    4.1000D-03 * RXRAT(   302 )      ! VSVPO1+OH=0.4100D-...
     &                      +    1.5300D-02 * RXRAT(   304 )      ! VSVPO3+OH=0.1530D-...
     &                      +    3.0000D-01 * RXRAT(   305 )      ! VIVPO1+OH=0.3000D+...
      LOSS(  VSVPO2       ) =    8.6270D-01 * RXRAT(   303 )      ! VSVPO2+OH=0.1373D+...

      PROD(  VSVPO3       ) =    2.6000D-03 * RXRAT(   301 )      ! VLVPO1+OH=0.2600D-...
     &                      +    3.5000D-03 * RXRAT(   302 )      ! VSVPO1+OH=0.3500D-...
     &                      +    5.0000D-04 * RXRAT(   303 )      ! VSVPO2+OH=0.5000D-...
      LOSS(  VSVPO3       ) =    8.9570D-01 * RXRAT(   304 )      ! VSVPO3+OH=0.1043D+...

      PROD(  VIVPO1       ) =    2.3000D-03 * RXRAT(   301 )      ! VLVPO1+OH=0.2300D-...
      LOSS(  VIVPO1       ) =                 RXRAT(   305 )      ! VIVPO1+OH=OH+0.2412D+...

      PROD(  VLVOO1       ) =    2.9440D-01 * RXRAT(   301 )      ! VLVPO1+OH=0.2944D+...
     &                      +    2.2390D-01 * RXRAT(   302 )      ! VSVPO1+OH=0.2239D+...
     &                      +    2.0510D-01 * RXRAT(   303 )      ! VSVPO2+OH=0.2051D+...
     &                      +    1.8930D-01 * RXRAT(   304 )      ! VSVPO3+OH=0.1893D+...
     &                      +    2.0280D-01 * RXRAT(   305 )      ! VIVPO1+OH=0.2028D+...
     &                      +    2.8580D-01 * RXRAT(   307 )      ! VLVOO2+OH=0.2858D+...
     &                      +    3.3030D-01 * RXRAT(   308 )      ! VSVOO1+OH=0.3303D+...
     &                      +    3.4440D-01 * RXRAT(   309 )      ! VSVOO2+OH=0.3444D+...
     &                      +    3.8860D-01 * RXRAT(   310 )      ! VSVOO3+OH=0.3886D+...
      LOSS(  VLVOO1       ) =    3.3360D-01 * RXRAT(   306 )      ! VLVOO1+OH=0.6664D+...

      PROD(  VLVOO2       ) =    2.0210D-01 * RXRAT(   301 )      ! VLVPO1+OH=0.2021D+...
     &                      +    1.8200D-01 * RXRAT(   302 )      ! VSVPO1+OH=0.1820D+...
     &                      +    1.7640D-01 * RXRAT(   303 )      ! VSVPO2+OH=0.1764D+...
     &                      +    1.6680D-01 * RXRAT(   304 )      ! VSVPO3+OH=0.1668D+...
     &                      +    4.7100D-02 * RXRAT(   305 )      ! VIVPO1+OH=0.4710D-...
     &                      +    1.4300D-02 * RXRAT(   306 )      ! VLVOO1+OH=0.1430D-...
     &                      +    2.2720D-01 * RXRAT(   308 )      ! VSVOO1+OH=0.2272D+...
     &                      +    2.7490D-01 * RXRAT(   309 )      ! VSVOO2+OH=0.2749D+...
     &                      +    2.4210D-01 * RXRAT(   310 )      ! VSVOO3+OH=0.2421D+...
      LOSS(  VLVOO2       ) =    6.0690D-01 * RXRAT(   307 )      ! VLVOO2+OH=0.3931D+...

      PROD(  VSVOO2       ) =    1.9000D-03 * RXRAT(   301 )      ! VLVPO1+OH=0.1900D-...
     &                      +    1.2390D-01 * RXRAT(   306 )      ! VLVOO1+OH=0.1239D+...
     &                      +    1.0270D-01 * RXRAT(   307 )      ! VLVOO2+OH=0.1027D+...
     &                      +    7.0200D-02 * RXRAT(   308 )      ! VSVOO1+OH=0.7020D-...
     &                      +    3.8500D-02 * RXRAT(   310 )      ! VSVOO3+OH=0.3850D-...
      LOSS(  VSVOO2       ) =    7.4230D-01 * RXRAT(   309 )      ! VSVOO2+OH=0.2577D+...

      PROD(  VSVOO3       ) =    2.3000D-03 * RXRAT(   301 )      ! VLVPO1+OH=0.2300D-...
     &                      +    1.8310D-01 * RXRAT(   306 )      ! VLVOO1+OH=0.1831D+...
     &                      +    2.0450D-01 * RXRAT(   307 )      ! VLVOO2+OH=0.2045D+...
     &                      +    1.1160D-01 * RXRAT(   308 )      ! VSVOO1+OH=0.1116D+...
     &                      +    7.3900D-02 * RXRAT(   309 )      ! VSVOO2+OH=0.7390D-...
      LOSS(  VSVOO3       ) =    7.3330D-01 * RXRAT(   310 )      ! VSVOO3+OH=0.2667D+...

      PROD(  VSVOO1       ) =    1.2300D-02 * RXRAT(   306 )      ! VLVOO1+OH=0.1230D-...
     &                      +    1.3900D-02 * RXRAT(   307 )      ! VLVOO2+OH=0.1390D-...
     &                      +    4.9100D-02 * RXRAT(   309 )      ! VSVOO2+OH=0.4910D-...
     &                      +    6.4000D-02 * RXRAT(   310 )      ! VSVOO3+OH=0.6400D-...
      LOSS(  VSVOO1       ) =    7.3930D-01 * RXRAT(   308 )      ! VSVOO1+OH=0.2607D+...

      PROD(  FORM_PRIMARY ) =   0.0D0
      LOSS(  FORM_PRIMARY ) =                 RXRAT(   311 )      ! FORM_PRIMARY+OH=OH
     &                      +                 RXRAT(   312 )      ! FORM_PRIMARY+NO3=NO3
     &                      +                 RXRAT(   313 )      ! FORM_PRIMARY+O=O
     &                      +                 RXRAT(   314 )      ! FORM_PRIMARY=
     &                      +                 RXRAT(   315 )      ! FORM_PRIMARY=
     &                      +                 RXRAT(   316 )      ! FORM_PRIMARY+CL=CL

      PROD(  ALD2_PRIMARY ) =   0.0D0
      LOSS(  ALD2_PRIMARY ) =                 RXRAT(   317 )      ! ALD2_PRIMARY+OH=OH
     &                      +                 RXRAT(   318 )      ! ALD2_PRIMARY+NO3=NO3
     &                      +                 RXRAT(   319 )      ! ALD2_PRIMARY+O=O
     &                      +                 RXRAT(   320 )      ! ALD2_PRIMARY=
     &                      +                 RXRAT(   321 )      ! ALD2_PRIMARY+CL=CL

      PROD(  BUTADIENE13  ) =   0.0D0
      LOSS(  BUTADIENE13  ) =                 RXRAT(   322 )      ! BUTADIENE13+OH=OH+0.5800D+...
     &                      +                 RXRAT(   323 )      ! BUTADIENE13+O3=O3+0.5200D+...
     &                      +                 RXRAT(   324 )      ! BUTADIENE13+NO3=NO3+...
     &                      +                 RXRAT(   325 )      ! BUTADIENE13+CL=CL+0.5800D+...

      PROD(  ACROLEIN     ) =    5.8000D-01 * RXRAT(   322 )      ! BUTADIENE13+OH=0.5800D+...
     &                      +    5.2000D-01 * RXRAT(   323 )      ! BUTADIENE13+O3=0.5200D+...
     &                      +    4.5000D-02 * RXRAT(   324 )      ! BUTADIENE13+NO3=0.4500D-...
     &                      +    5.8000D-01 * RXRAT(   325 )      ! BUTADIENE13+CL=0.5800D+...
      LOSS(  ACROLEIN     ) =                 RXRAT(   331 )      ! ACROLEIN+OH=OH
     &                      +                 RXRAT(   332 )      ! ACROLEIN+O3=O3
     &                      +                 RXRAT(   333 )      ! ACROLEIN+NO3=NO3
     &                      +                 RXRAT(   334 )      ! ACROLEIN=
     &                      +                 RXRAT(   335 )      ! ACROLEIN+CL=CL

      PROD(  ACRO_PRIMARY ) =   0.0D0
      LOSS(  ACRO_PRIMARY ) =                 RXRAT(   326 )      ! ACRO_PRIMARY+OH=OH
     &                      +                 RXRAT(   327 )      ! ACRO_PRIMARY+O3=O3
     &                      +                 RXRAT(   328 )      ! ACRO_PRIMARY+NO3=NO3
     &                      +                 RXRAT(   329 )      ! ACRO_PRIMARY=
     &                      +                 RXRAT(   330 )      ! ACRO_PRIMARY+CL=CL

      PROD(  TOLU         ) =   0.0D0
      LOSS(  TOLU         ) =                 RXRAT(   336 )      ! TOLU+OH=OH
     &                      +                 RXRAT(   337 )      ! TOLU+CL=CL

      PROD(  HG           ) =   0.0D0
      LOSS(  HG           ) =                 RXRAT(   338 )      ! HG+O3=0.5000D+00*HGIIAER+...
     &                      +                 RXRAT(   339 )      ! HG+CL2=HGIIGAS+CL2
     &                      +                 RXRAT(   340 )      ! HG+H2O2=HGIIGAS+H2O2
     &                      +                 RXRAT(   341 )      ! HG+OH=0.5000D+00*HGIIAER+...
     &                      +    5.0000D-01 * RXRAT(   342 )      ! HG+CL=0.5000D+00*HG+...

      PROD(  HGIIAER      ) =    5.0000D-01 * RXRAT(   338 )      ! HG+O3=0.5000D+00*HGIIAER+...
     &                      +    5.0000D-01 * RXRAT(   341 )      ! HG+OH=0.5000D+00*HGIIAER+...
      LOSS(  HGIIAER      ) =   0.0D0

      PROD(  HGIIGAS      ) =    5.0000D-01 * RXRAT(   338 )      ! HG+O3=0.5000D+00*HGIIGAS+...
     &                      +                 RXRAT(   339 )      ! HG+CL2=HGIIGAS+CL2
     &                      +                 RXRAT(   340 )      ! HG+H2O2=HGIIGAS+H2O2
     &                      +    5.0000D-01 * RXRAT(   341 )      ! HG+OH=0.5000D+00*HGIIGAS+...
     &                      +    5.0000D-01 * RXRAT(   342 )      ! HG+CL=0.5000D+00*HGIIGAS+...
      LOSS(  HGIIGAS      ) =   0.0D0

      PROD(  BR           ) =                 RXRAT(   346 )      ! HBR+OH=BR
     &                      +    2.0000D+00 * RXRAT(   347 )      ! BRO+BRO=0.2000D+01*BR
     &                      +                 RXRAT(   349 )      ! BRO+NO=BR+NO2
     &                      +                 RXRAT(   351 )      ! BR2+OH=BR+HOBR
     &                      +                 RXRAT(   352 )      ! BRO+OH=BR+HO2
     &                      +                 RXRAT(   356 )      ! BRO+CLO=BR+CL
     &                      +                 RXRAT(   361 )      ! FMBR+OH=BR+CO
     &                      +    2.0000D-01 * RXRAT(   362 )      ! BRO+MEO2=0.2000D+00*BR+...
     &                      +                 RXRAT(   363 )      ! CH3BR+OH=BR+FORM
     &                      +    3.0000D+00 * RXRAT(   364 )      ! MB3+OH=0.3000D+01*BR+CO
     &                      +    2.0000D+00 * RXRAT(   365 )      ! MB2+OH=0.2000D+01*BR+HO2+CO
     &                      +    2.0000D+00 * RXRAT(   366 )      ! MB2C+OH=0.2000D+01*BR+CL+CO
     &                      +                 RXRAT(   367 )      ! MBC2+OH=BR+0.2000D+01*CL+CO
     &                      +                 RXRAT(   368 )      ! MBC+OH=BR+CL+CO+HO2
     &                      +                 RXRAT(   369 )      ! DMS+BRO=BR+0.2500D+00*MSA+...
     &                      +    2.0000D+00 * RXRAT(   370 )      ! BR2=0.2000D+01*BR
     &                      +                 RXRAT(   371 )      ! HOBR=BR+OH
     &                      +                 RXRAT(   372 )      ! BRO=BR+O
     &                      +                 RXRAT(   373 )      ! BRNO2=BR+NO2
     &                      +                 RXRAT(   375 )      ! BRNO3=BR+NO3
     &                      +                 RXRAT(   376 )      ! BRCL=BR+CL
     &                      +                 RXRAT(   377 )      ! FMBR=BR+CO+HO2
     &                      +    3.0000D+00 * RXRAT(   378 )      ! MB3=0.3000D+01*BR+HO2+CO
     &                      +    2.0000D+00 * RXRAT(   379 )      ! MB2C=0.2000D+01*BR+CL+HO2+CO
     &                      +                 RXRAT(   380 )      ! MBC2=BR+0.2000D+01*CL+HO2+CO
     &                      +                 RXRAT(   396 )      ! I+BRO=BR+IO
     &                      +                 RXRAT(   398 )      ! IO+BRO=BR+I
     &                      +                 RXRAT(   424 )      ! IBR=BR+I
     &                      +                 RXRAT(   427 )      ! MIB=BR+I+FORM
      LOSS(  BR           ) =                 RXRAT(   343 )      ! BR+O3=BRO
     &                      +                 RXRAT(   345 )      ! BR+HO2=HBR
     &                      +                 RXRAT(   350 )      ! BR+BRNO3=BR2+NO3
     &                      +                 RXRAT(   353 )      ! BR+NO3=BRO+NO2
     &                      +                 RXRAT(   355 )      ! BR+NO2=BRNO2
     &                      +                 RXRAT(   357 )      ! BR+FORM=HBR+HO2+CO
     &                      +                 RXRAT(   358 )      ! BR+ALD2=HBR+C2O3
     &                      +                 RXRAT(   359 )      ! BR+OLE=FMBR+ALD2+XO2H-PAR+RO2
     &                      +                 RXRAT(   360 )      ! BR+ISOP=FMBR+ISPD+0.9600D+...
     &                      +                 RXRAT(   397 )      ! BR+IO=I+BRO

      PROD(  BRO          ) =                 RXRAT(   343 )      ! BR+O3=BRO
     &                      +                 RXRAT(   353 )      ! BR+NO3=BRO+NO2
     &                      +                 RXRAT(   374 )      ! BRNO3=BRO+NO2
     &                      +                 RXRAT(   397 )      ! IO+BR=BRO+I
      LOSS(  BRO          ) =                 RXRAT(   344 )      ! BRO+HO2=HOBR
     &                      +    2.0000D+00 * RXRAT(   347 )      ! BRO+BRO=0.2000D+01*BR
     &                      +    2.0000D+00 * RXRAT(   348 )      ! BRO+BRO=BR2
     &                      +                 RXRAT(   349 )      ! BRO+NO=BR+NO2
     &                      +                 RXRAT(   352 )      ! BRO+OH=BR+HO2
     &                      +                 RXRAT(   354 )      ! BRO+NO2=BRNO3
     &                      +                 RXRAT(   356 )      ! BRO+CLO=BR+CL
     &                      +                 RXRAT(   362 )      ! BRO+MEO2=0.8000D+00*HOBR+...
     &                      +                 RXRAT(   369 )      ! BRO+DMS=0.7500D+00*SO2+...
     &                      +                 RXRAT(   372 )      ! BRO=BR+O
     &                      +                 RXRAT(   396 )      ! BRO+I=IO+BR
     &                      +                 RXRAT(   398 )      ! BRO+IO=BR+I

      PROD(  HOBR         ) =                 RXRAT(   344 )      ! BRO+HO2=HOBR
     &                      +                 RXRAT(   351 )      ! BR2+OH=HOBR+BR
     &                      +    8.0000D-01 * RXRAT(   362 )      ! BRO+MEO2=0.8000D+00*HOBR+...
     &                      +                 RXRAT(   381 )      ! BRNO3=HOBR+HNO3
      LOSS(  HOBR         ) =                 RXRAT(   371 )      ! HOBR=OH+BR
     &                      +                 RXRAT(   382 )      ! HOBR+ACLJ=BRCL
     &                      +                 RXRAT(   383 )      ! HOBR+ABRJ=BR2

      PROD(  HBR          ) =                 RXRAT(   345 )      ! BR+HO2=HBR
     &                      +                 RXRAT(   357 )      ! FORM+BR=HBR+HO2+CO
     &                      +                 RXRAT(   358 )      ! ALD2+BR=HBR+C2O3
      LOSS(  HBR          ) =                 RXRAT(   346 )      ! HBR+OH=BR
     &                      +                 RXRAT(   384 )      ! HBR=ABRJ

      PROD(  BR2          ) =                 RXRAT(   348 )      ! BRO+BRO=BR2
     &                      +                 RXRAT(   350 )      ! BR+BRNO3=BR2+NO3
     &                      +                 RXRAT(   383 )      ! HOBR+ABRJ=BR2
      LOSS(  BR2          ) =                 RXRAT(   351 )      ! BR2+OH=HOBR+BR
     &                      +                 RXRAT(   370 )      ! BR2=0.2000D+01*BR

      PROD(  BRNO3        ) =                 RXRAT(   354 )      ! BRO+NO2=BRNO3
      LOSS(  BRNO3        ) =                 RXRAT(   350 )      ! BRNO3+BR=BR2+NO3
     &                      +                 RXRAT(   374 )      ! BRNO3=BRO+NO2
     &                      +                 RXRAT(   375 )      ! BRNO3=BR+NO3
     &                      +                 RXRAT(   381 )      ! BRNO3=HOBR+HNO3

      PROD(  BRNO2        ) =                 RXRAT(   355 )      ! BR+NO2=BRNO2
      LOSS(  BRNO2        ) =                 RXRAT(   373 )      ! BRNO2=BR+NO2

      PROD(  FMBR         ) =                 RXRAT(   359 )      ! OLE+BR=FMBR+ALD2+XO2H-PAR+RO2
     &                      +                 RXRAT(   360 )      ! ISOP+BR=FMBR+ISPD+0.9600D+...
      LOSS(  FMBR         ) =                 RXRAT(   361 )      ! FMBR+OH=BR+CO
     &                      +                 RXRAT(   377 )      ! FMBR=BR+CO+HO2

      PROD(  CH3BR        ) =   0.0D0
      LOSS(  CH3BR        ) =                 RXRAT(   363 )      ! CH3BR+OH=BR+FORM

      PROD(  MB3          ) =   0.0D0
      LOSS(  MB3          ) =                 RXRAT(   364 )      ! MB3+OH=0.3000D+01*BR+CO
     &                      +                 RXRAT(   378 )      ! MB3=0.3000D+01*BR+HO2+CO

      PROD(  MB2          ) =   0.0D0
      LOSS(  MB2          ) =                 RXRAT(   365 )      ! MB2+OH=0.2000D+01*BR+HO2+CO

      PROD(  MB2C         ) =   0.0D0
      LOSS(  MB2C         ) =                 RXRAT(   366 )      ! MB2C+OH=0.2000D+01*BR+CL+CO
     &                      +                 RXRAT(   379 )      ! MB2C=0.2000D+01*BR+CL+HO2+CO

      PROD(  MBC2         ) =   0.0D0
      LOSS(  MBC2         ) =                 RXRAT(   367 )      ! MBC2+OH=BR+0.2000D+01*CL+CO
     &                      +                 RXRAT(   380 )      ! MBC2=BR+0.2000D+01*CL+HO2+CO

      PROD(  MBC          ) =   0.0D0
      LOSS(  MBC          ) =                 RXRAT(   368 )      ! MBC+OH=BR+CL+CO+HO2

      PROD(  DMS          ) =   0.0D0
      LOSS(  DMS          ) =                 RXRAT(   369 )      ! DMS+BRO=0.7500D+00*SO2+...
     &                      +                 RXRAT(   412 )      ! DMS+IO=0.7500D+00*SO2+...
     &                      +                 RXRAT(   439 )      ! DMS+OH=SO2+MEO2+FORM
     &                      +                 RXRAT(   440 )      ! DMS+OH=0.7500D+00*SO2+...
     &                      +                 RXRAT(   441 )      ! DMS+NO3=SO2+HNO3+MEO2+FORM
     &                      +                 RXRAT(   442 )      ! DMS+CL=0.8600D+00*SO2+MEO2+...
     &                      +                 RXRAT(   443 )      ! DMS+CLO=0.7500D+00*SO2+...

      PROD(  MSA          ) =    2.5000D-01 * RXRAT(   369 )      ! DMS+BRO=0.2500D+00*MSA+...
     &                      +    2.5000D-01 * RXRAT(   412 )      ! DMS+IO=0.2500D+00*MSA+...
     &                      +    2.5000D-01 * RXRAT(   440 )      ! DMS+OH=0.2500D+00*MSA+...
     &                      +    1.4000D-01 * RXRAT(   442 )      ! DMS+CL=0.1400D+00*MSA+MEO2+...
     &                      +    2.5000D-01 * RXRAT(   443 )      ! DMS+CLO=0.2500D+00*MSA+...
      LOSS(  MSA          ) =   0.0D0

      PROD(  BRCL         ) =                 RXRAT(   382 )      ! HOBR+ACLJ=BRCL
      LOSS(  BRCL         ) =                 RXRAT(   376 )      ! BRCL=BR+CL

      PROD(  ABRJ         ) =                 RXRAT(   384 )      ! HBR=ABRJ
      LOSS(  ABRJ         ) =                 RXRAT(   383 )      ! ABRJ+HOBR=BR2
     &                      +                 RXRAT(   433 )      ! ABRJ+INO3=IBR+HNO3
     &                      +                 RXRAT(   435 )      ! ABRJ+INO2=IBR+HONO
     &                      +                 RXRAT(   437 )      ! ABRJ+HOI=IBR

      PROD(  I            ) =                 RXRAT(   387 )      ! I2+OH=I+HOI
     &                      +                 RXRAT(   388 )      ! HI+OH=I
     &                      +                 RXRAT(   391 )      ! IO+NO=I+NO2
     &                      +                 RXRAT(   394 )      ! I2+NO3=I+INO3
     &                      +                 RXRAT(   397 )      ! IO+BR=I+BRO
     &                      +                 RXRAT(   398 )      ! IO+BRO=I+BR
     &                      +                 RXRAT(   399 )      ! IO+CLO=I+CL
     &                      +    4.0000D-01 * RXRAT(   402 )      ! IO+IO=0.4000D+00*I+0.4000D+...
     &                      +                 RXRAT(   404 )      ! I2O2=I+OIO
     &                      +                 RXRAT(   406 )      ! INO2=I+NO2
     &                      +                 RXRAT(   411 )      ! CH3I+OH=I+FORM
     &                      +                 RXRAT(   412 )      ! DMS+IO=I+0.2500D+00*MSA+...
     &                      +    2.0000D+00 * RXRAT(   413 )      ! I2=0.2000D+01*I
     &                      +                 RXRAT(   414 )      ! HOI=I+OH
     &                      +                 RXRAT(   415 )      ! IO=I+O
     &                      +                 RXRAT(   416 )      ! OIO=I
     &                      +                 RXRAT(   417 )      ! INO=I+NO
     &                      +                 RXRAT(   418 )      ! INO2=I+NO2
     &                      +                 RXRAT(   419 )      ! INO3=I+NO3
     &                      +                 RXRAT(   420 )      ! I2O2=I+OIO
     &                      +                 RXRAT(   423 )      ! ICL=I+CL
     &                      +                 RXRAT(   424 )      ! IBR=I+BR
     &                      +                 RXRAT(   425 )      ! CH3I=I+MEO2
     &                      +    2.0000D+00 * RXRAT(   426 )      ! MI2=0.2000D+01*I+FORM
     &                      +                 RXRAT(   427 )      ! MIB=I+BR+FORM
     &                      +                 RXRAT(   428 )      ! MIC=I+CL+FORM
      LOSS(  I            ) =                 RXRAT(   385 )      ! I+O3=IO
     &                      +                 RXRAT(   386 )      ! I+HO2=HI
     &                      +                 RXRAT(   395 )      ! I+INO3=I2+NO3
     &                      +                 RXRAT(   396 )      ! I+BRO=IO+BR
     &                      +                 RXRAT(   408 )      ! I+NO=INO
     &                      +                 RXRAT(   409 )      ! I+NO2=INO2

      PROD(  IO           ) =                 RXRAT(   385 )      ! I+O3=IO
     &                      +                 RXRAT(   389 )      ! HOI+OH=IO
     &                      +                 RXRAT(   396 )      ! I+BRO=IO+BR
     &                      +                 RXRAT(   401 )      ! OIO+NO=IO+NO2
     &                      +                 RXRAT(   407 )      ! INO3=IO+NO2
     &                      +                 RXRAT(   421 )      ! I2O3=IO+OIO
      LOSS(  IO           ) =                 RXRAT(   390 )      ! IO+HO2=HOI
     &                      +                 RXRAT(   391 )      ! IO+NO=I+NO2
     &                      +                 RXRAT(   397 )      ! IO+BR=I+BRO
     &                      +                 RXRAT(   398 )      ! IO+BRO=BR+I
     &                      +                 RXRAT(   399 )      ! IO+CLO=I+CL
     &                      +    2.0000D+00 * RXRAT(   402 )      ! IO+IO=0.4000D+00*OIO+...
     &                      +                 RXRAT(   403 )      ! IO+OIO=I2O3
     &                      +                 RXRAT(   410 )      ! IO+NO2=INO3
     &                      +                 RXRAT(   412 )      ! IO+DMS=0.7500D+00*SO2+...
     &                      +                 RXRAT(   415 )      ! IO=I+O

      PROD(  HI           ) =                 RXRAT(   386 )      ! I+HO2=HI
      LOSS(  HI           ) =                 RXRAT(   388 )      ! HI+OH=I
     &                      +                 RXRAT(   438 )      ! HI=

      PROD(  I2           ) =                 RXRAT(   392 )      ! INO+INO=I2+0.2000D+01*NO
     &                      +                 RXRAT(   393 )      ! INO2+INO2=I2+0.2000D+01*NO2
     &                      +                 RXRAT(   395 )      ! INO3+I=I2+NO3
      LOSS(  I2           ) =                 RXRAT(   387 )      ! I2+OH=HOI+I
     &                      +                 RXRAT(   394 )      ! I2+NO3=I+INO3
     &                      +                 RXRAT(   413 )      ! I2=0.2000D+01*I

      PROD(  HOI          ) =                 RXRAT(   387 )      ! I2+OH=HOI+I
     &                      +                 RXRAT(   390 )      ! IO+HO2=HOI
      LOSS(  HOI          ) =                 RXRAT(   389 )      ! HOI+OH=IO
     &                      +                 RXRAT(   414 )      ! HOI=I+OH
     &                      +                 RXRAT(   436 )      ! HOI+ACLJ=ICL
     &                      +                 RXRAT(   437 )      ! HOI+ABRJ=IBR

      PROD(  INO          ) =                 RXRAT(   408 )      ! I+NO=INO
      LOSS(  INO          ) =    2.0000D+00 * RXRAT(   392 )      ! INO+INO=I2+0.2000D+01*NO
     &                      +                 RXRAT(   417 )      ! INO=I+NO

      PROD(  INO2         ) =                 RXRAT(   409 )      ! I+NO2=INO2
      LOSS(  INO2         ) =    2.0000D+00 * RXRAT(   393 )      ! INO2+INO2=I2+0.2000D+01*NO2
     &                      +                 RXRAT(   406 )      ! INO2=I+NO2
     &                      +                 RXRAT(   418 )      ! INO2=I+NO2
     &                      +                 RXRAT(   434 )      ! INO2+ACLJ=ICL+HONO
     &                      +                 RXRAT(   435 )      ! INO2+ABRJ=IBR+HONO

      PROD(  INO3         ) =                 RXRAT(   394 )      ! I2+NO3=INO3+I
     &                      +                 RXRAT(   410 )      ! IO+NO2=INO3
      LOSS(  INO3         ) =                 RXRAT(   395 )      ! INO3+I=I2+NO3
     &                      +                 RXRAT(   407 )      ! INO3=IO+NO2
     &                      +                 RXRAT(   419 )      ! INO3=I+NO3
     &                      +                 RXRAT(   432 )      ! INO3+ACLJ=ICL+HNO3
     &                      +                 RXRAT(   433 )      ! INO3+ABRJ=IBR+HNO3

      PROD(  OIO          ) =    4.0000D-01 * RXRAT(   402 )      ! IO+IO=0.4000D+00*OIO+...
     &                      +                 RXRAT(   404 )      ! I2O2=OIO+I
     &                      +    2.0000D+00 * RXRAT(   405 )      ! I2O4=0.2000D+01*OIO
     &                      +                 RXRAT(   420 )      ! I2O2=OIO+I
     &                      +                 RXRAT(   421 )      ! I2O3=OIO+IO
     &                      +    2.0000D+00 * RXRAT(   422 )      ! I2O4=0.2000D+01*OIO
      LOSS(  OIO          ) =    2.0000D+00 * RXRAT(   400 )      ! OIO+OIO=I2O4
     &                      +                 RXRAT(   401 )      ! OIO+NO=IO+NO2
     &                      +                 RXRAT(   403 )      ! OIO+IO=I2O3
     &                      +                 RXRAT(   416 )      ! OIO=I

      PROD(  I2O4         ) =                 RXRAT(   400 )      ! OIO+OIO=I2O4
      LOSS(  I2O4         ) =                 RXRAT(   405 )      ! I2O4=0.2000D+01*OIO
     &                      +                 RXRAT(   422 )      ! I2O4=0.2000D+01*OIO
     &                      +                 RXRAT(   431 )      ! I2O4=

      PROD(  I2O2         ) =    6.0000D-01 * RXRAT(   402 )      ! IO+IO=0.6000D+00*I2O2+...
      LOSS(  I2O2         ) =                 RXRAT(   404 )      ! I2O2=OIO+I
     &                      +                 RXRAT(   420 )      ! I2O2=I+OIO
     &                      +                 RXRAT(   429 )      ! I2O2=

      PROD(  I2O3         ) =                 RXRAT(   403 )      ! IO+OIO=I2O3
      LOSS(  I2O3         ) =                 RXRAT(   421 )      ! I2O3=IO+OIO
     &                      +                 RXRAT(   430 )      ! I2O3=

      PROD(  CH3I         ) =   0.0D0
      LOSS(  CH3I         ) =                 RXRAT(   411 )      ! CH3I+OH=I+FORM
     &                      +                 RXRAT(   425 )      ! CH3I=I+MEO2

      PROD(  ICL          ) =                 RXRAT(   432 )      ! INO3+ACLJ=ICL+HNO3
     &                      +                 RXRAT(   434 )      ! INO2+ACLJ=ICL+HONO
     &                      +                 RXRAT(   436 )      ! HOI+ACLJ=ICL
      LOSS(  ICL          ) =                 RXRAT(   423 )      ! ICL=I+CL

      PROD(  IBR          ) =                 RXRAT(   433 )      ! INO3+ABRJ=IBR+HNO3
     &                      +                 RXRAT(   435 )      ! INO2+ABRJ=IBR+HONO
     &                      +                 RXRAT(   437 )      ! HOI+ABRJ=IBR
      LOSS(  IBR          ) =                 RXRAT(   424 )      ! IBR=I+BR

      PROD(  MI2          ) =   0.0D0
      LOSS(  MI2          ) =                 RXRAT(   426 )      ! MI2=0.2000D+01*I+FORM

      PROD(  MIB          ) =   0.0D0
      LOSS(  MIB          ) =                 RXRAT(   427 )      ! MIB=I+BR+FORM

      PROD(  MIC          ) =   0.0D0
      LOSS(  MIC          ) =                 RXRAT(   428 )      ! MIC=I+CL+FORM

      PNEG( PAR ) =    2.5000D+00 * RXRAT(   128 )      ! KET=-0.2500D+01*PAR+...
     &            +    2.7000D+00 * RXRAT(   133 )      ! ROR=-0.2700D+01*PAR+...
     &            +    7.3000D-01 * RXRAT(   142 )      ! OLE+OH=-0.7300D+00*PAR+...
     &            +    7.9000D-01 * RXRAT(   143 )      ! OLE+O3=-0.7900D+00*PAR+...
     &            +                 RXRAT(   144 )      ! OLE+NO3=-PAR+0.5000D+...
     &            +    1.2600D-01 * RXRAT(   224 )      ! XPAR=-0.1260D+00*PAR+...
     &            +                 RXRAT(   239 )      ! CL+OLE=-PAR+0.3300D+...
     &            +                 RXRAT(   359 )      ! OLE+BR=-PAR+ALD2+XO2H+FMBR+RO2

      RETURN

      END
