      subroutine rdGSI(ccount,JDATE,JTIME,CGRID)
      USE GRID_CONF             ! horizontal & vertical domain specifications
      USE CGRID_SPCS            ! CGRID mechanism species
      USE UTILIO_DEFN
      USE STD_CONC              ! ajl just added

      IMPLICIT NONE

      INCLUDE SUBST_CONST       ! constants
      INCLUDE SUBST_FILES_ID    ! file name parameters

      CHARACTER( 16 ) :: FNAME
      character(*) ccount
      INTEGER      JDATE
      INTEGER      JTIME,l,r,c
      REAL, POINTER :: CGRID( :,:,:,: )  ! for initial CONC
      REAL      :: DBUFF( NCOLS,NROWS,NLAYS )
      INTEGER       :: STRTCOLINI, ENDCOLINI, STRTROWINI, ENDROWINI
      INTEGER      GXOFF, GYOFF               ! global origin offset from file
      CHARACTER( 96 ) :: XMSG = ' '
      CHARACTER( 16 ) :: PNAME = 'RDGSI'
! JDE      integer logdev
      INTEGER      INDX
      INTEGER      INO2,VNO2 ! pointer to NO2 information
      integer v,fini,spc,strt
      FNAME='CTM_GSI_'//trim(ccount)
! JDE      logdev=init3()
      write(logdev,*)'rdGSI CTM_GSI_1',trim(fname)
      call flush(logdev)
      write(logdev,*)'jdate',jdate,'jtime',jtime
      call flush(logdev)

      IF ( .NOT. OPEN3( FNAME, FSREAD3, PNAME ) ) THEN
         XMSG = 'Could not open ' // FNAME // ' file'
         CALL M3EXIT ( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
      END IF
      write(logdev,*)'subhfile'
      call flush(logdev)
      CALL SUBHFILE ( fname, GXOFF, GYOFF,
     &                STRTCOLINI, ENDCOLINI, STRTROWINI, ENDROWINI )
      write(logdev,*)'do xtract3',jdate,jtime
      call flush(logdev)
      V = 0
      FINI = N_C_GC_SPC
      ino2=-1
      vno2=-1
      strt=1
      DO SPC = STRT, FINI
         V = V + 1
         if( C_GC_SPC( V ).eq.'NO2')then
           INO2=SPC
           VNO2=V
           write(logdev,*)'rdgsi INO2',INO2,'VNO2',VNO2
           call flush(logdev)
           exit
         endif
      END DO
      if (INO2<1)then
            XMSG = 'Could not find NO2'
            CALL M3EXIT( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
      endif
      spc=ino2
      v=vno2
!      WRITE(6,*)'JDE rdGSI check C_GC_SPC( V ) ',TRIM(C_GC_SPC( V )),' VNAME3D( SPC ) ',TRIM(VNAME3D( SPC ))
!      WRITE(6,*)'JDE rdGSI check2 C_GC_SPC( 1 ) ',TRIM(C_GC_SPC( 1 )),' VNAME3D( 1 ) ',TRIM(VNAME3D( 1 ))
      IF ( .NOT. XTRACT3( FNAME, VNAME3D ( 1 ),
!      IF ( .NOT. XTRACT3( FNAME, VNAME3D ( spc ),
     &           1,NLAYS, STRTROWINI,ENDROWINI, STRTCOLINI,ENDCOLINI,
     &           JDATE, JTIME, DBUFF ) ) THEN
               XMSG = 'Could not read ' // TRIM( VNAME3D( 1 ) )
! JDE               XMSG = 'Could not read ' // TRIM( VNAME3D( SPC ) )
     &              // ' from ' // FNAME
               CALL M3EXIT ( PNAME, JDATE, JTIME, XMSG, XSTAT1 )
      END IF
      INDX = CONC_MAP( V )
      write(logdev,*)'rdgsi spc ',spc,' v ',v,' indx ',indx
      call flush(logdev)
      DO L = 1, NLAYS
        DO R = 1, NROWS
        !JDE DO R = 1, MY_NROWS
          DO C = 1, NCOLS
          !JDE DO C = 1, MY_NCOLS
!            CGRID( C,R,L,1 ) = DBUFF( C,R,L )
            CGRID( C,R,L,INDX ) = DBUFF( C,R,L )
          END DO
        END DO
      END DO
      write(LOGDEV,*)'Made it through the CGRID loop, closing file ',fname
      call flush(LOGDEV)
      IF ( .NOT. CLOSE3( fname ) ) THEN 
        XMSG = 'rdgsi Could not close file "' // TRIM( fname ) // '"'
        CALL M3EXIT( PNAME, 0, 0, XMSG, XSTAT2 )
      END IF
      RETURN
      end subroutine rdGSI

