#!/bin/ksh 
# . /home/lenzen/.bashrc
# Source global definitions
#if [ -f /etc/bashrc ]; then
#        . /etc/bashrc
#fi
#####################################################
# machine set up (users should change this part)
#####################################################
#
# GSIPROC = processor number used for GSI analysis
#------------------------------------------------
GSIPROC=1 #JDE for offline restart


# may need to change depending on queuing system you use
# set up for sbatch and srun
# if you have PBS or qusb will need to change srun back to mpiexec

  
  ARCH='LINUX'
#  ARCH='LINUX_PBS'
# Supported configurations:
            # IBM_LSF,
            # LINUX, LINUX_LSF, LINUX_PBS,
            # DARWIN_PGI
#
#####################################################
# case set up (users should change this part)
#####################################################
#
# ANAL_TIME= analysis time  (YYYYMMDDHH)
# WORK_ROOT= working directory, where GSI runs
# PREPBURF = path of PreBUFR conventional obs
# BK_ROOT  = path of background files
# OBS_ROOT = path of observations files
# FIX_ROOT = path of fix files
# GSI_EXE  = path and name of the gsi executable 
#  export DONO2=YES
  export OMP_NUM_THREADS=1
  export FORT_BUFFERED=true
  GSIDIR=/work/ROMO/users/bhenders/HAQAST/NO2ASSIM/CMAQ/gsi_scripts/2018_12US1_TROPOMI_restart_test/
  GSI_TIME=2018070118
  BUFRDATE=2018070118
  GSIDATE=2018070118
  ANAL_TIME=$GSI_TIME
  GUESS_TIME=$GSI_TIME
  echo GSI_TIME $GSI_TIME
  SST_TIME=`echo $ANAL_TIME | cut -c 1-8`12
  YYYY=`echo $ANAL_TIME | cut -c 1-4`
  YYYYB=`echo $BUFRDATE | cut -c 1-4`
  MM=`echo $ANAL_TIME | cut -c 5-6`
  MMB=`echo $BUFRDATE | cut -c 5-6`
  DD=`echo $ANAL_TIME | cut -c 7-8`
  HH=`echo $ANAL_TIME | cut -c 9-10`
  cmaqfile=cmaq_d01_${YYYY}-${MM}-${DD}_${HH}:00:00
  echo cmaqfile $cmaqfile
  scratch_d_gsi=/work/ROMO/users/bhenders/HAQAST/NO2ASSIM/CMAQ/gsi_scripts//2018_12US1_TROPOMI_restart_test//2018070118/
  WORK_ROOT=$scratch_d_gsi
  #base_data_disk=/work/ROMO/satellite/TROPOMINO2/bufr/
  base_data_disk=/work/ROMO/users/bhenders/HAQAST/NO2ASSIM/gsi_tropomi/run/
  OBS_ROOT=$base_data_disk/$YYYYB/
  echo OBS_ROOT $OBS_ROOT
# Make sure OBS_ROOT is defined and exists
if [ ! "${OBS_ROOT}" ]; then
  echo "ERROR: \$OBS_ROOT is not defined!"
  rmdir $WORK_ROOT
  exit 1
fi
  GSI_DIR=/work/ROMO/users/bhenders/HAQAST/NO2ASSIM/gsi_tropomi/
  PREPBUFR=${OBS_ROOT}/gdas1.t00z.prepbufr.nr
  FIX_ROOT=${GSI_DIR}/fix/
  CRTM_ROOT=${GSI_DIR}/src/libs/crtm_2.1.3
  GSI_EXE=${GSI_DIR}/run/gsi.exe
# path to uwh file or restart file
  BK_FILE=

#------------------------------------------------
# if_clean = clean  : delete temperal files in working directory (default)
#            no     : leave running directory as is (this is for debug only)
#  if_clean=clean
  if_clean=no

# Set the JCAP resolution which you want.
# All resolutions use LEVS=64
  JCAP=62
  LEVS=35
  JCAP_B=62
#
#
  BYTE_ORDER=Big_Endian
workdir=${WORK_ROOT}
#echo " Create working directory:" ${workdir}
cd ${workdir}
/bin/rm -rf GSIDONE
sleep 1
# clean out old sigf
#/bin/rm -f sigf00*
#
#####################################################
# Users should NOT change script after this point
#####################################################
#

case $ARCH in
   'IBM_LSF')
      ###### IBM LSF (Load Sharing Facility)
      RUN_COMMAND="mpirun.lsf " ;;

   'LINUX')
      if [ $GSIPROC = 1 ]; then
         #### Linux workstation - single processor
#         RUN_COMMAND="srun --export=ALL --overcommit -N 1-1 -n 1    "
         #RUN_COMMAND=""
         RUN_COMMAND="mpirun -np ${GSIPROC}  "
      else
         ###### Linux workstation -  mpi run
#         RUN_COMMAND="srun --export=ALL --overcommit -N 1-1 -n ${GSIPROC}  "
#         RUN_COMMAND="srun --ntasks=2 --export=ALL  "
         RUN_COMMAND="mpirun -np ${GSIPROC}  "
      fi ;;

   'LINUX_LSF')
      ###### LINUX LSF (Load Sharing Facility)
      RUN_COMMAND="mpirun.lsf " ;;

   'LINUX_PBS')
      #### Linux cluster PBS (Portable Batch System)
      ulimit -a
      RUN_COMMAND="mpirun -np ${GSIPROC} " ;;

   'DARWIN_PGI')
      ### Mac - mpi run
      if [ $GSIPROC = 1 ]; then
         #### Mac workstation - single processor
         RUN_COMMAND=""
      else
         ###### Mac workstation -  mpi run
         RUN_COMMAND="mpirun -np ${GSIPROC} -machinefile ~/mach "
      fi ;;

   * )
     print "error: $ARCH is not a supported platform configuration."
     exit 1 ;;
esac


##################################################################################
# Check GSI needed environment variables are defined and exist
#
 
# Make sure ANAL_TIME is defined and in the correct format
if [ ! "${ANAL_TIME}" ]; then
  echo "ERROR: \$ANAL_TIME is not defined!"
  exit 1
fi

# Make sure WORK_ROOT is defined and exists
if [ ! "${WORK_ROOT}" ]; then
  echo "ERROR: \$WORK_ROOT is not defined!"
  exit 1
fi

# Make sure the background file exists
#if [ ! -r "${BK_ROOT}" ]; then
#  echo "ERROR: ${BK_ROOT} does not exist!"
#exit 1
#fi

# Make sure OBS_ROOT is defined and exists
if [ ! "${OBS_ROOT}" ]; then
  echo "ERROR: \$OBS_ROOT is not defined!"
  exit 1
fi
if [ ! -d "${OBS_ROOT}" ]; then
  echo "ERROR: OBS_ROOT directory '${OBS_ROOT}' does not exist!"
  exit 1
fi

# Set the path to the GSI static files
if [ ! "${FIX_ROOT}" ]; then
  echo "ERROR: \$FIX_ROOT is not defined!"
  exit 1
fi
if [ ! -d "${FIX_ROOT}" ]; then
  echo "ERROR: fix directory '${FIX_ROOT}' does not exist!"
  exit 1
fi

# Set the path to the CRTM coefficients 
if [ ! "${CRTM_ROOT}" ]; then
  echo "ERROR: \$CRTM_ROOT is not defined!"
  exit 1
fi
if [ ! -d "${CRTM_ROOT}" ]; then
  echo "ERROR: fix directory '${CRTM_ROOT}' does not exist!"
  exit 1
fi


# Make sure the GSI executable exists
if [ ! -x "${GSI_EXE}" ]; then
  echo "ERROR: ${GSI_EXE} does not exist!"
  exit 1
fi

# Check to make sure the number of processors for running GSI was specified
if [ -z "${GSIPROC}" ]; then
  echo "ERROR: The variable $GSIPROC must be set to contain the number of processors to run GSI"
  exit 1
fi

################################################################################
## Given the analysis date, compute the date from which the
# first guess comes.  Extract cycle and set prefix and suffix
# for guess and observation data files
hha=`echo $ANAL_TIME | cut -c9-10`
hhg=`echo $GUESS_TIME | cut -c9-10`
echo hha $hha hhg $hhg

#
##################################################################################
# Create the ram work directory and cd into it


#
##################################################################################
# Set some parameters for use by the GSI executable and to build the namelist
echo " Build the namelist "

# Given the requested resolution, set dependent resolution parameters
if [[ "$JCAP" = "382" ]]; then
   LONA=768
   LATA=384
   DELTIM=180
   resol=1
elif [[ "$JCAP" = "62" ]]; then
   LONA=192
   LATA=94
   DELTIM=1200
   resol=2
else
   echo "INVALID JCAP = $JCAP"
#   exit
fi
LONA=360
LATA=179
NLAT=` expr $LATA + 2 `

# CO2 namelist and file decisions
ICO2=${ICO2:-0}
if [ $ICO2 -gt 0 ] ; then
        # Copy co2 files to $workdir
        co2dir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./global_co2_data.txt
        co2=$co2dir/global_co2.gcmscl_$yyyy.txt
        while [ ! -s $co2 ] ; do
                ((yyyy-=1))
                co2=$co2dir/global_co2.gcmscl_$yyyy.txt
        done
        if [ -s $co2 ] ; then
                cp $co2 ./global_co2_data.txt
        fi
        if [ ! -s ./global_co2_data.txt ] ; then
                echo "\./global_co2_data.txt" not created
                exit 1
        fi
fi
#CH4 file decision
ICH4=${ICH4:-0}
if [ $ICH4 -gt 0 ] ; then
#        # Copy ch4 files to $workdir
        ch4dir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./ch4globaldata.txt
        ch4=$ch4dir/global_ch4_esrlctm_$yyyy.txt
        while [ ! -s $ch4 ] ; do
                ((yyyy-=1))
                ch4=$ch4dir/global_ch4_esrlctm_$yyyy.txt
        done
        if [ -s $ch4 ] ; then
                cp $ch4 ./ch4globaldata.txt
        fi
        if [ ! -s ./ch4globaldata.txt ] ; then
                echo "\./ch4globaldata.txt" not created
                exit 1
        fi
fi
IN2O=${IN2O:-0}
if [ $IN2O -gt 0 ] ; then
#        # Copy ch4 files to $workdir
        n2odir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./n2oglobaldata.txt
        n2o=$n2odir/global_n2o_esrlctm_$yyyy.txt
        while [ ! -s $n2o ] ; do
                ((yyyy-=1))
                n2o=$n2odir/global_n2o_esrlctm_$yyyy.txt
        done
        if [ -s $n2o ] ; then
                cp $n2o ./n2oglobaldata.txt
        fi
        if [ ! -s ./n2oglobaldata.txt ] ; then
                echo "\./n2oglobaldata.txt" not created
                exit 1
        fi
fi
ICO=${ICO:-0}
if [ $ICO -gt 0 ] ; then
#        # Copy CO files to $workdir
        codir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./coglobaldata.txt
        co=$codir/global_co_esrlctm_$yyyy.txt
        while [ ! -s $co ] ; do
                ((yyyy-=1))
                co=$codir/global_co_esrlctm_$yyyy.txt
        done
        if [ -s $co ] ; then
                cp $co ./coglobaldata.txt
        fi
        if [ ! -s ./coglobaldata.txt ] ; then
                echo "\./coglobaldata.txt" not created
                exit 1
        fi
fi
SETUP=""
GRIDOPTS=""
BKGVERR=""
ANBKGERR=""
JCOPTS=""
STRONGOPTS=""
OBSQC=""
OBSINPUT=""
SUPERRAD=""
SINGLEOB=""

ln -fs ${GSI_EXE} . || exit 1


# Link to the prepbufr data
/bin/rm -f .prepbufr
ln -s ${PREPBUFR} ./prepbufr

# Link to the radiance data
suffix=tm00.bufr_d
/bin/rm -f  ./tropomino2bufr 


#
##################################################################################

# echo " Copy fixed files and link CRTM coefficient files to working directory"

# Set fixed files
#   berror   = forecast model background error statistics
#   specoef  = CRTM spectral coefficients
#   trncoef  = CRTM transmittance coefficients
#   emiscoef = CRTM coefficients for IR sea surface emissivity model
#   aerocoef = CRTM coefficients for aerosol effects
#   cldcoef  = CRTM coefficients for cloud effects
#   satinfo  = text file with information about assimilation of brightness temperatures
#   satangl  = angle dependent bias correction file (fixed in time)
#   pcpinfo  = text file with information about assimilation of prepcipitation rates
#   ozinfo   = text file with information about assimilation of ozone data
#   errtable = text file with obs error for conventional data (regional only)
#   convinfo = text file with information about assimilation of conventional data
#   bufrtable= text file ONLY needed for single obs test (oneobstest=.true.)
#   bftab_sst= bufr table for sst ONLY needed for sst retrieval (retrieval=.true.)

#ANAVINFO=${FIX_ROOT}/global_anavinfo.l64.txt
ANAVINFO=${FIX_ROOT}/global_raqms.txt

# AJL this can be changed 5 times inflation of NO2 Background covariance worked well with 15 percent NOX reduction GENBE
# Background covariance
# AJL will have to see if this is suitable for the lightning NOX experiment
export NO2BERRORMULT=5.

# AJL need to set to either 15 percent NOX reduction GENBE Background covariance or
# AJL the lightning NOX experiment GENBE Background covariance

BERROR=${FIX_ROOT}/wrf-arw-gsi_be_HAQAST_LNOX_CONTROL

SATINFO=${FIX_ROOT}/global_satinfo_reg_test.txt
scaninfo=${FIX_ROOT}/global_scaninfo.txt
SATANGL=${FIX_ROOT}/global_satangbias.txt
atmsbeamdat=${FIX_ROOT}/atms_beamwidth.txt
CONVINFO=${FIX_ROOT}/global_convinfo.txt
#OZINFO=${FIX_ROOT}/global_ozinfo.30.raqms.txt
OZINFO=${FIX_ROOT}/global_ozinfo.30.215.raqms.txt
PCPINFO=${FIX_ROOT}/global_pcpinfo.txt
OBERROR=${FIX_ROOT}/prepobs_errtable.global

# Only need this file for single obs test
#bufrtable=${FIX_ROOT}/prepobs_prep.bufrtable

# Only need this file for sst retrieval
#bftab_sst=${FIX_ROOT}/bufrtab.012

#  copy Fixed fields to working directory
 cp $ANAVINFO anavinfo
 cp $BERROR   berror_stats
 cp $SATANGL  satbias_angle
 cp $atmsbeamdat  atms_beamwidth.txt
 cp $SATINFO  satinfo
 cp $scaninfo scaninfo
 cp $CONVINFO convinfo
 cp $OZINFO   ozinfo
 cp $PCPINFO  pcpinfo
 cp $OBERROR  errtable

# cp $bufrtable ./prepobs_prep.bufrtable
# cp $bftab_sst ./bftab_sstphr

#
# CRTM Spectral and Transmittance coefficients
RTMFIX=${CRTM_ROOT}/${BYTE_ORDER}
emiscoef_IRwater=${RTMFIX}/Nalli.IRwater.EmisCoeff.bin
emiscoef_IRice=${RTMFIX}/NPOESS.IRice.EmisCoeff.bin
emiscoef_IRland=${RTMFIX}/NPOESS.IRland.EmisCoeff.bin
emiscoef_IRsnow=${RTMFIX}/NPOESS.IRsnow.EmisCoeff.bin
emiscoef_VISice=${RTMFIX}/NPOESS.VISice.EmisCoeff.bin
emiscoef_VISland=${RTMFIX}/NPOESS.VISland.EmisCoeff.bin
emiscoef_VISsnow=${RTMFIX}/NPOESS.VISsnow.EmisCoeff.bin
emiscoef_VISwater=${RTMFIX}/NPOESS.VISwater.EmisCoeff.bin
emiscoef_MWwater=${RTMFIX}/FASTEM5.MWwater.EmisCoeff.bin
aercoef=${RTMFIX}/AerosolCoeff.bin
cldcoef=${RTMFIX}/CloudCoeff.bin

ln -s $emiscoef_IRwater ./Nalli.IRwater.EmisCoeff.bin
ln -s $emiscoef_IRice ./NPOESS.IRice.EmisCoeff.bin
ln -s $emiscoef_IRsnow ./NPOESS.IRsnow.EmisCoeff.bin
ln -s $emiscoef_IRland ./NPOESS.IRland.EmisCoeff.bin
ln -s $emiscoef_VISice ./NPOESS.VISice.EmisCoeff.bin
ln -s $emiscoef_VISland ./NPOESS.VISland.EmisCoeff.bin
ln -s $emiscoef_VISsnow ./NPOESS.VISsnow.EmisCoeff.bin
ln -s $emiscoef_VISwater ./NPOESS.VISwater.EmisCoeff.bin
ln -s $emiscoef_MWwater ./FASTEM5.MWwater.EmisCoeff.bin
ln -s $aercoef  ./AerosolCoeff.bin
ln -s $cldcoef  ./CloudCoeff.bin
# Copy CRTM coefficient files based on entries in satinfo file
for file in `awk '{if($1!~"!"){print $1}}' ./satinfo | sort | uniq` ;do
   ln -s ${RTMFIX}/${file}.SpcCoeff.bin ./
   ln -s ${RTMFIX}/${file}.TauCoeff.bin ./
done

#
###################################################
#  run  GSI
###################################################
echo ' Run GSI with' ${bk_core} 'background'
/bin/rm -f sigf00*
echo $GSIDIR > $HOME/outgsidir
rsync -av $GSIDIR/$cmaqfile sigf00 || exit 1
cp -p sigf00 sigf00.orig
mkdir $GSIDATE
/bin/rm -fr dir.0*
if [ -s ${OBS_ROOT}/tropomi.no2.RPRO.${BUFRDATE}.bufr ] ; then
  ln -s ${OBS_ROOT}/tropomi.no2.RPRO.${BUFRDATE}.bufr           ./tropomino2bufr 
#if [ -s ${OBS_ROOT}/omi.no2.bufr.${BUFRDATE} ] ; then
#  ln -s ${OBS_ROOT}/omi.no2.bufr.${BUFRDATE}           ./tropomino2bufr 
else
  rsync -av iris:${OBS_ROOT}/tropomi.no2.RPRO.${BUFRDATE}.bufr   tropomino2bufr 
fi
ANAVINFO=${FIX_ROOT}/global_raqms.oz.no2.txt
ANAVINFO=${FIX_ROOT}/regional_no2.txt
NO2INFO=${FIX_ROOT}/global_no2info.txt
 cp $NO2INFO  no2info || exit 1
/bin/rm -f anavinfo
cp $ANAVINFO anavinfo
/bin/rm -f mlsbufr
                                                                                                   

# now do omi GSI

#if [ -s ${OBS_ROOT}/omi.no2.bufr.${BUFRDATE} ];then
if [ -s tropomino2bufr ] || [ -s omibufr ] ;then
echo do NO2 GSI

# Build the GSI namelist on-the-fly
cat << EOF > gsiparm.anl.OMI
 &SETUP
   miter=2,niter(1)=50,niter(2)=50,
   niter_no_qc(1)=1,niter_no_qc(2)=0,
   write_diag(1)=.true.,write_diag(2)=.false.,write_diag(3)=.true.,
   gencode=82,qoption=1,
   factqmin=0.1,factqmax=0.1,deltim=$DELTIM,
   ndat=1,iguess=-1,
   oneobtest=.false.,retrieval=.false.,l_foto=.false.,
   use_pbl=.false.,use_compress=.true.,nsig_ext=12,gpstop=50.,
   use_gfs_nemsio=.false.,lrun_subdirs=.true.,
   nhr_assimilation=0,offtime_data=.true.,min_offset=0,
   $SETUP
 /
 &GRIDOPTS
   JCAP=$JCAP,JCAP_B=$JCAP_B,NLAT=$NLAT,NLON=$LONA,nsig=$LEVS,
   regional=.true.,cmaq_regional=.true.,nlayers(63)=3,nlayers(64)=6,raqms=.false.,
   netcdf=.true.,
   $GRIDOPTS
 /
 &BKGERR
   vs=0.7,
   hzscl=1.7,0.8,0.5,
   hswgt=0.45,0.3,0.25,
   bw=0.0,norsp=4,
   bkgv_flowdep=.true.,bkgv_rewgtfct=1.5,
   $BKGVERR
 /
 &ANBKGERR
   anisotropic=.false.,
   $ANBKGERR
 /
 &JCOPTS
   ljcdfi=.false.,alphajc=0.0,ljcpdry=.true.,bamp_jcpdry=5.0e7,
   $JCOPTS
 /
 &STRONGOPTS
   tlnmc_option=0,nstrong=1,nvmodes_keep=8,period_max=6.,period_width=1.5,
   baldiag_full=.true.,baldiag_inc=.true.,
   $STRONGOPTS
 /
 &OBSQC
   dfact=0.75,dfact1=3.0,noiqc=.true.,oberrflg=.false.,c_varqc=0.02,
   use_poq7=.true.,
   $OBSQC
 /
 &OBS_INPUT
   dmesh(1)=25.0,dmesh(2)=150.0,time_window_max=1.5,
   dfile(1)='tropomino2bufr',   dtype(1)='tropomino2',       dplat(1)='aura',    dsis(1)='omi_aura',        dval(1)=0.0,  dthin(1)=0,  dsfcalc(1)=0,
   $OBSINPUT
 /
  &SUPEROB_RADAR
   $SUPERRAD
 /
 &LAG_DATA
 /
 &HYBRID_ENSEMBLE
   l_hyb_ens=.false.,
 /
 &RAPIDREFRESH_CLDSURF
   dfi_radar_latent_heat_time_period=30.0,
 /
 &CHEM
   berror_chem=.false.,
   oneobtest_chem=.false.,
 /
 &SINGLEOB_TEST
   maginnov=0.1,magoberr=0.1,oneob_type='t',
   oblat=45.,oblon=180.,obpres=1000.,obdattim=${ANAL_TIME},
   obhourset=0.,
   $SINGLEOB
 /
EOF
/bin/rm -f gsiparm.anl
rsync -av gsiparm.anl.OMI gsiparm.anl
sleep 2
cat gsiparm.anl

echo JDE here:
#echo JDE NO2SCATTERWEIGHT is $NO2SCATTERWEIGHT
#echo JDE GSIDATE is $GSIDATE
#echo JDE GSIDIAGDIR is $GSIDIAGDIR
#echo JDE no2gross is $no2gross
#echo JDE RAQMSADJUST is $RAQMSADJUST
#echo JDE end
echo NPROCS is $NPROCS JDE
echo GSIPROC is $GSIPROC JDE

case $ARCH in
   'IBM_LSF')
      ${RUN_COMMAND} ./gsi.exe < gsiparm.anl > stdout.OMI.ibm 2>&1  ;;

   * )
      ${RUN_COMMAND} ./gsi.exe > ../stdout.OMI.$GSIDATE 2>&1  ;;
esac
exit 0
# end of omi if there
mv sigf00 sigf00.OMI.NO2 || exit 1
ln -fs sigf00.OMI.NO2 sigf00.OMI || exit 1 # for model

fi

exit 0
