       SUBROUTINE W3FB01(XI,XJ,XMESHL,ALAT,ALONG)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FB01         I,J TO LATITUDE, LONGITUDE
C   AUTHOR: HEERMANN,A.      ORG: W345       DATE: 69-08-01
C
C ABSTRACT: CONVERTS THE COORDINATES OF A LOCATION FROM THE GRID(I,J)
C   COORDINATE SYSTEM OVERLAID ON THE POLAR STEREOGRAPHIC MAP PRO-
C   JECTION TRUE AT 60 N TO THE NATURAL COORDINATE SYSTEM OF LATITUDE
C   /LONGITUDE ON THE EARTH. A PREFERABLE MORE FLEXIBLE SUBROUTINE TO
C   USE IS W3FB05. W3FB01 IS THE REVERSE OF W3FB00.
C
C PROGRAM HISTORY LOG:
C   69-08-01  A. HEERMANN
C   90-08-31  R.E.JONES     CHANGE TO CRAY CFT77 FORTRAN
C
C USAGE:  CALL W3FB01 (XI, XJ, XMESHL, ALAT, ALONG)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     XI     ARG LIST  I OF THE POINT RELATIVE TO NORTH POLE
C     XJ     ARG LIST  J OF THE POINT RELATIVE TO NORTH POLE
C     XMESHL ARG LIST  MESH LENGTH OF GRID IN KILOMETERS AT 60N
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     ALAT   ARG LIST  LATITUDE IN DEG. (-20.0(S. HEMIS) < ALAT < 90.0)
C     ALONG  ARG LIST  WEST LONGITUDE IN DEGREES
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     ASIN ATAN2                                              SYSLIB
C
C   REMARKS: THE GRID USED IN THIS SUBROUTINE HAS ITS ORIGIN (I=0,J=0)
C     AT THE NORTH POLE, SO IF THE USER'S GRID HAS ITS ORIGIN AT A
C     POINT OTHER THAN THE NORTH POLE, A TRANSLATION IS REQUIRED TO
C     GET I AND J FOR INPUT INTO W3FB01. THE SUBROUTINE GRID IS
C     ORIENTED SO THAT LONGITUDE 80W IS PARALLEL TO GRIDLINES OF
C     I=CONSTANT. THE EARTH'S RADIUS IS TAKEN TO BE 6371.2 KM.
C     ALL PARAMETERS IN THE CALL STATEMENT MUST BE REAL
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP8/832
C
C$$$
C
      DATA  DEGPRD/57.2957795/
      DATA  EARTHR/6371.2/
C
      GI2 = (1.86603 * EARTHR) / XMESHL
      GI2 = GI2 * GI2
      R2  = XI * XI + XJ * XJ
      IF (R2.NE.0.0)  GO TO 100
      ALONG = 0.0
      ALAT = 90.0
      RETURN
C
100   CONTINUE
      ALAT = ASIN((GI2-R2) / (GI2+R2)) * DEGPRD
      XLONG = DEGPRD * ATAN2(XJ,XI)
      IF (XLONG) 200,300,300
C
200   CONTINUE
      ALONG = -10.0 - XLONG
      IF (ALONG.LT.0.0)  ALONG = ALONG + 360.0
      GO TO 400
C
300   CONTINUE
      ALONG = 350.0 - XLONG
C
400   CONTINUE
      RETURN
        END
