       SUBROUTINE W3FC02(FFID,FFJD,FGU,FGV,DIR,SPD)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FC02         GRID U,V WIND COMPS. TO DIR. AND SPEED
C   AUTHOR: STACKPOLE, J.    ORG: W324       DATE: 81-12-30
C
C ABSTRACT: GIVEN THE GRID-ORIENTED WIND COMPONENTS ON A NORTHERN
C   HEMISPHERE POLAR STEREOGRAPHIC GRID POINT, COMPUTE THE DIRECTION
C   AND SPEED OF THE WIND AT THAT POINT.  INPUT WINDS AT THE NORTH
C   POLE POINT ARE ASSUMED TO HAVE THEIR COMPONENTS FOLLOW THE WMO
C   STANDARDS FOR REPORTING WINDS AT THE NORTH POLE.
C   (SEE OFFICE NOTE 241 FOR WMO DEFINITION). OUTPUT DIRECTION
C   WILL FOLLOW WMO CONVENTION.
C
C PROGRAM HISTORY LOG:
C   81-12-30  J.STACKPOLE
C   89-01-20  R.E.JONES  CONVERT TO MICROSOFT FORTRAN 4.10
C   90-06-11  R.E.JONES  CONVERT TO SUN FORTRAN 1.3
C   91-03-30  R.E.JONES  CONVERT TO SiliconGRaphics FORTRAN
C   93-03-29  R.E.JONES  ADD SAVE STATEMENT
C   95-08-09  R.E.JONES  COMPILE ON CRAY
C
C USAGE:  CALL W3FC02 (FFID, FFJD, FGU, FGV, DIR, SPD)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     FFID   ARG LIST  REAL*4    I(NORTH POLE) - I(POINT)
C     FFJD   ARG LIST  REAL*4    J(NORTH POLE) - J(POINT)
C     FGU    ARG LIST  REAL*4    GRID-ORIENTED U-COMPONENT
C     FGV    ARG LIST  REAL*4    GRID-ORIENTED V-COMPONENT
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     DIR    ARG LIST  REAL*4     WIND DIRECTION, DEGREES
C     SPD    ARG LIST  REAL*4     WIND SPEED
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     ABS  ACOS   ATAN2   SQRT                                SYSTEM
C
C WARNING: THIS JOB WILL NOT VECTORIZE ON A CRAY
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916/16256, J916/162048
C
C$$$
C
      SAVE
C
      SPD = SQRT(FGU * FGU + FGV * FGV)
      IF (SPD.NE.0.) GO TO 1000
         FGU = 0.
         FGV = 0.
         GO TO 3000
 1000 CONTINUE
      DFP = SQRT(FFID * FFID + FFJD * FFJD)
      IF (DFP.NE.0.) GO TO 2000
         XLAM = ACOS(FGU / SPD)
         XLAM = XLAM * 57.29578
         IF (FGV.LT.0.) DIR = 170. + XLAM
         IF ((FGV.GT.0.).AND.(XLAM.LT.170.)) DIR = 170. - XLAM
         IF ((FGV.GT.0.).AND.(XLAM.GE.170.)) DIR = 530. - XLAM
         IF ((ABS(FGV).LE.0.001).AND.(FGU.GT.0.)) DIR = 170.
         IF ((ABS(FGV).LE.0.001).AND.(FGU.LT.0.)) DIR = 350.
         GO TO 3000
 2000 CONTINUE
         CAL = FFJD / DFP
         SAL = FFID / DFP
         U = FGU * CAL - FGV * SAL
         V = FGU * SAL + FGV * CAL
         DIR = 57.29578 * ATAN2(U,V) + 180.
 3000 CONTINUE
      RETURN
      END
