#!/bin/ksh

##########################################################################
####  UNIX Script Documentation Block                                    #
#                                                                        #
# Script name:         rtma_getguess.sh                                  #
# Script description:  Read in first guess in grib1 as created by the    #
#                      post and reformat to conform to GSI requirements. #
#                                                                        #
##########################################################################
                                                                                                      
set -x

#####################################################################

  ROOTDIR=/glade/p/work/mhu/gsi/rtma/rtma/RTMA
  FGFILE=/glade/p/work/mhu/gsi/rtma/RTMA_test/wrftwo_rr_01.grib1
  work_dir=${ROOTDIR}/rtmagus
  CYCLE=2012052811 
#
. ${ROOTDIR}/rtma_envir.sh
  fixparm=${ROOTDIR}/fix
  lexec=${ROOTDIR}/rtma_firstguess/rtma_firstguess.exe
  lstats=
#####################################################################
#####################################################################

   if [ ! -d $work_dir ] ; then
      mkdir -p $work_dir
   fi
      
   cd $work_dir
   
###################################################################################
   echo ${CYCLE} > cycledate
   YYYYMMDD=`echo ${CYCLE} | cut -c 1-8`
   YYYY=`echo ${CYCLE}     | cut -c 1-4`
   MM=`echo ${CYCLE}       | cut -c 5-6`
   DD=`echo ${CYCLE}       | cut -c 7-8`
   HH=`echo ${CYCLE}       | cut -c 9-10`
   CYCLE_date="${YYYYMMDD} ${HH}" 

#**********************************************************************************
#==> RETRIEVE THE FIRST GUESS                                                           
#**********************************************************************************

   if [ -e ${FGFILE} ] ; then
       cp ${FGFILE} $work_dir/first_guess.grib1
   else
       echo "HRRR forecast file missing"
       exit 1
   fi

#**********************************************************************************
#==> RETRIEVE THE OFF-TIME FIRST GUESS FIELDS FOR USE WITH FGAT
#**********************************************************************************
#**********************************************************************************
# CONVENIENTLY RENAME ALL INPUT FILES. 
#**********************************************************************************
#**********************************************************************************
# RETRIEVE THE BIAS CORRECTION FIELD
#**********************************************************************************
   if [[ "$lbiascor" = ".true." ]] ; then
      CYCLEm24=`date +%Y%m%d%H -d "${CYCLE_date} 24 hours ago"`
      if [ -e ${lstats}/rtma_biascor_out.dat_$CYCLEm24 ] ; then
        cp ${lstats}/rtma_biascor_out.dat_$CYCLEm24 rtma_biascor_in.dat
       else
        CYCLEm48=`date +%Y%m%d%H -d "${CYCLE_date} 48 hours ago"`
        cp ${lstats}/rtma_biascor_out.dat_$CYCLEm48 rtma_biascor_in.dat
      fi
   fi
#**********************************************************************************
# RETRIEVE THE OBSERVATION REJECT LISTS
#**********************************************************************************
   echo "Retrieving the iobservation reject lists"

    if [[ "$mkrjlists" = ".true." ]] ; then
      cp ${fixparm}/rtma_bigrjlist.txt bigrjlist.txt
#      cp ${lstats}/mass_rjlist.txt_dynamic_$CYCLEm1 mass_rjlist.txt_dynamic
#      cp ${lstats}/t_rjlist.txt_dynamic_$CYCLEm1    t_rjlist.txt_dynamic
#      cp ${lstats}/q_rjlist.txt_dynamic_$CYCLEm1    q_rjlist.txt_dynamic
#      cp ${lstats}/p_rjlist.txt_dynamic_$CYCLEm1    p_rjlist.txt_dynamic
   fi
#####################################################################


   infile=first_guess.grib1

#####################################################################
# write out records from grib file in binary format

##geofile=$fixparm/hrrr_geo.grib1

rm -f slabs.dat
wgrib -s $infile  | grep ":PRES:sfc:1hr fcst:"            | wgrib -i $infile          -ieee -o slabs.dat
wgrib -s $infile  | grep ":HGT:sfc:1hr fcst:"             | wgrib -i $infile  -append -ieee -o slabs.dat
## wgrib -s $geofile | grep ":HGT:sfc:1hr fcst:"             | wgrib -i $geofile -append -ieee -o slabs.dat
wgrib -s $infile  | grep ":TMP:sfc:1hr fcst:"             | wgrib -i $infile  -append -ieee -o slabs.dat
wgrib -s $infile  | grep ":DPT:2 m above gnd:1hr fcst:"   | wgrib -i $infile  -append -ieee -o slabs.dat
wgrib -s $infile  | grep ":UGRD:10 m above gnd:1hr fcst:" | wgrib -i $infile  -append -ieee -o slabs.dat
wgrib -s $infile  | grep ":VGRD:10 m above gnd:1hr fcst:" | wgrib -i $infile  -append -ieee -o slabs.dat
wgrib -s $infile  | grep ":SPFH:2 m above gnd:1hr fcst:"  | wgrib -i $infile  -append -ieee -o slabs.dat
wgrib -s $infile  | grep ":GUST:sfc:1hr fcst:"            | wgrib -i $infile  -append -ieee -o slabs.dat
## wgrib -s $geofile | grep ":HGT:sfc:1hr fcst:"             | wgrib -i $geofile -append -ieee -o slabs.dat    #in lieu of DIST
wgrib -s $infile  | grep ":HGT:sfc:1hr fcst:"             | wgrib -i $infile  -append -ieee -o slabs.dat
wgrib -s $infile  | grep ":VIS:sfc:1hr fcst:"             | wgrib -i $infile  -append -ieee -o slabs.dat
## wgrib -s $geofile | grep ":HGT:sfc:1hr fcst:"             | wgrib -i $geofile -append -ieee -o slabs.dat    #in lieu of HPBL
wgrib -s $infile  | grep ":HGT:sfc:1hr fcst:"             | wgrib -i $infile  -append -ieee -o slabs.dat

#####################################################################
# compile and run program that outputs first guess in the binary format
# required by the GSI-2DVAR. Wind rotation to get earth-relative winds 
# also performed.

cat << EOF > gridname_input
&gridname
    cgrid='${cgrid}',
    lbiascor=${lbiascor},
    lpbiascor=.false.,
    pbiascor=0.0,
    ltbiascor=.true.,
    tbiascor=0.1,
    lqbiascor=.false.,
    qbiascor=0.0,
    lubiascor=.false.,
    ubiascor=0.0,
    lvbiascor=.false.,
    vbiascor=0.0,
    ltdbiascor=.false.,
    tdbiascor=0.0,
    lgustbiascor=.false.,
    gustbiascor=0.0,
    lvisbiascor=.false.,
    visbiascor=0.0,
    lpblhbiascor=.false.,
    pblhbiascor=0.0,
    mkrjlists=${mkrjlists}
    hwrfblend=${hwrfblend}
/
EOF
#
cat << EOF > parm_ndfd_time_namelist 
&timeinfo
    iyear=${YYYY},
    imonth=${MM},
    iday=${DD},
    ihour=${HH}
/
EOF


   ln -s -f  parm_ndfd_time_namelist                          fort.9
   ln -s -f  slabs.dat                                        fort.20 
   ln -s -f  $fixparm/rtma_${cgrid}_latlon_mpfactor_slmask.data_be  fort.30
   ln -s -f  twodvar_input_bi                                 fort.88 
                                   # ndfd bckg converted to gsi format
   $lexec > stdout.rtma_getguess


   exit 0
#################################################################################################
