#!/usr/local/apps/anaconda/4.4.0/anaconda3/bin/python

# code from Barron Henderson

import yaml
import os

def readopts(optpath, **kwds):
    return yaml.load(open(optpath).read().format(**kwds))


def loadopts(optpath, **kwds):
    opts = readopts(optpath, **kwds)
    os.environ.update(**opts)
    return opts

# Load linux environment
linuxopts = loadopts('linux.env', WORKDIR=os.getcwd())
print('#!/bin/tcsh')
print('module purge')
#print('module load intel/18.0.1 intelmpi/2018.0.128')
print('module load intel/19.0.5')
print('module load openmpi-4.1.0/intel-19.0')
#print('module load netcdf-4.4.1/intel-18.0 pnetcdf-1.8.1/intel-18.0')
print('module load netcdf-4.7.4/intel-19.0')
print('module load pnetcdf-1.9.0/intel-18.0')
print('module load ioapi-3.2_20181011/intel-19.0')
print('module load anaconda3/4.4.0')

for k,v in linuxopts.items():
    print('setenv ',k,f'"{v}"')

#print('setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${IOAPI_LIB_DIR}')

#print(linuxopts)

# Update environment
#os.environ.update(**linuxopts)
