--T_EJ_Demographic
CREATE TABLE IF NOT EXISTS T_EJ_Demographic(
	[Year] INTEGER NOT NULL,								--Year
	GeoId11 TEXT NOT NULL,									--State FIPS + County FIPS + CensusTract FIPS
	DemographicIndexValue REAL NOT NULL,					
	DemographicIndexPercentile REAL NOT NULL,				
	LowIncomeValue REAL NOT NULL,					
	LowIncomePercentile REAL NOT NULL,				
	MinorityValue REAL NOT NULL,					
	MinorityPercentile REAL NOT NULL,				
	LessThanHighSchoolEduValue REAL NOT NULL,				--Less than high school education	
	LessThanHighSchoolEduPercentile REAL NOT NULL,		
	LinguisticIsolationValue REAL NOT NULL,					
	LinguisticIsolationPercentile REAL NOT NULL,	
	IndividualsUnderAge5Value REAL NOT NULL,					
	IndividualsUnderAge5Percentile REAL NOT NULL,	
	IndividualsOverAge64Value REAL NOT NULL,					
	IndividualsOverAge64Percentile REAL NOT NULL,	
	PRIMARY KEY([Year],GeoId11)
);


--创建索引
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_1 ON T_EJ_Demographic(DemographicIndexValue);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_2 ON T_EJ_Demographic(DemographicIndexPercentile);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_3 ON T_EJ_Demographic(LowIncomeValue);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_4 ON T_EJ_Demographic(LowIncomePercentile);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_5 ON T_EJ_Demographic(MinorityValue);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_6 ON T_EJ_Demographic(MinorityPercentile);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_7 ON T_EJ_Demographic(LessThanHighSchoolEduValue);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_8 ON T_EJ_Demographic(LessThanHighSchoolEduPercentile);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_9 ON T_EJ_Demographic(LinguisticIsolationValue);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_10 ON T_EJ_Demographic(LinguisticIsolationPercentile);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_11 ON T_EJ_Demographic(IndividualsUnderAge5Value);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_12 ON T_EJ_Demographic(IndividualsUnderAge5Percentile);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_13 ON T_EJ_Demographic(IndividualsOverAge64Value);
CREATE INDEX IF NOT EXISTS Index_EJ_Demographic_14 ON T_EJ_Demographic(IndividualsOverAge64Percentile);
