﻿using NEXUS.Data.Dtos;
using NEXUS.Data.Entities;
using NEXUS.Data.IRepositories;

namespace NEXUS.Data.Repositories
{
    public class CancerRiskRepository : SqliteRepository<T_CancerRisk>, ICancerRiskRepository
    {
        private const string sql1 = "SELECT GeoId11 FROM T_CancerRisk WHERE Year=@Year AND TotalValue>=@Min";
        private const string sql2 = "SELECT GeoId11 FROM T_CancerRisk WHERE Year=@Year AND TotalPercentile>=@Min";

        public CancerRiskRepository(DefaultDbConnectionInfo dbConnectionInfo) : base(dbConnectionInfo)
        {
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinPercentileAsync(Year year, PollutantType pollutantType, float min)
        {
            return base.QueryAsync<string>(sql2, new { Year = year, Min = min });
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinValueAsync(Year year, PollutantType pollutantType, double min)
        {
            return base.QueryAsync<string>(sql1, new { Year = year, Min = min });
        }
    }
}