﻿using NEXUS.Data.Dtos;
using NEXUS.Data.Entities;
using NEXUS.Data.IRepositories;

namespace NEXUS.Data.Repositories
{
    public class EJ_DemographicRepository : SqliteRepository<T_EJ_Demographic>, IEJ_DemographicRepository
    {
        private const string sql = "SELECT GeoId11 FROM T_EJ_Demographic WHERE Year=@Year AND {0}>=@Min";

        public EJ_DemographicRepository(DefaultDbConnectionInfo dbConnectionInfo) : base(dbConnectionInfo)
        {
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinPercentileAsync(Year year, EJType ejType, float min)
        {
            return base.QueryAsync<string>(string.Format(sql, ejType.ToString() + "Percentile"), new { Year = year, Min = min });
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinValueAsync(Year year, EJType ejType, float min)
        {
            return base.QueryAsync<string>(string.Format(sql, ejType.ToString() + "Value"), new { Year = year, Min = min });
        }
    }
}