﻿using NEXUS.Data.Dtos;
using NEXUS.Data.Entities;
using NEXUS.Data.IRepositories;

namespace NEXUS.Data.Repositories
{
    public class MorbidityOzoneRepository : SqliteRepository<T_MorbidityOzone>, IMorbidityOzoneRepository
    {
        private const string sql1 = "SELECT GeoId11 FROM T_Morbidity_Ozone WHERE Year=@Year AND EndpointId=@EndpointId AND IncidencesPercentile>=@Min";
        private const string sql2 = "SELECT GeoId11 FROM T_Morbidity_Ozone WHERE Year=@Year AND EndpointId=@EndpointId AND IncidencesPer10K>=@Min";

        public MorbidityOzoneRepository(DefaultDbConnectionInfo dbConnectionInfo) : base(dbConnectionInfo)
        {
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinPercentileAsync(Year year, int endpointId, float min)
        {
            return base.QueryAsync<string>(sql1, new { Year = year, EndpointId = endpointId, Min = min });
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinValueAsync(Year year, int endpointId, double min)
        {
            return base.QueryAsync<string>(sql2, new { Year = year, EndpointId = endpointId, Min = min });
        }
    }
}