﻿using NEXUS.Data.Dtos;
using NEXUS.Data.Entities;
using NEXUS.Data.IRepositories;

namespace NEXUS.Data.Repositories
{
    public class MortalityOzoneRepository : SqliteRepository<T_MortalityOzone>, IMortalityOzoneRepository
    {
        private const string sql1 = "SELECT GeoId11 FROM T_Mortality_Ozone WHERE Year=@Year AND EndpointId=@EndpointId AND DeathsPercentile>=@Min";
        private const string sql2 = "SELECT GeoId11 FROM T_Mortality_Ozone WHERE Year=@Year AND EndpointId=@EndpointId AND DeathsPer10K>=@Min";

        public MortalityOzoneRepository(DefaultDbConnectionInfo dbConnectionInfo) : base(dbConnectionInfo)
        {
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinPercentileAsync(Year year, int endpointId, float min)
        {
            return base.QueryAsync<string>(sql1, new { Year = year, EndpointId = endpointId, Min = min });
        }

        public Task<IEnumerable<string>> QueryGeoId11ByMinValueAsync(Year year, int endpointId, double min)
        {
            return base.QueryAsync<string>(sql2, new { Year = year, EndpointId = endpointId, Min = min });
        }
    }
}