﻿using NEXUS.Data.Dtos;

namespace NEXUS.WebApi.Controllers
{
    /// <summary>
    /// EJ/Demographic
    /// </summary>
    [Route("api/{year}/[controller]/{ejType}")]
    public class EJ_DemographicController : ApiControllerBase
    {
        private readonly IEJ_DemographicRepository _ejDemographicRepository;

        public EJ_DemographicController(IEJ_DemographicRepository ejDemographicRepository)
        {
            _ejDemographicRepository = ejDemographicRepository;
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Percentile")]
        public async Task<Response<IEnumerable<string>>> GetByMinPercentile(
            [FromRoute] Year year, [FromRoute] EJType ejType, [FromQuery] float min)
        {
            var data = await _ejDemographicRepository.QueryGeoId11ByMinPercentileAsync(year, ejType, min);
            return SucceededResult(data);
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Value")]
        public async Task<Response<IEnumerable<string>>> GetByMinValue(
            [FromRoute] Year year, [FromRoute] EJType ejType, [FromQuery] float min)
        {
            var data = await _ejDemographicRepository.QueryGeoId11ByMinValueAsync(year, ejType, min);
            return SucceededResult(data);
        }
    }
}