import { defineStore } from 'pinia';
import * as cancerRiskApi from '../../api/cancer-risk';
import * as hazardIndexApi from '../../api/hazard-index';
import { initYear } from '../../libs/year-options';
import { toxicsCache as cache } from '../../libs/geoid-cache';
import { emitter, eventTypes } from '../../libs/event-hub';

export const useToxicsStore = defineStore('toxics', {
    state: () => {
        return {
            year: initYear,
            cancerRisk: {
                isChecked: true,
                radio: 0,
                currentValue: 40,
                maxValue: 100,
                currentPercentile: 90,
            },
            hazardIndex: {
                isChecked: false,
                radio: 0,
                currentValue: 0.65,
                maxValue: 1,
                currentPercentile: 90,
            },
        };
    },
    actions: {
        async handleCancerRiskData() {
            if (this.cancerRisk.isChecked) {
                if (this.cancerRisk.radio === 0) {
                    cache.cancerRisk.values = await cancerRiskApi.getGeoId11ByMinValue(this.year, this.cancerRisk.currentValue);
                } else {
                    cache.cancerRisk.percentiles = await cancerRiskApi.getGeoId11ByMinPercentile(this.year, this.cancerRisk.currentPercentile);
                }
            } else {
                cache.cancerRisk.values = [];
                cache.cancerRisk.percentiles = [];
            }

            emitter.emit(eventTypes.OnRefreshDataAndSetStyle);
        },
        async handleHazardIndexData() {
            if (this.hazardIndex.isChecked) {
                if (this.hazardIndex.radio === 0) {
                    cache.hazardIndex.values = await hazardIndexApi.getGeoId11ByMinValue(this.year, this.hazardIndex.currentValue);
                } else {
                    cache.hazardIndex.percentiles = await hazardIndexApi.getGeoId11ByMinPercentile(this.year, this.hazardIndex.currentPercentile);
                }
            } else {
                cache.hazardIndex.values = [];
                cache.hazardIndex.percentiles = [];
            }

            emitter.emit(eventTypes.OnRefreshDataAndSetStyle);
        },
    },
});
