! for CB6_cl2
!
IRRTYPE = PARTIAL;
DEFINE FAMILY NOX = NO + NO2;
DEFINE FAMILY NTR = NTR1 +NTR2 +INTR;
DEFINE FAMILY PANy = PAN +PANX +OPAN;
DEFINE FAMILY NOZ = PAN +PANX +OPAN +HONO +PNA +2*N2O5 +NTR1 +NTR2 +INTR +HNO3
 +CLNO2 +CLNO3 +CRON;
DEFINE FAMILY OX    = O3 +NO2 +2*NO3 +O +O1D +PAN +3*N2O5 +PNA +PANX +OPAN;
DEFINE FAMILY HOX    = OH + HO2;
DEFINE FAMILY aRO2s = C2O3 +CXO3 +OPO3;
DEFINE FAMILY RO2s = MEO2 +XO2 +XO2H +XO2N +ISO2 +EPX2 +BZO2 +TO2
 +XLO2;
DEFINE FAMILY aVOC = FORM +ALD2 +ALDX +PAR +ETHA +PRPA +MEOH +ETOH +ETH +OLE
 +IOLE +ACET +TOL +XYLMN +GLYD +GLY +MGLY +KET +CRON +NTR1 +OPEN +CAT1 +CRES
 +XOPN +NAPH;
DEFINE FAMILY bVOC =  ISOP + ISPD + INTR + HPLD + EPOX + TERP;
!!=======================================================================
! Reaction Sum Definitions 
!=======================================================================

DEFINE CYCLE PANcyc = PAN;
DEFINE CYCLE PANXcyc = PANX;
DEFINE CYCLE OPANcyc = OPAN;
DEFINE CYCLE PNAcyc = PNA;
DEFINE RXNSUM PNAHO2cyc      = 0.59*<R50> + <R49> - <R48>;
DEFINE RXNSUM HONOcyc  = <R40> + 2.0*<R41> - 2.0*<R42> - <R43> - <R44>;
DEFINE RXNSUM NO3cyc      = <R26> - <R27>;
DEFINE RXNSUM MEPXcyc      = <R88> - 0.9*<R72>;
DEFINE RXNSUM ROOHcyc      = <R90> - <R76> - <R80> - <R84>;
DEFINE RXNSUM N2O5cyc      = <R36> - <R37>;
DEFINE RXNSUM H2O2_OHcyc =  <R21> -<R17> -<R19>-<R20>;
DEFINE RXNSUM HOXcyc =  <R12> -<R13>;
DEFINE RXNSUM HCO3cyc      = <R102> - <R101>;
DEFINE RXNSUM CLNO3cyc      = <CL28> - <CL30>;
!=======================================================================
! IPR_OUTPUTS
!=======================================================================
IPR_OUTPUT O3    =  CHEM+DDEP+CLDS+AERO+TRNM;
IPR_OUTPUT HNO3    =  CHEM+DDEP+CLDS+AERO;
IPR_OUTPUT PAN    =  CHEM+DDEP+CLDS+AERO+TRNM;
IPR_OUTPUT N2O5    =  CHEM+DDEP+CLDS+AERO;

DEFINE FAMILY EC = AECI + AECJ;
IPR_OUTPUT EC = COAG + EMIS + HADV;
IPR_OUTPUT ASO4J = COND + COAG + EMIS + CHEM + VDIF + CLDS;
IPR_OUTPUT ASO4I = NPF + COND + COAG + EMIS + CHEM + VDIF +CLDS;
IPR_OUTPUT NUMATKN;
!IPR_OUTPUT NUMACC;
!IPR_OUTPUT NUMCOR;
!=======================================================================
! IRR_OUTPUTS
! OX prod and loss
!
IRR_OUTPUT OxPROD = NETP[OX];
IRR_OUTPUT OxLOSS = NETL[OX];
IRR_OUTPUT OxLOSSHAL = <HAL_Ozone>;

! factors influencing PAN and N2O5 concentrations
!
IRR_OUTPUT PANprod = PANcyc[POSONLY];
IRR_OUTPUT PANloss= PANcyc[NEGONLY] + <R56>;

! RO2 fate
IRR_OUTPUT RO2withNOtoNO2 = PROD[NO2] FROM [RO2s] AND [NO]
+ PROD[NO2] FROM [aRO2s] AND [NO];
IRR_OUTPUT RO2withNOtoNTR = PROD[NTR] FROM [RO2s] AND [NO];
IRR_OUTPUT RO2withNO2toPAN = PROD[PANy] FROM [aRO2s] AND [NO2];
IRR_OUTPUT RO2withHO2 = LOSS [RO2s] AND [HO2] + LOSS [aRO2s] AND [HO2];
IRR_OUTPUT RO2withRO2 = LOSS [RO2s] AND [RO2] + LOSS [aRO2s] AND [RO2]
 + LOSS [RO2s] AND [aRO2s];
! VOC fate
IRR_OUTPUT aVOCwithOH = LOSS[aVOC] AND [OH];
IRR_OUTPUT aVOCwithO3 = LOSS[aVOC] AND [O3];
IRR_OUTPUT aVOCwithNO3 = LOSS[aVOC] AND [NO3];
IRR_OUTPUT aVOCwithCL = LOSS[aVOC] AND [CL];
IRR_OUTPUT bVOCwithOH = LOSS[bVOC] AND [OH];
IRR_OUTPUT bVOCwithO3 = LOSS[bVOC] AND [O3];
IRR_OUTPUT bVOCwithNO3 = LOSS[bVOC] AND [NO3];
IRR_OUTPUT bVOCwithCL = LOSS[bVOC] AND [CL];

! New radicals

IRR_OUTPUT OHfrO1D = PROD [OH] FROM [O1D];
!
IRR_OUTPUT NewHOxfromHCHO =2.0*<R97>; 
IRR_OUTPUT NewHOxfromH2O2 =2.0*H2O2_OHcyc[POSONLY];
IRR_OUTPUT NewHOxfromHONO = HONOcyc[NEGONLY]; 
! from photolysis not including HCHO
IRR_OUTPUT NewHOxfromhv = <R50> + <R88> + 2.0*<R90> + 2.0*<R97> + <R108> 
  + 1.59*<R114> + 2.0*<R117> + <R119> + 0.76*<R161> + <R196> + 0.7*<R197> 
  + <R201> + <CL9>;
! from O3+alkene reactions
IRR_OUTPUT NewHOxfromO3 =0.32*<R139> + 0.414*<R143> + 0.5*<R147> +0.332*<R156>
   +0.859*<R159> +0.57*<R173> + 1.06*<R203>;  

! chlorine
IRR_OUTPUT NewClrad = 2.0*<CL1> + <CL2> + <CL9> + <CL23> + <CL31>;
IRR_OUTPUT ClfromCLNO2 = <CL27>;
IRR_OUTPUT ClfromCLNO3 = <CL31>;

! NOz production rates

IRR_OUTPUT NOZfrNOX = PANcyc[POSONLY] + PANXcyc[POSONLY] + OPANcyc[POSONLY] 
  + HONOcyc[POSONLY] + PNAcyc[POSONLY] + NO3cyc[POSONLY] + N2O5cyc[POSONLY]
  + CLNO3cyc[POSONLY] +PROD[NTR] FROM [NOX] + PROD[HNO3] FROM [NOX];
! O3 production efficiency = p(O3)/p(NOz)= O3prod/NOZfromNOX
IRR_OUTPUT O3prod = NETP[O3];

! HNO3 formation pathways
IRR_OUTPUT HNO3prod = PROD[HNO3];
IRR_OUTPUT HNO3fromOHNO2 = <R45>;
IRR_OUTPUT HNO3fromhetNTR = <HET_NTR2>;
IRR_OUTPUT HNO3fromN2O5 = <HET_N2O5IJ> + <HET_N2O5K> + <HET_H2NO3PIJA> 
      +<HET_H2NO3PKA>;
IRR_OUTPUT HNO3fromNO3 = PROD[HNO3] FROM [NO3];
IRR_OUTPUT HNO3frCLNO3 = <HET_CLNO3_WAJ>;

! alkyl nitrate pathways
!
IRR_OUTPUT NTRprod = NETP[NTR];
IRR_OUTPUT NTRfromISOP = PROD[NTR] FROM [ISOP] + PROD[NTR] FROM [ISPD];
IRR_OUTPUT NTRfromTERP = PROD[NTR] FROM [TERP];
IRR_OUTPUT XO2NfromISOP = PROD[XO2N] FROM [ISOP] + PROD[XO2N] FROM [ISPD];
IRR_OUTPUT XO2NfromTERP = PROD[XO2N] FROM [TERP];
IRR_OUTPUT XO2NfromALKx = PROD[XO2N] FROM [PAR];
IRR_OUTPUT XO2Nprod = PROD[XO2N];
IRR_OUTPUT NTRfromXO2N = PROD[NTR] FROM [XO2N];
!
ENDPA;
