#' @title Create supplementary boxplots
#'
#' @description
#' Create the boxplots for number of total number of assays tested for food 
#' chemicals, per use category, and the proportion of active assays relative to
#' the total number of assays tested.
#'
#' @import data.table
#' @export


bxplt2 <- function(fname = NULL) {
  
  op <- par(no.readonly = TRUE)
  on.exit(par(op))
  
  data(SR)
  
  setkey(SR, cat)
  
  n0 <- SR[which(toxc), .N, by = cat][order(cat), N]
  
  ns <- c("Direct Food\nAdditives",
          "Food Contact\nSubstances",
          "Pesticides")
  
  if (!is.null(fname)) png(fname, 6, 9, "in", res = 600)
  
  par(mfrow = c(2, 1), oma = c(5, 0, 0, 0))
  par(mar = c(0, 5, 0, 0))
  boxplot(data = SR[which(toxc)], N ~ cat,
          ylab = "# Tested Endpoints",
          frame = FALSE, 
          notch = TRUE, 
          xaxt = "n",
          border = rep(c("gray50", "gray50"), 3))
  addfiglab("A")
  
  boxplot(data = SR[which(toxc)], phit ~ cat,
          ylab = "Proportion Assays Active",
          frame = FALSE, 
          notch = TRUE, 
          xaxt = "n",
          border = rep(c("gray50", "gray50"), 3))
  addfiglab("B")
  
  text(line2user(0, 2), line2user(0.5, 1),
       adj = c(1, 1), labels = "# Chemicals", xpd = NA)
  text(1:3, line2user(0.5, 1), adj = c(0.5, 1), xpd = NA, n0)
  
  text(1:3, line2user(2, 1), adj = c(0.5, 1), xpd = NA, ns)
  
  if (!is.null(fname)) graphics.off()
  
}