#' @title Calculate mol objects
#'
#' @description
#' Calculate mol objects
#'
#' @import rcdk
#' @export

calcmols <- function(casn = NULL) {

  data(smis, envir = environment())

  if (!is.null(casn)) smis <- smis[casn]

  ## Get molecules from SMILES with kekulise = FALSE
  mols <- sapply(smis, parse.smiles, kekulise = FALSE)
  names(mols) <- names(smis)

  ## Add the information suggested by rcdk
  for (i in names(mols)) do.aromaticity(mols[[i]])
  for (i in names(mols)) do.typing(mols[[i]])
  for (i in names(mols)) do.isotopes(mols[[i]])

  mols

}