#' @title Create violin plots
#'
#' @description
#' Create the violin plots for the cytotox centers
#'
#' @import data.table
#' @export

cytoplot <- function(fname = NULL) {

  data(CD)

  if (!is.null(fname)) {
    png(fname, pointsize = 8, height = 4, width = 6, units = "in", res = 600)
  }

  par(mar = c(5, 9, 0, 1))

  plot.new()
  plot.window(xlim = c(-2, 3), ylim = c(0, 4))
  violin(list(CD[i == 3 & nhit > 2, cyto_pt],
              CD[i == 2 & nhit > 2, cyto_pt],
              CD[i == 1 & nhit > 2, cyto_pt]),
         drawRect = FALSE)
  boxplot(list(CD[i == 3 & nhit > 2, cyto_pt],
               CD[i == 2 & nhit > 2, cyto_pt],
               CD[i == 1 & nhit > 2, cyto_pt]),
          horizontal = TRUE,
          width = c(CD[i == 3, length(which(nhit > 2))/.N],
                    CD[i == 2, length(which(nhit > 2))/.N],
                    CD[i == 1, length(which(nhit > 2))/.N]),
          frame = FALSE,
          yaxt = "n", xaxt = "n",
          add = TRUE, col = NA)
  axis(side = 1, at = -2:2, labels = c(10^(-2:2)))
  axis(side = 1, at = c(2.5, 3), labels = c("N", "Total"))
  text(x = 2.5, y = 1:3,
       labels = c(CD[i == 3, length(which(nhit > 2))],
                  CD[i == 2, length(which(nhit > 2))],
                  CD[i == 1, length(which(nhit > 2))]))
  text(x = 3, y = 1:3, labels = CD[ , .N, keyby = i][J(3:1), N])
  axis(side = 2, line = -2,
       labels = c("Pesticides",
                  "Food Contact Substances",
                  "Direct Food Additives"),
       at = 1:3, las = 2, tick = FALSE)
  mtext(text = expression(paste("Cytotoxicity Center (", mu, "M)")),
        side = 1, at = 0, line = 3)

  if (!is.null(fname)) graphics.off()

}