#' @name line2user
#' @title Convert margin line location to user coordinate
#' @description Convert margin line location to user coordinate
#'
#' @export

line2user <- function(line, side) {
  lh <- par('cin')[2] * par('cex') * par('lheight')
  x_off <- diff(grconvertX(c(0, lh), 'inches', 'npc'))
  y_off <- diff(grconvertY(c(0, lh), 'inches', 'npc'))
  switch(side,
         `1` = grconvertY(-line * y_off, 'npc', 'user'),
         `2` = grconvertX(-line * x_off, 'npc', 'user'),
         `3` = grconvertY(1 + line * y_off, 'npc', 'user'),
         `4` = grconvertX(1 + line * x_off, 'npc', 'user'),
         stop("Side must be 1, 2, 3, or 4", call.=FALSE))
}


#' @name addfiglab
#' @title Add a figure label
#' @description Add a figure label
#'
#' @export

addfiglab <- function(lab, xl = par()$mar[2], yl = par()$mar[3]) {
  
  text(x = line2user(xl, 2), y = line2user(yl, 3), 
       lab, xpd = NA, font = 2, cex = 1.5, adj = c(0, 1))
  
}


figlines <- function() {
  
  mar <- par()$mar
  usr <- par()$usr
  x0 <- line2user(line = 0, side = 2)
  x1 <- line2user(line = 1, side = 2)
  xlines <- sum(mar[c(2, 4)], abs(diff(usr[c(1:2)]))/abs(x1 - x0))
  xlines <- abs(diff(usr[c(1:2)]))/abs(x1 - x0)
  
  y0 <- line2user(line = 0, side = 1)
  y1 <- line2user(line = 1, side = 1)
  ylines <- sum(mar[c(1, 3)], abs(diff(usr[c(3:4)]))/abs(y1 - y0))
  ylines <- abs(diff(usr[c(3:4)]))/abs(y1 - y0)
  
  c(xlines, ylines)
              
}



