#' @title Create summary table
#'
#' @description
#' Create summary table showing nhits for cyto assays,  and pre- and 
#' post-filtering
#' 
#' \itemize{
#'   \item c_hit = # cyto assays active
#'   \item c_ttl = # cyto assays tested
#'   \item t_hit = # non-cyto assays active pre-filtering
#'   \item t_ttl = # non-cyto assays tested
#'   \item f_hit = # non-cyto assays active post-filtering
#' }
#'
#' @import data.table
#' 
#' @examples
#' tbl <- makefilttbl()
#' tbl[ , .SD[order(t_hit, decreasing = TRUE)], keyby = cat]
#' tbl[ , .SD[order(f_hit, decreasing = TRUE)], keyby = cat]
#' 
#' @export


makefilttbl <- function() {
  
  
  data(TM, CD, envir = environment())
  
  tbl <- CD[ , list(code, casn, chnm, cat = i, c_hit = nhit, c_ttl = ntested)]
  
  tbl[ , t_hit := apply(TM$hitc, 1, sum, na.rm = TRUE)]
  tbl[ , f_hit := apply(TM$filt_hit, 1, sum, na.rm = TRUE)]
  tbl[ , t_ttl := apply(TM$tested, 1, sum, na.rm = TRUE)]
  
  tbl[]
  
}