#' @title Create SOM generation plots
#'
#' @description
#' Create the count plot for the SOM with the training progress
#'
#' @export


somgenplot <- function(fname = NULL) {

  op <- par(no.readonly = TRUE)
  on.exit(par(op))

  data(SR, SOM, envir = environment())

  vals <- SR[!is.na(casn), .N, by = bin][J(1:480), N]

  if (!is.null(fname)) {
    png(fname, 6, 4, "in", res = 600, pointsize = 10)
  }

  par(mfrow = c(1, 2))
  plot(SOM$changes, bty = "n", main = "", ylab = "Mean BMU Distance",
       type = "l", xlab = "Iteration")
  addfiglab("A")

  hist(vals, breaks = 25, main = "", xlab = "Chemicals per Bin")
  addfiglab("B")

  if (!is.null(fname)) graphics.off()

}