#' @title Create SOM plot
#'
#' @description
#' Create SOM plot highlighting the proportion of chemicals per category with
#' the option of expanding a selected bin
#' 
#' @examples
#' somplot(b = 387)
#'
#' @export


somplot <- function(fname = NULL, b) {
  
  op <- par(no.readonly = TRUE)
  on.exit(par(op))
  
  data(SR, envir = environment())
  
  lw <- function(x) length(which(x))
  
  ## Prop in Category 1
  v1 <- SR[!is.na(casn), list(p = lw(cat1)/.N), by = bin][J(1:480), p]
  
  ## Prop in Category 2
  v2 <- SR[!is.na(casn), list(p = lw(cat2)/.N), by = bin][J(1:480), p]
  
  ## Prop in Category 3
  v3 <- SR[!is.na(casn), list(p = lw(cat3)/.N), by = bin][J(1:480), p]
  
  ## #Chem in ToxCast
  v4 <- SR[!is.na(casn), list(p = lw(toxc)), by = bin][J(1:480), p]
  
  ## Mean proportion active
  v5 <- SR[which(toxc), list(h = mean(phit)), by = bin][J(1:480), h]
  v5[is.infinite(v5)] <- 0
  
  mols <- calcmols()
  
  if (!is.null(fname)) png(fname, 12, 10, "in", res = 300)
  layout(mat = matrix(c(1:6), ncol = 3, byrow = TRUE))
  
  p <- list(xdim = 20, ydim = 24, pal = cbrh, border = NA,
            mars = c(0, 4, 0, 0))
  do.call(honey.plot,
          c(list(vals = v1, 
                 key.lab = "Proportion in Direct Food Additives",
                 hl = which(v1 == 0)), 
            p))
  addfiglab("A")
  do.call(honey.plot,
          c(list(vals = v2, 
                 key.lab = "Proportion in Food Contact Substances",
                 hl = which(v2 == 0)), 
            p))
  addfiglab("B")
  do.call(honey.plot, 
          c(list(vals = v3, 
                 key.lab = "Proportion in Pesticides", 
                 hl = which(v3 == 0)), 
            p))
  addfiglab("C")
  
  p <- list(xdim = 20, ydim = 24, pal = cbrh, border = NA, hl = which(v4 == 0),
            mars = c(0, 4, 0, 0))
  do.call(honey.plot,
          c(list(vals = v4, key.lab = "# Chemicals in ToxCast"), p))
  addfiglab("D")
  do.call(honey.plot,
          c(list(vals = v5, key.lab = "Mean Proportion Active"), p))
  addfiglab("E")
  box_loc <- honey.box(20, 24, bin = b, lwd = 2, col = "gray30", bac = FALSE)
  add.molgrid(mols = mols[SR[J(b), casn]], coln = 3, bl = box_loc$bl,
              tr = box_loc$tr, labels = SR[J(b), casn],
              lab.font = SR[J(b), ifelse(toxc, 2, 1)],
              lab.col = SR[J(b), ifelse(toxc, "red", "black")])
  plot.new()
  
  if (!is.null(fname)) graphics.off()
  
  layout(1)
  
} 