##----------------------------------------------------------------------------##
## Violin function
##----------------------------------------------------------------------------##

#' @title Draw violin
#'
#' @description
#' Draw violin
#'
#' @import sm
#' @export

violin <- function(x, col = "gray90", border = "gray80", lty = 1,
                   lwd = 1, rectCol = "black", colMed = "white", pchMed = 19,
                   at, wex = 1, drawRect = TRUE) {
  datas <- x
  n <- length(datas)
  if (missing(at))
    at <- 1:n
  upper <- vector(mode = "numeric", length = n)
  lower <- vector(mode = "numeric", length = n)
  q1 <- vector(mode = "numeric", length = n)
  q3 <- vector(mode = "numeric", length = n)
  med <- vector(mode = "numeric", length = n)
  base <- vector(mode = "list", length = n)
  height <- vector(mode = "list", length = n)
  baserange <- c(Inf, -Inf)
  for (i in 1:n) {
    data <- datas[[i]]
    data.min <- min(data)
    data.max <- max(data)
    q1[i] <- quantile(data, 0.25)
    q3[i] <- quantile(data, 0.75)
    med[i] <- median(data)
    iqd <- q3[i] - q1[i]
    upper[i] <- min(q3[i] + 1.5 * iqd, data.max)
    lower[i] <- max(q1[i] - 1.5 * iqd, data.min)
    est.xlim <- c(min(lower[i], data.min), max(upper[i],
                                               data.max))
    smout <- do.call("sm.density",
                     c(list(data, xlim = est.xlim, display = "none")))
    hscale <- 0.4/max(smout$estimate) * wex
    base[[i]] <- smout$eval.points
    height[[i]] <- smout$estimate * hscale
    t <- range(base[[i]])
    baserange[1] <- min(baserange[1], t[1])
    baserange[2] <- max(baserange[2], t[2])
  }
  for (i in 1:n) {
    polygon(c(base[[i]],
              rev(base[[i]])),
            c(at[i] - height[[i]],
              rev(at[i] + height[[i]])),
            col = col, border = border,
            lty = lty, lwd = lwd)
    if (drawRect) {
      lines(c(lower[i], upper[i]), at[c(i, i)], lwd = lwd,
            lty = lty)
      rect(q1[i], at[i] - boxwidth/2, q3[i], at[i] +
             boxwidth/2, col = rectCol)
      points(med[i], at[i], pch = pchMed, col = colMed)
    }
  }
}