<cfcomponent>
  <cfscript>

    // creates new excel WB with default active sheet, no row data
    // sheetName = name of the default sheet
    // columnNames = comma delimited list
    function createNewWorkbookEmpty(sheetName, columnNames) {
        var newWorkbook = SpreadsheetNew(sheetName, true);
        SpreadsheetAddRow(newWorkbook, columnNames);

        return newWorkbook;
    }

    // creates new excel WB with default active sheet
    // sheetName = name of the default sheet
    // columnNames = comma delimited list
    // rows = array of comma delimited lists
    function createNewWorkbook(sheetName, columnNames, rows) {
        var currentRow = "";

        var newWorkbook = SpreadsheetNew(sheetName, true);
        SpreadsheetAddRow(newWorkbook, columnNames);

        for(i=1; i <= arrayLen(rows); i++) {
            currentRow = rows[i];
            SpreadsheetAddRow(newWorkbook, currentRow);
        }

        return newWorkbook;
    }

    // adds a row to the active sheet of the specified workbook
    // workbook = workbook object to add to
    // row = comma delimited list of values
    function addRowData(workbook, row) {
        SpreadsheetAddRow(workbook, row);
    }

    // adds an excel spreadsheet to an existing workbook, no data
    // workbook = existing Excel workbook
    // sheetName = name of the sheet
    // columnNames = comma delimited list
    function addWorksheetEmpty(workbook, sheetName, columnNames) {
        var currentRow = "";

        SpreadSheetCreateSheet(workbook, sheetName);
        SpreadSheetSetActiveSheet(workbook, sheetName);
        SpreadsheetAddRow(workbook, columnNames);

    }

    // adds an excel spreadsheet to an existing workbook
    // workbook = existing Excel workbook
    // sheetName = name of the sheet
    // columnNames = comma delimited list
    // rows = array of comma delimited lists
    function addWorksheet(workbook, sheetName, columnNames, rows) {
        var currentRow = "";

        SpreadSheetCreateSheet(workbook, sheetName);
        SpreadSheetSetActiveSheet(workbook, sheetName);
        SpreadsheetAddRow(workbook, columnNames);

        for(i=1; i <= arrayLen(rows); i++) {
            currentRow = rows[i];
            SpreadsheetAddRow(workbook, currentRow);
        }
    }

    function addNumericCellValue(workbook, thisVal, row, col) {
        SpreadsheetSetCellValue(workbook, thisVal, row, col, "NUMERIC");
    }

    function addAlphaNumericCellValue(workbook, thisVal, row, col) {
        SpreadsheetSetCellValue(workbook, thisVal, row, col, "STRING");
    }

    function addDateCellValue(workbook, thisVal, row, col) {
        SpreadsheetSetCellValue(workbook, thisVal, row, col, "DATE");
    }

    function addGoogleScholarLink(workbook, googleLink, row, col) {
        var linkStyle = StructNew();
        linkStyle.color="blue";
        linkStyle.underline="true";

        if(googleLink NEQ "") {
            if(Len(googleLink) GT 255) {
                googleLink = Left(googleLink, 255);
            }
            SpreadsheetSetCellFormula(workbook, 'HYPERLINK("#googleLink#", "Google Scholar")', row, col);
            SpreadsheetFormatCell(workbook, linkStyle, row, col);
        }
    }



    function determineStreamingWindowSize(numOfColumns) {
        var windowSize = 50;     // default is 100

        if(numOfColumns > 250) {
            windowSize = 10;
        }
        else if(numOfColumns > 200) {
            windowSize = 20;
        }
        else if(numOfColumns > 150) {
            windowSize = 30;
        }
        else if(numOfColumns > 100) {
            windowSize = 40;
        }

        return windowSize;
    }

    function generateStreamingXlsx(spreadsheetLib, columnNames, firstSheetName) {

        // first determine size of the streaming window - smaller for more columns
        var memWindowSize = determineStreamingWindowSize(ListLen(columnNames));

        // new workbook
        var wbook = spreadsheetLib.newStreamingXlsx( firstSheetName, memWindowSize );

        // add the column names
        spreadsheetLib.addRow(wbook, columnNames);

        return wbook;

    }

    function addNewWorksheetWithData(spreadsheetLib, wbook, columnNames, exportRows, sheetName) {

        spreadsheetLib.createSheet( wbook, sheetName );
        spreadsheetLib.setActiveSheet( wbook, sheetName );

        // columns
        spreadsheetLib.addRow(wbook, columnNames);

        // rows
        spreadsheetLib.addRows(workbook = wbook, data = exportRows);
    }

    function addNewWorksheet(spreadsheetLib, wbook, columnNames, sheetName) {

        spreadsheetLib.createSheet( wbook, sheetName );
        spreadsheetLib.setActiveSheet( wbook, sheetName );

        // columns
        spreadsheetLib.addRow(wbook, columnNames);

    }
    
    function addRow(spreadsheetLib, wbook, rowData) {

        spreadsheetLib.addRow(wbook, rowData);
    }

    function setGoogleScholarLink(spreadsheetLib, wbook, googleLink, row, col, linkStyle) {

        if(googleLink NEQ "") {
            if(Len(googleLink) GT 255) {
                googleLink = Left(googleLink, 255);
            }
            spreadsheetLib.setCellFormula(wbook, 'HYPERLINK("#googleLink#", "Google Scholar")', row, col);
            spreadsheetLib.formatCell(wbook, linkStyle, row, col);
        }
    }

    function generateStreamingXlsxDownload(spreadsheetLib, wbook, exportFileName) {

        spreadsheetLib.download(workbook=wbook, filename=exportFileName);

    }


    function additionalParameters(BasicOption, conc_desc, mean_OP, mean_Val, min_OP, min_Val, max_OP, max_Val, unit_Val) {
        var l_desc = "";
        var l_mean_OP = "";
        var l_mean_Val = "";
        var l_min_OP = "";
        var l_min_Val = "";
        var l_max_OP = "";
        var l_max_Val = "";
        var l_unit_Val = "";
        var theReturn = "";

        if(IsNull(BasicOption)) { BasicOption = "1"; }          // 2 shows mean(min - max) units
        if(IsNull(conc_desc)) { conc_desc = ""; }
        if(IsNull(mean_OP)) { mean_OP = ""; }
        if(IsNull(mean_Val)) { mean_Val = "NR"; }
        if(IsNull(min_OP)) { min_OP = ""; }
        if(IsNull(min_Val)) { min_Val = "NR"; }
        if(IsNull(max_OP)) { max_OP = ""; }
        if(IsNull(max_Val)) { max_Val = "NR"; }
        if(IsNull(unit_Val)) { unit_Val = ""; }

        l_desc = htmlEditFormat(conc_desc);
        l_mean_OP = htmlEditFormat(mean_OP);                    // Converts < and > to &lt; and &gt;
        l_mean_Val = htmlEditFormat(mean_Val);
        l_min_OP = htmlEditFormat(min_OP);
        l_min_Val = htmlEditFormat(min_Val);
        l_max_OP = htmlEditFormat(max_OP);
        l_max_Val = htmlEditFormat(max_Val);
        l_unit_Val = htmlEditFormat(unit_Val);

        if(l_mean_Val EQ "NR" OR l_mean_Val EQ "") {
            l_mean_Val = "NR";
            l_mean_OP  = "";
        }

        if(l_min_Val EQ "NR" OR l_min_Val EQ "") {
            l_min_Val = "NR";
            l_min_OP  = "";
        }

        if(l_max_Val EQ "NR" OR l_max_Val EQ "") {
            l_max_Val = "NR";
            l_max_OP  = "";
        }

        if(len(l_desc) gt 0) {
            l_desc = l_desc & " ";      // Just spacing
        }
        
        if(len(l_unit_val) eq 0) {
            l_unit_val = "NR";
        }

        switch(BasicOption) {
            case "1" :                      // min - max          
                theReturn = l_min_OP & l_min_Val & " - " & l_max_OP & l_max_Val;
                break;
            case "2" :                      // min - max unit
                theReturn = l_min_OP & l_min_Val & " - " & l_max_OP & l_Max_Val & " " & l_unit_Val;
                break;
            case "3" :                      // type min - max unit
                theReturn = l_desc & l_min_OP & l_min_Val & " - " & l_max_OP & l_Max_Val & " " & l_unit_Val;
                break;
            case "4" :                      // type mean (min - max) unit
                theReturn = l_desc & l_mean_OP & l_mean_Val & " (" & l_min_OP & l_min_Val & " - " & l_max_OP & l_Max_Val  & ") " & l_unit_Val;
                break;
        }

        return theReturn;
    }

    // Converts < and > to &lt; and &gt;
    function concatMean(mean_OP, mean_Val) {
        var l_mean_OP = "";
        var l_mean_Val = "";

        if(IsNull(mean_OP)) { mean_OP = ""; }
        if(IsNull(mean_Val)) { mean_Val = "NR"; }

        l_mean_OP = trim(mean_OP);
        l_mean_Val = trim(mean_Val);

        if(l_mean_Val EQ "NR" OR l_mean_Val EQ "") {
            l_mean_Val = "NR";
            l_mean_OP  = "";
        }

        return l_mean_OP & l_mean_Val;
    }

  </cfscript>
</cfcomponent>

