<cfcomponent>
<cfscript>

    this.SCOPES_ARRAY = ["FORM","COOKIE","URL"];

    function runInputValidation() {

        var allSuccessful = true;
        var success = true;

        for(scopeName in this.SCOPES_ARRAY) {
            success = checkInputScope(scopeName);
            if(!success) {
                allSuccessful = false;
            }
        }

        return allSuccessful;
    }

    function checkAnalyticsParam(scope, field) {
        var isAnalyticsParam = false;
        // for now we are going to exclude GA params in the COOKIE scope only
        if(scope EQ "COOKIE") {
            if(
                field EQ "_ga"
                OR field EQ "_gid"
                OR field EQ "_gat_EPA"
                OR LEFT(field, 4) EQ "_ga_"
            ) {
                isAnalyticsParam = true;
            }
        }
        return isAnalyticsParam;
    }

    function checkInputScope(scope) {
        return checkInputScopeByPattern(scope, "^[A-Za-z\d~@##%\^\*\(\)_\+=\{\[\}\]\|:""'',\.\?/\s-]*$");
    }

    function checkBridgeFormInputs() {
        return checkInputScopeByPattern("FORM", "^[a-zA-Z0-9~*\(\)\|,._\s-]*$");
    }

    function checkSearchAndRefFormInputAlphaNumeric(field, paramValue) {
        return checkParameter(field, paramValue, "FORM", "^[a-zA-Z0-9,._\s]*$")
    }

    function checkSearchAndRefFormInputNumeric(field, paramValue) {
        return checkParameter(field, paramValue, "FORM", "^[0-9]*$")
    }

    function checkInputScopeByPattern(scope, matchPattern) {
        var scopeStruct = Evaluate(scope);
        var success = true;

        for (field in scopeStruct) {
            if(NOT checkAnalyticsParam(scope, field)) {
                // check for special cases
                scopeStruct[field] = checkSpecialCases(field, scopeStruct[field], matchPattern);

                if(NOT IsValid("regex", scopeStruct[field], matchPattern)) {                    
                    WriteLog("field " & field & ", value = " & scopeStruct[field]);
                    scopeStruct[field] = "";

                    success = false;
                }
            }
        }

        return success;
    }

    function checkSpecialCases(field, value, matchPattern) {
        var retValue = value;

        if(field EQ "contact_form_concern" OR field EQ "selectedExploreFilters") {
            if(NOT IsValid("regex", value, matchPattern)) {                
                retValue = Replace(value, "`", "BACKTICK", "all");
                retValue = Replace(retValue, "~", "TILDE", "all");
                retValue = Replace(retValue, "!", "EXCLAMATIONPOINT", "all");
                retValue = Replace(retValue, "@", "ATSYMBOL", "all");
                retValue = Replace(retValue, "##", "POUNDSIGN", "all");
                retValue = Replace(retValue, "$", "DOLLARSIGN", "all");
                retValue = Replace(retValue, "%", "PERCENT", "all");
                retValue = Replace(retValue, "^", "CARAT", "all");
                retValue = Replace(retValue, "&", "AMPERSAND", "all");
                retValue = Replace(retValue, "*", "ASTERISK", "all");
                retValue = Replace(retValue, "|", "PIPE", "all");
                retValue = Replace(retValue, "+", "PLUS", "all");
                retValue = Replace(retValue, "=", "EQUALS", "all");
                retValue = Replace(retValue, "?", "QUESTIONMARK", "all");
                retValue = Replace(retValue, "<", "LEFTANGLEBRACKET", "all");
                retValue = Replace(retValue, ">", "RIGHTANGLEBRACKET", "all");
                retValue = Replace(retValue, "\", "BACKSLASH", "all");
                retValue = Replace(retValue, "/", "FORWARDSLASH", "all");
            }
        }
        
        return retValue;
    }

    function checkNumericSize(field, paramValue, scope, size) {
        var success = checkParamNumeric(field, paramValue, scope);
        if(success) {
            if(paramValue LT 0 || paramValue GT size) {
                WriteLog("field " & field & ", value = " & paramValue);

                scopeStruct[field] = "";

                success = false;
            }
        }
        return success;
    }

    function checkParamNumeric(field, paramValue, scope) {
        return checkParameter(field, paramValue, scope, "^[0-9,-]*$");
    }

    function checkParamDecimal(field, paramValue, scope, gteZeroCheck) {
        var success = checkParameter(field, paramValue, scope, "^[0-9,.-]*$");
        if(success) {
            if(gteZeroCheck && paramValue LT 0) {
                WriteLog("field " & field & ", value = " & paramValue);

                scopeStruct[field] = "";

                success = false;
            }
        }
        return success;
    }

    function checkParamAlphaNumeric(field, paramValue, scope) {
        return checkParameter(field, paramValue, scope, "^[a-zA-Z0-9,._\s-]*$");
    }

    function checkParamAlphaNumericExtras(field, paramValue, scope) {
        return checkParameter(field, paramValue, scope, "^[a-zA-Z0-9~*\(\),._\s-]*$");
    }

    function checkParameter(field, paramValue, scope, matchPattern) {
        var success = true;
        var scopeStruct = Evaluate(scope);

        if(NOT checkAnalyticsParam(scope, field)) {
            if(NOT IsValid("regex", paramValue, matchPattern)) {
                    
                WriteLog("field " & field & ", value = " & paramValue);

                scopeStruct[field] = "";

                success = false;
            }
        }

        return success;
    }

</cfscript>
</cfcomponent>
