
<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="BrowseQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="BrowseQueryVars">
        
        SELECT * FROM (
            SELECT /*+ first_rows(#PAGESIZE#) */
                <!---DISTINCT---> iq.cas_number, iq.epa_chem_substance_name, iq.chem_primary_name, iq.chem_name_concat, iq.synonyms, <!--- --+ ORDERED --->
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (
                SELECT 
                    c.cas_number, c.epa_chem_substance_name, c.chem_primary_name, c.chem_name_concat,
                    listagg(cs.chem_synonym_name, ', ') within group (order by cs.chem_synonym_name) as synonyms
                FROM
                    chemicals c
                    LEFT OUTER JOIN chemical_synonyms cs ON cs.cas_number = c.cas_number AND LOWER(cs.chem_synonym_name) like '%#SEARCHTERM#%'
                WHERE
                    (
                        LOWER(c.cas_number) like '%#SEARCHTERM#%'
                    )
                    OR (
                        LOWER(c.cas_number) like '%#Replace(SEARCHTERM, '-', '', 'ALL')#%'
                    )
                    OR (
                        LOWER(c.epa_chem_substance_name) like '%#SEARCHTERM#%'
                    )
                    OR (
                        LOWER(c.chem_primary_name) like '%#SEARCHTERM#%'
                    )
                    OR (
                        LOWER(c.chem_name_concat) like '%#SEARCHTERM#%'
                    )
                    OR (
                        LOWER(cs.chem_synonym_name) like '%#SEARCHTERM#%'
                    )
                GROUP BY c.cas_number, c.epa_chem_substance_name, c.chem_primary_name, c.chem_name_concat
            ) iq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#BrowseQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(BrowseQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>

