<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="BrowseQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="BrowseQueryVars">

        SELECT * FROM (
            SELECT /*+ first_rows(#PAGESIZE#) */
                <!---DISTINCT---> iq.reference_number, iq.author, iq.title, iq.publication_year, iq.full_citation, iq.doi, <!--- --+ ORDERED --->
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (
                SELECT 
                    f.reference_number, f.author, f.title, f.publication_year, f.full_citation, f.doi
                FROM
                    references f
                WHERE
                    (
                        LOWER(f.reference_number) like '%#SEARCHTERM#%'
                    )
                GROUP BY f.reference_number, f.author, f.title, f.publication_year, f.full_citation, f.doi
            ) iq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#BrowseQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(BrowseQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
