<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="BrowseQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="BrowseQueryVars">
        
        SELECT * FROM (
            SELECT /*+ first_rows(#PAGESIZE#) */
                <!---DISTINCT---> iq.effect_code, iq.effect_desc, iq.meas_code, iq.meas_desc, iq.meas_long, <!--- --+ ORDERED --->
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (
                SELECT
                    REPLACE(REPLACE(ec.code, '~', ''), '/', '') as effect_code, ec.description as effect_desc, REPLACE(REPLACE(mc.code, '~', ''), '/', '') as meas_code, mc.description as meas_desc, mc.long_description as meas_long
                FROM
                    effect_codes ec
                    LEFT JOIN effect_measurement_pairs emp ON emp.effect = ec.code
                    LEFT JOIN measurement_codes mc ON mc.code = emp.measurement
                WHERE
                    ec.code in (select distinct effect from results r)
                    AND (
                        (
                            REPLACE(REPLACE(LOWER(ec.code), '~', ''), '/', '') like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(ec.description) like '%#SEARCHTERM#%'
                        )
                        OR (
                            REPLACE(REPLACE(LOWER(mc.code), '~', ''), '/', '') like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(mc.description) like '%#SEARCHTERM#%'
                        )            
                        OR (
                            (INSTR(mc.long_description, 'Also:') > 0)
                            AND
                            (LOWER(SUBSTR(mc.long_description, INSTR(mc.long_description, 'Also:'))) like '%#SEARCHTERM#%')
                        )
                    )
                GROUP BY REPLACE(REPLACE(ec.code, '~', ''), '/', ''), ec.description, REPLACE(REPLACE(mc.code, '~', ''), '/', ''), mc.description, mc.long_description
            ) iq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#BrowseQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(BrowseQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>


	
