
<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="BrowseQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="BrowseQueryVars">
                


        SELECT * FROM (
            SELECT /*+ first_rows(#PAGESIZE#) */


        
                <!---DISTINCT---> iq.cas_number, iq.epa_chem_substance_name, iq.chem_primary_name, iq.chem_name_concat, iq.synonyms, <!--- --+ ORDERED --->
                
                <!---DISTINCT---> iq.effect_code, iq.effect_desc, iq.meas_code, iq.meas_desc, iq.meas_long, <!--- --+ ORDERED --->

                <!---DISTINCT---> iq.species_number, iq.common_name, iq.latin_name, iq.ncbi_taxid, iq.syn_common, iq.syn_latin, <!--- --+ ORDERED --->



                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM ( 



                (
                    SELECT 
                        f.reference_number as eco_ref_num, 'CHEMICAL' as match_source, count(*) as match_count                        
                    FROM
                        references f
                        LEFT OUTER JOIN tests t ON t.ecoref_number = f.reference_number
                        LEFT OUTER JOIN results r ON r.test_id_fk = t.test_id
                        LEFT OUTER JOIN chemicals c ON c.cas_number = t.test_cas
                        LEFT OUTER JOIN chemical_synonyms cs ON cs.cas_number = c.cas_number AND LOWER(cs.chem_synonym_name) like '%#SEARCHTERM#%'
                    WHERE
                        (
                            LOWER(c.cas_number) like '%#Replace(SEARCHTERM, '-', '', 'ALL')#%'
                        )
                        OR (
                            LOWER(c.epa_chem_substance_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(c.chem_primary_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(c.chem_name_concat) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(cs.chem_synonym_name) like '%#SEARCHTERM#%'
                        )
                    GROUP BY f.reference_number, 'CHEMICAL'
                )
                UNION ALL
                (
                    SELECT 
                        f.reference_number as eco_ref_num, 'SPECIES' as match_source, count(*) as match_count                        
                    FROM
                        references f
                        LEFT OUTER JOIN tests t ON t.ecoref_number = f.reference_number
                        LEFT OUTER JOIN results r ON r.test_id_fk = t.test_id                        
                        LEFT OUTER JOIN species s ON s.species_number = t.species_number
                        LEFT OUTER JOIN species_common_synonyms sc ON sc.species_number = s.species_number AND LOWER(sc.common_name) like '%#SEARCHTERM#%'
                        LEFT OUTER JOIN species_latin_synonyms sl ON sl.species_number = s.species_number AND LOWER(sl.latin_name) like '%#SEARCHTERM#%'
                    WHERE
                        (
                            LOWER(s.common_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(s.latin_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(s.ncbi_taxid) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(sc.common_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(sl.latin_name) like '%#SEARCHTERM#%'
                        )
                    GROUP BY f.reference_number, 'SPECIES'
                )
                UNION ALL
                (
                    SELECT 
                        f.reference_number as eco_ref_num, 'EFFECTS' as match_source, count(*) as match_count                        
                    FROM
                        references f
                        LEFT OUTER JOIN tests t ON t.ecoref_number = f.reference_number
                        LEFT OUTER JOIN results r ON r.test_id_fk = t.test_id
                        LEFT OUTER JOIN effect_codes ec ON ec.code = r.effect
                        LEFT OUTER JOIN effect_measurement_pairs emp ON emp.effect = ec.code
                        LEFT OUTER JOIN measurement_codes mc ON mc.code = emp.measurement
                    WHERE
                        (
                            LOWER(ec.code) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(ec.description) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(mc.code) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(mc.description) like '%#SEARCHTERM#%'
                        )            
                        OR (
                            (INSTR(mc.long_description, 'Also:') > 0)
                            AND
                            (LOWER(SUBSTR(mc.long_description, INSTR(mc.long_description, 'Also:'))) like '%#SEARCHTERM#%')
                        )
                    GROUP BY f.reference_number, 'EFFECTS'
                )
                UNION ALL
                (
                    SELECT 
                        f.reference_number as eco_ref_num, 'AUTHOR' as match_source, count(*) as match_count                        
                    FROM
                        references f
                    WHERE
                        LOWER(f.author) like '%#SEARCHTERM#%'
                    GROUP BY f.reference_number, 'AUTHOR'
                )
                UNION ALL
                (
                    SELECT 
                        f.reference_number as eco_ref_num, 'TITLE' as match_source, count(*) as match_count                        
                    FROM
                        references f
                    WHERE
                        LOWER(f.title) like '%#SEARCHTERM#%'
                    GROUP BY f.reference_number, 'TITLE'
                )



            ) iq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#BrowseQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(BrowseQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
