<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<cfparam name="URL.dataview" default="">
<cfparam name="URL.export" default="">
<cfparam name="URL.format" default="">
<cfparam name="FORM.filecleanup" default="">

<cfset datatype = "">
<cfif URL.dataview EQ "exploreSummary" OR URL.dataview EQ "exploreRecords" OR URL.dataview EQ "exploreCharts">
    <cfset datatype = URL.dataview>
</cfif>

<cfset expdata = "">
<cfif URL.export EQ "0" OR URL.export EQ "1">
    <cfset expdata = URL.export>
</cfif>

<cfset isFileCleanup = "">
<cfif FORM.filecleanup EQ "0" OR FORM.filecleanup EQ "1">
    <cfset isFileCleanup = FORM.filecleanup>
</cfif>

<cfset expformat = "">
<cfif URL.format EQ "csv" OR URL.format EQ "r_plot">
    <cfset expformat = URL.format>
</cfif>

<cfset Y_VARIABLES = structNew()>
<cfset Y_VARIABLES["conc"]["name"] = "Concentration Mean (Std)">
<cfset Y_VARIABLES["conc"]["unit"] = "Unit ratio equivalent to ppm">
<cfset Y_VARIABLES["conc"]["datacol"] = "Conc_Mean_Std">
<cfset Y_VARIABLES["dur"]["name"] = "Duration (Std)">
<cfset Y_VARIABLES["dur"]["unit"] = "days">
<cfset Y_VARIABLES["dur"]["datacol"] = "Duration_Std">

<cfset X_VARIABLES = structNew()>
<cfset X_VARIABLES["spec_grp"]["name"] = "Species Group">	
<cfset X_VARIABLES["spec_grp"]["datacol"] = "Species_Group">	
<cfset X_VARIABLES["tax_class"]["name"] = "Class">
<cfset X_VARIABLES["tax_class"]["datacol"] = "Class">
<cfset X_VARIABLES["tax_ord"]["name"] = "Order">
<cfset X_VARIABLES["tax_ord"]["datacol"] = "Order">
<cfset X_VARIABLES["family"]["name"] = "Family">
<cfset X_VARIABLES["family"]["datacol"] = "Family">
<cfset X_VARIABLES["genus"]["name"] = "Genus">
<cfset X_VARIABLES["genus"]["datacol"] = "Genus">
<cfset X_VARIABLES["spec"]["name"] = "Species">
<cfset X_VARIABLES["spec"]["datacol"] = "Species_Name">
<cfset X_VARIABLES["cas"]["name"] = "Chemical">
<cfset X_VARIABLES["cas"]["datacol"] = "Chemical_Name">
<cfset X_VARIABLES["effect"]["name"] = "Effect Group">
<cfset X_VARIABLES["effect"]["datacol"] = "Effect">
<cfset X_VARIABLES["meas"]["name"] = "Effect Measurement">
<cfset X_VARIABLES["meas"]["datacol"] = "Measurement">
<cfset X_VARIABLES["endpoint"]["name"] = "Endpoint">
<cfset X_VARIABLES["endpoint"]["datacol"] = "Endpoint">
<cfset X_VARIABLES["refNum"]["name"] = "Reference">
<cfset X_VARIABLES["refNum"]["datacol"] = "Ecoref_Num">
<cfset X_VARIABLES["testId"]["name"] = "Test Number">
<cfset X_VARIABLES["testId"]["datacol"] = "Test_Num">

<cfset Z_VARIABLES = structNew()>
<cfset Z_VARIABLES["spec_grp"]["name"] = "Species Group">	
<cfset Z_VARIABLES["spec_grp"]["datacol"] = "Species_Group">	
<cfset Z_VARIABLES["tax_class"]["name"] = "Class">
<cfset Z_VARIABLES["tax_class"]["datacol"] = "Class">
<cfset Z_VARIABLES["tax_ord"]["name"] = "Order">
<cfset Z_VARIABLES["tax_ord"]["datacol"] = "Order">
<cfset Z_VARIABLES["family"]["name"] = "Family">
<cfset Z_VARIABLES["family"]["datacol"] = "Family">
<cfset Z_VARIABLES["genus"]["name"] = "Genus">
<cfset Z_VARIABLES["genus"]["datacol"] = "Genus">
<cfset Z_VARIABLES["spec"]["name"] = "Species">
<cfset Z_VARIABLES["spec"]["datacol"] = "Species_Name">
<cfset Z_VARIABLES["cas"]["name"] = "Chemical">
<cfset Z_VARIABLES["cas"]["datacol"] = "Chemical_Name">
<cfset Z_VARIABLES["effect"]["name"] = "Effect Group">
<cfset Z_VARIABLES["effect"]["datacol"] = "Effect">
<cfset Z_VARIABLES["meas"]["name"] = "Effect Measurement">
<cfset Z_VARIABLES["meas"]["datacol"] = "Measurement">
<cfset Z_VARIABLES["endpoint"]["name"] = "Endpoint">
<cfset Z_VARIABLES["endpoint"]["datacol"] = "Endpoint">
<cfset Z_VARIABLES["refNum"]["name"] = "Reference">
<cfset Z_VARIABLES["refNum"]["datacol"] = "Ecoref_Num">
<cfset Z_VARIABLES["testId"]["name"] = "Test Number">
<cfset Z_VARIABLES["testId"]["datacol"] = "Test_Num">

        
<!--- paging / sorting vars --->  
<cfparam name="FORM.sortfield" default="">       <!--- UI will pass this or default to col 1 on DT.  Exports will use the default value here  --->
<cfparam name="FORM.sortdir" default="">
<cfparam name="FORM.length" default="10000">   <!--- default is application max.  UI will pass page size, exports will not and will be capped at 10000 rows --->
<cfparam name="FORM.start" default="0">       <!--- offset position for query results.  UI will pass this, default to beginning.  Exports will have full range 0-10000 --->

<cfset SORTFIELD = OutFunc.generateOrderByClause( FORM.sortfield, FORM.sortdir )>
<cfset PAGESIZE = FORM.length>
<cfset STARTPOS = FORM.start>
    
<!--- jquery datatable specific --->
<cfparam name ="FORM.draw" default="">
<cfset RETURNDRAW = FORM.draw>

<cfset RIGHT_NOW = Now()>
<cfset RUN_TS = DateTimeFormat(RIGHT_NOW, "yyyy-mm-dd_HHnnss")>

<cfif datatype eq "">
      
    <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->
      
    <cfinclude template="explore/error_response.cfm" />
      
<cfelse>    
    <cfswitch expression="#datatype#">
        <cfcase value="exploreSummary">

        </cfcase>
        
        <cfcase value="exploreRecords">

        </cfcase>

        <cfcase value="exploreCharts">
            
            <!--- retrieve the export data query --->
            <cfinclude template="../pages/explore/query_chart_data.cfm" />

            <cfif expdata EQ "1">
                <cfswitch expression="#expformat#">
                    <cfcase value="csv">
                        <cfinclude template="explore/get_resp_chart_dt_CSV.cfm" />
                    </cfcase>

                    <cfcase value="r_plot">
                        <cfset ZIPFILENAME = "ecotox_R_" & RUN_TS & ".zip">
                        <cfset DATAFILENAME = "ecotox_explore_data_" & RUN_TS & ".csv">
                        <cfset RSCRIPTFILENAME = "ecotox_explore_data_" & RUN_TS & ".r">

                        <cfparam name="FORM.selectedExploreFilters" default="">
                        <cfset APPLIEDFILTERS = ArrayNew(1)>
                        <cfset APPLIEDFILTERSSTR = "">
                        <cfset ABBREVIATEDFILTERSSTR = "">
                        <cfif FORM.selectedExploreFilters NEQ "">
                            <cfset tempArray = DeserializeJSON(FORM.selectedExploreFilters)>
                            <cfif IsArray(tempArray)>
                                <cfset APPLIEDFILTERS = tempArray>
                            </cfif>

                            <cfset APPLIEDFILTERSSTR = OutFunc.generateFilterSummaryForR(APPLIEDFILTERS)>
                            <cfif APPLIEDFILTERSSTR EQ "">
                                <cfset APPLIEDFILTERSSTR = "##   [ No Filters Applied ]">
                            </cfif>

                            <cfset ABBREVIATEDFILTERSSTR = OutFunc.generateAbbreviatedSummaryForR(APPLIEDFILTERS)>
                            <cfif ABBREVIATEDFILTERSSTR EQ "">
                                <cfset ABBREVIATEDFILTERSSTR = "####   [ No Filters Applied ]">
                            </cfif>
                        </cfif>

                        <cfset x_cat = "">
                        <cfif StructKeyExists(X_VARIABLES, FORM.xcat)>
                            <cfset x_cat = FORM.xcat>
                        </cfif>

                        <cfset y_cat = "">
                        <cfif StructKeyExists(Y_VARIABLES, FORM.ycat)>
                            <cfset y_cat = FORM.ycat>
                        </cfif>

                        <cfset z_cat = "">
                        <cfif StructKeyExists(Z_VARIABLES, FORM.zcat)>
                            <cfset z_cat = FORM.zcat>
                        </cfif>

                        <cfset YAXISLINEVAL = "NA">
                        <cfif isdefined("FORM.yaxisline")>
                            <cfif FORM.yaxisline NEQ "" AND FORM.yaxisline NEQ "NA" AND isNumeric(FORM.yaxisline)>
                                <cfset YAXISLINEVAL = FORM.yaxisline>
                            </cfif>
                        </cfif>

                        <cfset PLOTTABLECOUNT = 0>
                        <cfif isdefined("FORM.plottableCount") AND isNumeric(FORM.plottableCount)>
                            <cfset PLOTTABLECOUNT = FORM.plottableCount>
                        </cfif>
                        
                        <cfset TOTALCOUNT = 0>
                        <cfif isdefined("FORM.totalCount") AND isNumeric(FORM.totalCount)>
                            <cfset TOTALCOUNT = FORM.totalCount>
                        </cfif>
                        
                        <cfset ROWCOUNT = 0>
                        <cfif isdefined("FORM.rowCount") AND isNumeric(FORM.rowCount)>
                            <cfset ROWCOUNT = FORM.rowCount>
                        </cfif>

                        <cfinclude template="explore/export_full_R.cfm" />
                    </cfcase>
                    
                    <cfdefaultcase>

                        <!--- UNKNOWN FORMAT --->
                
                        <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->
                
                        <cfinclude template="explore/error_response.cfm">

                    </cfdefaultcase>
                </cfswitch>
            <cfelseif isFileCleanup EQ "1">            

                <!--- Had to move this out of the export above as it was not reaching the code --->
                <cftry>
                    <!--- ORIG CODE WHEN IT WAS PART OF export_full_R.cfm
                    <!--- Delete the temporary directory and its contents --->
                    <cffile action="delete" file="#WORKING_DIR#/#DATAFILENAME#">
                    <cffile action="delete" file="#WORKING_DIR#/#RSCRIPTFILENAME#">
                    <cffile action="delete" file="#WORKING_DIR#/#ZIPFILENAME#">
                    <cfdirectory action="delete" directory="#WORKING_DIR#"> --->

                    <cfset targetDirectory = ExpandPath("temp_att")>

                    <cfif DirectoryExists(targetDirectory)>
                        <cflog text="Cleaning up temp_att directory: #targetDirectory#">
                        <cfdirectory action="delete" directory="#targetDirectory#" recurse="yes">
                        <cfdirectory action="create" directory="#targetDirectory#">
                    <cfelse>
                        <cflog text="The directory '#targetDirectory#' does not exist.">
                    </cfif>
                    
                    <cfcatch type="any">
                        <cflog text="Error deleting file #pathToDownloadFile#: #cfcatch.message# - #cfcatch.detail#">
                    </cfcatch>
                </cftry>

            </cfif>
        </cfcase>
        
        <cfdefaultcase>

            <!--- UNKNOWN TYPE --->
      
            <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->
    
            <cfinclude template="explore/error_response.cfm">

        </cfdefaultcase>    
    </cfswitch>      
</cfif>