
<cfset hasWhereClause = "">
<cfset speciesIdList = "">
<cfset multIds = 0>

<cfif NOT isdefined("allSpeciesGroups")>
	<cfset keyList = ListSort(structKeyList(form),'textnocase','asc')>
	<cfloop list="#keyList#" index="key">
		<cfif form[key] neq "" and key neq "specSelections" and key neq "fieldnames" and key neq "cbStandardTest" and key neq "cbEndangered" and key neq "cbInvasive">
			<cfset hasWhereClause = "YES">
			
			<cfif multIds is 1>
				<cfset speciesIdList = listappend(speciesIdList, form[key])>
			<cfelse>
				<cfset speciesIdList = form[key]>
			</cfif>
				
			<cfset multIds = 1>
			
		</cfif>
	</cfloop>
</cfif>

<cfset standardTest = false>
<cfset endangered = false>
<cfset invasive = false>

<cfif isdefined("cbStandardTest")>
	<cfset hasWhereClause = "YES">
	<cfset standardTest = true>
</cfif>

<cfif isdefined("cbEndangered")>
	<cfset hasWhereClause = "YES">
	<cfset endangered = true>
</cfif>

<cfif isdefined("cbInvasive")>
	<cfset hasWhereClause = "YES">
	<cfset invasive = true>
</cfif>

<cfif hasWhereClause is not "">
	<cfoutput>	
	<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
	<cfquery name="GetSpeciesList" datasource="#application.datasource#" dbtype="Oracle80" result="results">
		SELECT s.species_listid, s1.species_list_desc, s.species_number, s.LATIN_NAME, s.common_name FROM species_list_xref sx
		INNER JOIN species s ON sx.species_number = s.species_number 
		INNER JOIN species_lists s1 ON s1.species_listid = sx.species_listid
		<cfif hasWhereClause is "YES">
			 where NOT sx.species_listid in (13, 14, 15) 
			
			<cfif speciesIdList neq "">
				 AND sx.species_listid in (<CFQUERYPARAM CFSQLTYPE="CF_SQL_VARCHAR" LIST="Yes" SEPARATOR="," VALUE="#speciesIdList#">)
			</cfif>
			
			<cfif standardTest OR endangered OR invasive>
				 AND ( 
				<cfif standardTest>
					s.standard_test_species_yn = <CFQUERYPARAM CFSQLTYPE="CF_SQL_VARCHAR" VALUE="Y">
				</cfif>			 
				  
				<cfif endangered>
					<cfif standardTest> OR </cfif>
					s.threatened_endangered_yn = <CFQUERYPARAM CFSQLTYPE="CF_SQL_VARCHAR" VALUE="Y">
				</cfif>			 
				  
				<cfif invasive>
					<cfif standardTest OR endangered> OR </cfif>
					s.exotic_nuisance_yn = <CFQUERYPARAM CFSQLTYPE="CF_SQL_VARCHAR" VALUE="Y">
				</cfif>
				 ) 
			</cfif>		
		</cfif>
		order by sx.species_listid, s.latin_name	
	</cfquery>
	</cflock>
	</cfoutput>
</cfif>

