
<cfif isDefined("URL.searchstr") AND URL.searchstr NEQ "">
    <cfset searchClauseValue = LCase(URL.searchstr)>
    <cfset searchClauseNoDashes = replace(searchClauseValue, '-', '', 'ALL')>
<cfelse>
    <cfset searchClauseValue = "">
</cfif>

<cfset defaultSortOrder = "search_date DESC, project_name">

<cfif NOT isDefined("SORTFIELD") OR SORTFIELD EQ "">
    <cfset SORTFIELD = defaultSortOrder>
<cfelse>
    <cfset SORTFIELD = SORTFIELD & "," & defaultSortOrder>
    <cfset SORTFIELD = listRemoveDuplicates(SORTFIELD)>
</cfif>


<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="ChemicalSearchesQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="ChemicalSearchesQueryVars">

        SELECT * FROM (
            SELECT iq.chem_search_id, iq.search_date_str, iq.project_name, iq.use_chem_group, iq.chemical_group_id, iq.num_in_chem_group,
                iq.ask_for_terms, iq.ask_for_cas, iq.num_cas_numbers, iq.num_search_terms, iq.notes,
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (
                SELECT
                    cs.ID as chem_search_id,
                    cs.search_date,
                    TO_CHAR(cs.search_date, 'YYYYMMDD') as search_date_str,
                    cs.project_name as project_name,
                    NVL(cs.use_chem_group, 0) as use_chem_group,
                    NVL(cs.chemical_group_id, 0) as chemical_group_id,
                    (select count(*) from chemical_list_xref where chemical_listid = cs.chemical_group_id) as num_in_chem_group,
                    NVL(cs.ask_for_terms, 0) as ask_for_terms,
                    NVL(cs.ask_for_cas, 0) as ask_for_cas,
                    (select count(*) from chemical_searches_cas csc where csc.chem_search_id_fk = cs.id) as num_cas_numbers,
                    (select count(*) from chemical_searches_terms where chem_search_id_fk = cs.id) as num_search_terms,            
                    cs.notes
                FROM chemical_searches cs
                WHERE cs.display = 1
            
                <cfif searchClauseValue NEQ "">
                AND (
                    (cs.id in (
                        select distinct icsc.chem_search_id_fk as chem_search_id
                            from chemical_searches_cas icsc
                            left join chemicals c ON icsc.cas_number = c.cas_number
                            left join chemical_synonyms csy on c.cas_number = csy.cas_number
                        where (
                            (to_char(icsc.cas_number) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                            OR (to_char(icsc.cas_number) like <CFQUERYPARAM VALUE="%#searchClauseNoDashes#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                            OR (lower(c.epa_chem_substance_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                            OR (lower(csy.chem_synonym_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                        )
                    ))                    
                    OR (lower(cs.project_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                    OR (cs.id in (
                        select distinct ics.id as chem_search_id
                            from chemical_searches ics        
                            inner join chemical_list_xref icx on ics.use_chem_group = 1 and ics.chemical_group_id = icx.chemical_listid
                            left join chemicals c2 on icx.cas_number = c2.cas_number
                            left join chemical_synonyms csy2 on c2.cas_number = csy2.cas_number        
                        where (
                            (to_char(icx.cas_number) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                            OR (to_char(icx.cas_number) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                            OR (lower(c2.epa_chem_substance_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                            OR (lower(csy2.chem_synonym_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                        )
                    ))
                )
                </cfif>
            ) iq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#ChemicalSearchesQueryVars.sql#">
    <cfif isDefined("ChemicalSearchesQueryVars.SQLParameters") AND ChemicalSearchesQueryVars.SQLParameters NEQ "">
        <cflog text ="#ArrayToList(ChemicalSearchesQueryVars.SQLParameters)#">
    </cfif>--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>

