
<cfif isDefined("URL.searchstr") AND URL.searchstr NEQ "">
    <cfset searchClauseValue = LCase(URL.searchstr)>
    <cfset searchClauseNoDashes = replace(searchClauseValue, '-', '', 'ALL')>
<cfelse>
    <cfset searchClauseValue = "">
</cfif>

<cfset defaultSortOrder = "cas_number, chemical_name">

<cfif NOT isDefined("MATCHSORTFIELD") OR MATCHSORTFIELD EQ "">
    <cfset MATCHSORTFIELD = defaultSortOrder>
<cfelse>
    <cfset MATCHSORTFIELD = MATCHSORTFIELD & "," & defaultSortOrder>
    <cfset MATCHSORTFIELD = listRemoveDuplicates(MATCHSORTFIELD)>
</cfif>

<cfif NOT isDefined("MATCHSTARTPOS")>
    <cfset MATCHSTARTPOS = 0>
</cfif>

<cfif NOT isDefined("MATCHPAGESIZE")>
    <cfset MATCHPAGESIZE = 10>
</cfif>

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="ChemicalSearchMatchesQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="ChemicalSearchMatchesQueryVars">

        SELECT * FROM (        
        SELECT mq.chem_search_id, mq.project_name, mq.cas_number, mq.chemical_name, mq.synonyms
            , row_number() over (order by #MATCHSORTFIELD#) as rn
            , COUNT(*) OVER () as TotalRows
        FROM (
            SELECT oq.chem_search_id, oq.project_name, oq.cas_number
            , CASE
                WHEN (lower(oq.epa_chem_substance_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">) THEN oq.epa_chem_substance_name
                WHEN (lower(oq.chem_primary_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">) THEN oq.chem_primary_name
                ELSE oq.epa_chem_substance_name
            END as chemical_name           
            , LISTAGG(
                CASE WHEN (lower(oq.chem_synonym_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">) THEN oq.chem_synonym_name ELSE '' END, ' | ' ON OVERFLOW TRUNCATE '...'
            ) WITHIN GROUP (ORDER BY oq.chem_synonym_name) as synonyms            
            FROM (
                SELECT
                    cs.id as chem_search_id, cs.project_name
                    , cs.use_chem_group, cs.chemical_group_id
                    , csc.cas_number as cas_number
                    , c.epa_chem_substance_name as epa_chem_substance_name
                    , c.chem_primary_name as chem_primary_name
                    , csy.chem_synonym_name as chem_synonym_name
                from
                    chemical_searches cs
                    inner join chemical_searches_cas csc on cs.id = csc.chem_search_id_fk
                    left join chemicals c on csc.cas_number = c.cas_number
                    left join chemical_synonyms csy on c.cas_number = csy.cas_number
                where
                    cs.display = 1
                    AND cs.id = <CFQUERYPARAM VALUE="#URL.csid#" CFSQLTYPE="CF_SQL_INTEGER">
                UNION
                SELECT
                    cs2.id as chem_search_id, cs2.project_name
                    , cs2.use_chem_group, cs2.chemical_group_id
                    , cx.cas_number as cas_number
                    , c2.epa_chem_substance_name as epa_chem_substance_name
                    , c2.chem_primary_name as chem_primary_name
                    , csy2.chem_synonym_name as chem_synonym_name
                from
                    chemical_searches cs2
                    inner join chemical_list_xref cx on cs2.use_chem_group = 1 and cs2.chemical_group_id = cx.chemical_listid
                    left join chemicals c2 on cx.cas_number = c2.cas_number
                    left join chemical_synonyms csy2 on c2.cas_number = csy2.cas_number            
                where
                    cs2.display = 1
                    AND cs2.id = <CFQUERYPARAM VALUE="#URL.csid#" CFSQLTYPE="CF_SQL_INTEGER">
            ) oq
            group by oq.chem_search_id, oq.project_name, oq.cas_number, oq.epa_chem_substance_name, oq.chem_primary_name
        ) mq
        WHERE
        (
            lower(mq.project_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
            OR lower(mq.cas_number) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
            OR lower(mq.cas_number) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
            OR lower(mq.chemical_name) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
            OR lower(mq.synonyms) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
        )
        )
        WHERE rn between #MATCHSTARTPOS#+1 AND (#MATCHPAGESIZE# + #MATCHSTARTPOS#)
        ORDER BY rn
        
    </cfquery>
    
    <!---<cflog text ="#ChemicalSearchMatchesQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(ChemicalSearchMatchesQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>

