
<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="FullCitationQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="FullCitationQueryVars">

        SELECT * FROM (                
            SELECT /*+ first_rows(#PAGESIZE#) */            
                <!---DISTINCT---> 
                iq.ecoref_number, iq.citation, <!--- --+ ORDERED --->
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (                
                SELECT DISTINCT v.ecoref_number, v.citation
                FROM ecotox_group_summary3_mv v
                WHERE v.ecoref_number IN (<CFQUERYPARAM VALUE="#REFNUMS#" CFSQLTYPE="CF_SQL_BIGINT" list="yes">)
            ) iq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#FullCitationQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(FullCitationQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
