
<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="PubsQuerySummary" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="PubsQuerySummaryVars">

        SELECT * FROM (                
            SELECT /*+ first_rows(#PAGESIZE#) */            
                <!---DISTINCT---> 
                iq.ecoref_number, COUNT(DISTINCT iq.test_id) as num_tests, COUNT(DISTINCT iq.result_id) as num_results
                , COUNT(DISTINCT iq.cas_number) as num_chemicals, COUNT(DISTINCT iq.species_number) as num_species, <!--- --+ ORDERED --->
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (            
                select
                    mv.ecoref_number, mv.test_id, mv.result_id, mv.cas_number, mv.species_number
                from
                    ecotox_group_summary3_mv mv
                WHERE (
                    mv.ecoref_number in (<CFQUERYPARAM VALUE="#REFNUMS#" CFSQLTYPE="CF_SQL_VARCHAR" list="yes">)
                )
            ) iq
            GROUP BY iq.ecoref_number
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#PubsQuerySummaryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(PubsQuerySummaryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
