
<CFLOCK TIMEOUT="30" throwontimeout="no" TYPE="readonly" scope="application">
    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>  <!--- SPE 4/27/06 --->
</CFLOCK>

<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>
<cfif IsDefined("SearchQuery")>
    <cfset mainQueryTotalRecordCount = SearchQuery.TotalRows>
    <cfif mainQueryTotalRecordCount eq "">
        <cfset mainQueryTotalRecordCount = 0>
    </cfif>
<cfelse>
    <cfset mainQueryTotalRecordCount = 0>
</cfif>
<cfset distinctRefNumsAry = arrayNew(1)> 
    
<cfset headerArray = "">
<cfset dataArray = "">

<cfset display2=0>


<cfif tooManyChem eq 1>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "Your Chemical Entry string matched too many chemicals. This filter will return all Ecotox values that match the search term but matches are capped at 2000 values. Please consider using a more specific term.">

<cfelseif tooManyEffects eq 1>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "Your Effect Measurement Entry string matched too many effects. This filter will return all Ecotox values that match the search term but matches are capped at 2000 values. Please consider using a more specific term.">

<cfelseif tooManySpecies eq 1>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "Your Taxonomic Name Entry string matched too many species. This filter will return all Ecotox values that match the search term but matches are capped at 2000 values. Please consider using a more specific term.">

<cfelseif mainQueryTotalRecordCount eq 0>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this search. Please refine your search.">

<cfelse>                    
                    
    <cfset AquaticFieldList = "">
    <cfset indexList = "">
    <cfset count = 0>
        
    <cfif ArrayLen(aquireOutputFields) is not 0>
        <CFLOOP index = "i" from = "1" to = "#ArrayLen(aquireOutputFields)#">
            
            <cfif #aquireOutputFields[i][3]# eq "PH">
                <cfset indexOf = 0>
            <cfelse>
                <cfset indexOf = Find("#aquireOutputFields[i][3]#", AquaticFieldList)>
            </cfif>       
            
            <cfif indexOf eq 0>
                <cfset headers = ListToArray(aquireOutputFields[i][2], "|")>
                <cfset headerFullNames = ListToArray(aquireOutputFields[i][5], "|")>
                <cfset sortStr = OutFunc.generateOrderString(trim(aquireOutputFields[i][3]), trim(aquireOutputFields[i][4]))>

                <cfif aquireOutputFields[i][3] neq "REVIEWER" OR (aquireOutputFields[i][3] eq "REVIEWER" AND thisInternalOnly eq 1)>
                    <cfset AquaticFieldList = AquaticFieldList & trim(aquireOutputFields[i][3])>
                           
                    <cfif ArrayLen(headers) gt 0>

                        <cfset fullNames = OutFunc.strReplace( aquireOutputFields[i][5], "|", " / " )>
                        <cfset tooltip1 = "#headerFullNames[1]#">
                        <cfset fieldname1 = "#headers[1]#">

                        <cfif ArrayLen(headers) gt 1>                                
                            <cfset tooltip2 = "#headerFullNames[2]#">
                            <cfset fieldname2 = "#headers[2]#">                                
                        <cfelse>                                
                            <cfset tooltip2 = "">
                            <cfset fieldname2 = "">                                
                        </cfif>
                            
                        <cfif fullNames eq "Reference Citation">
                            <cfset cellClass = "dt-tooltip">
                        <cfelse>
                            <cfset cellClass = "">
                        </cfif>

                        <cfset headerArray = listAppend(headerArray,'{"fullNames":"#fullNames#","sortStr":"#sortStr#","fieldname1":"#fieldname1#","tooltip1":"#tooltip1#","fieldname2":"#fieldname2#","tooltip2":"#tooltip2#","cellClass":"#cellClass#"}')>

                    </cfif>
                </cfif>
            <cfelse>
                <cfset indexList = Listappend(indexList, count)>
            </cfif>
            
            <cfset count = count + 1>
                                
        </CFLOOP>
    </cfif>
        
        
    <cfset otherFieldsToConvert = "DTXSID">    

    <!--- search results - dt rows --->
    <cfprocessingdirective suppressWhiteSpace = "Yes">
    <cfoutput query="SearchQuery">
        <cfset count = 0>
        <cfset recordArray = "">

        <cfif ArrayLen(aquireOutputFields) is not 0>                
            <CFLOOP index = "i" from = "1" to = "#ArrayLen(aquireOutputFields)#">
                <cfset columnOutput = "">
                       
                <cfif ListFind(indexList,"#count#") eq 0>                      
                    <cfset tmp = #Evaluate(listGetAt(aquireOutputFields[i][3],1))#>
                        
                    <cfif ListLen(aquireOutputFields[i][3]) gt 1>                          
                        <cfset tmp2 = #Evaluate(listGetAt(aquireOutputFields[i][3],2))#>

                        <cfinclude template="format/aquire_report_conversion.cfm">

                        <cfset cleanStr2 = replace(replace(replace(tmp2,"/","","ALL"),"~","","ALL"),"*","","ALL")>

                        <cfif cleanStr2 is "NC" or cleanStr2 is "NA" or ucase(cleanStr2) is "NOT CODED" or ucase(cleanStr2) is "NOT EXTRACTED" or ucase(cleanStr2) is "NOT APPLICABLE">
                            <cfset tmp2 = "&nbsp;">
                        </cfif>
                    
                    <cfelseif ListFind(otherFieldsToConvert, aquireOutputFields[i][3], ",") neq 0>

                        <cfinclude template="format/aquire_report_conversion.cfm">
                    
                    </cfif>

                    <cfset cleanStr = replace(replace(replace(tmp,"/","","ALL"),"~","","ALL"),"*","","ALL")>
                        
                    <cfif trim(cleanStr) is "NC" or trim(cleanStr) is "NA" or ucase(cleanStr) is "NOT CODED" or ucase(cleanStr) is "NOT EXTRACTED" or ucase(cleanStr) is "NOT APPLICABLE">
                            <cfset tmp = "&nbsp;">
                    </cfif> 
                    
                    <cfset oneValueOnlyFields = "Spec. Taxon. Info.,Eff %,Result Percent Lipid,Humic Acid,Sodium,Chlorine,Dissolved Inorganic Carbon,Calcium,Potassium,Magnesium,Sulfate,Sulfur,Intake Rate,Organism Initial Weight,Species Final Weight,Obs. Dur. (Author),Study Duration (Author),Study Duration (Standard),Exp. Dur. (Author),Exp. Dur. (Days)">
                    <cfif ListFind(oneValueOnlyFields, aquireOutputFields[i][2], ",") neq 0>
                        <cfset display2 = 0>
                    </cfif>

                    <cfset columnOutput = "#tmp#">
                    <cfif display2 eq 1>
                        <cfif (ListLen(aquireOutputFields[i][3]) gt 1)
                                OR ( ListFind(otherFieldsToConvert, aquireOutputFields[i][3], ",") neq 0 )>
                            <cfset columnOutput = columnOutput & "<hr/>">
                            <cfif tmp2 eq "">
                                <cfset columnOutput = columnOutput & "<br/>">
                            <cfelse>
                              <cfset columnOutput = columnOutput & "#tmp2#">
                            </cfif>
                        </cfif>
                    </cfif>
                    
                    <cfset columnOutput = OutFunc.cleanStringForDataTable(columnOutput, "JSON")>
                        
                    <cfset recordArray = listAppend(recordArray, columnOutput)>
                </cfif>
                    
                <cfset count = count + 1>                                
            </CFLOOP>
                
            <cfset recordArray = "[" & recordArray & "]">
        </cfif>
            
        <cfif recordArray neq "">
            <cfset dataArray = listAppend(dataArray, recordArray)>
        </cfif>
    </cfoutput>
    </cfprocessingdirective>
    
    <!--- REFERENCE NUMBERS ---->
    <cfprocessingdirective suppressWhiteSpace = "Yes">
    <cfoutput query="GetDistinctReferences">
        <cfset thisRefNum = #GetDistinctReferences.REFERENCE_NUMBER#>
        <cfset ArrayAppend(distinctRefNumsAry, thisRefNum)>
    </cfoutput>
    </cfprocessingdirective>
        
</cfif>
        
<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
   
<cfset refNumStr = "">
<cfloop index="i" from="1" to="#ArrayLen(distinctRefNumsAry)#">
    <cfset refNumStr = listAppend(refNumStr, #distinctRefNumsAry[i]#)>
</cfloop>

<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","draw":"#RETURNDRAW#","recordsTotal":"#mainQueryTotalRecordCount#","recordsFiltered":"#mainQueryTotalRecordCount#","distinctRefNums":"#refNumStr#","headers":['>

<cfset hdrString = "">
<cfloop list="#headerArray#" index="hdrItem">
    <cfset hdrString = listAppend(hdrString, hdrItem)>
</cfloop>

<cfset dataString = "">
<cfloop list="#dataArray#" index="dataItem">
    <cfset dataString = listAppend(dataString, dataItem)>
</cfloop>
    
<cfset jsonString = jsonString & hdrString & '],"records":[' & dataString & ']}'>

<cfprocessingdirective suppressWhiteSpace = "Yes">
<cfoutput>
    #jsonString#
</cfoutput>
</cfprocessingdirective>

