
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<cfset outputFormat = "JSON">
    
<cfprocessingdirective suppressWhiteSpace = "Yes">
<cfloop query="ReferenceQuery">
    <cfset recordArray = "">
        
    <cfset encTitle = EncodeForURL(ReferenceQuery.TITLE)>
        
    <cfset qRef_num = OutFunc.cleanStringForDataTable(ReferenceQuery.REFERENCE_NUMBER, outputFormat)>
    <cfset qAuthor = OutFunc.cleanStringForDataTable(ReferenceQuery.AUTHOR, outputFormat)>
    <cfset qTitle = OutFunc.cleanStringForDataTable(ReferenceQuery.TITLE, outputFormat)>
    <cfset qSource = OutFunc.cleanStringForDataTable(ReferenceQuery.SOURCE, outputFormat)>
    <cfset qPub_year = OutFunc.cleanStringForDataTable(ReferenceQuery.PUBLICATION_YEAR, outputFormat)>
    <cfset qCitation = OutFunc.cleanStringForDataTable(ReferenceQuery.FULL_CITATION, outputFormat)>
    <cfset qRef_type = OutFunc.cleanStringForDataTable(ReferenceQuery.REFTYPEDESC, outputFormat)>
    <cfset qGS_title = OutFunc.cleanStringForDataTable(encTitle, outputFormat)>

    <cfset recordArray = listAppend(recordArray,'"reference_number":#qRef_num#')>
    <cfset recordArray = listAppend(recordArray,'"author":#qAuthor#')>
    <cfset recordArray = listAppend(recordArray,'"title":#qTitle#')>
    <cfset recordArray = listAppend(recordArray,'"source":#qSource#')>
    <cfset recordArray = listAppend(recordArray,'"publication_year":#qPub_year#')>
    <cfset recordArray = listAppend(recordArray,'"full_citation":#qCitation#')>

    <cfset includeRefType = 0>
    <cfif ListFind("OECDF,MED03,MED04,MED02,OECDN,OECDG,MED01,MED05,OPP,RUSSN,USGS", ReferenceQuery.REFERENCE_TYPE) gt 0>
        <cfset includeRefType = 1>
    </cfif>            
    <cfset recordArray = listAppend(recordArray,'"include_ref_type":"#includeRefType#"')>

    <cfset recordArray = listAppend(recordArray,'"reftypedesc":#qRef_type#')>
    <cfset recordArray = listAppend(recordArray,'"encodedGsUrl":#qGS_title#')>

    <cfset recordArray = '{"reference": {' & recordArray & '}}'>

    <cfif recordArray neq "">
        <cfset dataArray = listAppend(dataArray, recordArray)>
    </cfif>        
</cfloop>
</cfprocessingdirective>

<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>

<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","draw":"#RETURNDRAW#","recordsTotal":"#TOTALREFCOUNT#","recordsFiltered":"#TOTALREFCOUNT#","records":['>

<cfset dataString = "">
<cfloop list="#dataArray#" index="dataItem">
    <cfset dataString = listAppend(dataString, dataItem)>
</cfloop>
    
<cfset jsonString = jsonString & dataString & ']}'>

<cfoutput>
    #jsonString#
</cfoutput>


