
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<!---construct csv output --->

<!--- TODO: error handling when we determine process flow
<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
--->
        
<cfset outputFormat = "CSV">
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=ECOTOX-Reference-Summary.csv">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfoutput>"REF. NUMBER","AUTHOR","TITLE","SOURCE","PUB. YEAR","REF. TYPE","DOI","CITATION"#chr(13)##chr(10)#</cfoutput>

<cfloop query="ReferenceQuery">
    <cfset recordArray = "">

    <cfset encTitle = EncodeForURL(ReferenceQuery.TITLE)>
        
    <cfset qRef_num = OutFunc.cleanStringForDataTable(ReferenceQuery.REFERENCE_NUMBER, outputFormat)>
    <cfset qAuthor = OutFunc.cleanStringForDataTable(ReferenceQuery.AUTHOR, outputFormat)>
    <cfset qTitle = OutFunc.cleanStringForDataTable(ReferenceQuery.TITLE, outputFormat)>
    <cfset qSource = OutFunc.cleanStringForDataTable(ReferenceQuery.SOURCE, outputFormat)>
    <cfset qPub_year = OutFunc.cleanStringForDataTable(ReferenceQuery.PUBLICATION_YEAR, outputFormat)>
    <cfset qRef_type = OutFunc.cleanStringForDataTable(ReferenceQuery.REFTYPEDESC, outputFormat)>
    <cfset qDOI = OutFunc.cleanStringForDataTable(ReferenceQuery.DOI, outputFormat)>

    <cfset recordArray = listAppend(recordArray,'#qRef_num#')>
    <cfset recordArray = listAppend(recordArray,'#qAuthor#')>
    <cfset recordArray = listAppend(recordArray,'#qTitle#')>
    <cfset recordArray = listAppend(recordArray,'#qSource#')>
    <cfset recordArray = listAppend(recordArray,'#qPub_year#')>

    <cfif ListFind("OECDF,MED03,MED04,MED02,OECDN,OECDG,MED01,MED05,OPP,RUSSN,USGS", ReferenceQuery.REFERENCE_TYPE) gt 0>
        <cfset recordArray = listAppend(recordArray,'#qRef_type#')>
    <cfelse>        
        <cfset recordArray = listAppend(recordArray,'')>
    </cfif>
        
    <cfset recordArray = listAppend(recordArray,'#qDOI#')>
    <cfset fullCitation = OutFunc.cleanStringForDataTable(ReferenceQuery.FULL_CITATION, outputFormat)>        
    <cfset recordArray = listAppend(recordArray,'#fullCitation#')>
        
    <cfoutput>#recordArray##chr(13)##chr(10)#</cfoutput>
</cfloop>
</cfprocessingdirective>