
<cfset startSegment = "TY  - ">
<cfset idSegment = "ID  - ">
<cfset authorSegment = "AU  - ">
<cfset titleSegment = "TI  - ">
<cfset sourceSegment = "T2  - ">
<cfset pubYearSegment = "PY  - ">
<cfset endSegment = "ER  - ">
    
<!---construct ris output --->

<!--- TODO: error handling when we determine process flow
<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
--->
        
<cfset outputFormat = "RIS">
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=ECOTOX-Reference-Summary.ris">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfloop query="ReferenceQuery">
        
    <cfset recType = "GEN">
    <cfset qRef_num = ReferenceQuery.REFERENCE_NUMBER>
        
    <cfset qAuthorStr = ReferenceQuery.AUTHOR>
    <cfset authorArray = listToArray(qAuthorStr, ", ", false, true)>
        
    <cfset qTitle = ReferenceQuery.TITLE>
    <cfset qSource = ReferenceQuery.SOURCE>
    <cfset qPub_year = ReferenceQuery.PUBLICATION_YEAR>
    <cfset qRef_type = ReferenceQuery.REFTYPEDESC>
        
    <cfoutput>#startSegment##recType##chr(13)##chr(10)#</cfoutput>
    
    <cfloop index="thisAuthor" array="#authorArray#">        
        <cfset thisAuthor = REPLACE(thisAuthor, 'and ', '', 'ALL')>
        <cfoutput>#authorSegment##thisAuthor##chr(13)##chr(10)#</cfoutput>
    </cfloop>
    
    <cfoutput>#titleSegment##qTitle##chr(13)##chr(10)#</cfoutput>        
    <cfoutput>#sourceSegment##qSource##chr(13)##chr(10)#</cfoutput>        
    <cfoutput>#pubYearSegment##qPub_year##chr(13)##chr(10)#</cfoutput>
    <cfoutput>#idSegment##qRef_num##chr(13)##chr(10)#</cfoutput>
    <cfoutput>#endSegment##chr(13)##chr(10)#</cfoutput>
    
    <cfoutput>#chr(13)##chr(10)#</cfoutput>
</cfloop>
</cfprocessingdirective>