
<CFLOCK TIMEOUT="30" throwontimeout="no" TYPE="readonly" scope="application">
    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>
</CFLOCK>

<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>
<cfif IsDefined("SearchQuery")>
    <cfset mainQueryTotalRecordCount = SearchQuery.TotalRows>
    <cfif mainQueryTotalRecordCount eq "">
        <cfset mainQueryTotalRecordCount = 0>
    </cfif>
<cfelse>
    <cfset mainQueryTotalRecordCount = 0>
</cfif>
<cfset distinctRefNumsAry = arrayNew(1)>
    
<cfset headerArray = "">
<cfset dataArray = "">

<cfset display2=0>
    
<cfif tooManyChem eq 1>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "Your Chemical Entry string matched too many chemicals. This filter will return all Ecotox values that match the search term but matches are capped at 2000 values. Please consider using a more specific term.">

<cfelseif tooManyEffects eq 1>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "Your Effect Measurement Entry string matched too many effects. This filter will return all Ecotox values that match the search term but matches are capped at 2000 values. Please consider using a more specific term.">

<cfelseif tooManySpecies eq 1>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "Your Taxonomic Name Entry string matched too many species. This filter will return all Ecotox values that match the search term but matches are capped at 2000 values. Please consider using a more specific term.">

<cfelseif mainQueryTotalRecordCount eq 0>

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this search. Please refine your search.">

<cfelse>                    
                    
    <cfset TerrFieldList = "">
    <cfset indexList = "">
    <cfset count = 0>
        
    <cfif ArrayLen(terrestrialOutputFields) is not 0>
        <CFLOOP index = "i" from = "1" to = "#ArrayLen(terrestrialOutputFields)#">
            
            <cfif #terrestrialOutputFields[i][3]# eq "PH">
                <cfset indexOf=0>
            <cfelse>
                <cfset indexOf = Find("#terrestrialOutputFields[i][3]#", TerrFieldList)>
            </cfif>
            
            <cfif indexOf eq 0>
                <cfset headers = ListToArray(terrestrialOutputFields[i][2], "|")>
                <cfset headerFullNames = ListToArray(terrestrialOutputFields[i][5], "|")>                 
                <cfset sortStr = OutFunc.generateOrderString(trim(terrestrialOutputFields[i][3]), trim(terrestrialOutputFields[i][4]))>

                <cfif terrestrialOutputFields[i][3] neq "REVIEWER" OR (terrestrialOutputFields[i][3] eq "REVIEWER" AND thisInternalOnly eq 1)>
                    <cfset TerrFieldList = TerrFieldList & trim(terrestrialOutputFields[i][3])>
                           
                    <cfif ArrayLen(headers) gt 0>

                        <cfset fullNames = OutFunc.strReplace( terrestrialOutputFields[i][5], "|", " / " )>
                        <cfset tooltip1 = "#headerFullNames[1]#">
                        <cfset fieldname1 = "#headers[1]#">

                        <cfif ArrayLen(headers) gt 1>                                
                            <cfset tooltip2 = "#headerFullNames[2]#">
                            <cfset fieldname2 = "#headers[2]#">                                
                        <cfelse>                                
                            <cfset tooltip2 = "">
                            <cfset fieldname2 = "">                                
                        </cfif>
                            
                        <cfif fullNames eq "Reference Citation">
                            <cfset cellClass = "dt-tooltip">
                        <cfelse>
                            <cfset cellClass = "">
                        </cfif>

                        <cfset headerArray = listAppend(headerArray,'{"fullNames":"#fullNames#","sortStr":"#sortStr#","fieldname1":"#fieldname1#","tooltip1":"#tooltip1#","fieldname2":"#fieldname2#","tooltip2":"#tooltip2#","cellClass":"#cellClass#"}')>

                    </cfif>
                </cfif>
            <cfelse>
                <cfset indexList = Listappend(indexList, count)>
            </cfif>
            
            <cfset count = count + 1>
        </CFLOOP>
    </cfif>

    <cfset arrNumbers="APP_FREQ_VALUE_SORT,CAS_NUMBER,TEST_CAS,TEST_PURITY_SORT,DOSE_NUMBER_SORT,DOSE_SORT,EXPOSURE_DURATION_SORT,EXP_DURATION_STD_SORT,EXPOSURE_NUMBER,ORGANISM_NUMBER_SORT,OBSERV_DURATION_SORT,OBSERV_DURATION_STD_SORT,OBSERV_RESPONSE_SORT,AGE_SORT,PERCENT_LIPID_SORT,RESULT_NUMBER,RESULT_GROUP,SAMPLE_NUMBER_SORT,SIGNIFICANCE_LEVEL_SORT,SOIL_CEC_SORT,SOIL_TEXTURE_CL_SORT,SOIL_MOISTURE_SORT,SOIL_ORG_MATTER_SORT,SOIL_PH_SORT,SOIL_TEXTURE_SA_SORT,SOIL_TEXTURE_SI_SORT,SPECIES_NUMBER,TEST_NUMBER,RESULTRECORDNUMBER">
        
    <cfset otherFieldsToConvert = "DTXSID">
        
    <!--- search results - dt rows --->
    <cfprocessingdirective suppressWhiteSpace = "Yes">
    <cfoutput query="SearchQuery">
        <cfset count = 0>
        <cfset recordArray = "">
            
        <cfset endPoint="#SearchQuery.Endpoint#">
        <cfset recordNumber = val(SearchQuery.TEST_NUMBER)>
        <cfset myEffect = SearchQuery.Effect>
            
        <cfif SearchQuery.TEST_CAS neq "" and val(SearchQuery.TEST_NUMBER) neq "" and SearchQuery.LATIN_NAME neq "">    
            <cfif SearchQuery.TEST_NUMBER is not "A">
                <cfif ArrayLen(terrestrialOutputFields) is not 0>                      
                    <CFLOOP index = "i" from = "1" to = "#ArrayLen(terrestrialOutputFields)#">
                        <cfset columnOutput = "">

                        <cfif ListFind(indexList,"#count#") eq 0>                                
                            <cfif ListFind(arrNumbers,listGetAt(terrestrialOutputFields[i][3],1),",") neq 0>
                                <cfset tmp = #val(Evaluate(listGetAt(terrestrialOutputFields[i][3],1)))#>
                            <cfelse>
                                <cfset tmp = #Evaluate(listGetAt(terrestrialOutputFields[i][3],1))#>
                            </cfif>

                            <cfset tmp = trim(tmp)>
                            <cfif REPLACE(REPLACE(REPLACE(tmp,"/","","ALL"),"*","","ALL"),"~","","ALL") is "NA"
                                or REPLACE(REPLACE(REPLACE(tmp,"/","","ALL"),"*","","ALL"),"~","","ALL") is "NC"
                                or ucase(REPLACE(REPLACE(REPLACE(tmp,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT APPLICABLE"
                                or ucase(REPLACE(REPLACE(REPLACE(tmp,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT EXTRACTED"
                                or ucase(REPLACE(REPLACE(REPLACE(tmp,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT CODED">
                                <cfset tmp = "&nbsp;">
                            </cfif>

                            <cfif ListLen(terrestrialOutputFields[i][3]) gt 1>
                                <cfset unit_pos = 2>
                                <cfif listGetAt(terrestrialOutputFields[i][3],1) eq "APP_FREQ_VALUE">
                                    <cfset unit_pos = 8>
                                </cfif>

                                <cfif ListFind(arrNumbers,listGetAt(terrestrialOutputFields[i][3],unit_pos),",") neq 0>
                                    <cfset tmp2 = #val(Evaluate(listGetAt(terrestrialOutputFields[i][3],unit_pos)))#>
                                <cfelse>
                                    <cfset tmp2 = #Evaluate(listGetAt(terrestrialOutputFields[i][3],unit_pos))#>
                                </cfif>

                                <cfinclude template="format/terrestrial_report_conversion.cfm">

                                <cfif REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL") is "NA"
                                    or REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL") is "NC"
                                    or ucase(REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT APPLICABLE"
                                    or ucase(REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT EXTRACTED"
                                    or ucase(REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT CODED">
                                    <cfset tmp2 = "&nbsp;">
                                </cfif>

                            <cfelseif terrestrialOutputFields[i][4] is "CR">

                                <cfinclude template="format/terrestrial_report_conversion.cfm">

                                <cfif REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL") is "NA"
                                    or REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL") is "NC"
                                    or ucase(REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT APPLICABLE"
                                    or ucase(REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT EXTRACTED"
                                    or ucase(REPLACE(REPLACE(REPLACE(tmp2,"/","","ALL"),"*","","ALL"),"~","","ALL")) is "NOT CODED">
                                    <cfset tmp2 = "&nbsp;">
                                </cfif>

                            <cfelseif terrestrialOutputFields[i][1] is "Result Record Number">
                                <cfset tmp=#val(SearchQuery.ResultRecordNumber)#>
                                    
                            <cfelseif ListFind(otherFieldsToConvert, terrestrialOutputFields[i][3], ",") neq 0>

                                <cfinclude template="format/terrestrial_report_conversion.cfm">
            
                            </cfif> 
                    
                            <cfset oneValueOnlyFields = "Spec. Taxon. Info.,Org. Init. Wt.,Org. Final Wt.,Doses,Temp.,Exp. Sample Number,Intake Rate,Result % Lipd.,Result % Dry/Wet Wt.">
                            <cfif ListFind(oneValueOnlyFields, terrestrialOutputFields[i][2], ",") neq 0>
                                <cfset display2 = 0>
                            </cfif>

                            <cfset columnOutput = "#tmp#">
                            <cfif display2 eq 1>
                                <cfif ( ListLen(terrestrialOutputFields[i][3]) gt 1 )
                                        OR ( ListFind(otherFieldsToConvert, terrestrialOutputFields[i][3], ",") neq 0 )>
                                    <cfset columnOutput = columnOutput & "<hr/>">
                                    <cfif tmp2 eq "">
                                        <cfset columnOutput = columnOutput & "<br/>">
                                    <cfelse>
                                        <cfset columnOutput = columnOutput & "#tmp2#">
                                    </cfif>
                                </cfif>
                            </cfif>
                                
                            <cfset columnOutput = OutFunc.cleanStringForDataTable(columnOutput, "JSON")>    
                                
                            <cfset recordArray = listAppend(recordArray, columnOutput)>                                
                        </cfif>                            
                            
                        <cfset count = count + 1>
                    </CFLOOP>

                    <cfset recordArray = "[" & recordArray & "]">
                           
                </cfif>

                <cfif recordArray neq "">
                    <cfset dataArray = listAppend(dataArray, recordArray)>
                </cfif>            
            </cfif>
        </cfif>    
            
    </cfoutput>
    </cfprocessingdirective>
    
    <!--- REFERENCE NUMBERS ---->
    <cfprocessingdirective suppressWhiteSpace = "Yes">
    <cfoutput query="GetDistinctReferences">
        <cfset thisRefNum = #GetDistinctReferences.REFERENCE_NUMBER#>
        <cfset ArrayAppend(distinctRefNumsAry, thisRefNum)>
    </cfoutput>
    </cfprocessingdirective>
        
</cfif>
        
<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
   
<cfset refNumStr = "">
<cfloop index="i" from="1" to="#ArrayLen(distinctRefNumsAry)#">
    <cfset refNumStr = listAppend(refNumStr, #distinctRefNumsAry[i]#)>
</cfloop>

<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","draw":"#RETURNDRAW#","recordsTotal":"#mainQueryTotalRecordCount#","recordsFiltered":"#mainQueryTotalRecordCount#","distinctRefNums":"#refNumStr#","headers":['>

<cfset hdrString = "">
<cfloop list="#headerArray#" index="hdrItem">
    <cfset hdrString = listAppend(hdrString, hdrItem)>
</cfloop>

<cfset dataString = "">
<cfloop list="#dataArray#" index="dataItem">
    <cfset dataString = listAppend(dataString, dataItem)>
</cfloop>
    
<cfset jsonString = jsonString & hdrString & '],"records":[' & dataString & ']}'>

<cfprocessingdirective suppressWhiteSpace = "Yes">
<cfoutput>
    #jsonString#
</cfoutput>
</cfprocessingdirective>
       
       