
<cfset ExcelFunc = CreateObject("component", "cfc.excel_functions")>
<cfset spreadsheet = CreateObject( "component", "lucee_ss.Spreadsheet" ).init( javaLoaderDotPath = "lucee_ss.javaLoader.JavaLoader" )>

<CFLOCK TIMEOUT="30" throwontimeout="no" TYPE="readonly" scope="application">
    <CFSET thisRecordMax = duplicate(Application.RecordMax)>
    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>
</CFLOCK>

<cfif ExportQuery.RecordCount is 0>

    <div class="callout primary">
        <h5 class="title">Sorry</h5>
        <p>There were no results found for this search. Please refine your search.</p>
    </div>

<cfelseif ExportQuery.RecordCount gt thisRecordMax>

    <div class="callout alert">
        <h5 class="title">Warning</h5>
        <p>There were too many results found to display in a browser report format.  There is a limit of <cfoutput>#thisRecordMax#</cfoutput> records for a browser viewable report. Please refine your search.</p>
    </div>

<cfelse>
    
    <!--- Before you go into .xls code, find out if cbIncludeCodeDesc is in use --->
    <cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
        <cfset displayLookupCodes = True>
    <cfelse>
        <cfset displayLookupCodes = False>
    </cfif>

    <cfset pipeSpacer = " | "> <!--- Used in Summary column output with NoWrap --->


    <!--- MATCH LISTS FOR SKIP FIELDS --->

    <cfset condensedColNameList = "Dose,Temperature,Application Frequency,Effect Percent,Significance Level,Chemical Half Life,Result Percent Lipid,Intake Rate,Exposure Sample Number,Result Sample Number,Organism Initial Weight Mean Op,Organism Initial Weight Mean,Organism Initial Weight Min Op,Organism Initial Weight Min,Organism Initial Weight Max Op,Organism Initial Weight Max,Organism Initial Weight Units,Species Final Weight,Result Percent Dry/Wet Weight,Doses,Chemical Purity Mean Op,Chemical Purity Mean(%),Chemical Purity Min Op,Chemical Purity Min(%),Chemical Purity Max Op,Chemical Purity Max(%),Observed Duration Op (Days),Observed Duration Min Op (Days),Observed Duration Min (Days),Observed Duration Max Op (Days),Observed Duration Max (Days),Conc 2 Type (Author),Conc 2 Mean Op (Author),Conc 2 Mean (Author),Conc 2 Min Op (Author),Conc Min 2 (Author),Conc 2 Max Op (Author),Conc 2 Max (Author),Conc 2 Units (Author),Conc 3 Type (Author),Conc 3 Mean Op (Author),Conc 3 Mean (Author),Conc 3 Min Op (Author),Conc Min 3 (Author),Conc 3 Max Op (Author),Conc 3 Max (Author),Conc 3 Units (Author),Organism Age Mean Op,Organism Age Mean,Organism Age Min Op,Organism Age Min,Organism Age Max Op,Organism Age Max,Organism Initial Length Mean,Organism Initial Length Mean Op,Organism Initial Length Min,Organism Initial Length Min Op,Organism Initial Length Max,Organism Initial Length Max Op,Organism Initial Length Units,Organism Initial Length Type">

    <cfset condensedDBFieldList = "DOSE,TEMPERATURE,APP_FREQ_VALUE,EFFECT_PCT,SIGNIFICANCE_LEVEL,HALFLIFE,PERCENT_LIPID,INTAKE_RATE,ORGANISM_NUMBER,SAMPLE_NUMBER,ORGANISM_INIT_WT_MEAN_OP,ORGANISM_INIT_WT_MEAN,ORGANISM_INIT_WT_MIN_OP,ORGANISM_INIT_WT_MIN,ORGANISM_INIT_WT_MAX_OP,ORGANISM_INIT_WT_MAX,ORGANISM_INIT_WT_UNIT,ORGANISM_FINAL_WT,DRY_WEIGHT_PERCENT,DOSES,TEST_PURITY_MEAN_OP,TEST_PURITY_MEAN,TEST_PURITY_MIN_OP,TEST_PURITY_MIN,TEST_PURITY_MAX_OP,TEST_PURITY_MAX,OBSERV_DURATION_MEAN_STD,OBSERV_MIN_STD_OP,OBSERV_DURATION_MIN_STD,OBSERV_MAX_STD_OP,OBSERV_DURATION_MAX_STD,CONC2_TYPE_DESC,CONC2_TYPE,CONC2_MEAN_OP,CONC2_MEAN,CONC2_MIN_OP,CONC2_MIN,CONC2_MAX_OP,CONC2_MAX,CONC2_UNIT,CONC3_TYPE_DESC,CONC3_TYPE,CONC3_MEAN_OP,CONC3_MEAN,CONC3_MIN_OP,CONC3_MIN,CONC3_MAX_OP,CONC3_MAX,CONC3_UNIT,ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,ORGANISM_LENGTH_MEAN,ORGANISM_LENGTH_MEAN_OP,ORGANISM_LENGTH_MIN,ORGANISM_LENGTH_MIN_OP,ORGANISM_LENGTH_MAX,ORGANISM_LENGTH_MAX_OP,ORGANISM_LENGTH_UNIT,ORGANISM_LENGTH_TYPE,ORGANISM_LENGTH_UNIT_DESC,ORGANISM_LENGTH_TYPE_DESC">

    <cfset fullColNameList = "Dose,Temperature,Application Frequency,Effect Percent,Significance Level,Chemical Half Life,Result Percent Lipid,Intake Rate,Exposure Sample Number,Result Sample Number,Organism Initial Weight,Species Final Weight,Result Percent Dry/Wet Weight,Doses,Chemical Purity,Organism Age,Organism Initial Length">

    <cfset fullDBFieldList = "DOSE,TEMPERATURE,APP_FREQ_VALUE,EFFECT_PCT,SIGNIFICANCE_LEVEL,HALFLIFE,INTAKE_RATE,PERCENT_LIPID,ORGANISM_NUMBER,SAMPLE_NUMBER,ORGANISM_INIT_WT,ORGANISM_FINAL_WT,DRY_WEIGHT_PERCENT,DOSES,TEST_PURITY,AGE,AGE_DESC,ORGANISM_LENGTH,ORGANISM_LENGTH_DESC">


    <cfprocessingdirective suppressWhiteSpace = "Yes">

    <cfif ArrayLen(TerrestrialOutputFields) is not 0>
        <cfset indexList = "">
        <cfset count = 0>

        <cfset columnNameList_pg1 = "">

        <cfloop index = "i" from = "1" to = "#ArrayLen(TerrestrialOutputFields)#">      <!--- fields --->

            <cfset formFieldNames = TerrestrialOutputFields[i][1]>
            <cfloop index=k list="#formFieldNames#" delimiters="|">                     <!--- each column name --->

                <cfset trimmedColHdrVal = trim(k)>
                    
                <!--- Looking at the column names --->
                <cfset indexOf = ListFind(columnNameList_pg1,"#trimmedColHdrVal#")>
                <cfif indexOf eq 0>
                    <!--- Excludes headings of contatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                    <!--- Additional conditions to check:
                        1. one of the risk assessor default fields is un-selected
                            - That column will not be in the TerrestrialOutputFields[] array, so whether the field is checked in the if-statement below is irrelevant.
                            - Still need to test the checkbox (ie. cbPurity?) when assembling the Summary Column string output to include or exclude that line
                        2. New checkbox for cbCondensed -- checked is condensed, unchecked is full
                            - If cbCondensed is checked, then do this normal logic, else don't check those 4 mean-min-max fields
                    --->
                    <cfif CONDENSED_EXCEL eq true> <!--- then condensed output --->

                        <cfif ListFind(condensedColNameList, trimmedColHdrVal) eq 0>

                            <cfset columnNameList_pg1 = Listappend(columnNameList_pg1, trimmedColHdrVal)>

                        </cfif>
                    <cfelse>

                        <cfif ListFind(fullColNameList, trimmedColHdrVal) eq 0>

                            <cfset columnNameList_pg1 = Listappend(columnNameList_pg1, trimmedColHdrVal)>

                        </cfif>
                    </cfif>
                <cfelse>

                    <cfset indexList = Listappend(indexList, count)>
                </cfif>

                <cfset count = count + 1>

            </cfloop>      <!--- end each column name --->
        </cfloop>              <!--- end fields --->

        <cfif CONDENSED_EXCEL eq true> <!--- then condensed output --->
            <!--- Show the title for the "Summary of Additional Parameters" column. --->
            <cfset columnNameList_pg1 = Listappend(columnNameList_pg1, "Summary of Additional Parameters")>
        </cfif>


        <!---   PAGE 1      --->

        <cfset thisExcelWorkbook = ExcelFunc.generateStreamingXlsx(spreadsheet, columnNameList_pg1, "Terrestrial-Export")>



<cflog text="terr_search_excel_native - data loop starts">


        <cfset thisRow = 2>
        <cfloop query="ExportQuery">           <!--- NOTE: CHECK NAME OF QUERY HERE --->


<!---<cfset startTime = GetTickCount()>--->
<!---<cflog text="ROW = #thisRow#: Export Query Loop (1) - #TimeFormat(Now(),'HH:mm:ss.l')#">--->


            <cfset count = 0>

            <cfset dataRow = arrayNew(1)>

            <cfloop index = "i" from = "1" to = "#ArrayLen(TerrestrialOutputFields)#">           <!--- fields --->


<!---<cfset groupStartTime = GetTickCount()>--->
<!---<cflog text="ROW = #thisRow#: TerrestrialOutputFields Loop (2)">--->


                <cfloop index=j list="#TerrestrialOutputFields[i][3]#" delimiters=",">           <!--- db column list, loop through each db col --->


<!---<cfset fieldStartTime = GetTickCount()>--->
<!---<cflog text="ROW = #thisRow#: db column list Loop (3) - value = #j#">--->


                    <cfset trimmedColVal = trim(j)>
                    <cfset evalColVal = evaluate(j)>

                    <cfif ListFind(indexList, "#count#") eq 0>
                        <!--- Excludes column concatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                        <cfif CONDENSED_EXCEL eq true>
                            <cfif ListFind(condensedDBFieldList, trimmedColVal) eq 0>

                                <!--- Do some substitutions for condensed output --->
                                <cfif trimmedColVal eq "TEST_PURITY">
                                    <cfset cellValueToAdd = ExcelFunc.concatMean(TEST_PURITY_MEAN_OP, TEST_PURITY_MEAN)>

                                <cfelseif trimmedColVal eq "AGE" OR trimmedColVal eq "AGE_DESC">
                                    <cfset cellValueToAdd = ExcelFunc.concatMean(ORGANISM_AGE_MEAN_OP, ORGANISM_AGE_MEAN)>

                                <cfelseif trimmedColVal eq "OBSERV_MEAN_STD_OP">
                                    <cfset cellValueToAdd = ExcelFunc.concatMean(OBSERV_MEAN_STD_OP, OBSERV_DURATION_MEAN_STD)>

                                <cfelse>
                                    <cfset cellValueToAdd = evalColVal>

                                </cfif>

                                <cfset ArrayAppend(dataRow, cellValueToAdd)>

                            </cfif>
                        <cfelse>

                            <cfif ListFind(fullDBFieldList, trimmedColVal) eq 0>

                                <cfset ArrayAppend(dataRow, evalColVal)>

                            </cfif>
                        </cfif>
                    </cfif>
                    <cfset count = count + 1>


<!---<cfset fieldEndTime = GetTickCount()>--->
<!---<cfset fieldRunTime = fieldEndTime - fieldStartTime>--->
<!---<cflog text="ROW = #thisRow#: FIELD = #trimmedColVal# - #fieldRunTime#">--->
<!---<cflog text="ROW = #thisRow#: END LOOP (3)">--->


                </cfloop>


<!---<cfset groupEndTime = GetTickCount()>
<cfset groupRunTime = groupEndTime - groupStartTime>
<cflog text="ROW = #thisRow#: #groupRunTime# - GROUP = #TerrestrialOutputFields[i][3]#">--->
<!---<cflog text="ROW = #thisRow#: END LOOP (2)">--->


            </cfloop>

            <!--- Summary of Additional Parameters column --->
            <cfif CONDENSED_EXCEL eq true>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "conc1_type" )>
                    <cfset tempVar1 = conc1_type>
                    <cfset tempVar3 = conc2_type>
                    <cfset tempVar4 = conc3_type>
                <cfelseif ListFindNoCase( ExportQuery.ColumnList, "conc1_type_desc" )>
                    <cfset tempVar1 = conc1_type_desc>
                    <cfset tempVar3 = conc2_type_desc>
                    <cfset tempVar4 = conc3_type_desc>
                <cfelse>
                    <!--- Dose(Author)|Statistical Method was not checked, so there is no output for any conc#--->
                </cfif>

                <cfset tempText = "">
                <cfif ListFindNoCase( ExportQuery.ColumnList, "TEST_PURITY_MEAN_OP" )>
                    <cfset tempText = tempText & "Purity:  " &
                            ExcelFunc.additionalParameters("1","",TEST_PURITY_MEAN_OP,TEST_PURITY_MEAN,TEST_PURITY_MIN_OP,TEST_PURITY_MIN,TEST_PURITY_MAX_OP,TEST_PURITY_MAX)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "ORGANISM_AGE_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>

                    <cfif displayLookupCodes>
                        <cfset tempText = tempText & "Organism Age:  " &
                                ExcelFunc.additionalParameters("2","",ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNITS)>
                    <cfelse>
                        <cfset tempText = tempText & "Organism Age:  " &
                                ExcelFunc.additionalParameters("2","",ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNITS_DESC)>

                    </cfif>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "OBSERV_MEAN_STD_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Duration (Days):  " &
                            ExcelFunc.additionalParameters("2","",OBSERV_MEAN_STD_OP,OBSERV_DURATION_MEAN_STD,OBSERV_MIN_STD_OP,OBSERV_DURATION_MIN_STD,OBSERV_MAX_STD_OP,OBSERV_DURATION_MAX_STD)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "CONC2_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Conc 2 (Author):  " &
                            ExcelFunc.additionalParameters("4",tempVar3,CONC2_MEAN_OP,CONC2_MEAN,CONC2_MIN_OP,CONC2_MIN,CONC2_MAX_OP,CONC2_MAX,CONC2_UNIT)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "CONC3_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Conc 3 (Author):  " &
                            ExcelFunc.additionalParameters("4",tempVar4,CONC3_MEAN_OP,CONC3_MEAN,CONC3_MIN_OP,CONC3_MIN,CONC3_MAX_OP,CONC3_MAX,CONC3_UNIT)>
                </cfif>

                <cfset ArrayAppend(dataRow, tempText)>

            <cfelse>

                <!--- Don't print the summary with a full report --->

            </cfif>

            <cfset spreadsheet.addRow(thisExcelWorkbook, dataRow)>


<!---<cfset endTime = GetTickCount()>
<cfset runTime = endTime - startTime>
<cflog text="ROW = #thisRow#: END LOOP (1) - #runTime#">--->
<!---<cflog text="ROW = #thisRow#: END LOOP (1) - #TimeFormat(Now(),'HH:mm:ss.l')#">--->

                   
            <cfset thisRow = thisRow + 1>
        </cfloop>
 


<cflog text="terr_search_excel_native - data loop ends">

       
        
        <cfset spreadsheet.addFreezePane(thisExcelWorkbook, 1, 1)>
               
        <!---   END PAGE 1  --->


        <!---   PAGE 2      --->

        <cfinclude template="export_excel_native_pg2.cfm">


        <!---   PAGE 3          --->

        <!--- export time added to both page 3 and file name --->
        <cfset rightNow = Now()>
        <cfset thisYear = dateTimeFormat(rightNow, "yyyy")>
        <cfset thisMonth = dateTimeFormat(rightNow, "mm")>
        <cfset thisDay = dateTimeFormat(rightNow, "dd")>
        <cfset thisHour = dateTimeFormat(rightNow, "HH")>
        <cfset thisMinute = dateTimeFormat(rightNow, "nn")>
        <cfset thisSecond = dateTimeFormat(rightNow, "ss")>

        <cfset exportTime = thisYear & "-" & thisMonth & "-" & thisDay & " " & thisHour & ":" & thisMinute & ":" & thisSecond>    
        <cfset exportTimeFile = thisYear & thisMonth & thisDay & "_" & thisHour & thisMinute & thisSecond>

        <cfinclude template="export_excel_native_pg3.cfm">            
            

        <!---   OUTPUT THE ENTIRE WORKBOOK  --->

        <cfset spreadsheet.setActiveSheet(thisExcelWorkbook, "Terrestrial-Export")>
        <cfset fileName = "ECOTOX-Terrestrial-Export_" & exportTimeFile>  

        <!--- stream it to the browser --->
        <cfset ExcelFunc.generateStreamingXlsxDownload(spreadsheet, thisExcelWorkbook, fileName)>

    </cfif>

    </cfprocessingdirective>

</cfif>
