    
<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        AppendixCodesQuery - a coldfusion query object with this name.  Needs to have columns labeled "THISCODE" and "THISDESC".
                                Designed to work with code/description style tables.

    EXPECTED VARIABLES FROM HANDLER:

        OUTPUTFORMAT - JSON for web, CSV, EXCEL (possibly others in future) for exports

--->

<cfif URL.export EQ "1">
    <cfset rowCount = "">
<cfelse>
    <cfset rowCount = AppendixCodesQuery.TotalRows>
</cfif>
    
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>
    

<cfset columnDefs = arrayNew(2)>
    
<cfset col1Array = arrayNew(1)>
<cfset ArrayAppend(col1Array, "MEASUREMENT TERM")>
<cfset ArrayAppend(col1Array, "mc.code")>
<cfset ArrayAppend(columnDefs, col1Array)>
    
<cfset col2Array = arrayNew(1)>
<cfset ArrayAppend(col2Array, "MEASUREMENT NAME")>
<cfset ArrayAppend(col2Array, "mc.description")>
<cfset ArrayAppend(columnDefs, col2Array)>
    
<cfset col3Array = arrayNew(1)>
<cfset ArrayAppend(col3Array, "MEASUREMENT DEFINITION")>
<cfset ArrayAppend(col3Array, "mc.long_description")>
<cfset ArrayAppend(columnDefs, col3Array)>
       
<cfif URL.export EQ "1">    
    <cfset col4Array = arrayNew(1)>
    <cfset ArrayAppend(col4Array, "EFFECT CODE")>
    <cfset ArrayAppend(col4Array, "ec.code")>
    <cfset ArrayAppend(columnDefs, col4Array)>

    <cfset col5Array = arrayNew(1)>
    <cfset ArrayAppend(col5Array, "EFFECT")>
    <cfset ArrayAppend(col5Array, "ec.description")>
    <cfset ArrayAppend(columnDefs, col5Array)>
</cfif>
       
    
<cfset resultsArray = arrayNew(2)>
<cfloop query="AppendixCodesQuery">
    <cfset rowData = arrayNew(1)>
    
    <cfset col1Str = AppendixCodesQuery.MEAS_CODE>
    <cfset col1Str = OutFunc.cleanStringForDataTable(col1Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col1Str)>

    <cfset col2Str = AppendixCodesQuery.MEAS_DESC>
    <cfset col2Str = OutFunc.cleanStringForDataTable(col2Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col2Str)>

    <cfset col3Str = AppendixCodesQuery.MEAS_LONG>
    <cfset col3Str = OutFunc.cleanStringForDataTable(col3Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col3Str)>
           
    <cfif URL.export EQ "1">
        <cfset col4Str = AppendixCodesQuery.EFFECT_CODE>
        <cfset col4Str = OutFunc.cleanStringForDataTable(col4Str, OUTPUTFORMAT)> 
        <cfset ArrayAppend(rowData, col4Str)>

        <cfset col5Str = AppendixCodesQuery.EFFECT_DESC>
        <cfset col5Str = OutFunc.cleanStringForDataTable(col5Str, OUTPUTFORMAT)> 
        <cfset ArrayAppend(rowData, col5Str)>          
    </cfif>
           
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>

<cfinclude template="output_router.cfm">
        