<cfset GroupFunc = CreateObject("component", "cfc.group_option_functions")>

<div id="exploreFilters" class="accordion" data-accordion data-allow-all-closed="true">
    <div id="groupFilters">
        <div class="chemicals type" data-group-filter="chemicals">

            <select name="selGroupChem" id="selGroupChem" multiple
                    data-group-select="Chemicals" data-filter-param="chemgroupid">

                <cfset chemOptionArray = GroupFunc.getAllChemGroupOptions()>
                <cfloop from="1" to="#ArrayLen(chemOptionArray)#" index="i">
                    <cfoutput>#chemOptionArray[i]#</cfoutput>
                </cfloop>
                <option value="99">Custom Group</option>

            </select>

            <h4 class="mb1">Custom Group</h4>

            <p class="help-text mb2">Create a custom chemical group by browsing available chemicals or entering a list of CAS numbers.</p>
            <button class="show-all button success" data-open="exploreCustomGroupModal">Create Custom Group...</button>

            <cfoutput>
                <input type="hidden" name="hdnChemGroupId" id="hdnChemGroupId" data-custom-chem-group-cgid data-filter-param="cgid" data-url-cgid="#url.cgid#"/>
                <input type="hidden" name="hdnChemSearchId" id="hdnChemSearchId" data-custom-chem-group-csid data-filter-param="csid" data-url-csid="#url.csid#"/>
                <input type="hidden" name="hdnCasList" id="hdnCasList" data-custom-chem-group-browse data-custom-chem-group-cas data-filter-param="caslist" data-url-cas="#url.cas#"/>
                <input type="hidden" name="hdnDTXSIDList" id="hdnDTXSIDList" data-filter-param="dtxsidlist" data-url-dtxsid="#url.dtxsid#"/>
            </cfoutput>
        </div>

        <div class="species type" data-group-filter="species">

            <select name="selGroupSpecies" id="selGroupSpecies" multiple
                    data-group-select="Species" data-filter-param="specgroupid">

                <cfset specOptionArray = GroupFunc.getAllSpecGroupOptions()>
                <cfloop from="1" to="#ArrayLen(specOptionArray)#" index="i">
                    <cfoutput>#specOptionArray[i]#</cfoutput>
                </cfloop>
                <option value="99">Custom Group</option>

            </select>

            <h4 class="mb1">Custom Group</h4>

            <p class="help-text mb2">Create a custom species group by browsing available species or entering a list of <span class="has-tip add-image" data-tooltip data-click-open="true" data-allow-html="true" data-position-class="bottom" data-disable-hover="false" title="National Center for Biotechnology Information Taxonomy Database numerical unique identifier (<a class='on-dark-hp' target='_blank' href='http://www.ncbi.nlm.nih.gov/taxonomy'>http://www.ncbi.nlm.nih.gov/taxonomy</a> <a class='exit-disclaimer' href='https://www.epa.gov/home/exit-epa' title='EPAs External Link Disclaimer'>Exit</a>).">NCBI TaxIDs</span>.</p>
            <button class="show-all button success" data-open="exploreCustomGroupModal">Create Custom Group...</button>

            <cfoutput>
                <input type="hidden" name="hdnSpecIdList" id="hdnSpecIdList" data-custom-spec-group-browse data-filter-param="specidlist"/>
                <input type="hidden" name="hdnNcbiList" id="hdnNcbiList" data-custom-spec-group-ncbi data-filter-param="ncbilist" data-url-ncbi="#url.ncbi#"/>
                <input type="hidden" name="customSpecChemicals" id="customSpecChemicals" data-filter-param="custspecchemlist" data-url-spec-cas="#url.cas#"/>
            </cfoutput>
        </div>

        <div class="effects type" data-group-filter="effects">

            <select name="selGroupEffect" id="selGroupEffect" multiple
                    data-group-select="Effects" data-filter-param="effgroupid">

                <cfset effOptionArray = GroupFunc.getAllEffectGroupOptions()>
                <cfloop from="1" to="#ArrayLen(effOptionArray)#" index="i">
                    <cfoutput>#effOptionArray[i]#</cfoutput>
                </cfloop>
                <option value="99">Custom Group</option>

            </select>

            <h4 class="mb1">Custom Group</h4>

            <p class="help-text mb2">Create a custom effects group by browsing available effect measurements or entering a list of effect and measurement terms.</p>
            <button class="show-all button success" data-open="exploreCustomGroupModal">Create Custom Group...</button>

            <cfoutput>
                <input type="hidden" name="hdnEffMeasList" id="hdnEffMeasList" data-custom-eff-group-browse data-custom-eff-group-effmeas data-filter-param="effmeaslist"/>
            </cfoutput>
        </div>

        <hr/>
        <h4 class="mb1">Defined Groups</h4>
        <p class="help-text mb2"><span class="has-tip add-image" data-tooltip data-allow-html="true" data-position-class="bottom" data-disable-hover="false" title="Hold the <code>shift</code> or <code>ctrl/cmd</code> keys to select multiple categories.">Select one or more</span> categories from the graph to filter groups in the table.</p>
        <div id="hcExploreGroups"></div>
    </div>
    
    <div id="pubFilters">
        <div class="publications type" data-group-filter="publications">
            <cfoutput>
                <input type="hidden" name="hdnOrigEcoRefList" id="hdnOrigEcoRefList" data-filter-param="origreflist" data-url-ecoref="#url.ecoref#"/>
                <input type="hidden" name="hdnSelEcoRefList" id="hdnSelEcoRefList"/>
                <input type="hidden" name="hdnHeroIdList" id="hdnHeroIdList" data-filter-param="hero" data-url-hero="#url.hero#"/>
                <input type="hidden" name="hdnToxValList" id="hdnToxValList" data-filter-param="toxval" data-url-toxval="#url.toxval#"/>
            </cfoutput>
        </div>
    </div>

    <div id="addtlFilters" class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Query Filters</h4></a>

        <div class="accordion-content" data-tab-content>
            <form id="exploreToBridgeForm" action="search.cfm" target="_blank" method="POST">
                <input type="hidden" name="pre_search" data-bridge id="pre_search" value="1"/>
                <input type="hidden" name="pre_habitat" data-bridge id="pre_habitat" value="aquire"/>
                <input type="hidden" name="pre_exploretype" data-bridge id="pre_exploretype" value=""/>
                <input type="hidden" name="pre_exploretypegroupids" data-bridge id="pre_exploretypegroupids" value=""/>
                <input type="hidden" name="pre_speciesstring" data-bridge id="pre_speciesstring" value=""/>
                <input type="hidden" name="pre_chemstring" data-bridge id="pre_chemstring" value=""/>
                <input type="hidden" name="pre_effectstring" data-bridge id="pre_effectstring" value=""/>
                <input type="hidden" name="pre_endpointstring" data-bridge id="pre_endpointstring" value=""/>

            <fieldset id="exploreHabitatToggles">
                <legend>Habitat</legend>

                <input id="exploreHabitatAquatic" name="exploreHabitatAquatic" value="A" type="checkbox">
                <label class="button" for="exploreHabitatAquatic">Aquatic</label>

                <input id="exploreHabitatTerr" name="exploreHabitatTerr" value="T" type="checkbox">
                <label class="button" for="exploreHabitatTerr">Terrestrial</label>
            </fieldset>

            <h4>Query Filters</h4>
            <p class="help-text mb2"><span class="has-tip add-image" data-tooltip data-allow-html="true" data-position-class="bottom" data-disable-hover="false" title="Hold the <code>shift</code> or <code>ctrl/cmd</code> keys to select multiple options. Click anywhere outside of dropdown to apply filter or press <code>enter</code>.">Select one or more</span> of each filter to reduce the records.</p>

            <div id="ecorefFilter" data-group-filter="publications">
                <label for="selFilterEcoref">Reference <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterEcorefDropdown">Loading&hellip;</button>
                <div id="selFilterEcorefDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true">
                <select disabled multiple name="selFilterEcoref" id="selFilterEcoref"
                        data-filter-param="ecoref" data-category="Publications"></select>
                </div>
            </div>

            <div id="chemGrpFilter" data-group-filter="chemicals">
                <label for="selFilterChemGroup">Chemical Group <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterChemGrpDropdown">Loading&hellip;</button>
                <div id="selFilterChemGrpDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true">
                <select disabled multiple name="selFilterChemGroup" id="selFilterChemGroup"
                        data-filter-param="chemlistid" data-category="ChemGroup"></select>
                </div>
            </div>

            <div>
                <label for="selFilterCAS">Chemicals <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterCASDropdown">Loading&hellip;</button>
                <div class="dropdown-pane filter" data-dropdown data-hover-pane="true" id="selFilterCASDropdown">
                <select disabled multiple name="selFilterCAS" id="selFilterCAS"
                        data-filter-param="casid" data-category="Chemical"></select>
                </div>
            </div>

            <div id="specGrpFilter" data-group-filter="species">
                <label for="selFilterSpeciesGroup">Species Group <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterSpecGrpDropdown">Loading&hellip;</button>
                <div id="selFilterSpecGrpDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true">
                <select disabled multiple name="selFilterSpeciesGroup" id="selFilterSpeciesGroup"
                      data-filter-param="specieslistid" data-category="SpecGroup"></select>
                </div>
            </div>

            <div>
                <label for="selFilterClass">Class <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterClassDropdown">Loading&hellip;</button>
                <div id="selFilterClassDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true" >
                    <select disabled multiple name="selFilterClass" id="selFilterClass"
                            data-filter-param="class" data-category="Class">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterTaxOrder">Order <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterOrderDropdown">Loading&hellip;</button>
                <div id="selFilterOrderDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true" >
                    <select disabled multiple name="selFilterTaxOrder" id="selFilterTaxOrder"
                            data-filter-param="tax_order" data-category="TaxOrder">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterFamily">Family <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterFamilyDropdown">Loading&hellip;</button>
                <div id="selFilterFamilyDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true" >
                    <select disabled multiple name="selFilterFamily" id="selFilterFamily"
                            data-filter-param="family" data-category="Family">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterGenus">Genus <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterGenusDropdown">Loading&hellip;</button>
                <div id="selFilterGenusDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true" >
                    <select disabled multiple name="selFilterGenus" id="selFilterGenus"
                            data-filter-param="genus" data-category="Genus">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterSpecies">Species <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterSpeciesDropdown">Loading&hellip;</button>
                <div id="selFilterSpeciesDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true" >
                    <select disabled multiple name="selFilterSpecies" id="selFilterSpecies"
                            data-filter-param="speciesid" data-category="Species">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterSpecialInterest">Special Interest Groups <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterSpecialInterestDropdown">Loading&hellip;</button>
                <div id="selFilterSpecialInterestDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true" >
                    <select disabled multiple name="selFilterSpecialInterest" id="selFilterSpecialInterest"
                            data-filter-param="special" data-category="Special">
                    </select>
                </div>
            </div>

            <div id="effGrpFilter" data-group-filter="effects">
                <label for="selFilterEffect">Effect Groups <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterEffectDropdown">Loading&hellip;</button>
                <div id="selFilterEffectDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true">
                    <select disabled multiple name="selFilterEffect" id="selFilterEffect"
                            data-filter-param="effectid" data-category="EffectGroup">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterMeas">Effect Measurements <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterMeasDropdown">Loading&hellip;</button>
                <div id="selFilterMeasDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true">
                    <select disabled multiple name="selFilterMeas" id="selFilterMeas"
                            data-filter-param="measurementid" data-category="Effect">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterEndpoint">Endpoints <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterEndpointDropdown">Loading&hellip;</button>
                <div id="selFilterEndpointDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true">
                    <select disabled multiple name="selFilterEndpoint" id="selFilterEndpoint"
                            data-filter-param="endpointid" data-category="Endpoint">
                    </select>
                </div>
            </div>

            <div>
                <label for="selFilterObsDuration">Duration (Observed) - Days <span class="count"></span></label>
                <button class="input select disabled default" disabled type="button" data-toggle="selFilterObsDurationDropdown">Loading&hellip;</button>
                <div id="selFilterObsDurationDropdown" class="dropdown-pane filter" data-dropdown data-hover-pane="true">
                    <select disabled multiple name="selFilterObsDuration" id="selFilterObsDuration"
                            data-filter-param="obsduration" data-category="ObsDuration">
                    </select>
                </div>
            </div>

            <label class="slider-label">Duration (Observed) Range - Days <span class="count"></span>
                <span class="input-group">
                    <input id="txtFilterObsDurMin" name="txtFilterObsDurMin" type="number" class="default" data-filter-param="obsdurmin">
                    <span class="input-group-label center">to</span>
                    <input id="txtFilterObsDurMax" name="txtFilterObsDurMax" type="number" class="default" data-filter-param="obsdurmax">
                </span>
            </label>

            <label class="slider-label">Publication Years <span class="count"></span>
                <cfset minYear = 1915>
                <cfset maxYear = #year(now())#>
                <cfoutput>
                    <span class="input-group">
                    <input id="txtFilterPubYearMin" name="txtFilterPubYearMin" type="number" class="default"
                           placeholder="#minYear#" min="#minYear#" max="#maxYear#"
                           data-filter-param="pubyearmin">
                    <span class="input-group-label center">to</span>
                    <input id="txtFilterPubYearMax" name="txtFilterPubYearMax" type="number" class="default"
                           placeholder="#maxYear#" min="#minYear#" max="#maxYear#"
                           data-filter-param="pubyearmax">
                    </span>
                </cfoutput>
            </label>
            </form>

            <div class="text-center">
                <button class="reset-all button warning">Reset All</button>
                <button class="show-all button" data-toggle="exploreParametersModal">View All Applied</button>
            </div>
        </div>
    </div>
</div>

<div class="reveal" id="exploreParametersModal" data-reveal>
    <h2>All Applied Filters</h2>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
    </button>

    <div id="reviewExploreModal"></div>

    <div class="reveal-footer">
        <button id="exportExploreParams" class="button export">Export</button>
        <button class="button cancel" data-close>Close</button>
    </div>
</div>

<div class="reveal explore-custom-group-modal" id="exploreCustomGroupModal" data-reveal>
    <h2>Create Custom Group</h2>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
    </button>
    <div class="modal-form" data-explore-type="Chemicals">
        <div class="clearfix">
            <div id="customChemicalButtons">
                <a id="custChemBrowse" href="#custChemAsBrowse" class="button primary">Browse Chemicals</a>
                <a id="custChemCAS" href="#custChemAsCAS" class="button secondary">Enter by CAS Number</a>
            </div>
        </div>
        <div class="is-active view" id="custChemAsBrowse">
            <p class="help-text mb2">Enter text to search chemicals by primary name, synonym, or CAS number.  Hold the <code>ctrl/cmd</code> key to select multiple options.  When finished with selections, click 'Explore Data' to see results for the group.</p>
            <p class="help-text mb2"><b>NOTE:</b> This search includes all chemicals currently verified in ECOTOX, however some chemicals may not have test results extracted to ECOTOX.</p>
            <div class="modal-entry">
                <select name="selCustomChemBrowse" id="selCustomChemBrowse" data-browse multiple="multiple" style="width: 100%;"
                    data-custom-chem-group-browse="input"></select>
            </div>
            <div class="reveal-footer">
                <button class="button cancel" data-close>Cancel</button>
                <button class="button success next" data-custom-chem-group-browse="submit" data-close>Explore Data</button>
            </div>
        </div>
        <div class="view" id="custChemAsCAS">
            <p class="help-text mb2">Enter comma separated list of CAS numbers.  Click 'Explore Data' to see results for the group.</p>
            <div class="modal-entry">
            <cfoutput>
                <textarea rows="10" name="txCustomChemCAS" id="txCustomChemCAS" placeholder="Ex: 50000, 7440417"
                    data-custom-chem-group-cas="input"></textarea>
            </cfoutput>
            </div>
            <div class="reveal-footer">
                <button class="button cancel" data-close>Cancel</button>
                <button class="button success next" data-custom-chem-group-cas="submit" data-close>Explore Data</button>
            </div>
        </div>
    </div>
    <div class="modal-form" data-explore-type="Species">
        <div class="clearfix">
            <div id="customSpeciesButtons">
                <a id="custSpecBrowse" href="#custSpecAsBrowse" class="button primary">Browse Species</a>
                <a id="custSpecNCBI" href="#custSpecAsNCBI" class="button secondary">Enter by NCBI TaxID</a>
            </div>
        </div>
        <div class="is-active view" id="custSpecAsBrowse">
            <p class="help-text mb2">Enter text to search species by common name, latin name, or NCBI TaxID.  Hold the <code>ctrl/cmd</code> key to select multiple options.  When finished with selections, click 'Explore Data' to see results for the group.</p>
            <p class="help-text mb2"><b>NOTE:</b> This search includes all species currently verified in ECOTOX, however some species may not have test results extracted to ECOTOX.</p>
            <div class="modal-entry">
                <select name="selCustomSpeciesBrowse" id="selCustomSpeciesBrowse" data-browse multiple="multiple" style="width: 100%;"
                    data-custom-spec-group-browse="input"></select>
            </div>
            <div class="reveal-footer">
                <button class="button cancel" data-close>Cancel</button>
                <button class="button success next" data-custom-spec-group-browse="submit" data-close>Explore Data</button>
            </div>
        </div>
        <div class="view" id="custSpecAsNCBI">
            <p class="help-text mb2">Enter comma separated list of <span class="has-tip add-image" data-tooltip data-allow-html="true" data-position-class="bottom" data-disable-hover="false" title="National Center for Biotechnology Information Taxonomy Database numerical unique identifier (http://www.ncbi.nlm.nih.gov/taxonomy).">NCBI TaxID</span> numbers.  Click 'Explore Data' to see results for the group.</p>
            <p class="help-text mb2"><b>NOTE:</b> Not all species in ECOTOX have been assigned an NCBI TaxID and results are limited to species with data extracted to ECOTOX.</p>
            <div class="modal-entry">
            <cfoutput>
                <textarea rows="10" name="txCustomSpeciesNCBI" id="txCustomSpeciesNCBI" placeholder="Ex: 8355, 45438"
                    data-custom-spec-group-ncbi="input"></textarea>
            </cfoutput>
            </div>
            <div class="reveal-footer">
                <button class="button cancel" data-close>Cancel</button>
                <button class="button success next" data-custom-spec-group-ncbi="submit" data-close>Explore Data</button>
            </div>
        </div>
    </div>
    <div class="modal-form" data-explore-type="Effects">
        <div class="clearfix">
            <div id="customEffectsButtons">
                <a id="custEffectsBrowse" href="#custEffectsAsBrowse" class="button primary">Browse Effect Measurements</a>
                <a id="custEffectsEffMeas" href="#custEffectsAsEffMeas" class="button secondary">Enter by Term</a>
            </div>
        </div>
        <div class="is-active view" id="custEffectsAsBrowse">
            <p class="help-text mb2">Enter text to search effects by Effect term, Effect description, Measurement term, or Measurement description.  Hold the <code>ctrl/cmd</code> key to select multiple options.  When finished with selections, click 'Explore Data' to see results for the group.</p>
            <div class="modal-entry">
                <select name="selCustomEffectsBrowse" id="selCustomEffectsBrowse" data-browse multiple="multiple" style="width: 100%;"
                    data-custom-eff-group-browse="input"></select>
            </div>
            <div class="reveal-footer">
                <button class="button cancel" data-close>Cancel</button>
                <button class="button success next" data-custom-eff-group-browse="submit" data-close>Explore Data</button>
            </div>
        </div>
        <div class="view" id="custEffectsAsEffMeas">
            <p class="help-text mb2">Enter comma separated list of Effect and Measurement term pairs.  The term pair <strong>MUST</strong> be delimited by a "|" (pipe) character, like:<br/></br/>
                <strong>BCM|AFG2, BCM|ALAN, AVO|CHEM...</strong></p>
                <p class="help-text mb2">Click 'Explore Data' to see results for the group.</p>
                <p class="help-text mb2"><strong>Note:</strong> See the <a target="_blank" href="help.cfm?sub=term-appendix"><b>ECOTOX Terms Appendix</b></a> for more information on effect terms.</p>
            <div class="modal-entry">
            <cfoutput>
                <textarea rows="10" name="txCustomEffectsEffMeas" id="txCustomEffectsEffMeas" placeholder="Ex: BCM|AFG2, BCM|ALAN"
                    data-custom-eff-group-effmeas="input"></textarea>
            </cfoutput>
            </div>
            <div class="reveal-footer">
                <button class="button cancel" data-close>Cancel</button>
                <button class="button success next" data-custom-eff-group-effmeas="submit" data-close>Explore Data</button>
            </div>
        </div>
    </div>
</div>