<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>
<cfset GroupFunc = CreateObject("component", "cfc.group_option_functions")>

<cfprocessingdirective suppresswhitespace="yes">

<cfquery name="OptionQuery" datasource="#application.datasource#" dbtype="Oracle80" cachedWithin="#CreateTimeSpan(0,0,5,0)#">
	SELECT
		SUM(DECODE(STANDARD_TEST_SPECIES_YN, 'Y', 1, 0)) as NUM_STD,
		SUM(DECODE(EXOTIC_NUISANCE_YN, 'Y', 1, 0)) as NUM_EXO,
		SUM(DECODE(THREATENED_ENDANGERED_YN, 'Y', 1, 0)) as NUM_END
	FROM ECOTOX_GROUP_SUMMARY3_MV v
	WHERE 1=1

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>
	
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			<cfif len(IN_casList)>                
                <cfif ListLen(IN_casList) LTE 1000>
                    AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                <cfelse>
                    <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                    <cfif ArrayLen(arrayOfLists) GTE 1>
                    AND (
                        <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                            <cfset thisSubList = arrayOfLists[i]>
                            <cfif i GT 1> OR </cfif>                            
                            v.cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                        </cfloop>
                    )
                    </cfif>
                </cfif>
            </cfif>
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND v.dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
			AND v.cas_number IN (
				SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
			)
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>
		
	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
	  	<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
	  	<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
	  	</cfif>
	</cfif>	
	
	<!--- check additional filters --->
	<cfif IN_chemListId neq "All">
		AND v.cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>
	
	<cfif IN_casId neq "All">
		AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>	
	
	<cfif IN_speciesListId neq "All">
		AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>				
	
	<cfif IN_class neq "All">
		AND v.class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND v.tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND v.genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND v.family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND v.species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND v.effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND v.measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(v.effect, v.measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND v.endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>

        <!--- DURATION LOGIC HERE (v.) --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND v.habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND v.publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
		<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
                <!--- algae/moss/fungi split into 3 groups so exclude the old combined group as well (11) --->
		AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (11,13,14,15))
		
</cfquery>


<cfset numStd = 0>
<cfset numExo = 0>
<cfset numEnd = 0>
<cfloop query="OptionQuery">

    <cfif len(OptionQuery.NUM_STD)>
	<cfset numStd = numStd + OptionQuery.NUM_STD>
    </cfif>
    <cfif len(OptionQuery.NUM_EXO)>
	<cfset numExo = numExo + OptionQuery.NUM_EXO>
    </cfif>
    <cfif len(OptionQuery.NUM_END)>
	<cfset numEnd = numEnd + OptionQuery.NUM_END>
    </cfif>
	
</cfloop>

<cfoutput>

	<cfset selStr = "">	
		
		<option value="All" class="default">All</option>
		<option value="--" disabled>------------------</option>

	<cfif numStd gt 0>
		<cfif ListFind(IN_special, "STANDARD_TEST_SPECIES_YN") gt 0>
			<cfset selStr = " selected">
		<cfelse>
			<cfset selStr = "">	
		</cfif>
		<option value="STANDARD_TEST_SPECIES_YN"#selStr#>Standard Test Species</option>
	</cfif>

	<cfif numEnd gt 0>
		<cfif ListFind(IN_special, "THREATENED_ENDANGERED_YN") gt 0>
			<cfset selStr = " selected">
		<cfelse>
			<cfset selStr = "">	
		</cfif>
		<option value="THREATENED_ENDANGERED_YN"#selStr#>U.S. Threatened and Endangered Species</option>
	</cfif>

	<cfif numExo gt 0>
		<cfif ListFind(IN_special, "EXOTIC_NUISANCE_YN") gt 0>
			<cfset selStr = " selected">
		<cfelse>
			<cfset selStr = "">	
		</cfif>
		<option value="EXOTIC_NUISANCE_YN"#selStr#>U.S. Invasive Species</option>
	</cfif>

</cfoutput>

</cfprocessingdirective>