<section id="faq-general" data-magellan-target="faq-general">
  <h3>General Questions</h3>
  <p>By clicking on &ldquo;&plus;&rdquo; you will expand information on that particular question. Clicking &ldquo;&minus;&rdquo; will minimize the information.</p>
  <ul class="accordion mt2" data-accordion data-allow-all-closed="true" data-multi-expand="true">
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What types of data are included in ECOTOX?</h4></a>
         <div class="accordion-content" data-tab-content>
           <p>The ECOTOXicology Knowledgebase (ECOTOX) is a source for locating single chemical toxicity data or aquatic life, terrestrial plants and wildlife.  ECOTOX integrates three previously independent databases - AQUIRE, PHYTOTOX, and TERRETOX - into a unique system which includes toxicity data derived predominantly from the peer-reviewed literature, for aquatic life, terrestrial plants, and terrestrial wildlife, respectively.  Not all data published in the peer review ecotoxicology literature are included in ECOTOX.  You may want to refer to the Limitations section of the complete User Guide for more information.</p>
         </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What types of data are not included in ECOTOX?</h4></a>
        <div class="accordion-content" data-tab-content>
           <p>In order for data to be considered for inclusion into ECOTOX, the author(s) must report valid species and chemical information. If the ECOTOX staff cannot verify the species scientific names or locate the chemical's Chemical Abstract Services registry number and a Collective Indices name, the data record is not included in the database. Only single chemical exposures are included in ECOTOX, therefore results for chemical mixtures are excluded. The author(s) must also report a chemical concentration or application rate associated with an observed effect reported. The exposure duration must be reported in the publications for the data to be included in ECOTOX. Bacteria and virus exposures are not included in the ECOTOX Knowledgebase. In addition, toxicity test data for chemical exposures where only sediment concentrations are reported are excluded from the aquatic database. In general, tests conducted with petroleum (fuel oils) and air pollution (CO2 and ozone except when ozone is dissolved in water) chemicals are also excluded.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What is the intended use of data stored in ECOTOX?</h4></a>
          <div class="accordion-content" data-tab-content>
           <p>There has been an increased emphasis in ecotoxicology to improve and enhance the process by which ecological and human health hazard assessments are performed. This has resulted in a range of activity from the hazard evaluation of new and existing chemicals and pesticides to the evaluation of impact assessments associated with effluent, leachate, and environmental monitoring data. Additionally, research programs within the U.S. EPA which are associated with these efforts are expanding to further support the scientific basis of ecological and human health risk assessments for chemical pollutants. The U.S. EPA and other government agencies have a need for ready access to toxicity information for use in characterizing, diagnosing and predicting effects associated with chemical stressors and to support the development of ecocriteria and thresholds for natural resource use. One of the EPA Office of Research and Development's long-term goals was to facilitate the exchange of credible scientific data and risk assessment information among private and public stake holders. To meet this objective, Great Lakes Toxicology Ecology Division-Duluth (GLTED-Duluth), developed a suite of databases and expert systems that are used by risk assessors and researchers to quickly locate relevant ecotoxicology data and models. These empirical data and predictive models are also used by various EPA Program Offices to support on-going risk assessments and hazard rankings of chemicals stressors, including the setting of benchmarks at Superfund and RCRA sites, setting of permit levels for the Office of Water, and conducting assessments of new and existing chemicals within the Office of Chemical Safety and Pollution Prevention. These data systems can be to identify potential data gaps of chemicals tested from a mechanistically-based quantitative structure activity relationship (QSAR) perspective. Because of the intended use of the data, the databases were constructed to hold data from controlled experiments including laboratory and outdoor field exposures.</p>
           <div class="callout info">
              <h5 class="title">Note</h5>
              <p>Prior to using ECOTOX data for analysis or summary projects, you should consult the original scientific paper to ensure an understanding of the context of the data retrieved from ECOTOX.</p>
            </div>
          </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>How do I cite ECOTOX in my bibliography?</h4></a>
          <div class="accordion-content" data-tab-content>
            <p>To cite ECOTOX in your publications:</p>
            <p>Olker, J. H., Elonen, C. M., Pilli, A., Anderson, A., Kinziger, B., Erickson, S., Skopinski, M., Pomplun, A., LaLone, C. A., Russom, C. L., & Hoff, D. (2022). The ECOTOXicology Knowledgebase: A Curated Database of Ecologically Relevant Toxicity Tests to Support Environmental Research and Risk Assessment. <i>Environmental Toxicology and Chemistry</i>, 41(6):1520-1539. https://doi.org/10.1002/etc.5324</p>
            <p>To cite specific data:</p>
            <p>Curated toxicity data were retrieved from the ECOTOXicology Knowledgebase, U.S. Environmental Protection Agency. http:/www.epa.gov/ecotox/ (note calendar date your retrieval was performed).</p>
          </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>How current is the ECOTOX Knowledgebase?</h4></a>
        <div class="accordion-content" data-tab-content>
          <h4>Data Abstraction </h4>
          <p>The majority of literature reviewed for ECOTOX is from 1972 to the present. After test records are entered and quality assured, the data is updated quarterly to the public website. Although many of the literature searches are broad and do not focus on any particular chemical, ECOTOX also conducts focused data abstraction efforts on chemicals of interest to the Agency. Chemicals that have had significant test records added to the data base are noted in Recent Additions for each update.</p>
          <h4>Literature Searches</h4>
          <p>Literature acquisition searches are continually conducted by our staff for possible inclusion into the ECOTOX Knowledgebase.  Please note that even though our literature searches attempt to be comprehensive, they may not locate all relevant literature to every research project.  Users may want to conduct searches based on research interests to ensure capturing relevant research data that may not be acceptable for inclusion into the ECOTOX Knowledgebase.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Will GLTED-Duluth conduct a search of the ECOTOX Knowledgebase for me?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>Unfortunately, we do not have sufficient support staff to do specialized searches of the databases/expert systems for our client-base. However, please contact the ECOTOX Support Staff for help with conducting a search or for further information on how data searches could be conducted.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Why are parameters appearing in my search that I did not apply to my query?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>If you are seeing species, endpoints, chemicals, etc. that you did not search, it is possible that you may be experiencing network issues. If you have a slow or low-quality network connection, it is possible that not all parameters were applied to the query and you may see different search results than expected.</p>
		  <p>It is recommended you check your internet and network connection and then try and run your search again. If you are still experiencing problems, consult ECOTOX Support.</p>
        </div>
    </li>
  </ul>
</section>

<section id="faq-literature" data-magellan-target="faq-literature" class="mt2">
  <hr>
  <h3>Literature Questions</h3>

  <ul class="accordion mt2" data-accordion data-allow-all-closed="true" data-multi-expand="true">
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>How do you locate and identify relevant ecological effects data in the open literature?</h4></a>
        <div class="accordion-content" data-tab-content>
           <p>Relevant literature for ECOTOX is retrieved using a comprehensive search strategy. The strategy is designed to locate worldwide aquatic and terrestrial ecological effects literature. Chemical specific literature search strategies are also conducted, but generally, the literature searches intersect general habitat and test condition terms with general effects and endpoint terms. Exclusion terms are used to eliminate non-applicable studies, and these terms are examined extensively to ensure that they do not inadvertently eliminate applicable literature. ECOTOX staff also review publications in the GLTED-Duluth library holdings and identify applicable papers for acquisition. Publications are continually and systematically acquired and reviewed. In addition to the published literature, computerized data files from the public sector and available unpublished reports are also acquired and critiqued for inclusion into the Knowledgebase.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Will GLTED-Duluth provide copies of papers cited in ECOTOX?</h4></a>
        <div class="accordion-content" data-tab-content>
           <p>As a policy, EPA does not provide copies of publicly available documents from the ECOTOX files. This is because most publications are copyrighted and we are not designated as a lending library. If you are interested in locating publications cited within ECOTOX, you should:</p>
            <ul>
              <li>Attempt acquisition through a local (agency, institute, company, public) library. If you are unsuccessful through your local library, consult our list of <a href="help.cfm?sub=mr-related#related-document">document suppliers</a> to purchase the publication.</li>
              <li>For ECOTOX citations associated with independently compiled data sets, you need to contact the <a href="help.cfm?sub=mr-databases#databases-stewards">data steward</a> to obtain a hard copy of the publication. A notation displays within the ECOTOX citation (e.g., OECDG, OECDN, OECDF, MEDxx, OPP, USGS, RUSSN) when data are associated with these data sets.</li>
              <li>If you have pursued all acquisition steps listed above and cannot locate a source for the publication, contact the ECOTOX Support staff (<a href="mailto:ecotox.support@epa.gov">ecotox.support@epa.gov</a>) for further assistance.</li>
              <li>Copies may be provided for difficult to obtain publications (e.g., internal government reports, non-English publications not typically held by U.S. libraries).</li>
            </ul>
        </div>
    </li>
  </ul>
</section>

<section id="faq-species" data-magellan-target="faq-species" class="mt2">
  <hr>
  <h3>Species Questions</h3>
  <ul class="accordion mt2" data-accordion data-allow-all-closed="true" data-multi-expand="true">
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What species are included in ECOTOX?</h4></a>
        <div class="accordion-content" data-tab-content>
           <p>Aquatic data records are limited to test organisms that are exclusively aquatic (saltwater and freshwater). Species that are associated with the water but do not have gills, such as ducks and geese, are included in the Terrestrial data records. Amphibians are included in both Aquatic and Terrestrial data output records, with the life stages that exist exclusively in the water (e.g., tadpole) located in Aquatic data records and the terrestrial life-stage (e.g., adult) in Terrestrial data records. Bacteria and viruses are not included in ECOTOX. ECOTOX's primary focus is wildlife species, but when data gaps exist for a particular chemical, data for domestic species are included. ECOTOX also includes terrestrial plant data and effects, primarily from agricultural chemicals and predominantly agricultural species.</p>
        </div>
    </li>
  </ul>
</section>

<section id="faq-display" data-magellan-target="faq-display" class="mt2">
  <hr>
  <h3>Display and Content Questions</h3>
  <ul class="accordion mt2" data-accordion data-allow-all-closed="true" data-multi-expand="true">
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Some of the data in the ECOTOX reports are in a term format. Where can I get a copy of the definitions?</h4></a>
        <div class="accordion-content" data-tab-content>		
           <p>You can find detailed effect measurement terms and descriptions in the <a target="_blank" href="help.cfm?sub=term-appendix"><b>ECOTOX Terms Appendix</b></a>.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What does the AI | F | T | D | L | U  mean in the concentration field in my aquatic output?</h4></a>
        <div class="accordion-content" data-tab-content>
          <ul>
            <li>(AI) ACTIVE INGREDIENT: Chemical substance in a product that is responsible for the pesticidal (toxic) effect (Ware, 1978). Reported as "A" when the author refers to the concentration as active ingredient, active principle, active substance (A.S.), acid equivalent or various grades of reagents (ie., Analytical, Reagent or Technical). When coding, a value in the publication may be reported as "AI kg/ha", "AE kg/ha" or "kg AI/ha"; this type of value is reported as 'A =' for CONC TYPE.</li>
            <li>(F) FORMULATION: Way in which basic pesticide (toxicant) is prepared for practical use (Ware, 1978). Generally reserved for commercial preparation prior to actual use and does not include the final dilution (Insect-Pest Management and Control, 1971) (e.g.; Baythroid, 2,4-D). Also included in this category are organic compounds with no pesticidal activity (e.g.; PCB, dioxin).</li>
            <li>(T) TOTAL: The concentration of metals determined on an unfiltered sample after vigorous digestion, or the sum of the concentrations of metals in both dissolved and suspended fractions (APHA et.al. 1992). Heavy metals and single elements (e.g. Na, Cl, Br) are entered as T.</li>
            <li>(D) DISSOLVED: Those constituents of an unacidified sample that pass through a 0.45 um membrane filter (e.g. soluble metal) (APHA et.al. 1992).</li>
            <li>(L) LABILE: The labile or free ion metal concentration determined by various analytical methods. When coding, the specific labile forms or complexes are not differentiated.
(U) UN-IONIZED: The undissociated, uncharged form of ammonia or hydrogen sulfide. The ammonia molecule, NH3, is the unionized form. (In aqueous solution, ammonia assumes an equilibrium between NH3 and NH+4.) The NH3 is the toxic entity of the ammonia compound (Rand and Petrocelli, 1985).</li>
            <li>(U) UN-IONIZED: The undissociated, uncharged form of ammonia or hydrogen sulfide. The ammonia molecule, NH3, is the unionized form. (In aqueous solution, ammonia assumes an equilibrium between NH3 and NH+4). The NH3 is the toxic entity of the ammonia compound.</li>
          </ul>
        </div>        
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What does it mean when I see an asterisk (*) or forward slash (/) in my data output?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>The asterisk (*) denotes several meanings depending upon the field you are viewing. An asterisk can be used in these fields:</p>
          <ul class="mb1">
            <li><i>Concentration:</i> This means the reported concentration has been recalculated to meet database conformity. For example, the concentration unit was reported as Molar units, but the standard database unit is micrograms per liter. Another example would be if the reported value was as a metal compound and it was recalculated to the ion level. Note: These recalculations are no longer performed.</li>
            <li><i>Endpoint</i>: This denotes the reported endpoint acronym provided was modified to conform to the standard database acronym terminology. For example, if the author reported a TLM, the endpoint was extracted as an LC50*. The author reported acronym should appear in the EE Remark field.</li>
            <li><i>Percent Effect:</i> The survival of organisms was recalculated to mortality. For example, 20% survival is reported in our database as 80*% mortality.</li>
            <li><i>Water and Soil Chemistry</i> (temperature, hardness, alkalinity, pH, dissolved oxygen, salinity, conductivity, organic carbon): The author did not report the test water or soil chemistry, but did report the dilution or control parameters. Note: The actual test water or soil chemistry is reported without the asterisk.</li>
          </ul>
          <p>The forward slash (/) denotes that a comment is associated with the data in the data field. Header(s) that are associated with the data field where the comment appears (see the ECOTOX User Guide Appendix H for headers) and the comment(s) are usually found in the Other Effects, General Comments, Test Comments or Result Comments data fields. For example, doses may be reported based on a time weighted average. The dose would be entered and an associated comment is entered "DOSES/TIME WEIGHTED AVERAGE//"</p>
        </div>
    </li>
     <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>How do I locate statistical packages from EPA to calculate LC50s?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>You should refer to the <a href="https://www.epa.gov/water-research/ecological-exposure-research-water">EPA Ecological Exposure Research</a> web site for software and guidance on calculations used in toxicity testing.</p>
        </div>
     </li>
     <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What is the difference between the Result Number, Test Number, Location Number, and Test Number?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>The ECOTOX Result Number is a unique record number for each individual result record in ECOTOX. The ECOTOX Test number is a unique number for each individual test record (may have multiple results) in the ECOTOX data base. The Location Number and Test Numbers are historical numbers used to denote unique results in from previous database versions.</p>
          <p>When the terrestrial and aquatic data were merged into one database in March 2012, new result and test numbers were generated for some records. The previous Location Number (prior to March 2012) has been retained and is used as the current ECOTOX Result Number for aquatic records. New Test Numbers were generated for aquatic records as the previous aquatic Test Numbers were never displayed in the prior public versions. The old Test Number was retained as the current Test Number for terrestrial records. New Result Numbers were generated for terrestrial records as the previous terrestrial Result Numbers were never displayed in the prior public versions.</p>
        </div>
     </li>
     <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Why can't I see the actual BCF/BAF values when I run my search?</h4></a>
        <div class="accordion-content" data-tab-content>
		  <h4>Aquatic</h4>
          <p>BCF/BAF values are not a default display setting. You can change which displays are shown once you have run your search. To change your output display so that BCF/BAF values are shown, click the green 'Customize Output Fields' button after you have run your search. Click the checkbox next to 'BCF/BAF Value', and click the green 'Save' button on the Display Fields screen. Your search will requery with your new display output.</p>
		  <h4>Terrestrial</h4>
		  <p>BCF/BAF values are not a default display setting. You can change which displays are shown once you have run your search. To change your output display so that BCF/BAF values are shown, click the green 'Customize Output Fields' button after you have run your search. Click the checkbox next to 'Observed Response/BCF/BAF', and click the green 'Save' button on the Display Fields screen. Your search will requery with your new display output.</p>
		  </div>
     </li>
     <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>When I Explore Effects, why is the number of effects returned in the Group Summary different from the number of Effect Measurements displayed in the filter sidebar?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>Since some effects share the same effect-measurement term, a summary record is displayed for each effect group, but only once in the sidebar filter. For example, the effect measurement "Abnormal" is used by Development, Growth, Histology, Morphology and Reproduction effects.</p>
        </div>
     </li>
     <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Why does the 'Effect x Chem' plot in Explore show data points, but the data table below is empty?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>This condition is possible if you happen to zoom with click-and-drag without actually selecting a data point.  In this case, nearby data points associated with the closest Effect group on the x-axis may be displayed.</p>
        </div>
     </li>
     <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>When using the concentration range slider in Explore plot view, how do I zoom out by concentration value?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>The concentration range slider in Explore plot view allows a user to zoom in on a smaller range for chemical concentration (y-axis), similar to using the zoom on the plot itself.  Each time a user makes a selection with the slider, the slider's endpoints rescale to correspond to the new minimum and maximum concentration values.  The user can continue to refine within this new range of concentration values.  Hitting the 'Reset' button at the top of the plot will restore both the original plot and concentration range values.</p>
        </div>
     </li>
      <li class="accordion-item" data-accordion-item>
        <a href="#" name="postexpmeasurements" class="accordion-title"><h4>What are Post-exposure Measurements and how do I search them?</h4></a>
        <div class="accordion-content" data-tab-content>
            <p>If a study includes observations of organisms after the chemical exposure has been discontinued, these measurements are identified as "Post-exposure Measurements".
Records for post-exposure measurement data can be found by comparing the duration fields, where the Observed Duration will be greater than the Exposure duration.
</p>
        </div>
      </li>
  </ul>
</section>

<section id="faq-chemical" data-magellan-target="faq-chemical" class="mt2">
  <hr>
  <h3>Chemical Questions</h3>
  <ul class="accordion mt2" data-accordion data-allow-all-closed="true" data-multi-expand="true">
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>How do I locate CAS numbers?</h4></a>
        <div class="accordion-content" data-tab-content>
		  <p>On the "Search" page, under All Chemicals search parameter there is a link to the "US EPA CompTox Chemicals Dashboard" that can give you the CAS number for the chemical of interest.</p>
          <p>You can also locate CAS numbers for common pesticide names on other web sites:</p>
		  <p><span class="disclaimer">The following links exit the site <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></span></p>
          <ul>
             <li><a href="http://www.alanwood.net/pesticides/index.html">Compendium of Pesticide Common Names</a></li>
             <li><a href="http://www.sigmaaldrich.com/">Sigma-Aldrich</a></li>
             <li><a href="http://www.tcichemicals.com/">TCI America Exit</a></li>
             <li><a href="http://www.chem.com/catalogs">WWW Chemicals Catalog</a></li>
           </ul>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>When I search on a chemical synonym, why does a different name display in my output?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>Chemical synonyms are searchable, but the report will display the ECOTOX preferred name (usually the CAS 9th collective index name) and associated CAS number. You can verify chemical data displayed in the results if you are unsure by clicking on the link to the "US EPA CompTox Chemicals Dashboard" found in the All Chemicals search parameter and locating the related chemical information.</p>
        </div>
    </li>
  </ul>
</section>

<section id="faq-report" data-magellan-target="faq-report" class="mt2">
  <hr>
  <h3>Report and Printing Questions</h3>
  <ul class="accordion mt2" data-accordion data-allow-all-closed="true" data-multi-expand="true">
    <li class="accordion-item" data-accordion-item>
      <a href="#" class="accordion-title"><h4>How do I export data that can be moved into my PC spreadsheet or database?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>Under the "Search" function pages, you can select "Export as.." and choose either an Excel or delimited file export. Under the "Explore" function pages, you can export as .csv file. Each type of exported file will allow you to save your file which can then be imported into spreadsheets or other databases to manipulate or sort the data for your purposes. Each delimited data field is separated by a vertical bar (|) and each record will appear on a separate line.</p>
        </div>
    </li>
      <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Why do I frequently have to use the scroll bars to see and use all the buttons and links on a page?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>The ECOTOX Web Site was designed to be viewed with a minimum screen resolution of 800x600, and users with older PC's or small monitors may be using a lesser resolution such as 640x480. The lower resolutions will cause many of the pages to be truncated on your screen and will require using scroll bars. There are also pages on the site that do not display well even in the 800x600 format and this is simply due to the amount of information contained in the page. Increasing the resolution on your monitor, if possible, may resolve most of the problems you are having.</p>
        </div>
      </li>
      <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>Why does my report show that it was ten pages long but when I print it all out it is much longer?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>The number of pages indicated on the report page navigator refers to "Web" viewable pages which are not always the same size as a printable page. When creating reports it is difficult if not impossible to determine whether the resulting document will print on a single page, so report pages are instead based on a certain number of records per page. The record limits were chosen to present as much information per page as possible without making them to too long to comfortably read in a browser and to avoid having too many short pages to comfortably navigate and manage.</p>
        </div>
      </li>
      <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>How do I decrease the number of records retrieved by my search?</h4></a>
        <div class="accordion-content" data-tab-content>
         <p>Selecting more search parameters should decrease the number of records retrieved. Review the possible search options (<a target="_blank" href="pdf/ECOTOX_Search_Planner_form.pdf"><b>ECOTOX Search Planner (PDF)</b></a> (5 pp, 44 K, <a target="_blank" href="https://www.epa.gov/home/pdf-files">About PDF</a>)) to decide if additional selections can be made.</p>
        </div>
      </li>
      <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What if the number of records retrieved is over the maximum limit, but I want results for the search selections I made?</h4></a>
        <div class="accordion-content" data-tab-content>
           <p>If you want specific search parameters, but the number of records retrieved is too great to view, you may want to add a publication year filter. The publication year strategy allows to you to output your search in sections and export output.  You can then collate data records together for a complete report. You will need to select ranges of publications years (e.g., 1990-2000) that fits within the record limits. Example: Intersect search with publication years 1915-1980, then years 1981-1996, then years 1997-2017.</p>
        </div>
      </li>
      <li class="accordion-item" data-accordion-item>
        <a href="#" name="distinct" class="accordion-title"><h4>What is the difference between 'Total Records' and 'Distinct Records' in the "Explore" function?</h4></a>
        <div class="accordion-content" data-tab-content>
			<p>The Total Records count is reflective of all data represented by your search parameters. A Distinct Record is one that shares a Chemical, Species Common Name, Effect, Effect Measurement, and/or Endpoint. The records in the Total Records count may differ by study design attributes such as pH, duration, organism lifestage, etc. which are not differentiated in the Records table or on the interactive plots. Therefore, the Total Records count is generally higher than the Distinct Record count.</p>
			<p>As an example, while using "Explore" function, you may retrieve one Distinct Record and two Total Records. The difference between these two records could be that in one record the fish was exposed in water with a pH of 6, while the other was exposed in water with a pH of 7. This difference would not be reflected in the "Explore" Records table or on the plots. In these instances, records are displayed on one row in the table or together on the plot if all else remained the same. To figure out how the study design of these records differs, you should consult the original publication.</p>
        </div>
      </li>
  </ul>
</section>

<section id="faq-aster" data-magellan-target="faq-aster" class="mt2">
  <hr>
  <h3>ASTER Questions</h3>
  <ul class="accordion mt2" data-accordion data-allow-all-closed="true" data-multi-expand="true">
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What is ASTER?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>ASTER (ASsessment Tools for the Evaluation of Risk) was developed by the U.S. EPA to assist regulators in performing ecological risk assessments. ASTER was developed with funding from the U.S. EPA Office of Solid Waste and Emergency Response. The objective was to devise software that could assist regulators in hazard ranking and the development of comprehensive risk assessments. ASTER is a web based application which integrates database information and quantitative structure activity relationships (QSARs) to assess the environmental risk of discrete chemicals. ASTER integrates the ECOTOX toxic effects database and the QSAR (Quantitative Structure Activity Relationships) system, a structure-activity based expert system. ASTER is designed to provide high quality data for discrete chemicals, when available in the associated databases, and mechanistically-based QSAR estimates when data are lacking. Searches are conducted by identifying a chemical of interest using the Chemical Abstract Service registry number, a chemical name, or a SMILES string. For more information about ASTER see the <a href="help.cfm?sub=mr-databases#aster">Aster Product entry</a> under 'Related Websites'.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>What is SMILES?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>SMILES (Simplified Molecular Input Line Entry System) is a chemical notation that allows a user to represent a chemical structure in a way that can be used by the computer. SMILES is an easily learned and flexible notation. The SMILES notation requires that you learn a handful of rules. You do not need to worry about ambiguous representations because the software will automatically reorder your entry into a unique SMILES string when necessary. SMILES was developed through funding from the U.S. EPA's Office of Research and Development's Duluth laboratory to the Medicinal Chemistry Project at Pomona College, Claremont, CA and the Computer Sciences Corporation, Duluth, MN. View the <a href="help.cfm?sub=glossary#smiles">SMILES glossary entry</a> for additional information.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>How do I access ASTER?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>Effective September 15, 2022, ASTER has been <strong>decommissioned</strong>. For a limited time, ECOTOX Support Staff (<a href="mailto:ecotox.support@epa.gov">ecotox.support@epa.gov</a>) will provide support for offline ASTER Searches requested by EPA staff members, EPA contractors, and employees of other government (tribal, local, state, national, international) agencies. Please provide SMILES string(s) and/or CAS Registry number(s) for chemical(s) of interest. Persons affiliated with government contracts/extramural agreements must submit their search requests through the funding governmental agency's Project Officer. Consider using an alternative QSAR application. Please visit 'Other Tools' on the ASTER site: (<a target="_blank" href="https://q2626xmnay001.aa.ad.epa.gov/aster/">https://q2626xmnay001.aa.ad.epa.gov/aster/</a>) for a list of alternative QSAR applications.</p>
        </div>
    </li>
    <li class="accordion-item" data-accordion-item>
        <a href="#" class="accordion-title"><h4>When will ASTER be available on the WWW?</h4></a>
        <div class="accordion-content" data-tab-content>
          <p>Due to security restrictions there are no plans to release a public Internet version of ASTER.</p>
        </div>
    </li>
  </ul>
</section>
