<div class="callout primary mb2">
  <p>
    <a target="_blank" href="pdf/searchplanner.pdf">Search Planner (PDF)</a> (5 pp, 104 K, <a target="_blank" href="https://www.epa.gov/home/pdf-files">About PDF</a>)
  </p>
</div>

<section id="parameters-taxonomic" data-magellan-target="parameters-taxonomic">
	<h2>Taxonomic Searching</h2>
	<p>Within ECOTOX you may conduct a search by entering the Species Name or number(s), Genus/Species Name(s), or Common Name or Other Taxonomic Name(s).  The Contains and Exact Match radio buttons allow for partial or exact name matches.  You can also search by Species Group. All data records within ECOTOX include a Scientific name for the test species. All names and predefined groups have been verified in <a href="help.cfm?sub=wi-documentation#documentation-verification">reliable taxonomic sources</a>.</p>
	<p>The ECOTOX species file includes historical synonyms for the species. If a search is conducted using a species name that is noted as a taxonomic synonym in our system, ECOTOX will present the results using the currently acceptable genus and species name.</p>
	<h3>Taxonomic Entry</h3>
	<p><b>Species Number:</b> All species in ECOTOX have been assigned a unique number. You can include numbers and text information (either Scientific or common names) in one search. Species numbers are always searched as an exact match.</p>
	<h4>Example Taxonomic Search</h4>
	<p>The example below is the correct method of entering query text. You can enter a mix of numbers and species terms. Number will always be treated as exact matches by the ECOTOX query.</p>
	<p>Example Genus/Species Name Query</p>
    <textarea rows="5" class="input-group-field mb1" disabled wrap="hard" style="white-space: pre">
      Pimephales promelas
      Daphnia
      Salmo
      2371
      Oncorhynchus mykiss</textarea>
	<p>If you are storing your species records in another source (like a spreadsheet), you may cut and paste the values into this search box.</p>	
	<h3>Predefined Taxonomic/Species Groups</h3>	
	<p>The option to select from predefined lists is available in both the "Search" and "Explore" function pages. Species lists have been provided to effectively search a variety of species groups.</p>
	<p>You may remove and/or view the individual species within a list by clicking on the "View/Modify Entries for Selected Group(s)" button located directly below the "Any Species Group" check boxes.</p>
	<p>Taxonomic kingdom (plant or animal) searching is available in "Search". The kingdom is searched using a radio button option located within "All Species" as "Plants" for the plant kingdom or "Animals" for the animal kingdom.  You cannot view or modify the individual Animal and Plant species groups due to the large number of species within these lists but each group can be searched as a whole.</p>
	<p>The plant kingdom search also includes species representing Monera and Fungi. Some test results report both plant and animal species as one effect measurement (e.g., aquatic community, plankton, soil community). These results will be included when either plant, animal or both kingdoms are selected.</p>
        <section id="parameters-special" data-magellan-target="parameters-special">
	<h3>Special Interest Taxonomic/Species Groups</h3>	
	<p>In addition to searching by predefined Taxonomic/Species groups, users may add filters in Special Interest categories such as "Standard Test Species", "U.S. Threatened/Endangered Species", and "U.S. Invasive Species".  To see the list of species in these groups, click the links below.</p>
	<ul>
		<li><a data-open="specialInterestGroups" data-special data-listid="Standard">Standard Test Species</a>  <span class="help-text ml1"><strong>Note:</strong> The Standard Test Species List was last updated <cfoutput>#Application.currentUpdate["last_update_std_test_spec"]#</cfoutput>.</span></li>
		<li><a data-open="specialInterestGroups" data-special data-listid="Endangered">U.S. Threatened/Endangered Species</a>  <span class="help-text ml1"><strong>Note:</strong> The Endangered Species List was last updated <cfoutput>#Application.currentUpdate["last_update_endangered_spec"]#</cfoutput>.</span></li>
		<li><a data-open="specialInterestGroups" data-special data-listid="Invasive">U.S. Invasive Species</a>  <span class="help-text ml1"><strong>Note:</strong> The Invasive Species List was last updated <cfoutput>#Application.currentUpdate["last_update_invasive_spec"]#</cfoutput>.</span></li>
	</ul>
	</section>
</section>
<hr>
<section id="parameters-chemical" data-magellan-target="parameters-chemical">
	<h3>Chemical Entry</h3>	
	<p>To conduct a search, type in the CAS Registry number(s) and/or chemical name(s) into the search box. Partial chemical names may be used when typed into the search box, and all chemicals with that text string as part of the name will be included in the output if the Contains radio button is selected. Selecting the Exact Match will retrieve the exact string entered. CAS Registry numbers are always treated as exact entries.</p>
	<p>You can search for an unlimited number of entries and each entry must be entered on a separate line, but you can mix numbers and name entries.</p>
	<p><b>CAS Registry Number:</b> Enter the CAS Registry number(s) you wish to search. You may enter the CAS Registry number with or without hyphens and leading zeros. CAS number queries are always exact matches.</p>
	<p><b>Chemical Name:</b> ECOTOX now includes searching based on chemical synonyms. Enter the names of the chemicals you wish to search on, placing each name in a separate field. It is recommended that you search on CAS Registry numbers when you want to specifically restrict your search to selected chemical(s).</p>
	<h4>Example Chemical Search</h4>
    <p>The example below is the correct method of entering query text.</p>
    <textarea rows="6" class="input-group-field mb1" disabled wrap="hard" style="white-space: pre">
      99865
      Cadmium chloride
      99898
      Metolachlor
      Malathion
      100027</textarea>
    <p>If you are storing your chemical records in another source (e.g., spreadsheet), you may cut and paste the values into the search box.</p>
	<h3>Predefined Chemical Groups</h3>	
	<p>The option to select from predefined lists is available in both the "Search" and "Explore" pages. To select a chemical group, click on the check box you want to search. To unselect, click on the checkbox again.</p>
	<p>You may remove and/or view the Individual chemicals within a list by clicking on the "View/Modify Entries for Selected Group(s)" button located directly below the Chemical List check boxes. Within the Metal or Organometal Compounds group, each compound represents all reported forms of the compound.  For the Organic Compounds group, the chemicals are grouped together by class of compound.</p>
</section>
<hr>
<section id="parameters-conditions" data-magellan-target="parameters-conditions">
	<h2>Test Conditions</h2>
    <p>For each toxicity test record, pertinent information on testing procedures reported by the authors are extracted to the database. Search selections available on this page are test location, exposure media, exposures type and method of chemical analysis, and are briefly described below. These options are only available in the "Search" function page.</p>
	<h3>Test Location</h3>
    <p>The valid entries for test location are Lab (laboratory), Field (all outdoor field tests, artificial, natural or undeterminable) and Not Reported (i.e., the author(s) did not present sufficient information to determine test location). The default within ECOTOX is that all data, regardless of test location, are included in your search result. To selectively search on a specific test location, click to mark the appropriate checkbox.</p>
	<h3>Exposure Media</h3>
	<p>The default within ECOTOX is that all data, regardless of test media, are included in your search result. To selectively search on a specific exposure type, click to mark the appropriate checkbox.</p>
	<p>Aquatic freshwater tests include those conducted in freshwater, reconstituted water, distilled water, or tap water. Saltwater tests include those conducted in natural or artificial seawater, brackish water, or estuarine water. Not  Specified (NR) is used if a determination cannot be made regarding the use of either freshwater or saltwater.</p>
	<p>Terrestrial exposure media selections are focused on tests using a substrate (e.g., soil or artificial media). If the terrestrial organism does not utilize a substrate for nutrition (e.g., birds, mammals), do not select any exposure media types.</p>
	<h3>Any Exposure Type</h3>
        <p>ECOTOX includes chemical exposures on whole living organisms as well as organisms that are not intact (defined as in vitro). For example, in vitro exposures can contain studies using excised organs and cell cultures. Inclusion of in vitro studies into ECOTOX have the same species criteria requirements as those for whole organisms in that they need to be ecologically relevant and would exclude humans, monkeys and laboratory animals (rats and mice).</p>
        <p>You can select the exposure type by clicking the items in the search selection box area. Organisms are typically exposed to toxicants through aqueous or terrestrial means via diet, injection, in vitro, topical or environmental routes. Occasionally, an exposure may be through multiple routes or just via aquatic systems. To select any exposure types of interest, click on multiple items in list.</p>  
	<h3>Any Control Type</h3>
	<p>Control Type allows you the capability to filter out test records based on <u>whether or not</u> the authors reported test control types as well as being able to select specific control type(s).</p>
	<p>You can select "Any Control Types", "ECOTOX Historical Control Types" or "Control Not Reported". Individual control types may be selected by choosing the appropriate check box(es) from the following options:</p>
    <h4>All Controls</h4>
	<div class="ml2">
		<p><b>ECOTOX Control Types</b></p>
		<ul>
			<li>Concurrent (C) - run simultaneously with the exposure</li>
			<li>Multiple (M) - multiple type of controls reported, noted individually</li>
			<li>Baseline (B) - parameters measured before administration of test chemical</li>
			<li>Other (O) - control is run in a different system than exposures</li>
			<li>Solvent (V) - exposed to carrier or solvent only</li>
			<li>Positive (P) - an exposure that causes a desired effect in the experiment</li>
			<li>Undefined (K) - control is presented but without accompanying methodology</li>
		</ul>
		<p><b>Historical ECOTOX Control Types</b></p>
		<ul>		
			<li>Insufficient (I) - not enough information presented to determine control type</li>
			<li>Multiple Controls (OK) - multiple type of controls reported</li>
			<li>Satisfactory (S) - run in the same system, low mortality</li>
			<li>Unsatisfactory (U) - chemical entered control, high mortality</li>
		</ul>
		<p><b>Control Not Reported</b></p>
		<ul>
			<li>No Control Used (Z) - author state no control used</li>
			<li>Not Reported (NR) - was not reported</li>
		</ul>
	</div>
    <h3>Any Chemical Analysis</h3>
    <p>The method of chemical analysis allows you the capability to filter out test records based on <u>whether or not</u> the authors reported chemical concentrations as measured or nominal values. The default within ECOTOX is that all data are included in your search result.  To refine output, select the appropriate checkbox from the following options:</p>
    <ul>
		<li>Measured - Exposure and/or observation concentrations or doses are quantitative; analysis methods may be reported.</li>
		<li>Unmeasured - Exposure and/or observation concentrations or doses are clearly identified as nominal values; or when the author does not report whether the concentrations were measured or nominal, i.e., unmeasured is used as a default value when there is no information provided about the reported chemical concentrations.</li>
		<li>Not Reported - Exposure and/or observation concentrations or doses are not reported.</li>
    </ul>
    <h3>Duration</h3>
    <p>Specify Duration (Observed) allows you the capability to filter the results to a specific value or range for the Observed Duration (in days). The Observed Duration is the time at which an effect measurement was observed/measured and reported (for example, a 24-hour LC50). The Observed Duration may be different than the Study Duration and Exposure Duration. For example, measurements may be taken at intervals within a study, resulting in several records with Observed Durations shorter than the Study Duration. The Observed Duration for effects measured post-exposure will be greater than the Exposure Duration. You can enter a specific duration or range of durations in text boxes, in days, to filter to the selected value(s) from the records that are able to be converted to a standard unit (days).</p>
</section>
<hr>
<section id="parameters-results" data-magellan-target="parameters-results">
	<h2>Test Results</h2>
    <p>For each toxicity test record, pertinent information on test results presented by the authors are extracted to the database. This web page contains search selection boxes related to test results for endpoints and effects.</p>
	<h3>All Endpoints</h3>
    <p>The default within ECOTOX is that all effects and endpoints are selected for searching. Endpoint information is extracted if it is reported by the author. For the purposes of ECOTOX, an endpoint is defined as the quantification of an observed effect obtained through statistics or other means of calculation for the express purpose of comparing equivalent effects (e.g., LC50). Many terrestrial plant tests do not have associated endpoints. Prior to 1996, the terrestrial plant database (PHYTOTOX) structure allowed only results based on percent change from control.</p>
    <p>Within the Effects box, you can select the data to include by selecting one or more of the checkboxes:</p>
    <ul>
		<li>Endpoints Reported; statistically-derived, or calculated results (e.g., LC50) as reported by the author or determined by the ECOTOX staff.</li>
		<li>Statistics, No Endpoint; statistically analyzed data but authors did not identify a specific endpoint or one could not be determined by ECOTOX staff.</li>
		<li>Endpoint Not Reported (NR), data not statistically analyzed</li>
    </ul>
    <p>Within the "Search" page, you can click on one or more endpoints within the checkbox to select endpoints to include in your query. The Endpoint selection box is divided into the following sections</p>
    <ul>
		<li>Concentration, Time-Based, BAF/BCF Endpoints Reported: statistically-derived, or calculated as reported by the author or determined by the ECOTOX staff, i.e., ACxx, LC/LDxx, EC/EDxx, IC/IDxx, BMC/BMDxx, LOAEC, LOAEL, NOAEC, NOAEL, MATC, LETC/ATCN, LETH, ZERO</li>
		<li>Time-Based Endpoints: statistically-derived, or calculated as reported by the author or determined by the ECOTOX staff, i.e., LTxx, ETxx</li>
		<li>Bioaccumulation / Bioconcentration factor: statistically-derived, or calculated as reported by the author or determined by the ECOTOX staff, i.e., BCF, BCFD, BAF, LRxx, ERxx, IRxx, LOER, NOER, MATR</li>
		<li>Statistics, No Endpoint: statistically analyzed data but authors did not identify a specific endpoint or one could not be determined by ECOTOX staff</li>
		<li>Endpoint Not Reported (NR): data not statistically analyzed</li>
    </ul>
	<h3>All Effects</h3>
    <p>The option to select based on an effect group is available in both the "Search" and "Explore" pages. The default within ECOTOX is that all effect measurements are selected for searching. For ECOTOX purposes, effect is defined as the observation of a response resulting from the action of a chemical stressor (e.g., mortality). Currently ECOTOX requires that effect information be provided by the author(s) <u>in order for</u> the test to be included in ECOTOX, but historically studies with calculated endpoints that did not clearly define the observed effect were included in the database (e.g., EC50 presented, but observed effect not clearly identified)</p>
    <p>In the "Search" function page, "All Effects" Groups are categorized into major Effect Groupings such as Accumulation, Behavior, Biochemical, Mortality, etc.</p>
	<p>You can conduct a search on one or more group effects in the "Search" page. To refine your search to include specific effects or effect measurements, you can click to select the desired effect(s).  Each effect includes a list of observed measurements. For instance, the Effect Group "Biochemical" includes three effect categories: Biochemical, Enzyme, and Hormone. Within each of these effects there are multiple effect measurements.</p>
	<p>There is also an Effect Measurement search box where you can enter in more specific measurements (e.g. vitellogenin). The Contains and Exact Match radio buttons allow for partial or exact name matches.</p>
    <p><b>Effect Measurements:</b> For further refinement of observed effect information, you may click on the "View/Modify Entries for Selected Effect Measurement(s)" button located at the bottom of the Effect Measurements selection box. A new window will open and display the list of specific measurements for each of the selected effect(s) and/or effect group(s). Measurements include quantitative observations that describe and evaluate biological responses to toxicants. Each effect (e.g., Growth) can have several associated measurements (e.g., length, weight). The ECOTOX Terms Appendix located in the "What is.." section of the Help Center web page provides definitions of the effect measurements used in ECOTOX.</p>
    <p><b>Post-exposure Measurements:</b> Within the "All Effects" menu, the "Exclude Post-exposure Measurements" option allows you to exclude from your search results responses observed during a post exposure period. If you select to search on a specific effect group or effect and select to exclude the post-exposure measurements, your ECOTOX search results will only include effects observed during the direct exposure period of the study. Otherwise, all results are shown. Post-exposure measurements are indicated in the aquatic report by the placement of 'delayed' terminology after the measurement (e.g. Mortality (Delayed)). When using the lookup terms, a tilde (~) character before the effect term (e.g., ~MOR). Under the "Explore" page, all measurements are automatically included.</p>
	<p>In the "Explore" there are numerous Effect Groups. By clicking on the major Effect Group box, you are selecting all effects under that grouping to explore. To refine or filter data, click on the effect measurement in the resulting table, or use the Query Filters on the left of the table.</p>
</section>
<hr>
<section id="parameters-publications" data-magellan-target="parameters-publications">
	<h2>Publications/Updates Searching</h2>
	<h3>Publication Year(s)</h3>
	<p>The default within ECOTOX is that all data, regardless of publication year, are included in the search result. You may refine the default publication year search by either selecting years from the publication year option box. You may want to enter the bordering inclusive years of your data range.</p>
	<p>The aquatic component of ECOTOX contains data from publication years 1915 to present; the terrestrial component of ECOTOX contains data from publication years 1926 to present.</p>
	<h3>Authors</h3>
    <p>Searches may be conducted on specific authors. To search on an author, enter the specific author names in the selection box, one author per line. Partial author names may be searched when typed into the search box; and all authors with that partial name string will be searched. Only authors which have data extracted to the ECOTOX Knowledgebase are returned.</p>
	<h3>Reference Number</h3>
    <p>Searches may be conducted using ECOTOX specific reference numbers. Each publication abstracted for ECOTOX is assigned a unique reference number. These reference numbers appear in all default ECOTOX outputs. To search on a specific reference number, type the specific reference number(s) in the selection box, one reference number per line.</p>
	<h3>Independently Compiled Data</h3>
	<p>ECOTOX includes several independently compiled data sets. Data sets from the Organization for Economic Cooperation and Development (OECD), Russia, Office of Pesticide Programs, the U.S. Geological Survey, and MED are included as subsets of ECOTOX. Further information on these data files, is available in <a href="help.cfm?sub=mr-databases#databases-stewards">Independently Compiled Datasets</a> documentation. The ECOTOX default is that all data sets are included in your search result. You may override the default and restrict your search to only data sets checked in your selection box.</p>
	<h3>Recent Modifications and Additions</h3>
    <p>You may restrict your data records to newly updated or modified data. The Recent Modifications/Additions search box allows searches based on the last ten database updates, which typically span two-three years. This feature is useful if you have a specific query (e.g., list of species and/or chemicals) that you conduct on a regular basis. The default within ECOTOX is that all data, regardless of the date they were added to ECOTOX, are included in your search result.</p>
</section>


<div class="reveal" id="specialInterestGroups" data-reveal>
  <h2>Special Interest Species</h2>
  <button class="close-button" data-close aria-label="Close modal" type="button">
    <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
  </button>

  <div class="flex">
    <div id="specIntLoading" class="loading-overlay"></div>
    <table class="bordered only">
      <thead>
        <th>Latin Name</th>
        <th>Common Name</th>
      </thead>
      <tbody>

      </tbody>
    </table>
  </div>
</div>