<div class="callout primary mb2">
   <p><a target="_blank" href="help.cfm?sub=term-appendix"><b>ECOTOX Terms Appendix</b></a></p>
 </div>
 
<section id="documentation-database" data-magellan-target="documentation-database">
  <h2>Database Overview</2h>
  <h3>Data Sources</h3>
  <p>The primary source of toxicity effect information in ECOTOX is the peer reviewed literature. Pertinent literature is identified through online computerized searches of the international literature. The computerized searches were initiated with the 1970 publication year and continue through to the present. Comprehensive searches are designed to include the effect of nearly all toxic substances on aquatic and terrestrial organisms within the scope of each ECOTOX database systems" guidelines. Commercial literature sources are continually evaluated for relevance to the ECOTOX literature searches. The search strategy is evaluated regarding the success ratio of each search. Additional literature sources include abstract journals, review bibliographies, and the EPA GLTED library collection.</p>
  <p>The abstracts obtained through computerized searches of abstracting databases are screened to identify toxicity references applicable to aquatic and terrestrial habitats. Those references pertinent to one or more of the databases are acquired through a variety of literature acquisition procedures such as author reprint requests, inter-library loans, and commercial sources. As the publications are received, a reference number is assigned for storage and retrieval purposes, and a final check for applicability and duplication is made. A bibliographic sub-file stores the citations and a reprint of each publication is archived.</p>
  <p>Publications used in ECOTOX usually contain unique data. For various reasons authors may report the same data point in a number of publications. If the authors themselves cross-reference the data, ECOTOX extracts the data only once and notes the cross-reference as part of the bibliographic citation. This type of cross-reference most frequently occurs in the publication of a thesis and subsequent journal articles. If the author does NOT acknowledge multiple publications of a single data point, it is likely this data point will occur in ECOTOX as multiple records, each with a differing citation. This type of publication occurs most frequently when data is published in different sources such as a textbook and also a journal article, an agency publication and a journal article, or a regional journal and an international journal.</p>
  <p>Toxicity test data are included unless the data have been cited as published elsewhere. Data reported in review papers are abstracted from the original publication. International publications may be reviewed by ECOTOX staff if either an English abstract or a translated table of data is included. International cooperative efforts with the Organization for Economic Cooperation and Development (OECD) and Russia (Borok Institute) have been used to enhance review of the international literature.</p>
  <p>Data obtained from independently compiled data files must meet the minimum data requirements and quality assurance guidelines defined for each ECOTOX database component. The key data fields that must be included are: test chemical name, test organism, test duration, effect, and effect concentration or application rate. Table 1 outlines the minimum data requirements for each ECOTOX database.</p>
  <p>Table 1: ECOTOX Minimum Data Requirements</p>
  <div class="table-scroll">
    <table>
      <thead>
        <th>
          Requirement
        </th>
        <th>
          AQUIRE
        </th>
        <th>
          PHYTOTOX
        </th>
        <th>
          TERRETOX
        </th>
      </thead>
      <tbody>
        <tr>
          <td><h5>Chemical</h5></td>
          <td>Single chemicals relevant to environmental exposure</td>
          <td>Single chemicals relevant to environmental exposure</td>
          <td>Single chemicals and oils relevant to environmental exposure.</td>
        </tr>
        <tr>
          <td><h5>Species</h5></td>
          <td>Exclusively aquatic plants and animals</td>
          <td>Terrestrial plants</td>
          <td>Air-breathing animals (e.g., includes ducks, whales)</td>
        </tr>
        <tr>
          <td><h5>Effect</h5></td>
          <td>Biological effect on live organisms</td>
          <td>Biological effect on live organisms</td>
          <td>Biological effect on live organisms</td>
        </tr>
        <tr>
          <td><h5>Concentration or Dose Value</h5></td>
          <td>Must have concurrent environmental chemical concentration/dose</td>
          <td>Must have concurrent environmental chemical concentration/dose</td>
          <td>Must have concurrent environmental chemical concentration/dose</td>
        </tr>
        <tr>
          <td><h5>Exposure Duration</h5></td>
          <td>Duration required, except for abstracts</td>
          <td>Duration required</td>
          <td>Duration required</td>
        </tr>
        <tr>
          <td><h5>Concentration</h5></td>
          <td>Endpoints hierarchically extracted. Non-statistically analyzed and qualitative data may be summarized by effect into one test.</td>
          <td>Since February, 2000, all endpoints.</td>
          <td>All endpoints.</td>
        </tr>
      </tbody>
    </table>
  </div>
  <p>Documentation describing the test methods must be provided within the publication. If tests are missing key parameters, the data are rejected. No effort is made to locate unreported data (e.g., authors are not contacted, citations referring to methods used are not obtained). During the incorporation of an electronic data file, a quality assurance check of the CAS number, species scientific name, and reference citation is completed. Data files that have been included in the aquatic dataset are the <a href="help.cfm?sub=mr-databases#minnow">MED fathead minnow acute toxicity database </a>(Center for Lake Superior Studies; University of Wisconsin-Superior, 1984, 1985, 1986, 1988, and 1990), and data sets from France, Germany, the Netherlands and Russia. ECOTOX also includes the U.S. EPA OPP_s Pesticide Ecotoxicity Database for both aquatic and terrestrial toxicity tests.</p>
  <h3>Quality Assurance</h3>
  <p>Quality assurance procedures begin with literature acquisition and cataloging, and continue through the chemical and species verification, the literature review process, data entry, and data retrieval. The ECOTOX literature is abstracted by trained document abstractors. An intensive training period, a well-documented manual (U.S. EPA 2022), and close interaction with the data coordinator help to ensure a high level of accuracy and consistency in the reviewing process. Data entry for all steps of the process is QA'd by an experienced data curator.</p>
  <h4>Aquatic Data Elements</h4>
  <p>Aquatic data includes toxic effect results from exposures of single chemicals to aquatic organisms. Bioassays not included are water chemistry effects (e.g., pH), complex effluents, sediment studies that do not report a water concentration and chemical mixtures. If a publication contains data for a single chemical besides one of the above categories of toxicants, the paper is retained and only the single chemical data are used in ECOTOX. Test organisms are limited to those that are exclusively aquatic. Amphibian and insect data for purely aquatic life stages of the organism are included. Information and data for terrestrial life stages of these organisms is included in the terrestrial database. Classes of organisms associated with the aquatic environment (e.g., birds, mammals, reptiles) are extracted to the terrestrial database. Microbial communities (bacteria and virus) are omitted from the aquatic database. Terrestrial plants tested in hydroponic or nutrient solutions are extracted to the terrestrial database.</p>
  <p>The data elements for each test are grouped by chemical, organism, exposure conditions, and effect endpoint. The test chemical parameters describe the toxicant, the associated CAS registry number, and the grade, purity and/or composition of the toxicant. The test organism parameters define the type of organism and the lifestage being tested. The test conditions identify the test water, test location, exposure type and duration, control parameters, and basic water chemistry. The effect endpoint parameters consist of a term to define the lethal, sublethal, or residue endpoint and the corresponding test chemical concentration.</p>
  <h5>Aquatic Effect Parameter</h5>
  <p>A separate line is extracted for each effect or endpoint from either a unique experimental design or within one design scenario for statistically defined effects or endpoints. If no statistics are used to distinguish endpoints or effects and experimental designs are similar the data may be combined into one data record. Endpoints always require a discrete line. Effects lacking an author reported endpoint may be combined based on statistical representation by the author. Food chain effects are extracted for organisms at the first level of exposure.</p>
  <p>Toxicity test results are primarily reported for observations taken during the chemical exposure. However, when results are reported only for the period of time after the exposure, i.e. recovery or post-exposure measurements, this type of result is noted by using a "~" in conjunction with the endpoint/effect term, e.g., ~MOR for a post-exposure mortality effect.</p>
  <h4>Terrestrial Data Elements</h4>
  <p>Toxicity data includes toxic effect results from exposures of single chemicals to terrestrial organisms. Only quantitative data are abstracted from the publication; qualitative data are excluded. Graphical data may be recorded as ranges and are reported by using &lt;, &gt; or ~ operators with the value.</p>
  <p>Like for aquatic data, terrestrial data include toxic effect results from exposures of single chemicals. Bioassays that are not included are contaminated soils, sediment studies and chemical mixtures. If a publication contains data for a single chemical besides one of the above categories of toxicants, the paper is retained and only the single chemical data are used in ECOTOX. Test organisms are limited to those that are exclusively terrestrial.</p>
  <p>The data elements for each test are grouped by chemical, organism, exposure conditions, and effect endpoint. The test chemical parameters describe the toxicant, the associated CAS registry number, and the grade, purity and/or composition of the toxicant. The test organism parameters define the type of organism, organism source, and the lifestage being tested. The test conditions identify the test location, exposure type and duration, control parameters, and basic soil parameters. The effect endpoint parameters consist of a term to define the lethal, sublethal, or residue endpoint and the corresponding test chemical concentration.
  <p>If the author does not report data for a terrestrial database field, the field will display a "NR" (not reported).</p>
  <p>The terrestrial data identifies sources of alternative data (domestic, laboratory animal or plant toxicity and bioaccumulation information) when there is a paucity of information on wildlife species. Animals associated with the aquatic environment that breathe using lungs (e.g., ducks, beaver, muskrat) are included in the terrestrial database, unless exclusively aquatic (e.g., whales, manatee). Exposures to the aquatic life stages of amphibians and insects are included in the aquatic database. </p>
  <p>Decisions regarding the inclusion of animal terrestrial species are based on published terrestrial wildlife toxicity standard methods and procedures documentation. The priority for the animal portion of the database is wildlife avian species (e.g., mallard, pheasant or bobwhite), mammalian species (e.g., meadow vole, deer mouse or mink), and beneficial invertebrate species (e.g., earthworm, honeybee, leafcutter bee or alkali bee). If data for other species including laboratory, domestic or non-beneficial organisms are reported in a publication, data for all test species are abstracted for ECOTOX inclusion.</p>
  <p>Terrestrial plant data includes native, crop, or weed species. Terrestrial plants tested in hydroponic or nutrient solutions are abstracted for the terrestrial database. Aquatic plant exposures are recorded in the aquatic database portion of ECOTOX.</p>
  <h5>Test Identification</h5>
  <p>Test identification number is used to designate each unique test design. A unique test design may be characterized by a new test chemical, test species, test location, or exposure type. Additionally, there are experimental design parameters that will influence a test scenario sufficiently to warrant an independent test record. Such parameters include tests conducted at different test temperatures or conducted during different seasons.</p>
  <h4>References:</h4>
  <p>Center for Lake Superior Environmental Studies, University of Wisconsin-Superior; 1984, 1985, 1986, 1988, and 1990. <i>Acute Toxicities of Organic Chemicals to Fathead Minnows (Pimephales promelas)</i>, Vol. 1-5. University of Wisconsin-Superior, Superior, WI.</p>
  <p>U.S.  Environmental Protection Agency. 2021. <i>ECOTOX Data Abstraction Guidelines </i>(prepared by General Dynamics Information Technology, Contract CIO-SP3, HHSN316201200013W, Task Order EP-G16H-01256, SMAVCS3), Great Lakes Toxicology and Ecology Division, Duluth, MN.</p>
</section>
<hr>
<section id="documentation-verification" data-magellan-target="documentation-verification">
  <h2>Species Verification</h2>
  <p>The test organism is identified by the current scientific name as verified in the taxonomic literature. For each species entry, the verified name, taxonomic hierarchy, synonyms, and verification sources are kept on file for documentation purposes. Taxonomic kingdoms are divided into Plantae, Animalia, Chromista, Monera, Protista, Fungi and "Community". The taxonomic levels are verified by ITIS (Integrated Taxonomic Information System), located at <a href="http://www.itis.gov/">http://www.itis.gov/</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a>. If the taxonomic levels are not available with ITIS, other approved taxonomic sources are used.</p>
  <p>ECOTOX retains all species name synonyms that are no longer used for taxonomic classification. Searches in ECOTOX can be done using the species synonym name, however, output will contain the currently accepted species name.</p>
  <p>Field studies may report results for a target community (e.g., benthic macroinvertebrates) or for an entire enclosed ecosystem (e.g., system-level primary productivity or respiration). If a community of organisms was tested, the species grouping from the publication is reported. For example, benthic invertebrates may be entered under the Genus Invertebrates and a community of organisms may fall under the Genus Plankton.</p>
  <h3>Predefined Special Interest Sources</h3>
  <p>The species of special interest groups were compiled using the following references and are updated quarterly, or as needed:</p>
  <hr>
  <h4>Standard Test Species References</h4>
  <ol>
    <li>Amiard-Triquet, C., Amiard, J. C., and Mouneyrac, C. (2015). Aquatic Ecotoxicology - Advancing Tools for Dealing with Emerging Risks. Kidlington, Oxford: Elsevier/Academic Press. Print.</li>
    <li>ASTM International - Environmental Assessment Standards and Risk Management Standards - Biological Effects and Environmental Fate. Years 2012-2019.</li>
    <li>EPA, Office of Prevention, Pesticides and Toxic Substances, Harmonized Test Guidelines, Series 850, Ecological Effects Test Guidelines. Years 2012/2016.</li>
    <li>EPA, Office of Solid Waste and Emergency Response. (1994). ECO Update Catalogue of Standard Toxicity Tests for Ecological Risk Assessment Publication 9345.0-051. Volume 2 Number 2.</li>
    <li>Nikinmaa, M. (2014). An Intro to Aquatic Toxicology. Waltham, MA: Elsevier/Academic Press. Print.</li>
    <li>OECD (Organization for Economic Cooperation and Development) Test Guidelines. (2016). OECD Guidelines for the Testing of Chemicals, Section 2: Effects on Biotic Systems. Years 1984-2018.</li>
    <li>Rand, G. M. (2003). Fundamentals of aquatic toxicology: effects, environmental fate and risk assessment - Second Edition. Ecological Services, Inc. New York, NY: Taylor and Francis Group. Print.</li>    
  </ol>
  <hr>
  <h4>U.S. Threatened and Endangered Species Reference</h4>
  <p>U.S. Fish and Wildlife Service <a href="http://ecos.fws.gov/tess_public/pub/adHocSpeciesForm.jsp">http://ecos.fws.gov/tess_public/pub/adHocSpeciesForm.jsp</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a> Updated quarterly.</p>
  <hr>
  <h4>U.S. Invasive Species References</h4>
  <ol>
      <li>Swearingen, J., C. Bargeron. 2016 Invasive Plant Atlas of the United States. University of Georgia Center for Invasive Species and Ecosystem Health. <a href="https://www.invasiveplantatlas.org/distribution.cfm">https://www.invasiveplantatlas.org/distribution.cfm</a> (<a href="https://www.invasive.org/species.cfm">https://www.invasive.org/species.cfm</a>). <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></li>
      <li>University of Georgia - Center for Invasive Species and Ecosystem Health - <a href="https://www.invasive.org/south/index.html">https://www.invasive.org/south/index.html</a> (<a href="https://www.invasive.org/species.cfm">https://www.invasive.org/species.cfm</a>). <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></li>
      <li>Species Profiles List - <a href="https://www.invasivespeciesinfo.gov/species-type">https://www.invasivespeciesinfo.gov/species-type</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></li>
  </ol>
</section>

<hr>


<section id="documentation-chemverif" data-magellan-target="documentation-chemverif">
  <h2>Chemical Verification</h2>
  <p>A standardized identification number and name for each chemical recorded in the ECOTOX Knowledgebase is used for consistency. Chemicals reported in ECOTOX are cataloged by using a Chemical Abstracts Service (CAS) registry number.  The Chemical Abstracts Services Registry Number (CASRN or CAS #) is the core of the verification procedure.  Each chemical in the ECOTOX Knowledgebase must have a CAS # assigned or the data will not be released to the public.   The CAS # also provides a link to the Collective Index (CI) name which is stored in the Chemical Module as the Preferred Name (PN).  The Chemical Module strives to use the 9th Collective Index Name as its preferred name.</p>
  <p>Each chemical in the data file is verified in one or two chemical name sources (The primary source to obtain chemical information is from the <a href="https://comptox.epa.gov/dashboard/" target="_blank">US EPA CompTox Chemicals Dashboard</a>: only one source is needed if the source is the Chemical Abstract Services' STN International) and one structure source (most common source is from the Chemical Abstract Services' STN International). Chemicals in which a CAS number cannot be located through the regular sources are archived or archived under their active ingredient (AI).  Data associated with archived chemicals are not entered into the ECOTOX Knowledgebase.</p>
  <p>It is important to stress that you refer to the original publication to obtain additional test chemical information which may affect the context of toxicity information retrieved from ECOTOX.</p>  
</section>