<cfset cleanInputs = CreateObject("component", "cfc.input_sanitize")>

<div id="searchResults" class="main-content">
    
    <!--- pre-search parameter population here if applicable --->
    <cfparam name="FORM.pre_search" default="0">
    <cfparam name="FORM.pre_exploretype" default="">
    <cfparam name="FORM.pre_exploretypegroupids" default="">
    <cfparam name="FORM.pre_habitat" default="aquire">
    <cfparam name="FORM.pre_speciesstring" default="">
    <cfparam name="FORM.pre_chemstring" default="">
    <cfparam name="FORM.pre_effectstring" default="">        
    
    <cfparam name="FORM.selFilterEcoref" default="">
    <cfparam name="FORM.selFilterChemGroup" default="">
    <cfparam name="FORM.selFilterCAS" default="">
    <cfparam name="FORM.selFilterSpeciesGroup" default="">
    <cfparam name="FORM.selFilterClass" default="">
    <cfparam name="FORM.selFilterTaxOrder" default="">
    <cfparam name="FORM.selFilterFamily" default="">
    <cfparam name="FORM.selFilterGenus" default="">
    <cfparam name="FORM.selFilterSpecies" default="">
    <cfparam name="FORM.selFilterSpecialInterest" default="">
    <cfparam name="FORM.selFilterEffect" default="">
    <cfparam name="FORM.selFilterMeas" default="">
    <cfparam name="FORM.pre_endpointstring" default="">
    <cfparam name="FORM.txtFilterPubYearMin" default="">
    <cfparam name="FORM.txtFilterPubYearMax" default="">
    <cfparam name="FORM.selFilterObsDuration" default="">
    <cfparam name="FORM.txtFilterObsDurMin" default="">
    <cfparam name="FORM.txtFilterObsDurMax" default="">
      
    <div id="preSearchInputs">        
        <cfoutput>
            
        <cfset success = cleanInputs.checkBridgeFormInputs()>
        <cfif success>    
            
            <input type="hidden" id="hdnPreSearchFlag" name="hdnPreSearchFlag" value="#FORM.pre_search#" />
            <input type="hidden" id="hdnExploreType" name="hdnExploreType" value="#FORM.pre_exploretype#" />
            <input type="hidden" id="hdnExploreTypeGroupIds" name="hdnExploreTypeGroupIds" value="#FORM.pre_exploretypegroupids#" />

            <input type="hidden" id="hdnPre-habitat" name="hdnPre-habitat" value="#FORM.pre_habitat#" />

            <input type="hidden" id="hdnPre-chemicalgroup" name="hdnPre-chemicalgroup" value="#FORM.selFilterChemGroup#" data-explore-type="Chemicals" data-form-id="chemicalgroups" />
            <input type="hidden" id="hdnPre-speciesgroup" name="hdnPre-speciesgroup" value="#FORM.selFilterSpeciesGroup#" data-explore-type="Species" data-form-id="speciesgroups" />
            <input type="hidden" id="hdnPre-effectgroup" name="hdnPre-effectgroup" value="#FORM.selFilterEffect#" data-explore-type="Effects" data-form-id="effectsgroups" />

            <input type="hidden" id="hdnPre-chemstring" name="hdnPre-chemstring" value="#FORM.pre_chemstring#" data-custom-vals-string="Chemicals" data-search-input-id="txAdvancedChemicalEntries"/>
            <input type="hidden" id="hdnPre-speciesstring" name="hdnPre-speciesstring" value="#FORM.pre_speciesstring#" data-custom-vals-string="Species" data-search-input-id="speciesSearchInput"/>
            <input type="hidden" id="hdnPre-effectstring" name="hdnPre-effectstring" value="#FORM.pre_effectstring#" data-custom-vals-string="Effects" data-search-input-id="txAdvancedEffectEntries"/>
            <input type="hidden" id="hdnPre-ecorefstring" name="hdnPre-ecorefstring" value="#FORM.selFilterEcoref#" data-custom-vals-string="Publications" data-search-input-id="txAdvancedPublicationsEntries"/>

            <input type="hidden" id="hdnPre-chemicals" name="hdnPre-chemicals" value="#FORM.selFilterCAS#" data-explore-type-subitem="Chemicals" data-search-input-id="chemSelections" />
            <input type="hidden" id="hdnPre-class" name="hdnPre-class" value="#FORM.selFilterClass#" data-other-tax />
            <input type="hidden" id="hdnPre-order" name="hdnPre-order" value="#FORM.selFilterTaxOrder#" data-other-tax />
            <input type="hidden" id="hdnPre-family" name="hdnPre-family" value="#FORM.selFilterFamily#" data-other-tax />
            <input type="hidden" id="hdnPre-genus" name="hdnPre-genus" value="#FORM.selFilterGenus#" data-genus-species />
            <input type="hidden" id="hdnPre-species" name="hdnPre-species" value="#FORM.selFilterSpecies#" data-explore-type-subitem="Species" data-search-input-id="specSelections" />
            <input type="hidden" id="hdnPre-specialinterestgroup" name="hdnPre-specialinterestgroup" value="#FORM.selFilterSpecialInterest#" data-form-id="specialspecgroups" />
            <input type="hidden" id="hdnPre-effectmeasurement" name="hdnPre-effectmeasurement" value="#FORM.selFilterMeas#" data-explore-type-subitem="Effects" data-search-input-id="measSelections" />
            <input type="hidden" id="hdnPre-endpoints" name="hdnPre-endpoints" value="#FORM.pre_endpointstring#" data-explore-type="Endpoints" data-form-id="endpointsform" />
            <input type="hidden" id="hdnPre-publicationyearstart" name="hdnPre-publicationyearstart" value="#FORM.txtFilterPubYearMin#" data-search-input-id="Starting_Publication_Year" />
            <input type="hidden" id="hdnPre-publicationyearend" name="hdnPre-publicationyearend" value="#FORM.txtFilterPubYearMax#" data-search-input-id="Ending_Publication_Year" />
            <input type="hidden" id="hdnPre-obsdurmean" name="hdnPre-obsdurmean" value="#FORM.selFilterObsDuration#" data-search-input-id="txExposureDurationStd" />
            <input type="hidden" id="hdnPre-obsdurmin" name="hdnPre-obsdurmin" value="#FORM.txtFilterObsDurMin#" data-search-input-id="txExposureDurationMin" />
            <input type="hidden" id="hdnPre-obsdurmax" name="hdnPre-obsdurmax" value="#FORM.txtFilterObsDurMax#" data-search-input-id="txExposureDurationMax" />

        <cfelse>
            
            <input type="hidden" id="hdnPreSearchFlag" name="hdnPreSearchFlag" value="0" />
            <input type="hidden" id="hdnPre-habitat" name="hdnPre-habitat" value="aquire" />
                
        </cfif>
        </cfoutput>        
    </div>
        
  <cfinclude template="search-params/chemicals.cfm" />
  <cfinclude template="search-params/effects.cfm" />
  <cfinclude template="search-params/endpoints.cfm" />
  <cfinclude template="search-params/species.cfm" />
  <cfinclude template="search-params/test.cfm" />
  <cfinclude template="search-params/publications.cfm" />

  <nav id="searchResultsNav" class="page-header sub-nav">
    <button id="searchSidebarToggler" class="sidebar-toggler" data-toggle="searchSidebar">
      <svg class="icon" width="14" height="14"><use xlink:href="#adjust"></use></svg>
      Modify Parameters</button>

    <div class="button-group">
      <input type="hidden" id="sub" name="sub" value="aquire" />
      <input type="hidden" id="aquaOutputSelections" name="aquaOutputSelections" />
      <input type="hidden" id="terrOutputSelections" name="terrOutputSelections" />
      <button id="btnAquatic" class="button primary" data-search-type="aquire">Aquatic</button>
      <button id="btnTerrestrial" class="button secondary" data-search-type="terrestrial">Terrestrial</button>
    </div>

    <ul class="tabs" data-tabs id="searchResultsTabs">
      <li class="tabs-title is-active"><a title="Table View" href="#searchResultsPanel">
        <svg class="icon" width="16" height="16"><use xlink:href="#visuals-table"></use></svg>
        <span class="show-for-sr">Table Format</span></a></li>
      <li class="tabs-title"><a title="References View" href="#searchReferencesPanel">
        <svg class="icon" width="16" height="16"><use xlink:href="#visuals-files"></use></svg>
        <span class="show-for-sr">References</span></a></li>
    </ul>
  </nav>

  <main id="searchResultsMain" data-off-canvas-content data-tabs-content="searchResultsTabs">
    <div id="searchResultsLoading" class="loading-overlay"></div>
    <div id="calloutUnappliedParams" class="callout alert" data-closable>
      <h5 class="title">Warning</h5>
      <p>You have unapplied changes to your query parameters. Be sure to <a onclick="runSearch()">update your search</a>.</p>
      <button class="close-button" aria-label="Dismiss alert" type="button" data-close>
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
      </button>
    </div>

    <section id="searchResultsPanel" class="datatable-results tabs-panel is-active">
        <div class="clearfix">
            <h2 id="recordCount-results" class="float-left"></h2>
            <div class="button-group datatable-options float-right">
                <button id="btnOutput" class="button success disabled" data-open="outputOptionsModal">Customize Output Fields</button>
            </div>
        </div>
        <p id="exportWarning-5k" class="help-text" style="display: none;"><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg>  For 5,000 records or greater, we recommend exporting data as a 'Delimited' file.</p>
        <p id="exportWarning-10k" class="help-text" style="display: none;"><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg>  Export functionality is disabled when there are more than 10,000 search results.</p>
        <p id="outputMsg" class="help-text"><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg>  Results shown in condensed table. Use "Customize Output Fields" to view expanded data results.</p>

        <div id="searchResultsTable">
            <div id="searchIntro" class="card raised ideal centered mt4">
                <div class="card-content">
                    <h2>About Search</h2>
                    <p><strong>Search</strong> is a great tool for retrieving data from the ECOTOX Knowledgebase if you know the exact parameters you want to search.</p>
                    <p>The <strong>Search</strong> function provides a direct method to retrieve data that can be refined by limiting the search based on specific parameters including but not limited to: Chemical, Species, Endpoint, Control, and Media Type. Once you have selected your search options, you are able to view the report in the browser or export to an Excel spreadsheet or delimited text format.</p>
                    <p><small><strong>Disclaimer:</strong> You should consult the original scientific paper to ensure an understanding of the context of the data retrieved from ECOTOX.</small></p>
                </div>
            </div>
            <div id="searchDataTableDiv">
                <table id="searchResultsDataTable" class="hover" width="100%"></table>
            </div>
            <div id="searchDataTableError"></div>
        </div>
    </section>

    <section id="searchReferencesPanel" class="tabs-panel">
        <div id="searchResultsReferences">
            <div class="clearfix">
                <h2 id="recordCount-references" class="float-left"></h2>
                <div class="export-button float-right"></div>
            </div>
            <div id="referencesDataTableDiv">
                <input type="hidden" id="hdnActiveRefNums" name="hdnActiveRefNums" />
                <table id="searchReferencesDataTable" class="plain" width="100%">
                    <thead>
                        <th></th>
                    </thead>
                    <tfoot class="filters">
                        <tr>
                            <td><input type="text" class="small" placeholder="type to find..."></td>
                        </tr>
                    </tfoot>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <div id="referencesDataTableError"></div>
        </div>
    </section>
  </main>
</div>

<div class="reveal large modify-entries" id="outputOptionsModal" data-reveal data-close-on-click="false">
  <h2>Display Fields</h2>
  <button class="close-button" data-close aria-label="Close modal" type="button">
    <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
  </button>
  <p>Please select which fields you would like to display in the search results. Full descriptions of certain display fields can be found on the <a href="help.cfm?sub=wi-definitions">Data Field Definitions and Terms</a> help page.</p>
  <p>When you have completed your selections, click on the <strong>Save</strong> button.</p>
  <div class="reveal-footer" style="padding-bottom: 8px;">
    <button class="button secondary float-left" id="outputSelectAll">Select All</button>
    <button class="button secondary float-left" id="outputClearAll">Clear All</button>
    <button class="button secondary float-left" id="outputRestore">Restore Defaults</button>
    <button class="button secondary float-left" id="outputStudyDefaults">Study Evaluation Defaults</button>
    <button class="button secondary float-left" id="outputScreenDefaults">Screening Defaults</button>
    <button class="button cancel" data-close>Cancel</button>
    <button class="button success" data-close>Save</button>
  </div>
  <form id="outputsModal"></form>
</div>
