<cfcomponent>
<cfscript>

    function strReplace( inStr, strToRep, repWith ) {
        return Replace( inStr, strToRep, repWith, "All" );
    }

    // DATABASE ORDERING FOR DATATABLES
    function generateOrderString( fieldsStr, aliasesStr) {
        var retstr = "";
        var tempAliasStr = "";
        var fieldsAry = listToArray(fieldsStr, ",");
        var aliasesAry = listToArray(aliasesStr, ",");

        for (i = 1; i LTE arrayLen(fieldsAry); i++) {

            if(arrayLen(aliasesAry) eq arrayLen(fieldsAry)) {
                tempAliasStr = aliasesAry[i] & ".";
            }
            else {
                tempAliasStr = "";
            }

            if(i > 1) {
                retstr = retstr & ",";
            }

            retstr = retstr & tempAliasStr & fieldsAry[i];
        }
        return retstr;
    }

    function generateOrderByClause( fieldsStr, dirStr ) {

        var retstr = "";
        if(fieldsStr neq "") {
            if(dirStr eq "desc") {
                var fieldsAry = listToArray(fieldsStr, ",");
                for (i = 1; i LTE arrayLen(fieldsAry); i++) {
                    if(i > 1) {
                        retstr = retstr & ",";
                    }

                    retstr = retstr & fieldsAry[i] & " " & dirStr;
                }
            }
            else {
                retstr = fieldsStr;
            }
        }
        return retstr;
    }

    function cleanStringForDataTable( input, format ) {
        var retstr = input;
        if(retstr neq "") {

            if(format eq "EXCEL") {
                // DO NOTHING FOR NOW
            }
            else if(format eq "JSON") {    
                retstr = replace(retstr, "#Chr(13)##Chr(10)#", "<br/>", "ALL");
                retstr = cleanStringForJSON(retstr);
                if(isNumeric(retstr)) {
                    retstr = '"' & retstr & '"';
                }
            }
            else if(format eq "CSV") {
                retstr = cleanStringForCSV(retstr);
            }
        }

        if(retstr eq "") {
            if(format eq "JSON") {
                retstr = '"&nbsp;"';
            }
        }

        return retstr;
    }

    function cleanStringForJSON( input ) {
        var retstr = input;
        if(retstr neq "") {
            retstr = SerializeJSON(retstr);
        }
        return retstr;
    }

    function cleanStringForCSV( input ) {
        var retstr = input;
        if(retstr neq "") {
            retstr = replace(retstr, '"', '""', 'ALL');

            retstr = '"' & retstr & '"';
        }
        return retstr;
    }

    function cleanStringForExcel( input ) {
        var retstr = input;
        if(retstr neq "") {

            retstr = replace(retstr, "'", "_", 'ALL');
            
            if(Right(retstr, 1) EQ ",") {
                retstr = Left(retstr, Len(retstr)-1);
            }

            if(ListLen(retstr) gt 1) {
                retstr = "'" & retstr & "'";
            }
        }
        return retstr;
    }

    function cleanStringForExcelDate( input ) {
        var retstr = cleanStringForExcel(input);

        if(FindNoCase("-", retstr) GT 0) {
            retstr = Replace(retstr, "-", " to ","all");
            retstr = " " & retstr;
        }
        
        return retstr;
    }

    function parseRecentChemStrToJson( fullStr ) {
        var retstr = '';
        var chemArray = arraynew(1);
        var innerArrayStr = '';
        var innerArray = arraynew(1);
        
        chemArray = ListToArray(fullStr, "|");
        for (i = 1; i LTE arrayLen(chemArray); i++) {
            innerArrayStr = chemArray[i];
            innerArray = ListToArray(innerArrayStr, ";", true);
            if(arrayLen(innerArray) eq 2) {
                if(i > 1) {
                    retstr = retstr & ",";
                }

                retstr = retstr & '{"chemicalName":"' & innerArray[1] & '","cas":"' & innerArray[2] & '"}';
            }
            else if(arrayLen(innerArray) eq 3) {
                if(i > 1) {
                    retstr = retstr & ",";
                }

                retstr = retstr & '{"chemicalName":"' & innerArray[1] & '","cas":"' & innerArray[2] & '","chemicalgroupid":"' & innerArray[3] & '"}';
            }
        }

        return retstr;
    }
    
    function generateGoogleScholarLink(title) {
        var googleLink = "";

        if(title NEQ "") {
            googleLink = "https://scholar.google.com/scholar?hl=en&as_q=&as_oq=&as_eq=&as_sauthors=&as_publication=&as_ylo=&as_yhi=&as_occt=title&as_sdt=0%2C5&as_epq=%22" & EncodeForURL(title);
        }

        return googleLink;
    }

</cfscript>
</cfcomponent>