<cfset PageName="Contact">

<cfinclude template="includes/head.cfm" />

<div id="contactPage" class="main-content">
  <main id="contactContent" class="content row">

    <div class="column medium-7">
      <h2 class="mt1">Contact Us About the ECOTOX Knowledgebase</h2>
      <p>EPA welcomes your comments on this version of ECOTOX.  We are specifically interested in feedback from users about the new functionality and usability.  What, if any, issues did you experience? Please be as specific as possible in your comments.  If you or your team would like training on how to use and find information in ECOTOX, please indicate that in the Feedback box below.</p>
      <p>For technical questions about the scientific information and data interpretation, you may use the comment form below, or the contact information in the right-side bar, to contact the ECOTOX Support Staff.</p>

      <div class="card raised card-content">
        <p><strong>Please help us answer your request by including a correct e-mail address.</strong> If you are referring to a specific page within the ECOTOX web site, please include a URL or title for the page.</p>

        <form id="contactform">
          <label>Your Name
            <input name="contactname" type="text" placeholder="First Last" data-required-input="Your Name">
          </label>
          <label>Your Organization <em>(Optional)</em>
      		<select name="organizationSelect" class="default">
	      		<option selected value="not selected"> Select an option</option>
            <option value="US EPA Headquarters">US EPA Headquarters</option>
            <option value="US EPA Regional Office">US EPA Regional Office</option>
            <option value="US EPA Laboratory">US EPA Laboratory</option>
            <option value="Other US Federal Agencies">Other US Federal Agencies</option>
            <option value="US Government Contractors">US Government Contractors</option>
            <option value="State Government">State Government</option>
            <option value="Local Government">Local Government</option>
            <option value="International Government">International Government</option>
            <option value="University/Academia">University/Academia</option>
            <option value="Private Sector">Private Sector</option>
            <option value="Non-profit Organization">Non-profit Organization</option>
            <option value="Other">Other</option>
          </select>
            <input name="organization" type="text" placeholder="Name of Organization" class="mt1">
          </label>
          <label>Your E-mail Address
            <input name="emailaddress" type="text" placeholder="email@example.com" data-required-input="Your E-mail Address">
          </label>
          <label class="mb2">
            Your Feedback
            <textarea name="contact_form_concern" rows="5" placeholder="I really like the new..." data-required-input="Your Feedback"></textarea>
          </label>

          <input name="notifications" id="notifications" type="checkbox" value="1"><label for="notifications">Sign up to receive notifications when quarterly updates are available.</label>

          <button type="submit" class="button primary mt2">Submit</button>
          <div class="callout alert errorList" data-closable>
              <h5 class="title">Warning</h5>
              <p>Please correct the following errors:</p>
              <button class="close-button" aria-label="Dismiss alert" type="button" data-close>
                <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
              </button>
              <ul></ul>
          </div>
        </form>
      </div>
    </div>

    <div class="column medium-4">
      <cfinclude template="includes/updates/signup_button.cfm" />

      <div class="card card-content">
        <p>
          Telephone: 218-529-5225 <br>
          Fax: 218-529-5003 <br>
          E-mail: <a href="mailto:ecotox.support@epa.gov">ecotox.support@epa.gov</a>
        </p>

        <p>
          <strong>Mailing address:</strong> <br>
          ECOTOX Support <br>
          Great Lakes Toxicology Ecology Division <br>
          6201 Congdon Boulevard <br>
          Duluth, MN 55804
        </p>
      </div>
	  <!---  COMMENT THIS OUT FOR NOW PER JACQUES
	  <div class="box right">
		<!--- NOT SURE WHY THESE STYLES AREN'T BEING INCLUDED.  HARD-CODE FOR NOW BUT RE-VISIT THIS --->
		<div class="slat-image" style="float: left;"><a href="https://www.epa.gov/enforcement/report-environmental-violations-unpublished"><img alt="Report an environmental violation" src="images/badge.gif" /></a></div>
		<div class="slat-content">
		  <div><strong><a href="https://www.epa.gov/enforcement/report-environmental-violations-unpublished">Report a Violation</a></strong></div>
		  <p><small>Report possible violations of environmental laws and regulations.</small></p>
		</div>
	  </div>
      <div class="card card-content">
        <p><a href="http://www2.epa.gov/home/privacy-and-security-notice">Privacy
			        and Security Notice</a> </p>
      </div>
	  --->
    </div>
  </main>
</div>

<cfinclude template="includes/updates/signup_modal.cfm" />
<cfinclude template="includes/end.cfm" />
